/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import java.util.Map;
import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;

public interface QueueControl {
    public String getName();

    public String getAddress();

    public long getID();

    public boolean isTemporary();

    public boolean isDurable();

    public String getFilter();

    public long getMessageCount();

    public long getScheduledCount();

    public int getConsumerCount();

    public int getDeliveringCount();

    public long getMessagesAdded();

    public long getMessagesAcknowledged();

    public String getFirstMessageAsJSON() throws Exception;

    public String getExpiryAddress();

    public void setExpiryAddress(@Parameter(name="expiryAddress", desc="Expiry address of the queue") String var1) throws Exception;

    public String getDeadLetterAddress();

    public void setDeadLetterAddress(@Parameter(name="deadLetterAddress", desc="Dead-letter address of the queue") String var1) throws Exception;

    @Operation(desc="List the messages scheduled for delivery", impact=0)
    public Map<String, Object>[] listScheduledMessages() throws Exception;

    @Operation(desc="List the messages scheduled for delivery and returns them using JSON", impact=0)
    public String listScheduledMessagesAsJSON() throws Exception;

    @Operation(desc="List all messages being delivered per consumer")
    public Map<String, Map<String, Object>[]> listDeliveringMessages() throws Exception;

    @Operation(desc="list all messages being delivered per consumer using JSON form")
    public String listDeliveringMessagesAsJSON() throws Exception;

    @Operation(desc="List all the messages in the queue matching the given filter", impact=0)
    public Map<String, Object>[] listMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="List all the messages in the queue matching the given filter and returns them using JSON", impact=0)
    public String listMessagesAsJSON(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Returns the number of the messages in the queue matching the given filter", impact=0)
    public long countMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Remove the message corresponding to the given messageID", impact=1)
    public boolean removeMessage(@Parameter(name="messageID", desc="A message ID") long var1) throws Exception;

    @Operation(desc="Remove the messages corresponding to the given filter (and returns the number of removed messages)", impact=1)
    public int removeMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Remove the messages corresponding to the given filter (and returns the number of removed messages)", impact=1)
    public int removeMessages(@Parameter(name="flushLimit", desc="Limit to flush transactions during the operation to avoid OutOfMemory") int var1, @Parameter(name="filter", desc="A message filter (can be empty)") String var2) throws Exception;

    @Operation(desc="Expire the messages corresponding to the given filter (and returns the number of expired messages)", impact=1)
    public int expireMessages(@Parameter(name="filter", desc="A message filter") String var1) throws Exception;

    @Operation(desc="Remove the message corresponding to the given messageID", impact=1)
    public boolean expireMessage(@Parameter(name="messageID", desc="A message ID") long var1) throws Exception;

    @Operation(desc="Move the message corresponding to the given messageID to another queue. rejectDuplicate=false on this case", impact=1)
    public boolean moveMessage(@Parameter(name="messageID", desc="A message ID") long var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the message to") String var3) throws Exception;

    @Operation(desc="Move the message corresponding to the given messageID to another queue", impact=1)
    public boolean moveMessage(@Parameter(name="messageID", desc="A message ID") long var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the message to") String var3, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var4) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages). RejectDuplicates=false on this case.", impact=1)
    public int moveMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var2) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages)", impact=1)
    public int moveMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var2, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var3) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages)", impact=1)
    public int moveMessages(@Parameter(name="flushLimit", desc="Limit to flush transactions during the operation to avoid OutOfMemory") int var1, @Parameter(name="filter", desc="A message filter (can be empty)") String var2, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var3, @Parameter(name="rejectDuplicates", desc="Reject messages identified as duplicate by the duplicate message") boolean var4) throws Exception;

    @Operation(desc="Send the message corresponding to the given messageID to this queue's Dead Letter Address", impact=1)
    public boolean sendMessageToDeadLetterAddress(@Parameter(name="messageID", desc="A message ID") long var1) throws Exception;

    @Operation(desc="Send the messages corresponding to the given filter to this queue's Dead Letter Address", impact=1)
    public int sendMessagesToDeadLetterAddress(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Change the priority of the message corresponding to the given messageID", impact=1)
    public boolean changeMessagePriority(@Parameter(name="messageID", desc="A message ID") long var1, @Parameter(name="newPriority", desc="the new priority (between 0 and 9)") int var3) throws Exception;

    @Operation(desc="Change the priority of the messages corresponding to the given filter", impact=1)
    public int changeMessagesPriority(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="newPriority", desc="the new priority (between 0 and 9)") int var2) throws Exception;

    @Operation(desc="List the message counters", impact=0)
    public String listMessageCounter() throws Exception;

    @Operation(desc="Reset the message counters", impact=0)
    public void resetMessageCounter() throws Exception;

    @Operation(desc="List the message counters as HTML", impact=0)
    public String listMessageCounterAsHTML() throws Exception;

    @Operation(desc="List the message counters history", impact=0)
    public String listMessageCounterHistory() throws Exception;

    @Operation(desc="List the message counters history HTML", impact=0)
    public String listMessageCounterHistoryAsHTML() throws Exception;

    @Operation(desc="Pauses the Queue", impact=1)
    public void pause() throws Exception;

    @Operation(desc="Resumes delivery of queued messages and gets the queue out of paused state.", impact=1)
    public void resume() throws Exception;

    @Operation(desc="List all the existent consumers on the Queue")
    public String listConsumersAsJSON() throws Exception;

    @Operation(desc="Inspects if the queue is paused", impact=0)
    public boolean isPaused() throws Exception;

    @Operation(desc="Resets the MessagesAdded property", impact=1)
    public void resetMessagesAdded() throws Exception;

    @Operation(desc="Resets the MessagesAcknowledged property", impact=1)
    public void resetMessagesAcknowledged() throws Exception;

    public void flushExecutor();
}

