/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQPropertyConversionException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.reader.MessageUtil;

public class ClientMessageImpl
extends MessageImpl
implements ClientMessageInternal {
    public static final SimpleString REPLYTO_HEADER_NAME = MessageUtil.REPLYTO_HEADER_NAME;
    private int deliveryCount;
    private ClientConsumerInternal consumer;
    private int flowControlSize = -1;
    private InputStream bodyInputStream;

    public ClientMessageImpl() {
    }

    public ClientMessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize) {
        super(type, durable, expiration, timestamp, priority, initialMessageBufferSize);
    }

    @Override
    public boolean isServerMessage() {
        return false;
    }

    @Override
    public void onReceipt(ClientConsumerInternal consumer) {
        this.consumer = consumer;
    }

    @Override
    public ClientMessageImpl setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
        return this;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public ClientMessageImpl acknowledge() throws HornetQException {
        if (this.consumer != null) {
            this.consumer.acknowledge(this);
        }
        return this;
    }

    @Override
    public ClientMessageImpl individualAcknowledge() throws HornetQException {
        if (this.consumer != null) {
            this.consumer.individualAcknowledge(this);
        }
        return this;
    }

    @Override
    public int getFlowControlSize() {
        if (this.flowControlSize < 0) {
            throw new IllegalStateException("Flow Control hasn't been set");
        }
        return this.flowControlSize;
    }

    @Override
    public void setFlowControlSize(int flowControlSize) {
        this.flowControlSize = flowControlSize;
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public boolean isCompressed() {
        return this.properties.getBooleanProperty(Message.HDR_LARGE_COMPRESSED);
    }

    @Override
    public int getBodySize() {
        return this.buffer.writerIndex() - this.buffer.readerIndex();
    }

    public String toString() {
        return "ClientMessage[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + ",userID=" + (this.getUserID() != null ? this.getUserID() : "null") + ",properties=" + this.properties.toString() + "]";
    }

    @Override
    public void saveToOutputStream(OutputStream out) throws HornetQException {
        try {
            byte[] readBuffer = new byte[this.getBodySize()];
            this.getBodyBuffer().readBytes(readBuffer);
            out.write(readBuffer);
            out.flush();
        }
        catch (IOException e) {
            throw HornetQClientMessageBundle.BUNDLE.errorSavingBody(e);
        }
    }

    @Override
    public ClientMessageImpl setOutputStream(OutputStream out) throws HornetQException {
        this.saveToOutputStream(out);
        return this;
    }

    @Override
    public boolean waitOutputStreamCompletion(long timeMilliseconds) throws HornetQException {
        return true;
    }

    @Override
    public void discardBody() {
    }

    @Override
    public InputStream getBodyInputStream() {
        return this.bodyInputStream;
    }

    @Override
    public ClientMessageImpl setBodyInputStream(InputStream bodyInputStream) {
        this.bodyInputStream = bodyInputStream;
        return this;
    }

    @Override
    public BodyEncoder getBodyEncoder() throws HornetQException {
        return new DecodingContext();
    }

    @Override
    public ClientMessageImpl putBooleanProperty(SimpleString key, boolean value) {
        return (ClientMessageImpl)super.putBooleanProperty(key, value);
    }

    @Override
    public ClientMessageImpl putByteProperty(SimpleString key, byte value) {
        return (ClientMessageImpl)super.putByteProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBytesProperty(SimpleString key, byte[] value) {
        return (ClientMessageImpl)super.putBytesProperty(key, value);
    }

    @Override
    public ClientMessageImpl putCharProperty(SimpleString key, char value) {
        return (ClientMessageImpl)super.putCharProperty(key, value);
    }

    @Override
    public ClientMessageImpl putCharProperty(String key, char value) {
        return (ClientMessageImpl)super.putCharProperty(key, value);
    }

    @Override
    public ClientMessageImpl putShortProperty(SimpleString key, short value) {
        return (ClientMessageImpl)super.putShortProperty(key, value);
    }

    @Override
    public ClientMessageImpl putIntProperty(SimpleString key, int value) {
        return (ClientMessageImpl)super.putIntProperty(key, value);
    }

    @Override
    public ClientMessageImpl putLongProperty(SimpleString key, long value) {
        return (ClientMessageImpl)super.putLongProperty(key, value);
    }

    @Override
    public ClientMessageImpl putFloatProperty(SimpleString key, float value) {
        return (ClientMessageImpl)super.putFloatProperty(key, value);
    }

    @Override
    public ClientMessageImpl putDoubleProperty(SimpleString key, double value) {
        return (ClientMessageImpl)super.putDoubleProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(SimpleString key, SimpleString value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl putObjectProperty(SimpleString key, Object value) throws HornetQPropertyConversionException {
        return (ClientMessageImpl)super.putObjectProperty(key, value);
    }

    @Override
    public ClientMessageImpl putObjectProperty(String key, Object value) throws HornetQPropertyConversionException {
        return (ClientMessageImpl)super.putObjectProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBooleanProperty(String key, boolean value) {
        return (ClientMessageImpl)super.putBooleanProperty(key, value);
    }

    @Override
    public ClientMessageImpl putByteProperty(String key, byte value) {
        return (ClientMessageImpl)super.putByteProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBytesProperty(String key, byte[] value) {
        return (ClientMessageImpl)super.putBytesProperty(key, value);
    }

    @Override
    public ClientMessageImpl putShortProperty(String key, short value) {
        return (ClientMessageImpl)super.putShortProperty(key, value);
    }

    @Override
    public ClientMessageImpl putIntProperty(String key, int value) {
        return (ClientMessageImpl)super.putIntProperty(key, value);
    }

    @Override
    public ClientMessageImpl putLongProperty(String key, long value) {
        return (ClientMessageImpl)super.putLongProperty(key, value);
    }

    @Override
    public ClientMessageImpl putFloatProperty(String key, float value) {
        return (ClientMessageImpl)super.putFloatProperty(key, value);
    }

    @Override
    public ClientMessageImpl putDoubleProperty(String key, double value) {
        return (ClientMessageImpl)super.putDoubleProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(String key, String value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl writeBodyBufferBytes(byte[] bytes) {
        return (ClientMessageImpl)super.writeBodyBufferBytes(bytes);
    }

    @Override
    public ClientMessageImpl writeBodyBufferString(String string) {
        return (ClientMessageImpl)super.writeBodyBufferString(string);
    }

    private final class DecodingContext
    implements BodyEncoder {
        @Override
        public void open() {
            ClientMessageImpl.this.getBodyBuffer().readerIndex(0);
        }

        @Override
        public void close() {
        }

        @Override
        public long getLargeBodySize() {
            if (ClientMessageImpl.this.isLargeMessage()) {
                return ClientMessageImpl.this.getBodyBuffer().writerIndex();
            }
            return ClientMessageImpl.this.getBodyBuffer().writerIndex() - 17;
        }

        @Override
        public int encode(ByteBuffer bufferRead) throws HornetQException {
            HornetQBuffer buffer1 = HornetQBuffers.wrappedBuffer((ByteBuffer)bufferRead);
            return this.encode(buffer1, bufferRead.capacity());
        }

        @Override
        public int encode(HornetQBuffer bufferOut, int size) {
            byte[] bytes = new byte[size];
            ClientMessageImpl.this.getWholeBuffer().readBytes(bytes);
            bufferOut.writeBytes(bytes, 0, size);
            return size;
        }
    }
}

