/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.FailoverEventListener;
import org.hornetq.api.core.client.FailoverEventType;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ClientSessionImpl;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.DelegatingSession;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.ClientProtocolManager;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.Connector;
import org.hornetq.spi.core.remoting.ConnectorFactory;
import org.hornetq.spi.core.remoting.SessionContext;
import org.hornetq.spi.core.remoting.TopologyResponseHandler;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.ConfirmationWindowWarning;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.UUIDGenerator;

public class ClientSessionFactoryImpl
implements ClientSessionFactoryInternal,
ConnectionLifeCycleListener {
    private static final boolean isTrace = HornetQClientLogger.LOGGER.isTraceEnabled();
    private static final boolean isDebug = HornetQClientLogger.LOGGER.isDebugEnabled();
    private final ServerLocatorInternal serverLocator;
    private final ClientProtocolManager clientProtocolManager;
    private TransportConfiguration connectorConfig;
    private TransportConfiguration backupConfig;
    private ConnectorFactory connectorFactory;
    private transient boolean finalizeCheck = true;
    private final long callTimeout;
    private final long callFailoverTimeout;
    private final long clientFailureCheckPeriod;
    private final long connectionTTL;
    private final Set<ClientSessionInternal> sessions = new HashSet<ClientSessionInternal>();
    private final Object createSessionLock = new Object();
    private final Lock newFailoverLock = new ReentrantLock();
    private final Object connectionLock = new Object();
    private final ExecutorFactory orderedExecutorFactory;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;
    private RemotingConnection connection;
    private final long retryInterval;
    private final double retryIntervalMultiplier;
    private final long maxRetryInterval;
    private int reconnectAttempts;
    private final Set<SessionFailureListener> listeners = new ConcurrentHashSet();
    private final Set<FailoverEventListener> failoverListeners = new ConcurrentHashSet();
    private Connector connector;
    private Future<?> pingerFuture;
    private PingRunnable pingRunnable;
    private final List<Interceptor> incomingInterceptors;
    private final List<Interceptor> outgoingInterceptors;
    private volatile boolean stopPingingAfterOne;
    private volatile boolean closed;
    public final Exception createTrace = new Exception();
    public static final Set<CloseRunnable> CLOSE_RUNNABLES = Collections.synchronizedSet(new HashSet());
    private final ConfirmationWindowWarning confirmationWindowWarning;
    private String liveNodeID;

    public ClientSessionFactoryImpl(ServerLocatorInternal serverLocator, TransportConfiguration connectorConfig, long callTimeout, long callFailoverTimeout, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, Executor threadPool, ScheduledExecutorService scheduledThreadPool, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors) {
        this.serverLocator = serverLocator;
        this.clientProtocolManager = serverLocator.newProtocolManager();
        this.clientProtocolManager.setSessionFactory(this);
        this.connectorConfig = connectorConfig;
        this.connectorFactory = this.instantiateConnectorFactory(connectorConfig.getFactoryClassName());
        this.checkTransportKeys(this.connectorFactory, connectorConfig);
        this.callTimeout = callTimeout;
        this.callFailoverTimeout = callFailoverTimeout;
        if (this.connectorFactory.isReliable() && clientFailureCheckPeriod == HornetQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD && connectionTTL == HornetQClient.DEFAULT_CONNECTION_TTL) {
            this.clientFailureCheckPeriod = -1L;
            this.connectionTTL = -1L;
        } else {
            this.clientFailureCheckPeriod = clientFailureCheckPeriod;
            this.connectionTTL = connectionTTL;
        }
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.scheduledThreadPool = scheduledThreadPool;
        this.threadPool = threadPool;
        this.orderedExecutorFactory = new OrderedExecutorFactory(threadPool);
        this.closeExecutor = this.orderedExecutorFactory.getExecutor();
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
        this.confirmationWindowWarning = new ConfirmationWindowWarning(serverLocator.getConfirmationWindowSize() < 0);
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public Lock lockFailover() {
        this.newFailoverLock.lock();
        return this.newFailoverLock;
    }

    @Override
    public void connect(int initialConnectAttempts, boolean failoverOnInitialConnection) throws HornetQException {
        this.getConnectionWithRetry(initialConnectAttempts);
        if (this.connection == null) {
            StringBuilder msg = new StringBuilder("Unable to connect to server using configuration ").append(this.connectorConfig);
            if (this.backupConfig != null) {
                msg.append(" and backup configuration ").append(this.backupConfig);
            }
            throw new HornetQNotConnectedException(msg.toString());
        }
    }

    @Override
    public TransportConfiguration getConnectorConfiguration() {
        return this.connectorConfig;
    }

    @Override
    public void setBackupConnector(TransportConfiguration live, TransportConfiguration backUp) {
        Connector localConnector = this.connector;
        if (localConnector == null) {
            localConnector = this.connectorFactory.createConnector(this.connectorConfig.getParams(), new DelegatingBufferHandler(), this, this.closeExecutor, this.threadPool, this.scheduledThreadPool, this.clientProtocolManager);
        }
        if (localConnector.isEquivalent(live.getParams()) && backUp != null && !localConnector.isEquivalent(backUp.getParams())) {
            if (isDebug) {
                HornetQClientLogger.LOGGER.debug("Setting up backup config = " + backUp + " for live = " + live);
            }
            this.backupConfig = backUp;
        } else if (isDebug) {
            HornetQClientLogger.LOGGER.debug("ClientSessionFactoryImpl received backup update for live/backup pair = " + live + " / " + backUp + " but it didn't belong to " + this.connectorConfig);
        }
    }

    @Override
    public Object getBackupConnector() {
        return this.backupConfig;
    }

    @Override
    public ClientSession createSession(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), ackBatchSize);
    }

    @Override
    public ClientSession createXASession() throws HornetQException {
        return this.createSessionInternal(null, null, true, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createTransactedSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, true, true, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.getAckBatchSize());
    }

    @Override
    public void connectionCreated(HornetQComponent component, Connection connection, String protocol) {
    }

    @Override
    public void connectionDestroyed(final Object connectionID) {
        HornetQNotConnectedException ex = HornetQClientMessageBundle.BUNDLE.channelDisconnected();
        this.closeExecutor.execute(new Runnable((HornetQException)ex){
            final /* synthetic */ HornetQException val$ex;
            {
                this.val$ex = hornetQException;
            }

            @Override
            public void run() {
                ClientSessionFactoryImpl.this.handleConnectionFailure(connectionID, this.val$ex);
            }
        });
    }

    @Override
    public void connectionException(Object connectionID, HornetQException me) {
        this.handleConnectionFailure(connectionID, me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ClientSessionInternal session, boolean failingOver) {
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    @Override
    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public synchronized int numConnections() {
        return this.connection != null ? 1 : 0;
    }

    @Override
    public int numSessions() {
        return this.sessions.size();
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public ClientSessionFactoryImpl addFailoverListener(FailoverEventListener listener) {
        this.failoverListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeFailoverListener(FailoverEventListener listener) {
        return this.failoverListeners.remove(listener);
    }

    @Override
    public void causeExit() {
        this.clientProtocolManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptConnectAndCloseAllSessions(boolean close) {
        this.clientProtocolManager.stop();
        Object object = this.createSessionLock;
        synchronized (object) {
            this.closeCleanSessions(close);
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCleanSessions(boolean close) {
        HashSet<ClientSessionInternal> sessionsToClose;
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
        }
        for (ClientSessionInternal session : sessionsToClose) {
            try {
                if (close) {
                    session.close();
                    continue;
                }
                session.cleanUp(false);
            }
            catch (Exception e1) {
                HornetQClientLogger.LOGGER.unableToCloseSession(e1);
            }
        }
        this.checkCloseConnection();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.interruptConnectAndCloseAllSessions(true);
        this.serverLocator.factoryClosed(this);
    }

    @Override
    public void cleanup() {
        if (this.closed) {
            return;
        }
        this.interruptConnectAndCloseAllSessions(false);
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.serverLocator.isClosed();
    }

    @Override
    public ServerLocator getServerLocator() {
        return this.serverLocator;
    }

    public void stopPingingAfterOne() {
        this.stopPingingAfterOne = true;
    }

    private void handleConnectionFailure(Object connectionID, HornetQException me) {
        this.handleConnectionFailure(connectionID, me, null);
    }

    private void handleConnectionFailure(Object connectionID, HornetQException me, String scaleDownTargetNodeID) {
        try {
            this.failoverOrReconnect(connectionID, me, scaleDownTargetNodeID);
        }
        catch (HornetQInterruptedException e1) {
            HornetQClientLogger.LOGGER.debug(e1.getMessage(), e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failoverOrReconnect(Object connectionID, HornetQException me, String scaleDownTargetNodeID) {
        HashSet<ClientSessionInternal> sessionsToClose;
        block24: {
            sessionsToClose = null;
            if (!this.clientProtocolManager.isAlive()) {
                return;
            }
            Lock localFailoverLock = this.lockFailover();
            try {
                Object connectionToDestory;
                if (this.connection == null || !this.connection.getID().equals(connectionID) || !this.clientProtocolManager.isAlive()) {
                    return;
                }
                if (isTrace) {
                    HornetQClientLogger.LOGGER.trace("Client Connection failed, calling failure listeners and trying to reconnect, reconnectAttempts=" + this.reconnectAttempts);
                }
                this.callFailoverListeners(FailoverEventType.FAILURE_DETECTED);
                this.callSessionFailureListeners(me, false, false, scaleDownTargetNodeID);
                if (this.reconnectAttempts != 0) {
                    if (this.clientProtocolManager.cleanupBeforeFailover(me)) {
                        RemotingConnection oldConnection = this.connection;
                        this.connection = null;
                        Connector localConnector = this.connector;
                        if (localConnector != null) {
                            try {
                                localConnector.close();
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        this.cancelScheduledTasks();
                        this.connector = null;
                        this.reconnectSessions(oldConnection, this.reconnectAttempts, me);
                        if (oldConnection != null) {
                            oldConnection.destroy();
                        }
                        if (this.connection != null) {
                            this.callFailoverListeners(FailoverEventType.FAILOVER_COMPLETED);
                        }
                    }
                } else {
                    connectionToDestory = this.connection;
                    if (connectionToDestory != null) {
                        connectionToDestory.destroy();
                    }
                    this.connection = null;
                }
                if (this.connection != null) break block24;
                connectionToDestory = this.sessions;
                synchronized (connectionToDestory) {
                    sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
                }
                this.callFailoverListeners(FailoverEventType.FAILOVER_FAILED);
                this.callSessionFailureListeners(me, true, false);
            }
            finally {
                localFailoverLock.unlock();
            }
        }
        if (this.connection != null) {
            this.callSessionFailureListeners(me, true, true);
        }
        if (sessionsToClose != null) {
            for (ClientSessionInternal session : sessionsToClose) {
                try {
                    session.cleanUp(true);
                }
                catch (Exception cause) {
                    HornetQClientLogger.LOGGER.failedToCleanupSession(cause);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSession createSessionInternal(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        String name = UUIDGenerator.getInstance().generateStringUUID();
        SessionContext context = this.createSessionChannel(name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge);
        ClientSessionImpl session = new ClientSessionImpl(this, name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.isBlockOnAcknowledge(), this.serverLocator.isAutoGroup(), ackBatchSize, this.serverLocator.getConsumerWindowSize(), this.serverLocator.getConsumerMaxRate(), this.serverLocator.getConfirmationWindowSize(), this.serverLocator.getProducerWindowSize(), this.serverLocator.getProducerMaxRate(), this.serverLocator.isBlockOnNonDurableSend(), this.serverLocator.isBlockOnDurableSend(), this.serverLocator.isCacheLargeMessagesClient(), this.serverLocator.getMinLargeMessageSize(), this.serverLocator.isCompressLargeMessage(), this.serverLocator.getInitialMessagePacketSize(), this.serverLocator.getGroupID(), context, this.orderedExecutorFactory.getExecutor(), this.orderedExecutorFactory.getExecutor());
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            if (this.closed || !this.clientProtocolManager.isAlive()) {
                session.close();
                return null;
            }
            this.sessions.add(session);
        }
        return new DelegatingSession(session);
    }

    private void callSessionFailureListeners(HornetQException me, boolean afterReconnect, boolean failedOver) {
        this.callSessionFailureListeners(me, afterReconnect, failedOver, null);
    }

    private void callSessionFailureListeners(HornetQException me, boolean afterReconnect, boolean failedOver, String scaleDownTargetNodeID) {
        ArrayList<SessionFailureListener> listenersClone = new ArrayList<SessionFailureListener>(this.listeners);
        for (SessionFailureListener listener : listenersClone) {
            try {
                if (afterReconnect) {
                    listener.connectionFailed(me, failedOver, scaleDownTargetNodeID);
                    continue;
                }
                listener.beforeReconnect(me);
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.failedToExecuteListener(t);
            }
        }
    }

    private void callFailoverListeners(FailoverEventType type) {
        ArrayList<FailoverEventListener> listenersClone = new ArrayList<FailoverEventListener>(this.failoverListeners);
        for (FailoverEventListener listener : listenersClone) {
            try {
                listener.failoverEvent(type);
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.failedToExecuteListener(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectSessions(RemotingConnection oldConnection, int reconnectAttempts, HornetQException cause) {
        HashSet<ClientSessionInternal> sessionsToFailover;
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            sessionsToFailover = new HashSet<ClientSessionInternal>(this.sessions);
        }
        for (ClientSessionInternal session : sessionsToFailover) {
            session.preHandleFailover(this.connection);
        }
        this.getConnectionWithRetry(reconnectAttempts);
        if (this.connection == null) {
            if (!this.clientProtocolManager.isAlive()) {
                HornetQClientLogger.LOGGER.failedToConnectToServer();
            }
            return;
        }
        List<FailureListener> oldListeners = oldConnection.getFailureListeners();
        ArrayList<FailureListener> newListeners = new ArrayList<FailureListener>(this.connection.getFailureListeners());
        for (FailureListener listener : oldListeners) {
            if (listener instanceof DelegatingFailureListener) continue;
            newListeners.add(listener);
        }
        this.connection.setFailureListeners(newListeners);
        ((CoreRemotingConnection)this.connection).syncIDGeneratorSequence(((CoreRemotingConnection)oldConnection).getIDGeneratorSequence());
        for (ClientSessionInternal session : sessionsToFailover) {
            session.handleFailover(this.connection, cause);
        }
    }

    private void getConnectionWithRetry(int reconnectAttempts) {
        if (!this.clientProtocolManager.isAlive()) {
            return;
        }
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("getConnectionWithRetry::" + reconnectAttempts + " with retryInterval = " + this.retryInterval + " multiplier = " + this.retryIntervalMultiplier, new Exception("trace"));
        }
        long interval = this.retryInterval;
        int count = 0;
        while (this.clientProtocolManager.isAlive()) {
            if (isDebug) {
                HornetQClientLogger.LOGGER.debug("Trying reconnection attempt " + count + "/" + reconnectAttempts);
            }
            if (this.getConnection() != null) {
                if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                    HornetQClientLogger.LOGGER.debug("Reconnection successful");
                }
                return;
            }
            if (reconnectAttempts != 0) {
                if (reconnectAttempts != -1 && ++count == reconnectAttempts) {
                    if (reconnectAttempts != 1) {
                        HornetQClientLogger.LOGGER.failedToConnectToServer(reconnectAttempts);
                    }
                    return;
                }
                if (isTrace) {
                    HornetQClientLogger.LOGGER.waitingForRetry(interval, this.retryInterval, this.retryIntervalMultiplier);
                }
                try {
                    if (this.clientProtocolManager.waitOnLatch(interval)) {
                        return;
                    }
                }
                catch (InterruptedException ignore) {
                    throw new HornetQInterruptedException((Throwable)this.createTrace);
                }
                long newInterval = (long)((double)interval * this.retryIntervalMultiplier);
                if (newInterval > this.maxRetryInterval) {
                    newInterval = this.maxRetryInterval;
                }
                interval = newInterval;
                continue;
            }
            HornetQClientLogger.LOGGER.debug("Could not connect to any server. Didn't have reconnection configured on the ClientSessionFactory");
            return;
        }
    }

    private void cancelScheduledTasks() {
        PingRunnable pingRunnableLocal;
        Future<?> pingerFutureLocal = this.pingerFuture;
        if (pingerFutureLocal != null) {
            pingerFutureLocal.cancel(false);
        }
        if ((pingRunnableLocal = this.pingRunnable) != null) {
            pingRunnableLocal.cancel();
        }
        this.pingerFuture = null;
        this.pingRunnable = null;
    }

    private void checkCloseConnection() {
        if (this.connection != null && this.sessions.size() == 0) {
            this.cancelScheduledTasks();
            try {
                this.connection.destroy();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.connection = null;
            try {
                if (this.connector != null) {
                    this.connector.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemotingConnection getConnection() {
        if (this.closed) {
            throw new IllegalStateException("ClientSessionFactory is closed!");
        }
        if (!this.clientProtocolManager.isAlive()) {
            return null;
        }
        Object object = this.connectionLock;
        synchronized (object) {
            block15: {
                if (this.connection != null) {
                    return this.connection;
                }
                this.connection = this.establishNewConnection();
                if (this.connection != null && this.liveNodeID != null) {
                    try {
                        if (!this.clientProtocolManager.checkForFailover(this.liveNodeID)) {
                            this.connection.destroy();
                            this.connection = null;
                        }
                    }
                    catch (HornetQException e) {
                        if (this.connection == null) break block15;
                        this.connection.destroy();
                        this.connection = null;
                    }
                }
            }
            if (this.connection != null && this.serverLocator.getAfterConnectInternalListener() != null) {
                this.serverLocator.getAfterConnectInternalListener().onConnection(this);
            }
            if (this.serverLocator.getTopology() != null) {
                if (this.connection != null) {
                    if (isTrace) {
                        HornetQClientLogger.LOGGER.trace(this + "::Subscribing Topology");
                    }
                    this.clientProtocolManager.sendSubscribeTopology(this.serverLocator.isClusterConnection());
                }
            } else {
                HornetQClientLogger.LOGGER.debug("serverLocator@" + System.identityHashCode(this.serverLocator + " had no topology"));
            }
            return this.connection;
        }
    }

    protected void schedulePing() {
        if (this.pingerFuture == null) {
            this.pingRunnable = new PingRunnable();
            if (this.clientFailureCheckPeriod != -1L) {
                this.pingerFuture = this.scheduledThreadPool.scheduleWithFixedDelay(new ActualScheduledPinger(this.pingRunnable), 0L, this.clientFailureCheckPeriod, TimeUnit.MILLISECONDS);
            }
            this.pingRunnable.send();
        } else {
            this.pingRunnable.run();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed && this.finalizeCheck) {
            HornetQClientLogger.LOGGER.factoryLeftOpen(this.createTrace, System.identityHashCode(this));
            this.close();
        }
        super.finalize();
    }

    protected ConnectorFactory instantiateConnectorFactory(final String connectorFactoryClassName) {
        ConnectorFactory cachedFactory = this.connectorFactory;
        if (cachedFactory != null && cachedFactory.getClass().getName().equals(connectorFactoryClassName)) {
            return cachedFactory;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ConnectorFactory>(){

            @Override
            public ConnectorFactory run() {
                return (ConnectorFactory)ClassloadingUtil.newInstanceFromClassLoader((String)connectorFactoryClassName);
            }
        });
    }

    @Override
    public void setReconnectAttempts(int attempts) {
        this.reconnectAttempts = attempts;
    }

    @Override
    public Object getConnector() {
        return this.connector;
    }

    @Override
    public ConfirmationWindowWarning getConfirmationWindowWarning() {
        return this.confirmationWindowWarning;
    }

    protected Connection openTransportConnection(Connector connector) {
        connector.start();
        Connection transportConnection = connector.createConnection();
        if (transportConnection == null) {
            if (isDebug) {
                HornetQClientLogger.LOGGER.debug("Connector towards " + connector + " failed");
            }
            try {
                connector.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return transportConnection;
    }

    protected Connector createConnector(ConnectorFactory connectorFactory, TransportConfiguration configuration) {
        return connectorFactory.createConnector(configuration.getParams(), new DelegatingBufferHandler(), this, this.closeExecutor, this.threadPool, this.scheduledThreadPool, this.clientProtocolManager);
    }

    private void checkTransportKeys(ConnectorFactory factory, TransportConfiguration tc) {
        Set<String> invalid;
        if (tc.getParams() != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), tc.getParams().keySet())).isEmpty()) {
            String msg = "The following keys are invalid for configuring a connector: " + ConfigurationHelper.stringSetToCommaListString(invalid);
            throw new IllegalStateException(msg);
        }
    }

    protected Connection createTransportConnection() {
        Connection transportConnection = null;
        try {
            Connector liveConnector;
            if (isDebug) {
                HornetQClientLogger.LOGGER.debug("Trying to connect with connector = " + this.connectorFactory + ", parameters = " + this.connectorConfig.getParams() + " connector = " + this.connector);
            }
            if ((transportConnection = this.openTransportConnection(liveConnector = this.createConnector(this.connectorFactory, this.connectorConfig))) != null) {
                this.connector = liveConnector;
            } else if (this.backupConfig != null) {
                if (isDebug) {
                    HornetQClientLogger.LOGGER.debug("Trying backup config = " + this.backupConfig);
                }
                ConnectorFactory backupConnectorFactory = this.instantiateConnectorFactory(this.backupConfig.getFactoryClassName());
                Connector backupConnector = this.createConnector(backupConnectorFactory, this.backupConfig);
                transportConnection = this.openTransportConnection(backupConnector);
                transportConnection = this.openTransportConnection(backupConnector);
                if (transportConnection != null) {
                    if (isDebug) {
                        HornetQClientLogger.LOGGER.debug("Connected to the backup at " + this.backupConfig);
                    }
                    this.connector = backupConnector;
                    this.connectorConfig = this.backupConfig;
                    this.backupConfig = null;
                    this.connectorFactory = backupConnectorFactory;
                } else if (isDebug) {
                    HornetQClientLogger.LOGGER.debug("Backup is not active yet");
                }
            }
        }
        catch (Exception cause) {
            HornetQClientLogger.LOGGER.createConnectorException(cause);
            if (transportConnection != null) {
                try {
                    transportConnection.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (this.connector != null) {
                try {
                    this.connector.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            transportConnection = null;
            this.connector = null;
        }
        return transportConnection;
    }

    protected RemotingConnection establishNewConnection() {
        Connection transportConnection = this.createTransportConnection();
        if (transportConnection == null) {
            if (isTrace) {
                HornetQClientLogger.LOGGER.trace("Neither backup or live were active, will just give up now");
            }
            return null;
        }
        RemotingConnection newConnection = this.clientProtocolManager.connect(transportConnection, this.callTimeout, this.callFailoverTimeout, this.incomingInterceptors, this.outgoingInterceptors, new SessionFactoryTopologyHandler());
        newConnection.addFailureListener(new DelegatingFailureListener(newConnection.getID()));
        this.schedulePing();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("returning " + this.connection);
        }
        return newConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionContext createSessionChannel(String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws HornetQException {
        Object object = this.createSessionLock;
        synchronized (object) {
            return this.clientProtocolManager.createSessionContext(name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.getMinLargeMessageSize(), this.serverLocator.getConfirmationWindowSize());
        }
    }

    @Override
    public String getLiveNodeId() {
        return this.liveNodeID;
    }

    class SessionFactoryTopologyHandler
    implements TopologyResponseHandler {
        SessionFactoryTopologyHandler() {
        }

        @Override
        public void nodeDisconnected(RemotingConnection conn, String nodeID, String scaleDownTargetNodeID) {
            if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
                HornetQClientLogger.LOGGER.trace("Disconnect being called on client: server locator = " + ClientSessionFactoryImpl.this.serverLocator + " notifying node " + nodeID + " as down", new Exception("trace"));
            }
            ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(System.currentTimeMillis(), nodeID);
            ClientSessionFactoryImpl.this.closeExecutor.execute(new CloseRunnable(conn, scaleDownTargetNodeID));
        }

        @Override
        public void notifyNodeUp(long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean isLast) {
            if (connectorPair.getA() != null && ((TransportConfiguration)connectorPair.getA()).equals(ClientSessionFactoryImpl.this.connectorConfig)) {
                ClientSessionFactoryImpl.this.liveNodeID = nodeID;
            }
            ClientSessionFactoryImpl.this.serverLocator.notifyNodeUp(uniqueEventID, nodeID, backupGroupName, scaleDownGroupName, connectorPair, isLast);
        }

        @Override
        public void notifyNodeDown(long eventTime, String nodeID) {
            ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(eventTime, nodeID);
        }
    }

    private final class PingRunnable
    implements Runnable {
        private boolean cancelled;
        private boolean first;
        private long lastCheck = System.currentTimeMillis();

        private PingRunnable() {
        }

        @Override
        public synchronized void run() {
            if (this.cancelled || ClientSessionFactoryImpl.this.stopPingingAfterOne && !this.first) {
                return;
            }
            this.first = false;
            long now = System.currentTimeMillis();
            if (ClientSessionFactoryImpl.this.clientFailureCheckPeriod != -1L && ClientSessionFactoryImpl.this.connectionTTL != -1L && now >= this.lastCheck + ClientSessionFactoryImpl.this.connectionTTL) {
                if (!ClientSessionFactoryImpl.this.connection.checkDataReceived()) {
                    HornetQConnectionTimedOutException me = HornetQClientMessageBundle.BUNDLE.connectionTimedOut(ClientSessionFactoryImpl.this.connection.getTransportConnection());
                    this.cancelled = true;
                    ClientSessionFactoryImpl.this.threadPool.execute(new Runnable((HornetQException)me){
                        final /* synthetic */ HornetQException val$me;
                        {
                            this.val$me = hornetQException;
                        }

                        @Override
                        public void run() {
                            ClientSessionFactoryImpl.this.connection.fail(this.val$me);
                        }
                    });
                    return;
                }
                this.lastCheck = now;
            }
            this.send();
        }

        public void send() {
            ClientSessionFactoryImpl.this.clientProtocolManager.ping(ClientSessionFactoryImpl.this.connectionTTL);
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private static final class ActualScheduledPinger
    implements Runnable {
        private final WeakReference<PingRunnable> pingRunnable;

        ActualScheduledPinger(PingRunnable runnable) {
            this.pingRunnable = new WeakReference<PingRunnable>(runnable);
        }

        @Override
        public void run() {
            PingRunnable runnable = (PingRunnable)this.pingRunnable.get();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    private final class DelegatingFailureListener
    implements FailureListener {
        private final Object connectionID;

        DelegatingFailureListener(Object connectionID) {
            this.connectionID = connectionID;
        }

        @Override
        public void connectionFailed(HornetQException me, boolean failedOver) {
            this.connectionFailed(me, failedOver, null);
        }

        @Override
        public void connectionFailed(HornetQException me, boolean failedOver, String scaleDownTargetNodeID) {
            ClientSessionFactoryImpl.this.handleConnectionFailure(this.connectionID, me, scaleDownTargetNodeID);
        }

        public String toString() {
            return DelegatingFailureListener.class.getSimpleName() + "('reconnectsOrFailover', hash=" + super.hashCode() + ")";
        }
    }

    private class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        @Override
        public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
            RemotingConnection theConn = ClientSessionFactoryImpl.this.connection;
            if (theConn != null && connectionID.equals(theConn.getID())) {
                theConn.bufferReceived(connectionID, buffer);
            } else {
                HornetQClientLogger.LOGGER.debug("TheConn == null on ClientSessionFactoryImpl::DelegatingBufferHandler, ignoring packet");
            }
        }
    }

    public class CloseRunnable
    implements Runnable {
        private final RemotingConnection conn;
        private final String scaleDownTargetNodeID;

        public CloseRunnable(RemotingConnection conn, String scaleDownTargetNodeID) {
            this.conn = conn;
            this.scaleDownTargetNodeID = scaleDownTargetNodeID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CLOSE_RUNNABLES.add(this);
                if (this.scaleDownTargetNodeID == null) {
                    this.conn.fail((HornetQException)HornetQClientMessageBundle.BUNDLE.disconnected());
                } else {
                    this.conn.fail((HornetQException)HornetQClientMessageBundle.BUNDLE.disconnected(), this.scaleDownTargetNodeID);
                }
            }
            finally {
                CLOSE_RUNNABLES.remove(this);
            }
        }

        public ClientSessionFactoryImpl stop() {
            ClientSessionFactoryImpl.this.causeExit();
            CLOSE_RUNNABLES.remove(this);
            return ClientSessionFactoryImpl.this;
        }
    }
}

