/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.FailoverEventListener;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientLargeMessageInternal;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.client.impl.ClientProducerCreditManager;
import org.hornetq.core.client.impl.ClientProducerCreditManagerImpl;
import org.hornetq.core.client.impl.ClientProducerCredits;
import org.hornetq.core.client.impl.ClientProducerImpl;
import org.hornetq.core.client.impl.ClientProducerInternal;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.HornetQXAResource;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.ConsumerContext;
import org.hornetq.spi.core.remoting.SessionContext;
import org.hornetq.utils.ConfirmationWindowWarning;
import org.hornetq.utils.TokenBucketLimiterImpl;
import org.hornetq.utils.XidCodecSupport;

public final class ClientSessionImpl
implements ClientSessionInternal,
FailureListener {
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final ClientSessionFactoryInternal sessionFactory;
    private final String name;
    private final String username;
    private final String password;
    private final boolean xa;
    private final Executor executor;
    private final Executor flowControlExecutor;
    private final Set<ClientProducerInternal> producers = new HashSet<ClientProducerInternal>();
    private final Map<ConsumerContext, ClientConsumerInternal> consumers = new LinkedHashMap<ConsumerContext, ClientConsumerInternal>();
    private volatile boolean closed;
    private final boolean autoCommitAcks;
    private final boolean preAcknowledge;
    private final boolean autoCommitSends;
    private final boolean blockOnAcknowledge;
    private final boolean autoGroup;
    private final int ackBatchSize;
    private final int consumerWindowSize;
    private final int consumerMaxRate;
    private final int confirmationWindowSize;
    private final int producerMaxRate;
    private final boolean blockOnNonDurableSend;
    private final boolean blockOnDurableSend;
    private final int minLargeMessageSize;
    private final boolean compressLargeMessages;
    private volatile int initialMessagePacketSize;
    private final boolean cacheLargeMessageClient;
    private final SessionContext sessionContext;
    private boolean forceNotSameRM;
    private final ClientProducerCreditManager producerCreditManager;
    private volatile boolean started;
    private volatile boolean rollbackOnly;
    private volatile boolean workDone;
    private final String groupID;
    private volatile boolean inClose;
    private volatile boolean mayAttemptToFailover = true;
    private volatile SimpleString defaultAddress;
    private Xid currentXID;
    private final AtomicInteger concurrentCall = new AtomicInteger(0);
    private final ConfirmationWindowWarning confirmationWindowWarning;

    ClientSessionImpl(ClientSessionFactoryInternal sessionFactory, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean blockOnAcknowledge, boolean autoGroup, int ackBatchSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnNonDurableSend, boolean blockOnDurableSend, boolean cacheLargeMessageClient, int minLargeMessageSize, boolean compressLargeMessages, int initialMessagePacketSize, String groupID, SessionContext sessionContext, Executor executor, Executor flowControlExecutor) throws HornetQException {
        this.sessionFactory = sessionFactory;
        this.name = name;
        this.username = username;
        this.password = password;
        this.executor = executor;
        this.flowControlExecutor = flowControlExecutor;
        this.xa = xa;
        this.autoCommitAcks = autoCommitAcks;
        this.preAcknowledge = preAcknowledge;
        this.autoCommitSends = autoCommitSends;
        this.blockOnAcknowledge = blockOnAcknowledge;
        this.autoGroup = autoGroup;
        this.ackBatchSize = ackBatchSize;
        this.consumerWindowSize = consumerWindowSize;
        this.consumerMaxRate = consumerMaxRate;
        this.confirmationWindowSize = confirmationWindowSize;
        this.producerMaxRate = producerMaxRate;
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        this.blockOnDurableSend = blockOnDurableSend;
        this.cacheLargeMessageClient = cacheLargeMessageClient;
        this.minLargeMessageSize = minLargeMessageSize;
        this.compressLargeMessages = compressLargeMessages;
        this.initialMessagePacketSize = initialMessagePacketSize;
        this.groupID = groupID;
        this.producerCreditManager = new ClientProducerCreditManagerImpl(this, producerWindowSize);
        this.sessionContext = sessionContext;
        sessionContext.setSession(this);
        this.confirmationWindowWarning = sessionFactory.getConfirmationWindowWarning();
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName) throws HornetQException {
        this.internalCreateQueue(address, queueName, null, false, false);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, boolean durable) throws HornetQException {
        this.internalCreateQueue(address, queueName, null, durable, false);
    }

    @Override
    public void createQueue(String address, String queueName, boolean durable) throws HornetQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), durable);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, boolean durable) throws HornetQException {
        this.createSharedQueue(address, queueName, null, durable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws HornetQException {
        this.checkClosed();
        this.startCall();
        try {
            this.sessionContext.createSharedQueue(address, queueName, filterString, durable);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws HornetQException {
        this.internalCreateQueue(address, queueName, filterString, durable, false);
    }

    @Override
    public void createQueue(String address, String queueName, String filterString, boolean durable) throws HornetQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), durable);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName) throws HornetQException {
        this.internalCreateQueue(address, queueName, null, false, true);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName) throws HornetQException {
        this.internalCreateQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), null, false, true);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName, SimpleString filter) throws HornetQException {
        this.internalCreateQueue(address, queueName, filter, false, true);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName, String filter) throws HornetQException {
        this.internalCreateQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filter), false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(SimpleString queueName) throws HornetQException {
        this.checkClosed();
        this.startCall();
        try {
            this.sessionContext.deleteQueue(queueName);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void deleteQueue(String queueName) throws HornetQException {
        this.deleteQueue(SimpleString.toSimpleString((String)queueName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws HornetQException {
        this.checkClosed();
        this.startCall();
        try {
            ClientSession.QueueQuery queueQuery = this.sessionContext.queueQuery(queueName);
            return queueQuery;
        }
        finally {
            this.endCall();
        }
    }

    @Deprecated
    public ClientSession.BindingQuery bindingQuery(SimpleString address) throws HornetQException {
        return (ClientSession.BindingQuery)this.addressQuery(address);
    }

    @Override
    public ClientSession.AddressQuery addressQuery(SimpleString address) throws HornetQException {
        this.checkClosed();
        return this.sessionContext.addressQuery(address);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName) throws HornetQException {
        return this.createConsumer(queueName, null, false);
    }

    @Override
    public ClientConsumer createConsumer(String queueName) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName));
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString) throws HornetQException {
        return this.createConsumer(queueName, filterString, this.consumerWindowSize, this.consumerMaxRate, false);
    }

    @Override
    public void createQueue(String address, String queueName) throws HornetQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName));
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString));
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, boolean browseOnly) throws HornetQException {
        return this.createConsumer(queueName, filterString, this.consumerWindowSize, this.consumerMaxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, boolean browseOnly) throws HornetQException {
        return this.createConsumer(queueName, null, this.consumerWindowSize, this.consumerMaxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, boolean browseOnly) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, boolean browseOnly) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), null, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        return this.internalCreateConsumer(queueName, filterString, windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientProducer createProducer() throws HornetQException {
        return this.createProducer((SimpleString)null);
    }

    @Override
    public ClientProducer createProducer(SimpleString address) throws HornetQException {
        return this.createProducer(address, this.producerMaxRate);
    }

    @Override
    public ClientProducer createProducer(String address) throws HornetQException {
        return this.createProducer(SimpleString.toSimpleString((String)address));
    }

    @Override
    public ClientProducer createProducer(SimpleString address, int maxRate) throws HornetQException {
        return this.internalCreateProducer(address, maxRate);
    }

    public ClientProducer createProducer(String address, int rate) throws HornetQException {
        return this.createProducer(SimpleString.toSimpleString((String)address), rate);
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    private void rollbackOnFailover(boolean outcomeKnown) throws HornetQException {
        this.rollback(false);
        if (outcomeKnown) {
            throw HornetQClientMessageBundle.BUNDLE.txRolledBack();
        }
        throw HornetQClientMessageBundle.BUNDLE.txOutcomeUnknown();
    }

    @Override
    public void commit() throws HornetQException {
        this.checkClosed();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Sending commit");
        }
        if (this.rollbackOnly) {
            this.rollbackOnFailover(true);
        }
        this.flushAcks();
        if (this.rollbackOnly) {
            this.rollbackOnFailover(true);
        }
        try {
            this.sessionContext.simpleCommit();
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED || this.rollbackOnly) {
                this.rollbackOnFailover(false);
            }
            throw e;
        }
        if (this.rollbackOnly) {
            this.rollbackOnFailover(false);
        }
        this.workDone = false;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public void rollback() throws HornetQException {
        this.rollback(false);
    }

    @Override
    public void rollback(boolean isLastMessageAsDelivered) throws HornetQException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("calling rollback(isLastMessageAsDelivered=" + isLastMessageAsDelivered + ")");
        }
        this.checkClosed();
        boolean wasStarted = this.started;
        if (wasStarted) {
            this.stop();
        }
        for (ClientConsumerInternal consumer : this.cloneConsumers()) {
            consumer.clear(true);
        }
        this.flushAcks();
        this.sessionContext.simpleRollback(isLastMessageAsDelivered);
        if (wasStarted) {
            this.start();
        }
        this.rollbackOnly = false;
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable, long expiration, long timestamp, byte priority) {
        return new ClientMessageImpl(type, durable, expiration, timestamp, priority, this.initialMessagePacketSize);
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable) {
        return this.createMessage(type, durable, 0L, System.currentTimeMillis(), (byte)4);
    }

    @Override
    public ClientMessage createMessage(boolean durable) {
        return this.createMessage((byte)0, durable);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isAutoCommitSends() {
        return this.autoCommitSends;
    }

    @Override
    public boolean isAutoCommitAcks() {
        return this.autoCommitAcks;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public boolean isXA() {
        return this.xa;
    }

    @Override
    public void resetIfNeeded() throws HornetQException {
        if (this.rollbackOnly) {
            HornetQClientLogger.LOGGER.resettingSessionAfterFailure();
            this.rollback(false);
        }
    }

    @Override
    public ClientSessionImpl start() throws HornetQException {
        this.checkClosed();
        if (!this.started) {
            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                clientConsumerInternal.start();
            }
            this.sessionContext.sessionStart();
            this.started = true;
        }
        return this;
    }

    @Override
    public void stop() throws HornetQException {
        this.stop(true);
    }

    public void stop(boolean waitForOnMessage) throws HornetQException {
        this.checkClosed();
        if (this.started) {
            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                clientConsumerInternal.stop(waitForOnMessage);
            }
            this.sessionContext.sessionStop();
            this.started = false;
        }
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.sessionFactory.addFailureListener(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.sessionFactory.removeFailureListener(listener);
    }

    @Override
    public void addFailoverListener(FailoverEventListener listener) {
        this.sessionFactory.addFailoverListener(listener);
    }

    @Override
    public boolean removeFailoverListener(FailoverEventListener listener) {
        return this.sessionFactory.removeFailoverListener(listener);
    }

    @Override
    public int getVersion() {
        return this.sessionContext.getServerVersion();
    }

    @Override
    public boolean isClosing() {
        return this.inClose;
    }

    @Override
    public String getNodeId() {
        return this.sessionFactory.getLiveNodeId();
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public boolean isCompressLargeMessages() {
        return this.compressLargeMessages;
    }

    @Override
    public boolean isCacheLargeMessageClient() {
        return this.cacheLargeMessageClient;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(ClientConsumer consumer, Message message) throws HornetQException {
        if (this.preAcknowledge) {
            return;
        }
        this.checkClosed();
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug("client ack messageID = " + message.getMessageID());
        }
        this.startCall();
        try {
            this.sessionContext.sendACK(false, this.blockOnAcknowledge, consumer, message);
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void individualAcknowledge(ClientConsumer consumer, Message message) throws HornetQException {
        if (this.preAcknowledge) {
            return;
        }
        this.checkClosed();
        this.startCall();
        try {
            this.sessionContext.sendACK(true, this.blockOnAcknowledge, consumer, message);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void expire(ClientConsumer consumer, Message message) throws HornetQException {
        this.checkClosed();
        if (!this.preAcknowledge) {
            this.sessionContext.expireMessage(consumer, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(ClientConsumerInternal consumer) {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            this.consumers.put(consumer.getConsumerContext(), consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ClientProducerInternal producer) {
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ClientConsumerInternal consumer) throws HornetQException {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            this.consumers.remove(consumer.getConsumerContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ClientProducerInternal producer) {
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            this.producers.remove(producer);
        }
    }

    @Override
    public void handleReceiveMessage(ConsumerContext consumerID, ClientMessageInternal message) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleMessage(message);
        }
    }

    @Override
    public void handleReceiveLargeMessage(ConsumerContext consumerID, ClientLargeMessageInternal clientLargeMessage, long largeMessageSize) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleLargeMessage(clientLargeMessage, largeMessageSize);
        }
    }

    @Override
    public void handleReceiveContinuation(ConsumerContext consumerID, byte[] chunk, int flowControlSize, boolean isContinues) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleLargeMessageContinuation(chunk, flowControlSize, isContinues);
        }
    }

    @Override
    public void handleConsumerDisconnect(ConsumerContext context) throws HornetQException {
        final ClientConsumerInternal consumer = this.getConsumer(context);
        if (consumer != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        consumer.close();
                    }
                    catch (HornetQException e) {
                        HornetQClientLogger.LOGGER.unableToCloseConsumer((Exception)((Object)e));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HornetQException {
        if (this.closed) {
            HornetQClientLogger.LOGGER.debug("Session was already closed, giving up now, this=" + this);
            return;
        }
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug("Calling close on session " + this);
        }
        try {
            this.closeChildren();
            ClientSessionImpl clientSessionImpl = this;
            synchronized (clientSessionImpl) {
                this.producerCreditManager.close();
            }
            this.inClose = true;
            this.sessionContext.sessionClose();
        }
        catch (Throwable e) {
            HornetQClientLogger.LOGGER.trace("Failed to close session", e);
        }
        this.doCleanup(false);
    }

    @Override
    public synchronized void cleanUp(boolean failingOver) throws HornetQException {
        if (this.closed) {
            return;
        }
        this.producerCreditManager.close();
        this.cleanUpChildren();
        this.doCleanup(failingOver);
    }

    @Override
    public ClientSessionImpl setSendAcknowledgementHandler(SendAcknowledgementHandler handler) {
        this.sessionContext.setSendAcknowledgementHandler(handler);
        return this;
    }

    @Override
    public void preHandleFailover(RemotingConnection connection) {
        this.sessionContext.lockCommunications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFailover(RemotingConnection backupConnection, HornetQException cause) {
        HashMap<String, String> metaDataToSend;
        ClientSessionImpl clientSessionImpl = this;
        synchronized (clientSessionImpl) {
            if (this.closed) {
                return;
            }
            boolean resetCreditManager = false;
            try {
                boolean reattached = this.sessionContext.reattachOnNewConnection(backupConnection);
                if (!reattached) {
                    if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                        HornetQClientLogger.LOGGER.debug("ClientSession couldn't be reattached, creating a new session");
                    }
                    for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                        clientConsumerInternal.clearAtFailover();
                    }
                    if (!this.inClose && this.mayAttemptToFailover) {
                        this.sessionContext.recreateSession(this.username, this.password, this.minLargeMessageSize, this.xa, this.autoCommitSends, this.autoCommitAcks, this.preAcknowledge, this.defaultAddress);
                        for (Map.Entry entry : this.consumers.entrySet()) {
                            ClientConsumerInternal consumerInternal = (ClientConsumerInternal)entry.getValue();
                            this.sessionContext.recreateConsumerOnServer(consumerInternal);
                        }
                        if (!(this.autoCommitAcks && this.autoCommitSends || !this.workDone)) {
                            this.rollbackOnly = true;
                        }
                        if (this.currentXID != null) {
                            this.sessionContext.xaFailed(this.currentXID);
                            this.rollbackOnly = true;
                        }
                        if (this.started) {
                            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                                clientConsumerInternal.clearAtFailover();
                                clientConsumerInternal.start();
                            }
                            this.sessionContext.restartSession();
                        }
                        resetCreditManager = true;
                    }
                    this.sessionContext.returnBlocking(cause);
                }
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.failedToHandleFailover(t);
            }
            finally {
                this.sessionContext.releaseCommunications();
            }
            if (resetCreditManager) {
                this.producerCreditManager.reset();
            }
        }
        Map<String, String> map = this.metadata;
        synchronized (map) {
            metaDataToSend = new HashMap<String, String>(this.metadata);
        }
        this.sessionContext.resetMetadata(metaDataToSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaData(String key, String data) throws HornetQException {
        Map<String, String> map = this.metadata;
        synchronized (map) {
            this.metadata.put(key, data);
        }
        this.sessionContext.addSessionMetadata(key, data);
    }

    @Override
    public void addUniqueMetaData(String key, String data) throws HornetQException {
        this.sessionContext.addUniqueMetaData(key, data);
    }

    @Override
    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void setAddress(Message message, SimpleString address) {
        if (this.defaultAddress == null) {
            this.defaultAddress = address;
            message.setAddress(address);
        } else if (!address.equals((Object)this.defaultAddress)) {
            message.setAddress(address);
        } else {
            message.setAddress(null);
        }
    }

    @Override
    public void setPacketSize(int packetSize) {
        if (packetSize > this.initialMessagePacketSize) {
            this.initialMessagePacketSize = (int)((double)packetSize * 1.2);
        }
    }

    @Override
    public void workDone() {
        this.workDone = true;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        this.sessionContext.sendProducerCreditsMessage(credits, address);
    }

    @Override
    public synchronized ClientProducerCredits getCredits(SimpleString address, boolean anon) {
        ClientProducerCredits credits = this.producerCreditManager.getCredits(address, anon, this.sessionContext);
        return credits;
    }

    @Override
    public void returnCredits(SimpleString address) {
        this.producerCreditManager.returnCredits(address);
    }

    @Override
    public void handleReceiveProducerCredits(SimpleString address, int credits) {
        this.producerCreditManager.receiveCredits(address, credits);
    }

    @Override
    public void handleReceiveProducerFailCredits(SimpleString address, int credits) {
        this.producerCreditManager.receiveFailCredits(address, credits);
    }

    @Override
    public ClientProducerCreditManager getProducerCreditManager() {
        return this.producerCreditManager;
    }

    @Override
    public void startCall() {
        if (this.concurrentCall.incrementAndGet() > 1) {
            HornetQClientLogger.LOGGER.invalidConcurrentSessionUsage(new Exception("trace"));
        }
    }

    @Override
    public void endCall() {
        this.concurrentCall.decrementAndGet();
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("call commit(xid=" + ClientSessionImpl.convert(xid));
        }
        this.checkXA();
        if (this.rollbackOnly) {
            HornetQClientLogger.LOGGER.commitAfterFailover();
        }
        this.startCall();
        try {
            this.sessionContext.xaCommit(xid, onePhase);
            this.workDone = false;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable t) {
            HornetQClientLogger.LOGGER.failoverDuringCommit();
            XAException xaException = new XAException(4);
            xaException.initCause(t);
            throw xaException;
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling end:: " + ClientSessionImpl.convert(xid) + ", flags=" + this.convertTXFlag(flags));
        }
        this.checkXA();
        try {
            if (this.rollbackOnly) {
                try {
                    this.rollback();
                }
                catch (Throwable ignored) {
                    HornetQClientLogger.LOGGER.debug("Error on rollback during end call!", ignored);
                }
                throw new XAException(104);
            }
            try {
                this.flushAcks();
                this.startCall();
                try {
                    this.sessionContext.xaEnd(xid, flags);
                }
                finally {
                    this.endCall();
                }
            }
            catch (XAException xae) {
                throw xae;
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.errorCallingEnd(t);
                XAException xaException = new XAException(-3);
                xaException.initCause(t);
                throw xaException;
            }
        }
        finally {
            this.currentXID = null;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.checkXA();
        this.startCall();
        try {
            this.sessionContext.xaForget(xid);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-3);
            xaException.initCause(t);
            throw xaException;
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        this.checkXA();
        try {
            return this.sessionContext.recoverSessionTimeout();
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-3);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.checkXA();
        try {
            return this.sessionContext.configureTransactionTimeout(seconds);
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-3);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        this.checkXA();
        if (this.forceNotSameRM) {
            return false;
        }
        ClientSessionInternal other = this.getSessionInternalFromXAResource(xares);
        if (other == null) {
            return false;
        }
        String liveNodeId = this.sessionFactory.getLiveNodeId();
        String otherLiveNodeId = ((ClientSessionFactoryInternal)other.getSessionFactory()).getLiveNodeId();
        if (liveNodeId != null && otherLiveNodeId != null) {
            return liveNodeId.equals(otherLiveNodeId);
        }
        return this.sessionFactory == other.getSessionFactory();
    }

    private ClientSessionInternal getSessionInternalFromXAResource(XAResource xares) {
        if (xares == null) {
            return null;
        }
        if (xares instanceof ClientSessionInternal) {
            return (ClientSessionInternal)xares;
        }
        if (xares instanceof HornetQXAResource) {
            return this.getSessionInternalFromXAResource(((HornetQXAResource)xares).getResource());
        }
        return null;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.checkXA();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling prepare:: " + ClientSessionImpl.convert(xid));
        }
        if (this.rollbackOnly) {
            throw new XAException(104);
        }
        this.startCall();
        try {
            int n = this.sessionContext.xaPrepare(xid);
            return n;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED) {
                try {
                    int n = this.sessionContext.xaPrepare(xid);
                    return n;
                }
                catch (Throwable t) {
                    HornetQClientLogger.LOGGER.failoverDuringPrepareRollingBack();
                    try {
                        this.rollback(false);
                    }
                    catch (Throwable t2) {
                        XAException xaException = new XAException(-3);
                        xaException.initCause(t2);
                        throw xaException;
                    }
                    HornetQClientLogger.LOGGER.errorDuringPrepare(e);
                    throw new XAException(104);
                }
            }
            HornetQClientLogger.LOGGER.errorDuringPrepare(e);
            XAException xaException = new XAException(-3);
            xaException.initCause(e);
            throw xaException;
        }
        catch (Throwable t) {
            HornetQClientLogger.LOGGER.errorDuringPrepare(t);
            XAException xaException = new XAException(-3);
            xaException.initCause(t);
            throw xaException;
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        this.checkXA();
        if ((flags & 0x1000000) == 0x1000000) {
            try {
                return this.sessionContext.xaScan();
            }
            catch (Throwable t) {
                XAException xaException = new XAException(-3);
                xaException.initCause(t);
                throw xaException;
            }
        }
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        this.checkXA();
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling rollback:: " + ClientSessionImpl.convert(xid));
        }
        try {
            boolean wasStarted = this.started;
            if (wasStarted) {
                this.stop(false);
            }
            for (ClientConsumerInternal consumer : this.cloneConsumers()) {
                consumer.clear(false);
            }
            this.flushAcks();
            try {
                this.sessionContext.xaRollback(xid, wasStarted);
            }
            finally {
                if (wasStarted) {
                    this.start();
                }
            }
            this.workDone = false;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED) {
                throw new XAException(4);
            }
            XAException xaException = new XAException(-3);
            xaException.initCause(e);
            throw xaException;
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-3);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("Calling start:: " + ClientSessionImpl.convert(xid) + " clientXID=" + xid + " flags = " + this.convertTXFlag(flags));
        }
        this.checkXA();
        try {
            this.sessionContext.xaStart(xid, flags);
            this.currentXID = xid;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.UNBLOCKED) {
                try {
                    this.sessionContext.xaStart(xid, flags);
                }
                catch (XAException xae) {
                    throw xae;
                }
                catch (Throwable t) {
                    XAException xaException = new XAException(-3);
                    xaException.initCause(t);
                    throw xaException;
                }
            }
            XAException xaException = new XAException(-3);
            xaException.initCause(e);
            throw xaException;
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-3);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public void connectionFailed(HornetQException me, boolean failedOver) {
        try {
            this.cleanUp(false);
        }
        catch (Exception e) {
            HornetQClientLogger.LOGGER.failedToCleanupSession(e);
        }
    }

    @Override
    public void connectionFailed(HornetQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    @Override
    public void setForceNotSameRM(boolean force) {
        this.forceNotSameRM = force;
    }

    @Override
    public RemotingConnection getConnection() {
        return this.sessionContext.getRemotingConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Map<String, String> map = this.metadata;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                buffer.append(entry.getKey() + "=" + entry.getValue() + ",");
            }
        }
        return "ClientSessionImpl [name=" + this.name + ", username=" + this.username + ", closed=" + this.closed + ", factory = " + this.sessionFactory + ", metaData=(" + buffer + ")]@" + Integer.toHexString(this.hashCode());
    }

    private ClientConsumer internalCreateConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, boolean browseOnly) throws HornetQException {
        this.checkClosed();
        ClientConsumerInternal consumer = this.sessionContext.createConsumer(queueName, filterString, windowSize, maxRate, this.ackBatchSize, browseOnly, this.executor, this.flowControlExecutor);
        this.addConsumer(consumer);
        if (windowSize != 0) {
            this.sessionContext.sendConsumerCredits(consumer, windowSize);
        }
        return consumer;
    }

    private ClientProducer internalCreateProducer(SimpleString address, int maxRate) throws HornetQException {
        this.checkClosed();
        ClientProducerImpl producer = new ClientProducerImpl(this, address, maxRate == -1 ? null : new TokenBucketLimiterImpl(maxRate, false), this.autoCommitSends && this.blockOnNonDurableSend, this.autoCommitSends && this.blockOnDurableSend, this.autoGroup, this.groupID == null ? null : new SimpleString(this.groupID), this.minLargeMessageSize, this.sessionContext);
        this.addProducer(producer);
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCreateQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temp) throws HornetQException {
        this.checkClosed();
        if (durable && temp) {
            throw HornetQClientMessageBundle.BUNDLE.queueMisConfigured();
        }
        this.startCall();
        try {
            this.sessionContext.createQueue(address, queueName, filterString, durable, temp);
        }
        finally {
            this.endCall();
        }
    }

    private void checkXA() throws XAException {
        if (!this.xa) {
            HornetQClientLogger.LOGGER.sessionNotXA();
            throw new XAException(-3);
        }
    }

    private void checkClosed() throws HornetQException {
        if (this.closed || this.inClose) {
            throw HornetQClientMessageBundle.BUNDLE.sessionClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConsumerInternal getConsumer(ConsumerContext consumerContext) {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            ClientConsumerInternal consumer = this.consumers.get(consumerContext);
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup(boolean failingOver) {
        if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
            HornetQClientLogger.LOGGER.debug("calling cleanup on " + this);
        }
        ClientSessionImpl clientSessionImpl = this;
        synchronized (clientSessionImpl) {
            this.closed = true;
            this.sessionContext.cleanup();
        }
        this.sessionFactory.removeSession(this, failingOver);
    }

    private void cleanUpChildren() throws HornetQException {
        Set<ClientConsumerInternal> consumersClone = this.cloneConsumers();
        for (ClientConsumerInternal consumer : consumersClone) {
            consumer.cleanUp();
        }
        Set<ClientProducerInternal> producersClone = this.cloneProducers();
        for (ClientProducerInternal producer : producersClone) {
            producer.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClientProducerInternal> cloneProducers() {
        HashSet<ClientProducerInternal> producersClone;
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            producersClone = new HashSet<ClientProducerInternal>(this.producers);
        }
        return producersClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClientConsumerInternal> cloneConsumers() {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            return new HashSet<ClientConsumerInternal>(this.consumers.values());
        }
    }

    private void closeChildren() throws HornetQException {
        Set<ClientConsumerInternal> consumersClone = this.cloneConsumers();
        for (ClientConsumer clientConsumer : consumersClone) {
            clientConsumer.close();
        }
        Set<ClientProducerInternal> producersClone = this.cloneProducers();
        for (ClientProducer clientProducer : producersClone) {
            clientProducer.close();
        }
    }

    private void flushAcks() throws HornetQException {
        for (ClientConsumerInternal consumer : this.cloneConsumers()) {
            consumer.flushAcks();
        }
    }

    public static Object convert(Xid xid) {
        HornetQBuffer buffer = HornetQBuffers.dynamicBuffer((int)200);
        XidCodecSupport.encodeXid(xid, buffer);
        Xid obj = XidCodecSupport.decodeXid(buffer);
        return "xid=" + obj + ",clientXID=" + xid;
    }

    private String convertTXFlag(int flags) {
        if (flags == 0x2000000) {
            return "SESS_XA_SUSPEND";
        }
        if (flags == 0x4000000) {
            return "TMSUCCESS";
        }
        if (flags == 0x20000000) {
            return "TMFAIL";
        }
        if (flags == 0x200000) {
            return "TMJOIN";
        }
        if (flags == 0x8000000) {
            return "TMRESUME";
        }
        if (flags == 0) {
            return "TMNOFLAGS";
        }
        return "XAER_INVAL(" + flags + ")";
    }

    @Override
    public void setStopSignal() {
        this.mayAttemptToFailover = false;
    }

    @Override
    public boolean isConfirmationWindowEnabled() {
        if (this.confirmationWindowWarning.disabled) {
            if (!this.confirmationWindowWarning.warningIssued.get()) {
                HornetQClientLogger.LOGGER.confirmationWindowDisabledWarning();
                this.confirmationWindowWarning.warningIssued.set(true);
            }
            return false;
        }
        return true;
    }

    @Override
    public void scheduleConfirmation(final SendAcknowledgementHandler handler, final Message message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                handler.sendAcknowledged(message);
            }
        });
    }
}

