/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.AddressQueryImpl;
import org.hornetq.core.client.impl.ClientConsumerImpl;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientLargeMessageInternal;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.client.impl.ClientProducerCreditsImpl;
import org.hornetq.core.client.impl.ClientSessionImpl;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CommandConfirmationHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.HornetQConsumerContext;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.DisconnectConsumerMessage;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.RollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCloseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionProducerCreditsFailMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAAfterFailedMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.SessionContext;
import org.hornetq.utils.TokenBucketLimiterImpl;

public class HornetQSessionContext
extends SessionContext {
    private final Channel sessionChannel;
    private final int serverVersion;
    private int confirmationWindow;
    private final String name;
    private final CommandConfirmationHandler confirmationHandler = new CommandConfirmationHandler(){

        @Override
        public void commandConfirmed(Packet packet) {
            SessionSendContinuationMessage scm;
            if (packet.getType() == 71) {
                SessionSendMessage ssm = (SessionSendMessage)packet;
                this.callSendAck(ssm.getHandler(), ssm.getMessage());
            } else if (packet.getType() == 73 && !(scm = (SessionSendContinuationMessage)packet).isContinues()) {
                this.callSendAck(scm.getHandler(), scm.getMessage());
            }
        }

        private void callSendAck(SendAcknowledgementHandler handler, Message message) {
            if (handler != null) {
                handler.sendAcknowledged(message);
            } else if (HornetQSessionContext.this.sendAckHandler != null) {
                HornetQSessionContext.this.sendAckHandler.sendAcknowledged(message);
            }
        }
    };

    public HornetQSessionContext(String name, RemotingConnection remotingConnection, Channel sessionChannel, int serverVersion, int confirmationWindow) {
        super(remotingConnection);
        this.name = name;
        this.sessionChannel = sessionChannel;
        this.serverVersion = serverVersion;
        this.confirmationWindow = confirmationWindow;
        ClientSessionPacketHandler handler = new ClientSessionPacketHandler();
        sessionChannel.setHandler(handler);
        if (confirmationWindow >= 0) {
            sessionChannel.setCommandConfirmationHandler(this.confirmationHandler);
        }
    }

    @Override
    public void returnBlocking(HornetQException cause) {
        this.sessionChannel.returnBlocking(cause);
    }

    @Override
    public void lockCommunications() {
        this.sessionChannel.lock();
    }

    @Override
    public void releaseCommunications() {
        this.sessionChannel.setTransferring(false);
        this.sessionChannel.unlock();
    }

    @Override
    public void cleanup() {
        this.sessionChannel.close();
        this.sessionChannel.returnBlocking();
    }

    @Override
    public void linkFlowControl(SimpleString address, ClientProducerCreditsImpl clientProducerCredits) {
    }

    @Override
    public void setSendAcknowledgementHandler(SendAcknowledgementHandler handler) {
        this.sessionChannel.setCommandConfirmationHandler(this.confirmationHandler);
        this.sendAckHandler = handler;
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws HornetQException {
        this.sessionChannel.sendBlocking(new CreateSharedQueueMessage(address, queueName, filterString, durable, true), (byte)21);
    }

    @Override
    public void deleteQueue(SimpleString queueName) throws HornetQException {
        this.sessionChannel.sendBlocking(new SessionDeleteQueueMessage(queueName), (byte)21);
    }

    @Override
    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws HornetQException {
        SessionQueueQueryMessage request = new SessionQueueQueryMessage(queueName);
        SessionQueueQueryResponseMessage response = (SessionQueueQueryResponseMessage)this.sessionChannel.sendBlocking(request, (byte)46);
        return response.toQueueQuery();
    }

    @Override
    public ClientConsumerInternal createConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, int ackBatchSize, boolean browseOnly, Executor executor, Executor flowControlExecutor) throws HornetQException {
        long consumerID = this.idGenerator.generateID();
        HornetQConsumerContext consumerContext = new HornetQConsumerContext(consumerID);
        SessionCreateConsumerMessage request = new SessionCreateConsumerMessage(consumerID, queueName, filterString, browseOnly, true);
        SessionQueueQueryResponseMessage queueInfo = (SessionQueueQueryResponseMessage)this.sessionChannel.sendBlocking(request, (byte)46);
        return new ClientConsumerImpl(this.session, consumerContext, queueName, filterString, browseOnly, this.calcWindowSize(windowSize), ackBatchSize, maxRate > 0 ? new TokenBucketLimiterImpl(maxRate, false) : null, executor, flowControlExecutor, this, queueInfo.toQueueQuery(), this.lookupTCCL());
    }

    @Override
    public int getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public ClientSession.AddressQuery addressQuery(SimpleString address) throws HornetQException {
        SessionBindingQueryResponseMessage response = (SessionBindingQueryResponseMessage)this.sessionChannel.sendBlocking(new SessionBindingQueryMessage(address), (byte)50);
        return new AddressQueryImpl(response.isExists(), response.getQueueNames());
    }

    @Override
    public void closeConsumer(ClientConsumer consumer) throws HornetQException {
        this.sessionChannel.sendBlocking(new SessionConsumerCloseMessage(this.getConsumerID(consumer)), (byte)21);
    }

    @Override
    public void sendConsumerCredits(ClientConsumer consumer, int credits) {
        this.sessionChannel.send(new SessionConsumerFlowCreditMessage(this.getConsumerID(consumer), credits));
    }

    @Override
    public void forceDelivery(ClientConsumer consumer, long sequence) throws HornetQException {
        SessionForceConsumerDelivery request = new SessionForceConsumerDelivery(this.getConsumerID(consumer), sequence);
        this.sessionChannel.send(request);
    }

    @Override
    public void simpleCommit() throws HornetQException {
        this.sessionChannel.sendBlocking(new PacketImpl(43), (byte)21);
    }

    @Override
    public void simpleRollback(boolean lastMessageAsDelivered) throws HornetQException {
        this.sessionChannel.sendBlocking(new RollbackMessage(lastMessageAsDelivered), (byte)21);
    }

    @Override
    public void sessionStart() throws HornetQException {
        this.sessionChannel.send(new PacketImpl(67));
    }

    @Override
    public void sessionStop() throws HornetQException {
        this.sessionChannel.sendBlocking(new PacketImpl(68), (byte)21);
    }

    @Override
    public void addSessionMetadata(String key, String data) throws HornetQException {
        this.sessionChannel.sendBlocking(new SessionAddMetaDataMessageV2(key, data), (byte)21);
    }

    @Override
    public void addUniqueMetaData(String key, String data) throws HornetQException {
        this.sessionChannel.sendBlocking(new SessionUniqueAddMetaDataMessage(key, data), (byte)21);
    }

    @Override
    public void xaCommit(Xid xid, boolean onePhase) throws XAException, HornetQException {
        SessionXACommitMessage packet = new SessionXACommitMessage(xid, onePhase);
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
        if (HornetQClientLogger.LOGGER.isTraceEnabled()) {
            HornetQClientLogger.LOGGER.trace("finished commit on " + ClientSessionImpl.convert(xid) + " with response = " + response);
        }
    }

    @Override
    public void xaEnd(Xid xid, int flags) throws XAException, HornetQException {
        PacketImpl packet;
        if (flags == 0x2000000) {
            packet = new PacketImpl(58);
        } else if (flags == 0x4000000) {
            packet = new SessionXAEndMessage(xid, false);
        } else if (flags == 0x20000000) {
            packet = new SessionXAEndMessage(xid, true);
        } else {
            throw new XAException(-5);
        }
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        this.sessionChannel.send(new SessionRequestProducerCreditsMessage(credits, address));
    }

    @Override
    public boolean supportsLargeMessage() {
        return true;
    }

    @Override
    public int getCreditsOnSendingFull(MessageInternal msgI) {
        return msgI.getEncodeSize();
    }

    @Override
    public void sendFullMessage(MessageInternal msgI, boolean sendBlocking, SendAcknowledgementHandler handler, SimpleString defaultAddress) throws HornetQException {
        SessionSendMessage packet = new SessionSendMessage(msgI, sendBlocking, handler);
        if (sendBlocking) {
            this.sessionChannel.sendBlocking(packet, (byte)21);
        } else {
            this.sessionChannel.sendBatched(packet);
        }
    }

    @Override
    public int sendInitialChunkOnLargeMessage(MessageInternal msgI) throws HornetQException {
        SessionSendLargeMessage initialChunk = new SessionSendLargeMessage(msgI);
        this.sessionChannel.send(initialChunk);
        return msgI.getHeadersAndPropertiesEncodeSize();
    }

    @Override
    public int sendLargeMessageChunk(MessageInternal msgI, long messageBodySize, boolean sendBlocking, boolean lastChunk, byte[] chunk, SendAcknowledgementHandler messageHandler) throws HornetQException {
        boolean requiresResponse = lastChunk && sendBlocking;
        SessionSendContinuationMessage chunkPacket = new SessionSendContinuationMessage(msgI, chunk, !lastChunk, requiresResponse, messageBodySize, messageHandler);
        if (requiresResponse) {
            this.sessionChannel.sendBlocking(chunkPacket, (byte)21);
        } else {
            this.sessionChannel.send(chunkPacket);
        }
        return chunkPacket.getPacketSize();
    }

    @Override
    public void sendACK(boolean individual, boolean block, ClientConsumer consumer, Message message) throws HornetQException {
        PacketImpl messagePacket = individual ? new SessionIndividualAcknowledgeMessage(this.getConsumerID(consumer), message.getMessageID(), block) : new SessionAcknowledgeMessage(this.getConsumerID(consumer), message.getMessageID(), block);
        if (block) {
            this.sessionChannel.sendBlocking(messagePacket, (byte)21);
        } else {
            this.sessionChannel.sendBatched(messagePacket);
        }
    }

    @Override
    public void expireMessage(ClientConsumer consumer, Message message) throws HornetQException {
        SessionExpireMessage messagePacket = new SessionExpireMessage(this.getConsumerID(consumer), message.getMessageID());
        this.sessionChannel.send(messagePacket);
    }

    @Override
    public void sessionClose() throws HornetQException {
        this.sessionChannel.sendBlocking(new SessionCloseMessage(), (byte)21);
    }

    @Override
    public void xaForget(Xid xid) throws XAException, HornetQException {
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(new SessionXAForgetMessage(xid), (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public int xaPrepare(Xid xid) throws XAException, HornetQException {
        SessionXAPrepareMessage packet = new SessionXAPrepareMessage(xid);
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
        return response.getResponseCode();
    }

    @Override
    public Xid[] xaScan() throws HornetQException {
        SessionXAGetInDoubtXidsResponseMessage response = (SessionXAGetInDoubtXidsResponseMessage)this.sessionChannel.sendBlocking(new PacketImpl(61), (byte)62);
        List<Xid> xids = response.getXids();
        Xid[] xidArray = xids.toArray(new Xid[xids.size()]);
        return xidArray;
    }

    @Override
    public void xaRollback(Xid xid, boolean wasStarted) throws HornetQException, XAException {
        SessionXARollbackMessage packet = new SessionXARollbackMessage(xid);
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public void xaStart(Xid xid, int flags) throws XAException, HornetQException {
        PacketImpl packet;
        if (flags == 0x200000) {
            packet = new SessionXAJoinMessage(xid);
        } else if (flags == 0x8000000) {
            packet = new SessionXAResumeMessage(xid);
        } else if (flags == 0) {
            packet = new SessionXAStartMessage(xid);
        } else {
            throw new XAException(-5);
        }
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            HornetQClientLogger.LOGGER.errorCallingStart(response.getMessage(), response.getResponseCode());
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public boolean configureTransactionTimeout(int seconds) throws HornetQException {
        SessionXASetTimeoutResponseMessage response = (SessionXASetTimeoutResponseMessage)this.sessionChannel.sendBlocking(new SessionXASetTimeoutMessage(seconds), (byte)64);
        return response.isOK();
    }

    @Override
    public int recoverSessionTimeout() throws HornetQException {
        SessionXAGetTimeoutResponseMessage response = (SessionXAGetTimeoutResponseMessage)this.sessionChannel.sendBlocking(new PacketImpl(65), (byte)66);
        return response.getTimeoutSeconds();
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temp) throws HornetQException {
        CreateQueueMessage request = new CreateQueueMessage(address, queueName, filterString, durable, temp, true);
        this.sessionChannel.sendBlocking(request, (byte)21);
    }

    @Override
    public boolean reattachOnNewConnection(RemotingConnection newConnection) throws HornetQException {
        this.remotingConnection = newConnection;
        this.sessionChannel.transferConnection((CoreRemotingConnection)newConnection);
        ReattachSessionMessage request = new ReattachSessionMessage(this.name, this.sessionChannel.getLastConfirmedCommandID());
        Channel channel1 = this.getCoreConnection().getChannel(1L, -1);
        ReattachSessionResponseMessage response = (ReattachSessionResponseMessage)channel1.sendBlocking(request, (byte)33);
        if (response.isReattached()) {
            if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                HornetQClientLogger.LOGGER.debug("ClientSession reattached fine, replaying commands");
            }
            this.sessionChannel.replayCommands(response.getLastConfirmedCommandID());
            return true;
        }
        this.sessionChannel.clearCommands();
        return false;
    }

    @Override
    public void recreateSession(String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, SimpleString defaultAddress) throws HornetQException {
        boolean retry;
        CreateSessionMessage createRequest = new CreateSessionMessage(this.name, this.sessionChannel.getID(), this.getServerVersion(), username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.confirmationWindow, defaultAddress == null ? null : defaultAddress.toString());
        do {
            try {
                this.getCreateChannel().sendBlocking(createRequest, (byte)31);
                retry = false;
            }
            catch (HornetQException e) {
                if (e.getType() == HornetQExceptionType.SESSION_CREATION_REJECTED) {
                    HornetQClientLogger.LOGGER.retryCreateSessionSeverStarting(this.name);
                    retry = true;
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                throw e;
            }
        } while (retry && !this.session.isClosing());
    }

    @Override
    public void recreateConsumerOnServer(ClientConsumerInternal consumerInternal) throws HornetQException {
        ClientSession.QueueQuery queueInfo = consumerInternal.getQueueInfo();
        if (!queueInfo.isDurable()) {
            CreateQueueMessage createQueueRequest = new CreateQueueMessage(queueInfo.getAddress(), queueInfo.getName(), queueInfo.getFilterString(), false, queueInfo.isTemporary(), false);
            this.sendPacketWithoutLock(this.sessionChannel, createQueueRequest);
        }
        SessionCreateConsumerMessage createConsumerRequest = new SessionCreateConsumerMessage(this.getConsumerID(consumerInternal), consumerInternal.getQueueName(), consumerInternal.getFilterString(), consumerInternal.isBrowseOnly(), false);
        this.sendPacketWithoutLock(this.sessionChannel, createConsumerRequest);
        int clientWindowSize = consumerInternal.getClientWindowSize();
        if (clientWindowSize != 0) {
            SessionConsumerFlowCreditMessage packet = new SessionConsumerFlowCreditMessage(this.getConsumerID(consumerInternal), clientWindowSize);
            this.sendPacketWithoutLock(this.sessionChannel, packet);
        } else {
            SessionConsumerFlowCreditMessage packet = new SessionConsumerFlowCreditMessage(this.getConsumerID(consumerInternal), 1);
            this.sendPacketWithoutLock(this.sessionChannel, packet);
        }
    }

    @Override
    public void xaFailed(Xid xid) throws HornetQException {
        this.sendPacketWithoutLock(this.sessionChannel, new SessionXAAfterFailedMessage(xid));
    }

    @Override
    public void restartSession() throws HornetQException {
        this.sendPacketWithoutLock(this.sessionChannel, new PacketImpl(67));
    }

    @Override
    public void resetMetadata(HashMap<String, String> metaDataToSend) {
        for (Map.Entry<String, String> entries : metaDataToSend.entrySet()) {
            this.sendPacketWithoutLock(this.sessionChannel, new SessionAddMetaDataMessageV2(entries.getKey(), entries.getValue(), false));
        }
    }

    private Channel getCreateChannel() {
        return this.getCoreConnection().getChannel(1L, -1);
    }

    private CoreRemotingConnection getCoreConnection() {
        return (CoreRemotingConnection)this.remotingConnection;
    }

    private void handleConsumerDisconnected(DisconnectConsumerMessage packet) throws HornetQException {
        DisconnectConsumerMessage message = packet;
        this.session.handleConsumerDisconnect(new HornetQConsumerContext(message.getConsumerId()));
    }

    private void handleReceivedMessagePacket(SessionReceiveMessage messagePacket) throws Exception {
        ClientMessageInternal msgi = (ClientMessageInternal)messagePacket.getMessage();
        msgi.setDeliveryCount(messagePacket.getDeliveryCount());
        msgi.setFlowControlSize(messagePacket.getPacketSize());
        this.handleReceiveMessage(new HornetQConsumerContext(messagePacket.getConsumerID()), msgi);
    }

    private void handleReceiveLargeMessage(SessionReceiveLargeMessage serverPacket) throws Exception {
        ClientLargeMessageInternal clientLargeMessage = (ClientLargeMessageInternal)((Object)serverPacket.getLargeMessage());
        clientLargeMessage.setFlowControlSize(serverPacket.getPacketSize());
        clientLargeMessage.setDeliveryCount(serverPacket.getDeliveryCount());
        this.handleReceiveLargeMessage(new HornetQConsumerContext(serverPacket.getConsumerID()), clientLargeMessage, serverPacket.getLargeMessageSize());
    }

    private void handleReceiveContinuation(SessionReceiveContinuationMessage continuationPacket) throws Exception {
        this.handleReceiveContinuation(new HornetQConsumerContext(continuationPacket.getConsumerID()), continuationPacket.getBody(), continuationPacket.getPacketSize(), continuationPacket.isContinues());
    }

    protected void handleReceiveProducerCredits(SessionProducerCreditsMessage message) {
        this.handleReceiveProducerCredits(message.getAddress(), message.getCredits());
    }

    protected void handleReceiveProducerFailCredits(SessionProducerCreditsFailMessage message) {
        this.handleReceiveProducerFailCredits(message.getAddress(), message.getCredits());
    }

    private long getConsumerID(ClientConsumer consumer) {
        return ((HornetQConsumerContext)consumer.getConsumerContext()).getId();
    }

    private ClassLoader lookupTCCL() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private int calcWindowSize(int windowSize) {
        int clientWindowSize;
        if (windowSize == -1) {
            clientWindowSize = -1;
        } else if (windowSize == 0) {
            clientWindowSize = 0;
        } else if (windowSize == 1) {
            clientWindowSize = 1;
        } else if (windowSize > 1) {
            clientWindowSize = windowSize >> 1;
        } else {
            throw HornetQClientMessageBundle.BUNDLE.invalidWindowSize(windowSize);
        }
        return clientWindowSize;
    }

    private void sendPacketWithoutLock(Channel parameterChannel, Packet packet) {
        packet.setChannelID(parameterChannel.getID());
        Connection conn = parameterChannel.getConnection().getTransportConnection();
        HornetQBuffer buffer = packet.encode(this.getCoreConnection());
        conn.write(buffer, false, false);
    }

    class ClientSessionPacketHandler
    implements ChannelHandler {
        ClientSessionPacketHandler() {
        }

        @Override
        public void handlePacket(Packet packet) {
            byte type = packet.getType();
            try {
                switch (type) {
                    case 12: {
                        HornetQSessionContext.this.handleConsumerDisconnected((DisconnectConsumerMessage)packet);
                        break;
                    }
                    case 77: {
                        HornetQSessionContext.this.handleReceiveContinuation((SessionReceiveContinuationMessage)packet);
                        break;
                    }
                    case 75: {
                        HornetQSessionContext.this.handleReceivedMessagePacket((SessionReceiveMessage)packet);
                        break;
                    }
                    case 76: {
                        HornetQSessionContext.this.handleReceiveLargeMessage((SessionReceiveLargeMessage)packet);
                        break;
                    }
                    case 80: {
                        HornetQSessionContext.this.handleReceiveProducerCredits((SessionProducerCreditsMessage)packet);
                        break;
                    }
                    case 82: {
                        HornetQSessionContext.this.handleReceiveProducerFailCredits((SessionProducerCreditsFailMessage)packet);
                        break;
                    }
                    case 20: {
                        HornetQExceptionMessage mem = (HornetQExceptionMessage)packet;
                        HornetQClientLogger.LOGGER.receivedExceptionAsynchronously((Exception)((Object)mem.getException()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid packet: " + type);
                    }
                }
            }
            catch (Exception e) {
                HornetQClientLogger.LOGGER.failedToHandlePacket(e);
            }
            HornetQSessionContext.this.sessionChannel.confirm(packet);
        }
    }
}

