/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.core.impl.wireformat.SessionContinuationMessage;

public class SessionSendContinuationMessage
extends SessionContinuationMessage {
    private boolean requiresResponse;
    private MessageInternal message;
    private final transient SendAcknowledgementHandler handler;
    private long messageBodySize = -1L;

    public SessionSendContinuationMessage() {
        super((byte)73);
        this.handler = null;
    }

    public SessionSendContinuationMessage(MessageInternal message, byte[] body, boolean continues, boolean requiresResponse, long messageBodySize, SendAcknowledgementHandler handler) {
        super((byte)73, body, continues);
        this.requiresResponse = requiresResponse;
        this.message = message;
        this.handler = handler;
        this.messageBodySize = messageBodySize;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public long getMessageBodySize() {
        return this.messageBodySize;
    }

    public MessageInternal getMessage() {
        return this.message;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        super.encodeRest(buffer);
        if (!this.continues) {
            buffer.writeLong(this.messageBodySize);
        }
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        super.decodeRest(buffer);
        if (!this.continues) {
            this.messageBodySize = buffer.readLong();
        }
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (int)(this.messageBodySize ^ this.messageBodySize >>> 32);
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendContinuationMessage)) {
            return false;
        }
        SessionSendContinuationMessage other = (SessionSendContinuationMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageBodySize != other.messageBodySize) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }

    public SendAcknowledgementHandler getHandler() {
        return this.handler;
    }
}

