/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.reader;

import org.hornetq.api.core.Message;
import org.hornetq.reader.MessageUtil;

public class BytesMessageUtil
extends MessageUtil {
    public static boolean bytesReadBoolean(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readBoolean();
    }

    public static byte bytesReadByte(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readByte();
    }

    public static int bytesReadUnsignedByte(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readUnsignedByte();
    }

    public static short bytesReadShort(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readShort();
    }

    public static int bytesReadUnsignedShort(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readUnsignedShort();
    }

    public static char bytesReadChar(Message message) {
        return (char)BytesMessageUtil.getBodyBuffer(message).readShort();
    }

    public static int bytesReadInt(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readInt();
    }

    public static long bytesReadLong(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readLong();
    }

    public static float bytesReadFloat(Message message) {
        return Float.intBitsToFloat(BytesMessageUtil.getBodyBuffer(message).readInt());
    }

    public static double bytesReadDouble(Message message) {
        return Double.longBitsToDouble(BytesMessageUtil.getBodyBuffer(message).readLong());
    }

    public static String bytesReadUTF(Message message) {
        return BytesMessageUtil.getBodyBuffer(message).readUTF();
    }

    public static int bytesReadBytes(Message message, byte[] value) {
        return BytesMessageUtil.bytesReadBytes(message, value, value.length);
    }

    public static int bytesReadBytes(Message message, byte[] value, int length) {
        if (!BytesMessageUtil.getBodyBuffer(message).readable()) {
            return -1;
        }
        int read = Math.min(length, BytesMessageUtil.getBodyBuffer(message).readableBytes());
        if (read != 0) {
            BytesMessageUtil.getBodyBuffer(message).readBytes(value, 0, read);
        }
        return read;
    }

    public static void bytesWriteBoolean(Message message, boolean value) {
        BytesMessageUtil.getBodyBuffer(message).writeBoolean(value);
    }

    public static void bytesWriteByte(Message message, byte value) {
        BytesMessageUtil.getBodyBuffer(message).writeByte(value);
    }

    public static void bytesWriteShort(Message message, short value) {
        BytesMessageUtil.getBodyBuffer(message).writeShort(value);
    }

    public static void bytesWriteChar(Message message, char value) {
        BytesMessageUtil.getBodyBuffer(message).writeShort((short)value);
    }

    public static void bytesWriteInt(Message message, int value) {
        BytesMessageUtil.getBodyBuffer(message).writeInt(value);
    }

    public static void bytesWriteLong(Message message, long value) {
        BytesMessageUtil.getBodyBuffer(message).writeLong(value);
    }

    public static void bytesWriteFloat(Message message, float value) {
        BytesMessageUtil.getBodyBuffer(message).writeInt(Float.floatToIntBits(value));
    }

    public static void bytesWriteDouble(Message message, double value) {
        BytesMessageUtil.getBodyBuffer(message).writeLong(Double.doubleToLongBits(value));
    }

    public static void bytesWriteUTF(Message message, String value) {
        BytesMessageUtil.getBodyBuffer(message).writeUTF(value);
    }

    public static void bytesWriteBytes(Message message, byte[] value) {
        BytesMessageUtil.getBodyBuffer(message).writeBytes(value);
    }

    public static void bytesWriteBytes(Message message, byte[] value, int offset, int length) {
        BytesMessageUtil.getBodyBuffer(message).writeBytes(value, offset, length);
    }

    public static boolean bytesWriteObject(Message message, Object value) {
        if (value == null) {
            throw new NullPointerException("Attempt to write a null value");
        }
        if (value instanceof String) {
            BytesMessageUtil.bytesWriteUTF(message, (String)value);
        } else if (value instanceof Boolean) {
            BytesMessageUtil.bytesWriteBoolean(message, (Boolean)value);
        } else if (value instanceof Character) {
            BytesMessageUtil.bytesWriteChar(message, ((Character)value).charValue());
        } else if (value instanceof Byte) {
            BytesMessageUtil.bytesWriteByte(message, (Byte)value);
        } else if (value instanceof Short) {
            BytesMessageUtil.bytesWriteShort(message, (Short)value);
        } else if (value instanceof Integer) {
            BytesMessageUtil.bytesWriteInt(message, (Integer)value);
        } else if (value instanceof Long) {
            BytesMessageUtil.bytesWriteLong(message, (Long)value);
        } else if (value instanceof Float) {
            BytesMessageUtil.bytesWriteFloat(message, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            BytesMessageUtil.bytesWriteDouble(message, (Double)value);
        } else if (value instanceof byte[]) {
            BytesMessageUtil.bytesWriteBytes(message, (byte[])value);
        } else {
            return false;
        }
        return true;
    }

    public static void bytesMessageReset(Message message) {
        BytesMessageUtil.getBodyBuffer(message).resetReaderIndex();
    }
}

