/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.spi.core.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Connection;

public abstract class AbstractRemotingConnection
implements RemotingConnection {
    protected final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    protected final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    protected final Connection transportConnection;
    protected final Executor executor;
    protected final long creationTime;
    protected volatile boolean dataReceived;

    public AbstractRemotingConnection(Connection transportConnection, Executor executor) {
        this.transportConnection = transportConnection;
        this.executor = executor;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public List<FailureListener> getFailureListeners() {
        return new ArrayList<FailureListener>(this.failureListeners);
    }

    protected void callFailureListeners(HornetQException me, String scaleDownTargetNodeID) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false, scaleDownTargetNodeID);
            }
            catch (HornetQInterruptedException interrupted) {
                HornetQClientLogger.LOGGER.debug("thread interrupted", interrupted);
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    protected void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                HornetQClientLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    @Override
    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    @Override
    public Object getID() {
        return this.transportConnection.getID();
    }

    @Override
    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    @Override
    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.failListenerCannotBeNull();
        }
        this.failureListeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.failListenerCannotBeNull();
        }
        return this.failureListeners.remove(listener);
    }

    @Override
    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.closeListenerCannotBeNull();
        }
        this.closeListeners.add(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.closeListenerCannotBeNull();
        }
        return this.closeListeners.remove(listener);
    }

    @Override
    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    @Override
    public List<FailureListener> removeFailureListeners() {
        List<FailureListener> ret = this.getFailureListeners();
        this.failureListeners.clear();
        return ret;
    }

    @Override
    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return this.transportConnection.createBuffer(size);
    }

    @Override
    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    @Override
    public void fail(HornetQException me) {
        this.fail(me, null);
    }

    @Override
    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        this.dataReceived = true;
    }
}

