/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.spi.core.remoting;

import java.util.HashMap;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientLargeMessageInternal;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.client.impl.ClientProducerCreditsImpl;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.ConsumerContext;
import org.hornetq.utils.IDGenerator;
import org.hornetq.utils.SimpleIDGenerator;

public abstract class SessionContext {
    protected ClientSessionInternal session;
    protected SendAcknowledgementHandler sendAckHandler;
    protected volatile RemotingConnection remotingConnection;
    protected final IDGenerator idGenerator = new SimpleIDGenerator(0L);

    public SessionContext(RemotingConnection remotingConnection) {
        this.remotingConnection = remotingConnection;
    }

    public ClientSessionInternal getSession() {
        return this.session;
    }

    public void setSession(ClientSessionInternal session) {
        this.session = session;
    }

    public abstract boolean reattachOnNewConnection(RemotingConnection var1) throws HornetQException;

    public RemotingConnection getRemotingConnection() {
        return this.remotingConnection;
    }

    public abstract void closeConsumer(ClientConsumer var1) throws HornetQException;

    public abstract void sendConsumerCredits(ClientConsumer var1, int var2);

    public abstract boolean supportsLargeMessage();

    protected void handleReceiveLargeMessage(ConsumerContext consumerID, ClientLargeMessageInternal clientLargeMessage, long largeMessageSize) throws Exception {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveLargeMessage(consumerID, clientLargeMessage, largeMessageSize);
        }
    }

    protected void handleReceiveMessage(ConsumerContext consumerID, ClientMessageInternal message) throws Exception {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveMessage(consumerID, message);
        }
    }

    protected void handleReceiveContinuation(ConsumerContext consumerID, byte[] chunk, int flowControlSize, boolean isContinues) throws Exception {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveContinuation(consumerID, chunk, flowControlSize, isContinues);
        }
    }

    protected void handleReceiveProducerCredits(SimpleString address, int credits) {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveProducerCredits(address, credits);
        }
    }

    protected void handleReceiveProducerFailCredits(SimpleString address, int credits) {
        ClientSessionInternal session = this.session;
        if (session != null) {
            session.handleReceiveProducerFailCredits(address, credits);
        }
    }

    public abstract int getCreditsOnSendingFull(MessageInternal var1);

    public abstract void sendFullMessage(MessageInternal var1, boolean var2, SendAcknowledgementHandler var3, SimpleString var4) throws HornetQException;

    public abstract int sendInitialChunkOnLargeMessage(MessageInternal var1) throws HornetQException;

    public abstract int sendLargeMessageChunk(MessageInternal var1, long var2, boolean var4, boolean var5, byte[] var6, SendAcknowledgementHandler var7) throws HornetQException;

    public abstract void setSendAcknowledgementHandler(SendAcknowledgementHandler var1);

    public abstract void createSharedQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4) throws HornetQException;

    public abstract void deleteQueue(SimpleString var1) throws HornetQException;

    public abstract void createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws HornetQException;

    public abstract ClientSession.QueueQuery queueQuery(SimpleString var1) throws HornetQException;

    public abstract void forceDelivery(ClientConsumer var1, long var2) throws HornetQException;

    public abstract ClientSession.AddressQuery addressQuery(SimpleString var1) throws HornetQException;

    public abstract void simpleCommit() throws HornetQException;

    public abstract void simpleRollback(boolean var1) throws HornetQException;

    public abstract void sessionStart() throws HornetQException;

    public abstract void sessionStop() throws HornetQException;

    public abstract void sendACK(boolean var1, boolean var2, ClientConsumer var3, Message var4) throws HornetQException;

    public abstract void expireMessage(ClientConsumer var1, Message var2) throws HornetQException;

    public abstract void sessionClose() throws HornetQException;

    public abstract void addSessionMetadata(String var1, String var2) throws HornetQException;

    public abstract void addUniqueMetaData(String var1, String var2) throws HornetQException;

    public abstract void sendProducerCreditsMessage(int var1, SimpleString var2);

    public abstract void xaCommit(Xid var1, boolean var2) throws XAException, HornetQException;

    public abstract void xaEnd(Xid var1, int var2) throws XAException, HornetQException;

    public abstract void xaForget(Xid var1) throws XAException, HornetQException;

    public abstract int xaPrepare(Xid var1) throws XAException, HornetQException;

    public abstract Xid[] xaScan() throws HornetQException;

    public abstract void xaRollback(Xid var1, boolean var2) throws HornetQException, XAException;

    public abstract void xaStart(Xid var1, int var2) throws XAException, HornetQException;

    public abstract boolean configureTransactionTimeout(int var1) throws HornetQException;

    public abstract ClientConsumerInternal createConsumer(SimpleString var1, SimpleString var2, int var3, int var4, int var5, boolean var6, Executor var7, Executor var8) throws HornetQException;

    public abstract int recoverSessionTimeout() throws HornetQException;

    public abstract int getServerVersion();

    public abstract void recreateSession(String var1, String var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, SimpleString var8) throws HornetQException;

    public abstract void recreateConsumerOnServer(ClientConsumerInternal var1) throws HornetQException;

    public abstract void xaFailed(Xid var1) throws HornetQException;

    public abstract void restartSession() throws HornetQException;

    public abstract void resetMetadata(HashMap<String, String> var1);

    public abstract void returnBlocking(HornetQException var1);

    public abstract void lockCommunications();

    public abstract void releaseCommunications();

    public abstract void cleanup();

    public abstract void linkFlowControl(SimpleString var1, ClientProducerCreditsImpl var2);
}

