/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.registry.JndiBindingRegistry;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.Queue;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.client.HornetQTopic;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.jms.persistence.JMSStorageManager;
import org.hornetq.jms.persistence.config.PersistedConnectionFactory;
import org.hornetq.jms.persistence.config.PersistedDestination;
import org.hornetq.jms.persistence.config.PersistedJNDI;
import org.hornetq.jms.persistence.config.PersistedType;
import org.hornetq.jms.persistence.impl.journal.JMSJournalStorageManagerImpl;
import org.hornetq.jms.persistence.impl.nullpm.NullJMSStorageManagerImpl;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.hornetq.jms.server.impl.JMSServerDeployer;
import org.hornetq.jms.server.management.JMSManagementService;
import org.hornetq.jms.server.management.impl.JMSManagementServiceImpl;
import org.hornetq.jms.transaction.JMSTransactionDetail;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.hornetq.utils.IDGenerator;
import org.hornetq.utils.TimeAndCounterIDGenerator;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class JMSServerManagerImpl
implements JMSServerManager,
ActivateCallback {
    private static final Logger log = Logger.getLogger(JMSServerManagerImpl.class);
    private static final String REJECT_FILTER = "__HQX=-1";
    private BindingRegistry registry;
    private Map<String, HornetQQueue> queues = new HashMap<String, HornetQQueue>();
    private Map<String, HornetQTopic> topics = new HashMap<String, HornetQTopic>();
    private final Map<String, HornetQConnectionFactory> connectionFactories = new HashMap<String, HornetQConnectionFactory>();
    private final Map<String, List<String>> queueJNDI = new HashMap<String, List<String>>();
    private final Map<String, List<String>> topicJNDI = new HashMap<String, List<String>>();
    private final Map<String, List<String>> connectionFactoryJNDI = new HashMap<String, List<String>>();
    private final List<Runnable> cachedCommands = new ArrayList<Runnable>();
    private final HornetQServer server;
    private JMSManagementService jmsManagementService;
    private XmlDeployer jmsDeployer;
    private boolean started;
    private boolean active;
    private DeploymentManager deploymentManager;
    private final String configFileName;
    private boolean contextSet;
    private JMSConfiguration config;
    private Configuration coreConfig;
    private JMSStorageManager storage;

    public JMSServerManagerImpl(HornetQServer server) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.configFileName = null;
    }

    public JMSServerManagerImpl(HornetQServer server, BindingRegistry registry) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.configFileName = null;
        this.registry = registry;
    }

    public JMSServerManagerImpl(HornetQServer server, String configFileName) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.configFileName = configFileName;
    }

    public JMSServerManagerImpl(HornetQServer server, JMSConfiguration configuration) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.configFileName = null;
        this.config = configuration;
    }

    public JMSServerManagerImpl(HornetQServer server, String configFilename, JMSStorageManager storageManager) {
        this.server = server;
        this.configFileName = null;
        this.storage = storageManager;
    }

    public void preActivate() {
    }

    public synchronized void activated() {
        if (!this.started) {
            return;
        }
        this.active = true;
        this.jmsManagementService = new JMSManagementServiceImpl(this.server.getManagementService(), this.server, this);
        try {
            this.jmsManagementService.registerJMSServer(this);
            this.initJournal();
            if (this.config == null) {
                if (this.server.getConfiguration().isFileDeploymentEnabled()) {
                    this.jmsDeployer = new JMSServerDeployer(this, this.deploymentManager);
                    if (this.configFileName != null) {
                        this.jmsDeployer.setConfigFileNames(new String[]{this.configFileName});
                    }
                    this.jmsDeployer.start();
                    this.deploymentManager.start();
                }
            } else {
                this.deploy();
            }
            for (Runnable run : this.cachedCommands) {
                log.info((Object)("Running cached command for " + run));
                run.run();
            }
            this.cachedCommands.clear();
        }
        catch (Exception e) {
            log.error((Object)"Failed to start jms deployer", (Throwable)e);
        }
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.registry == null && !this.contextSet) {
            this.registry = new JndiBindingRegistry((Context)new InitialContext());
        }
        this.started = true;
        this.deploymentManager = new FileDeploymentManager(this.server.getConfiguration().getFileDeployerScanPeriod());
        this.server.registerActivateCallback((ActivateCallback)this);
        this.server.start();
        if (this.server.getReplicationEndpoint() != null) {
            this.createJournal();
            this.storage.installReplication(this.server.getReplicationEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        JMSServerManagerImpl jMSServerManagerImpl = this;
        synchronized (jMSServerManagerImpl) {
            if (!this.started) {
                return;
            }
            if (this.jmsDeployer != null) {
                this.jmsDeployer.stop();
            }
            if (this.deploymentManager != null) {
                this.deploymentManager.stop();
            }
            if (this.storage != null) {
                this.storage.stop();
            }
            this.unbindJNDI(this.queueJNDI);
            this.unbindJNDI(this.topicJNDI);
            this.unbindJNDI(this.connectionFactoryJNDI);
            for (String connectionFactory : new HashSet<String>(this.connectionFactories.keySet())) {
                this.shutdownConnectionFactory(connectionFactory);
            }
            this.connectionFactories.clear();
            this.connectionFactoryJNDI.clear();
            this.queueJNDI.clear();
            this.queues.clear();
            this.topicJNDI.clear();
            this.topics.clear();
            if (this.registry != null) {
                this.registry.close();
            }
            if (this.jmsManagementService != null) {
                this.jmsManagementService.unregisterJMSServer();
                this.jmsManagementService.stop();
            }
            this.started = false;
        }
        this.server.stop();
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public BindingRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(BindingRegistry registry) {
        this.registry = registry;
    }

    @Override
    public HornetQServer getHornetQServer() {
        return this.server;
    }

    @Override
    public void addAddressSettings(String address, AddressSettings addressSettings) {
        this.server.getAddressSettingsRepository().addMatch(address, (Object)addressSettings);
    }

    @Override
    public AddressSettings getAddressSettings(String address) {
        return (AddressSettings)this.server.getAddressSettingsRepository().getMatch(address);
    }

    @Override
    public void addSecurity(String addressMatch, Set<Role> roles) {
        this.server.getSecurityRepository().addMatch(addressMatch, roles);
    }

    @Override
    public Set<Role> getSecurity(String addressMatch) {
        return (Set)this.server.getSecurityRepository().getMatch(addressMatch);
    }

    @Override
    public synchronized void setContext(Context context) {
        if (this.registry == null || this.registry instanceof JndiBindingRegistry) {
            this.registry = new JndiBindingRegistry(context);
            this.registry.setContext((Object)context);
        }
        this.contextSet = true;
    }

    @Override
    public synchronized String getVersion() {
        this.checkInitialised();
        return this.server.getVersion().getFullVersion();
    }

    @Override
    public synchronized boolean createQueue(final boolean storeConfig, final String queueName, final String selectorString, final boolean durable, final String ... jndi) throws Exception {
        if (this.active && this.queues.get(queueName) != null) {
            return false;
        }
        this.runAfterActive(new RunnableException(){

            public String toString() {
                return "createQueue for " + queueName;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkJNDI(jndi);
                if (JMSServerManagerImpl.this.internalCreateQueue(queueName, selectorString, durable)) {
                    HornetQDestination destination = (HornetQDestination)JMSServerManagerImpl.this.queues.get(queueName);
                    if (destination == null) {
                        throw new IllegalArgumentException("Queue does not exist");
                    }
                    ArrayList<String> bindings = new ArrayList<String>();
                    for (String jndiItem : jndi) {
                        if (!JMSServerManagerImpl.this.bindToJndi(jndiItem, destination)) continue;
                        bindings.add(jndiItem);
                    }
                    String[] usedJNDI = bindings.toArray(new String[bindings.size()]);
                    JMSServerManagerImpl.this.addToBindings(JMSServerManagerImpl.this.queueJNDI, queueName, usedJNDI);
                    if (storeConfig && durable) {
                        JMSServerManagerImpl.this.storage.storeDestination(new PersistedDestination(PersistedType.Queue, queueName, selectorString, durable));
                        JMSServerManagerImpl.this.storage.addJNDI(PersistedType.Queue, queueName, usedJNDI);
                    }
                }
            }
        });
        return true;
    }

    @Override
    public synchronized boolean createTopic(final boolean storeConfig, final String topicName, final String ... jndi) throws Exception {
        if (this.active && this.topics.get(topicName) != null) {
            return false;
        }
        this.runAfterActive(new RunnableException(){

            public String toString() {
                return "createTopic for " + topicName;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkJNDI(jndi);
                if (JMSServerManagerImpl.this.internalCreateTopic(topicName)) {
                    HornetQDestination destination = (HornetQDestination)JMSServerManagerImpl.this.topics.get(topicName);
                    if (destination == null) {
                        throw new IllegalArgumentException("Queue does not exist");
                    }
                    ArrayList<String> bindings = new ArrayList<String>();
                    for (String jndiItem : jndi) {
                        if (!JMSServerManagerImpl.this.bindToJndi(jndiItem, destination)) continue;
                        bindings.add(jndiItem);
                    }
                    String[] usedJNDI = bindings.toArray(new String[bindings.size()]);
                    JMSServerManagerImpl.this.addToBindings(JMSServerManagerImpl.this.topicJNDI, topicName, usedJNDI);
                    if (storeConfig) {
                        JMSServerManagerImpl.this.storage.storeDestination(new PersistedDestination(PersistedType.Topic, topicName));
                        JMSServerManagerImpl.this.storage.addJNDI(PersistedType.Topic, topicName, usedJNDI);
                    }
                }
            }
        });
        return true;
    }

    @Override
    public boolean addTopicToJndi(String topicName, String jndiBinding) throws Exception {
        this.checkInitialised();
        this.checkJNDI(jndiBinding);
        HornetQTopic destination = this.topics.get(topicName);
        if (destination == null) {
            throw new IllegalArgumentException("Topic does not exist");
        }
        if (destination.getTopicName() == null) {
            throw new IllegalArgumentException(topicName + " is not a topic");
        }
        boolean added = this.bindToJndi(jndiBinding, destination);
        if (added) {
            this.addToBindings(this.topicJNDI, topicName, jndiBinding);
            this.storage.addJNDI(PersistedType.Topic, topicName, jndiBinding);
        }
        return added;
    }

    @Override
    public String[] getJNDIOnQueue(String queue) {
        return this.getJNDIList(this.queueJNDI, queue);
    }

    @Override
    public String[] getJNDIOnTopic(String topic) {
        return this.getJNDIList(this.topicJNDI, topic);
    }

    @Override
    public String[] getJNDIOnConnectionFactory(String factoryName) {
        return this.getJNDIList(this.connectionFactoryJNDI, factoryName);
    }

    @Override
    public boolean addQueueToJndi(String queueName, String jndiBinding) throws Exception {
        this.checkInitialised();
        this.checkJNDI(jndiBinding);
        HornetQQueue destination = this.queues.get(queueName);
        if (destination == null) {
            throw new IllegalArgumentException("Queue does not exist");
        }
        if (destination.getQueueName() == null) {
            throw new IllegalArgumentException(queueName + " is not a queue");
        }
        boolean added = this.bindToJndi(jndiBinding, destination);
        if (added) {
            this.addToBindings(this.queueJNDI, queueName, jndiBinding);
            this.storage.addJNDI(PersistedType.Queue, queueName, jndiBinding);
        }
        return added;
    }

    @Override
    public boolean addConnectionFactoryToJNDI(String name, String jndiBinding) throws Exception {
        this.checkInitialised();
        this.checkJNDI(jndiBinding);
        HornetQConnectionFactory factory = this.connectionFactories.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("Factory does not exist");
        }
        if (this.registry.lookup(jndiBinding) != null) {
            throw new HornetQException(107, "JNDI " + name + " is already being used by another connection factory");
        }
        boolean added = this.bindToJndi(jndiBinding, factory);
        if (added) {
            this.addToBindings(this.connectionFactoryJNDI, name, jndiBinding);
            this.storage.addJNDI(PersistedType.ConnectionFactory, name, jndiBinding);
        }
        return added;
    }

    @Override
    public boolean removeQueueFromJNDI(String name, String jndi) throws Exception {
        this.checkInitialised();
        boolean removed = this.removeFromJNDI(this.queueJNDI, name, jndi);
        if (removed) {
            this.storage.deleteJNDI(PersistedType.Queue, name, jndi);
        }
        return removed;
    }

    @Override
    public boolean removeQueueFromJNDI(final String name) throws Exception {
        final AtomicBoolean valueReturn = new AtomicBoolean(false);
        this.runAfterActive(new RunnableException(){

            public String toString() {
                return "removeQueueFromJNDI for " + name;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkInitialised();
                if (JMSServerManagerImpl.this.removeFromJNDI(JMSServerManagerImpl.this.queues, JMSServerManagerImpl.this.queueJNDI, name)) {
                    JMSServerManagerImpl.this.storage.deleteDestination(PersistedType.Queue, name);
                    valueReturn.set(true);
                }
            }
        });
        return valueReturn.get();
    }

    @Override
    public boolean removeTopicFromJNDI(String name, String jndi) throws Exception {
        this.checkInitialised();
        if (this.removeFromJNDI(this.topicJNDI, name, jndi)) {
            this.storage.deleteJNDI(PersistedType.Topic, name, jndi);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTopicFromJNDI(final String name) throws Exception {
        final AtomicBoolean valueReturn = new AtomicBoolean(false);
        this.runAfterActive(new RunnableException(){

            public String toString() {
                return "removeTopicFromJNDI for " + name;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkInitialised();
                if (JMSServerManagerImpl.this.removeFromJNDI(JMSServerManagerImpl.this.topics, JMSServerManagerImpl.this.topicJNDI, name)) {
                    JMSServerManagerImpl.this.storage.deleteDestination(PersistedType.Topic, name);
                    valueReturn.set(true);
                }
            }
        });
        return valueReturn.get();
    }

    @Override
    public boolean removeConnectionFactoryFromJNDI(String name, String jndi) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.connectionFactoryJNDI, name, jndi);
        this.storage.deleteJNDI(PersistedType.ConnectionFactory, name, jndi);
        return true;
    }

    @Override
    public boolean removeConnectionFactoryFromJNDI(String name) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.connectionFactories, this.connectionFactoryJNDI, name);
        this.storage.deleteConnectionFactory(name);
        return true;
    }

    @Override
    public synchronized boolean destroyQueue(String name) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.queues, this.queueJNDI, name);
        this.queues.remove(name);
        this.queueJNDI.remove(name);
        this.jmsManagementService.unregisterQueue(name);
        this.server.destroyQueue(HornetQDestination.createQueueAddressFromName(name), null);
        this.storage.deleteDestination(PersistedType.Queue, name);
        return true;
    }

    @Override
    public synchronized boolean destroyTopic(String name) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.topics, this.topicJNDI, name);
        this.topics.remove(name);
        this.topicJNDI.remove(name);
        this.jmsManagementService.unregisterTopic(name);
        AddressControl addressControl = (AddressControl)this.server.getManagementService().getResource("core.address." + HornetQDestination.createTopicAddressFromName(name));
        if (addressControl != null) {
            for (String queueName : addressControl.getQueueNames()) {
                Binding binding = this.server.getPostOffice().getBinding(new SimpleString(queueName));
                if (binding == null) {
                    log.warn((Object)("Queue " + queueName + " doesn't exist on the topic " + name + ". It was deleted manually probably."));
                    continue;
                }
                if (binding.getType() == BindingType.REMOTE_QUEUE) continue;
                this.server.destroyQueue(SimpleString.toSimpleString((String)queueName), null);
            }
        }
        this.storage.deleteDestination(PersistedType.Topic, name);
        return true;
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, List<String> connectorNames, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, ha, connectorNames, new String[0]);
            configuration.setFactoryType(cfType);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, List<String> connectorNames, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, boolean compressLargeMessage, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, ha, connectorNames, new String[0]);
            configuration.setClientID(clientID);
            configuration.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            configuration.setConnectionTTL(connectionTTL);
            configuration.setFactoryType(cfType);
            configuration.setCallTimeout(callTimeout);
            configuration.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            configuration.setMinLargeMessageSize(minLargeMessageSize);
            configuration.setCompressLargeMessages(compressLargeMessage);
            configuration.setConsumerWindowSize(consumerWindowSize);
            configuration.setConsumerMaxRate(consumerMaxRate);
            configuration.setConfirmationWindowSize(confirmationWindowSize);
            configuration.setProducerWindowSize(producerWindowSize);
            configuration.setProducerMaxRate(producerMaxRate);
            configuration.setBlockOnAcknowledge(blockOnAcknowledge);
            configuration.setBlockOnDurableSend(blockOnDurableSend);
            configuration.setBlockOnNonDurableSend(blockOnNonDurableSend);
            configuration.setAutoGroup(autoGroup);
            configuration.setPreAcknowledge(preAcknowledge);
            configuration.setLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            configuration.setTransactionBatchSize(transactionBatchSize);
            configuration.setDupsOKBatchSize(dupsOKBatchSize);
            configuration.setUseGlobalPools(useGlobalPools);
            configuration.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            configuration.setThreadPoolMaxSize(threadPoolMaxSize);
            configuration.setRetryInterval(retryInterval);
            configuration.setRetryIntervalMultiplier(retryIntervalMultiplier);
            configuration.setMaxRetryInterval(maxRetryInterval);
            configuration.setReconnectAttempts(reconnectAttempts);
            configuration.setFailoverOnInitialConnection(failoverOnInitialConnection);
            configuration.setGroupID(groupId);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, String discoveryGroupName, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, boolean compressLargeMessages, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, ha, jndiBindings);
            configuration.setDiscoveryGroupName(discoveryGroupName);
            configuration.setFactoryType(cfType);
            configuration.setClientID(clientID);
            configuration.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            configuration.setConnectionTTL(connectionTTL);
            configuration.setCallTimeout(callTimeout);
            configuration.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            configuration.setMinLargeMessageSize(minLargeMessageSize);
            configuration.setCompressLargeMessages(compressLargeMessages);
            configuration.setConsumerWindowSize(consumerWindowSize);
            configuration.setConsumerMaxRate(consumerMaxRate);
            configuration.setConfirmationWindowSize(confirmationWindowSize);
            configuration.setProducerWindowSize(producerWindowSize);
            configuration.setProducerMaxRate(producerMaxRate);
            configuration.setBlockOnAcknowledge(blockOnAcknowledge);
            configuration.setBlockOnDurableSend(blockOnDurableSend);
            configuration.setBlockOnNonDurableSend(blockOnNonDurableSend);
            configuration.setAutoGroup(autoGroup);
            configuration.setPreAcknowledge(preAcknowledge);
            configuration.setLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            configuration.setTransactionBatchSize(transactionBatchSize);
            configuration.setDupsOKBatchSize(dupsOKBatchSize);
            configuration.setUseGlobalPools(useGlobalPools);
            configuration.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            configuration.setThreadPoolMaxSize(threadPoolMaxSize);
            configuration.setRetryInterval(retryInterval);
            configuration.setRetryIntervalMultiplier(retryIntervalMultiplier);
            configuration.setMaxRetryInterval(maxRetryInterval);
            configuration.setReconnectAttempts(reconnectAttempts);
            configuration.setFailoverOnInitialConnection(failoverOnInitialConnection);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, String discoveryGroupName, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, ha, jndiBindings);
            configuration.setDiscoveryGroupName(discoveryGroupName);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized HornetQConnectionFactory recreateCF(String name, ConnectionFactoryConfiguration cf) throws Exception {
        List<String> jndi = this.connectionFactoryJNDI.get(name);
        if (jndi == null) {
            throw new HornetQException(0, "Connection Factory " + name + " doesn't exist");
        }
        String[] usedJNDI = jndi.toArray(new String[jndi.size()]);
        HornetQConnectionFactory realCF = this.internalCreateCFPOJO(cf);
        if (cf.isPersisted()) {
            this.storage.storeConnectionFactory(new PersistedConnectionFactory(cf));
            this.storage.addJNDI(PersistedType.ConnectionFactory, cf.getName(), usedJNDI);
        }
        for (String jndiElement : usedJNDI) {
            this.bindToJndi(jndiElement, realCF);
        }
        return realCF;
    }

    @Override
    public synchronized void createConnectionFactory(final boolean storeConfig, final ConnectionFactoryConfiguration cfConfig, final String ... jndi) throws Exception {
        this.runAfterActive(new RunnableException(){

            public String toString() {
                return "createConnectionFactory for " + cfConfig.getName();
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkJNDI(jndi);
                HornetQConnectionFactory cf = JMSServerManagerImpl.this.internalCreateCF(storeConfig, cfConfig);
                ArrayList<String> bindings = new ArrayList<String>();
                for (String jndiItem : jndi) {
                    if (!JMSServerManagerImpl.this.bindToJndi(jndiItem, cf)) continue;
                    bindings.add(jndiItem);
                }
                String[] usedJNDI = bindings.toArray(new String[bindings.size()]);
                JMSServerManagerImpl.this.addToBindings(JMSServerManagerImpl.this.connectionFactoryJNDI, cfConfig.getName(), usedJNDI);
                if (storeConfig) {
                    JMSServerManagerImpl.this.storage.storeConnectionFactory(new PersistedConnectionFactory(cfConfig));
                    JMSServerManagerImpl.this.storage.addJNDI(PersistedType.ConnectionFactory, cfConfig.getName(), usedJNDI);
                }
            }
        });
    }

    public JMSStorageManager getJMSStorageManager() {
        return this.storage;
    }

    public void replaceStorageManager(JMSStorageManager newStorage) {
        this.storage = newStorage;
    }

    private String[] getJNDIList(Map<String, List<String>> map, String name) {
        List<String> result = map.get(name);
        if (result == null) {
            return new String[0];
        }
        String[] strings = new String[result.size()];
        result.toArray(strings);
        return strings;
    }

    private boolean internalCreateQueue(String queueName, String selectorString, boolean durable) throws Exception {
        if (this.queues.get(queueName) != null) {
            return false;
        }
        HornetQQueue hqQueue = HornetQDestination.createQueue(queueName);
        String coreFilterString = null;
        if (selectorString != null) {
            coreFilterString = SelectorTranslator.convertToHornetQFilterString(selectorString);
        }
        Queue queue = this.server.deployQueue(SimpleString.toSimpleString((String)hqQueue.getAddress()), SimpleString.toSimpleString((String)hqQueue.getAddress()), SimpleString.toSimpleString((String)coreFilterString), durable, false);
        this.queues.put(queueName, hqQueue);
        this.jmsManagementService.registerQueue(hqQueue, queue);
        return true;
    }

    private boolean internalCreateTopic(String topicName) throws Exception {
        if (this.topics.get(topicName) != null) {
            return false;
        }
        HornetQTopic hqTopic = HornetQDestination.createTopic(topicName);
        this.server.deployQueue(SimpleString.toSimpleString((String)hqTopic.getAddress()), SimpleString.toSimpleString((String)hqTopic.getAddress()), SimpleString.toSimpleString((String)REJECT_FILTER), true, false);
        this.topics.put(topicName, hqTopic);
        this.jmsManagementService.registerTopic(hqTopic);
        return true;
    }

    private HornetQConnectionFactory internalCreateCF(boolean persisted, ConnectionFactoryConfiguration cfConfig) throws HornetQException, Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(cfConfig.getName());
        if (cf == null) {
            cf = this.internalCreateCFPOJO(cfConfig);
        }
        this.connectionFactories.put(cfConfig.getName(), cf);
        this.jmsManagementService.registerConnectionFactory(cfConfig.getName(), cfConfig, cf);
        return cf;
    }

    protected HornetQConnectionFactory internalCreateCFPOJO(ConnectionFactoryConfiguration cfConfig) throws HornetQException {
        HornetQConnectionFactory cf;
        if (cfConfig.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration groupConfig = (DiscoveryGroupConfiguration)this.server.getConfiguration().getDiscoveryGroupConfigurations().get(cfConfig.getDiscoveryGroupName());
            if (groupConfig == null) {
                throw new HornetQException(104, "Discovery Group '" + cfConfig.getDiscoveryGroupName() + "' doesn't exist on maing config");
            }
            cf = cfConfig.isHA() ? HornetQJMSClient.createConnectionFactoryWithHA(groupConfig, cfConfig.getFactoryType()) : HornetQJMSClient.createConnectionFactoryWithoutHA(groupConfig, cfConfig.getFactoryType());
        } else {
            if (cfConfig.getConnectorNames() == null || cfConfig.getConnectorNames().size() == 0) {
                throw new HornetQException(104, "Null Connector name passed to create ConnectionFactory");
            }
            TransportConfiguration[] configs = new TransportConfiguration[cfConfig.getConnectorNames().size()];
            int count = 0;
            for (String name : cfConfig.getConnectorNames()) {
                TransportConfiguration connector = (TransportConfiguration)this.server.getConfiguration().getConnectorConfigurations().get(name);
                if (connector == null) {
                    throw new HornetQException(104, "Connector '" + name + "' not found on the main configuration file");
                }
                configs[count++] = connector;
            }
            cf = cfConfig.isHA() ? HornetQJMSClient.createConnectionFactoryWithHA(cfConfig.getFactoryType(), configs) : HornetQJMSClient.createConnectionFactoryWithoutHA(cfConfig.getFactoryType(), configs);
        }
        cf.setClientID(cfConfig.getClientID());
        cf.setClientFailureCheckPeriod(cfConfig.getClientFailureCheckPeriod());
        cf.setConnectionTTL(cfConfig.getConnectionTTL());
        cf.setCallTimeout(cfConfig.getCallTimeout());
        cf.setCacheLargeMessagesClient(cfConfig.isCacheLargeMessagesClient());
        cf.setMinLargeMessageSize(cfConfig.getMinLargeMessageSize());
        cf.setConsumerWindowSize(cfConfig.getConsumerWindowSize());
        cf.setConsumerMaxRate(cfConfig.getConsumerMaxRate());
        cf.setConfirmationWindowSize(cfConfig.getConfirmationWindowSize());
        cf.setProducerWindowSize(cfConfig.getProducerWindowSize());
        cf.setProducerMaxRate(cfConfig.getProducerMaxRate());
        cf.setBlockOnAcknowledge(cfConfig.isBlockOnAcknowledge());
        cf.setBlockOnDurableSend(cfConfig.isBlockOnDurableSend());
        cf.setBlockOnNonDurableSend(cfConfig.isBlockOnNonDurableSend());
        cf.setAutoGroup(cfConfig.isAutoGroup());
        cf.setPreAcknowledge(cfConfig.isPreAcknowledge());
        cf.setConnectionLoadBalancingPolicyClassName(cfConfig.getLoadBalancingPolicyClassName());
        cf.setTransactionBatchSize(cfConfig.getTransactionBatchSize());
        cf.setDupsOKBatchSize(cfConfig.getDupsOKBatchSize());
        cf.setUseGlobalPools(cfConfig.isUseGlobalPools());
        cf.setScheduledThreadPoolMaxSize(cfConfig.getScheduledThreadPoolMaxSize());
        cf.setThreadPoolMaxSize(cfConfig.getThreadPoolMaxSize());
        cf.setRetryInterval(cfConfig.getRetryInterval());
        cf.setRetryIntervalMultiplier(cfConfig.getRetryIntervalMultiplier());
        cf.setMaxRetryInterval(cfConfig.getMaxRetryInterval());
        cf.setReconnectAttempts(cfConfig.getReconnectAttempts());
        cf.setFailoverOnInitialConnection(cfConfig.isFailoverOnInitialConnection());
        cf.setCompressLargeMessage(cfConfig.isCompressLargeMessages());
        cf.setGroupID(cfConfig.getGroupID());
        return cf;
    }

    @Override
    public synchronized boolean destroyConnectionFactory(final String name) throws Exception {
        final AtomicBoolean valueReturn = new AtomicBoolean(false);
        this.runAfterActive(new RunnableException(){

            public String toString() {
                return "destroyConnectionFactory for " + name;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.shutdownConnectionFactory(name);
                JMSServerManagerImpl.this.storage.deleteConnectionFactory(name);
                valueReturn.set(true);
            }
        });
        return valueReturn.get();
    }

    protected boolean shutdownConnectionFactory(String name) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = this.connectionFactoryJNDI.get(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        if (this.registry != null) {
            for (String jndiBinding : jndiBindings) {
                this.registry.unbind(jndiBinding);
            }
        }
        this.connectionFactoryJNDI.remove(name);
        this.connectionFactories.remove(name);
        this.jmsManagementService.unregisterConnectionFactory(name);
        return true;
    }

    @Override
    public String[] listRemoteAddresses() throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listRemoteAddresses();
    }

    @Override
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listRemoteAddresses(ipAddress);
    }

    @Override
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().closeConnectionsForAddress(ipAddress);
    }

    @Override
    public String[] listConnectionIDs() throws Exception {
        return this.server.getHornetQServerControl().listConnectionIDs();
    }

    @Override
    public String[] listSessions(String connectionID) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listSessions(connectionID);
    }

    @Override
    public String listPreparedTransactionDetailsAsJSON() throws Exception {
        ResourceManager resourceManager = this.server.getResourceManager();
        Map xids = resourceManager.getPreparedTransactionsWithCreationTime();
        if (xids == null || xids.size() == 0) {
            return "";
        }
        ArrayList xidsSortedByCreationTime = new ArrayList(xids.entrySet());
        Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

            @Override
            public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                return (int)(entry1.getValue() - entry2.getValue());
            }
        });
        JSONArray txDetailListJson = new JSONArray();
        for (Map.Entry entry : xidsSortedByCreationTime) {
            Xid xid = (Xid)entry.getKey();
            JMSTransactionDetail detail = new JMSTransactionDetail(xid, resourceManager.getTransaction(xid), (Long)entry.getValue());
            txDetailListJson.put((Object)detail.toJSON());
        }
        return txDetailListJson.toString();
    }

    @Override
    public String listPreparedTransactionDetailsAsHTML() throws Exception {
        ResourceManager resourceManager = this.server.getResourceManager();
        Map xids = resourceManager.getPreparedTransactionsWithCreationTime();
        if (xids == null || xids.size() == 0) {
            return "<h3>*** Prepared Transaction Details ***</h3><p>No entry.</p>";
        }
        ArrayList xidsSortedByCreationTime = new ArrayList(xids.entrySet());
        Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

            @Override
            public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                return (int)(entry1.getValue() - entry2.getValue());
            }
        });
        StringBuilder html = new StringBuilder();
        html.append("<h3>*** Prepared Transaction Details ***</h3>");
        for (Map.Entry entry : xidsSortedByCreationTime) {
            Xid xid = (Xid)entry.getKey();
            JMSTransactionDetail detail = new JMSTransactionDetail(xid, resourceManager.getTransaction(xid), (Long)entry.getValue());
            JSONObject txJson = detail.toJSON();
            html.append("<table border=\"1\">");
            html.append("<tr><th>creation_time</th>");
            html.append("<td>" + txJson.get("creation_time") + "</td>");
            html.append("<th>xid_as_base_64</th>");
            html.append("<td colspan=\"3\">" + txJson.get("xid_as_base64") + "</td></tr>");
            html.append("<tr><th>xid_format_id</th>");
            html.append("<td>" + txJson.get("xid_format_id") + "</td>");
            html.append("<th>xid_global_txid</th>");
            html.append("<td>" + txJson.get("xid_global_txid") + "</td>");
            html.append("<th>xid_branch_qual</th>");
            html.append("<td>" + txJson.get("xid_branch_qual") + "</td></tr>");
            html.append("<tr><th colspan=\"6\">Message List</th></tr>");
            html.append("<tr><td colspan=\"6\">");
            html.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
            JSONArray msgs = txJson.getJSONArray("tx_related_messages");
            for (int i = 0; i < msgs.length(); ++i) {
                JSONObject msgJson = msgs.getJSONObject(i);
                JSONObject props = msgJson.getJSONObject("message_properties");
                StringBuilder propstr = new StringBuilder();
                Iterator propkeys = props.keys();
                while (propkeys.hasNext()) {
                    String key = (String)propkeys.next();
                    propstr.append(key);
                    propstr.append("=");
                    propstr.append(props.get(key));
                    propstr.append(", ");
                }
                html.append("<th>operation_type</th>");
                html.append("<td>" + msgJson.get("message_operation_type") + "</th>");
                html.append("<th>message_type</th>");
                html.append("<td>" + msgJson.get("message_type") + "</td></tr>");
                html.append("<tr><th>properties</th>");
                html.append("<td colspan=\"3\">" + propstr.toString() + "</td></tr>");
                html.append("<tr><th colspan=\"4\">payload</th></tr>");
                html.append("<tr><td colspan=\"4\">" + msgJson.get("message_payload") + "</td></tr>");
            }
            html.append("</table></td></tr>");
            html.append("</table><br/>");
        }
        return html.toString();
    }

    private synchronized void checkInitialised() {
        if (!this.active) {
            throw new IllegalStateException("Cannot access JMS Server, core server is not yet active");
        }
    }

    private void addToBindings(Map<String, List<String>> map, String name, String ... jndi) {
        List<String> list = map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(name, list);
        }
        for (String jndiItem : jndi) {
            list.add(jndiItem);
        }
    }

    private void checkJNDI(String ... jndiNames) throws NamingException {
        for (String jndiName : jndiNames) {
            if (this.registry.lookup(jndiName) == null) continue;
            throw new NamingException(jndiName + " already has an object bound");
        }
    }

    private boolean bindToJndi(String jndiName, Object objectToBind) throws NamingException {
        if (this.registry != null) {
            this.registry.unbind(jndiName);
            this.registry.bind(jndiName, objectToBind);
        }
        return true;
    }

    private void deploy() throws Exception {
        if (this.config == null) {
            return;
        }
        if (this.config.getContext() != null) {
            this.setContext(this.config.getContext());
        }
        List<ConnectionFactoryConfiguration> connectionFactoryConfigurations = this.config.getConnectionFactoryConfigurations();
        for (ConnectionFactoryConfiguration config : connectionFactoryConfigurations) {
            this.createConnectionFactory(false, config, config.getBindings());
        }
        List<JMSQueueConfiguration> queueConfigs = this.config.getQueueConfigurations();
        for (JMSQueueConfiguration config : queueConfigs) {
            String[] bindings = config.getBindings();
            this.createQueue(false, config.getName(), config.getSelector(), config.isDurable(), bindings);
        }
        List<TopicConfiguration> topicConfigs = this.config.getTopicConfigurations();
        for (TopicConfiguration config : topicConfigs) {
            String[] bindings = config.getBindings();
            this.createTopic(false, config.getName(), bindings);
        }
    }

    private void unbindJNDI(Map<String, List<String>> param) {
        if (this.registry != null) {
            for (List<String> elementList : param.values()) {
                for (String key : elementList) {
                    try {
                        this.registry.unbind(key);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Impossible to unbind key " + key + " from JNDI"), (Throwable)e);
                    }
                }
            }
        }
    }

    private void initJournal() throws Exception {
        this.coreConfig = this.server.getConfiguration();
        this.createJournal();
        this.storage.load();
        List<PersistedConnectionFactory> cfs = this.storage.recoverConnectionFactories();
        for (PersistedConnectionFactory cf : cfs) {
            this.internalCreateCF(true, cf.getConfig());
        }
        List<PersistedDestination> destinations = this.storage.recoverDestinations();
        for (PersistedDestination destination : destinations) {
            if (destination.getType() == PersistedType.Queue) {
                this.internalCreateQueue(destination.getName(), destination.getSelector(), destination.isDurable());
                continue;
            }
            if (destination.getType() != PersistedType.Topic) continue;
            this.internalCreateTopic(destination.getName());
        }
        List<PersistedJNDI> jndiSpace = this.storage.recoverPersistedJNDI();
        for (PersistedJNDI record : jndiSpace) {
            Referenceable objectToBind;
            Map<String, Referenceable> objects;
            Map<String, List<String>> mapJNDI;
            switch (record.getType()) {
                case Queue: {
                    mapJNDI = this.queueJNDI;
                    objects = this.queues;
                    break;
                }
                case Topic: {
                    mapJNDI = this.topicJNDI;
                    objects = this.topics;
                    break;
                }
                default: {
                    mapJNDI = this.connectionFactoryJNDI;
                    objects = this.connectionFactories;
                }
            }
            if ((objectToBind = objects.get(record.getName())) == null) continue;
            List<String> jndiList = mapJNDI.get(record.getName());
            if (jndiList == null) {
                jndiList = new ArrayList<String>();
                mapJNDI.put(record.getName(), jndiList);
            }
            for (String jndi : record.getJndi()) {
                jndiList.add(jndi);
                this.bindToJndi(jndi, objectToBind);
            }
        }
    }

    private void createJournal() throws Exception {
        if (this.storage == null) {
            this.storage = this.coreConfig.isPersistenceEnabled() ? new JMSJournalStorageManagerImpl((IDGenerator)new TimeAndCounterIDGenerator(), this.server.getConfiguration(), this.server.getReplicationManager()) : new NullJMSStorageManagerImpl();
        } else if (this.storage.isStarted()) {
            this.storage.stop();
        }
        this.storage.start();
    }

    private synchronized boolean removeFromJNDI(Map<String, ?> keys, Map<String, List<String>> jndiMap, String name) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = jndiMap.remove(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        keys.remove(name);
        if (this.registry != null) {
            Iterator<String> iter = jndiBindings.iterator();
            while (iter.hasNext()) {
                String jndiBinding = iter.next();
                this.registry.unbind(jndiBinding);
                iter.remove();
            }
        }
        return true;
    }

    private synchronized boolean removeFromJNDI(Map<String, List<String>> jndiMap, String name, String jndi) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = jndiMap.get(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        if (jndiBindings.remove(jndi)) {
            this.registry.unbind(jndi);
            return true;
        }
        return false;
    }

    private boolean runAfterActive(RunnableException runnable) throws Exception {
        if (this.active) {
            runnable.runException();
            return true;
        }
        log.info((Object)("Caching command for " + runnable + " since the JMS Server is not active yet"));
        this.cachedCommands.add(runnable);
        return false;
    }

    private abstract class RunnableException
    implements Runnable {
        private RunnableException() {
        }

        @Override
        public void run() {
            try {
                this.runException();
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }

        public abstract void runException() throws Exception;
    }
}

