/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.reader.BytesMessageUtil;

public class HornetQBytesMessage
extends HornetQMessage
implements BytesMessage {
    public static final byte TYPE = 4;
    private int bodyLength;

    protected HornetQBytesMessage(ClientSession session) {
        super((byte)4, session);
    }

    protected HornetQBytesMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQBytesMessage(BytesMessage foreign, ClientSession session) throws JMSException {
        super((javax.jms.Message)foreign, (byte)4, session);
        foreign.reset();
        byte[] buffer = new byte[1024];
        int n = foreign.readBytes(buffer);
        while (n != -1) {
            this.writeBytes(buffer, 0, n);
            n = foreign.readBytes(buffer);
        }
    }

    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadBoolean((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadByte((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadUnsignedByte((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public short readShort() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadShort((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadUnsignedShort((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadChar((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadInt((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadLong((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadFloat((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadDouble((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public String readUTF() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadUTF((Message)this.message);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to get UTF");
            je.setLinkedException(e);
            je.initCause((Throwable)e);
            throw je;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        return BytesMessageUtil.bytesReadBytes((Message)this.message, (byte[])value);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkRead();
        return BytesMessageUtil.bytesReadBytes((Message)this.message, (byte[])value, (int)length);
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteBoolean((Message)this.message, (boolean)value);
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteByte((Message)this.message, (byte)value);
    }

    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteShort((Message)this.message, (short)value);
    }

    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteChar((Message)this.message, (char)value);
    }

    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteInt((Message)this.message, (int)value);
    }

    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteLong((Message)this.message, (long)value);
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteFloat((Message)this.message, (float)value);
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteDouble((Message)this.message, (double)value);
    }

    public void writeUTF(String value) throws JMSException {
        this.checkWrite();
        try {
            BytesMessageUtil.bytesWriteUTF((Message)this.message, (String)value);
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to write UTF");
            je.setLinkedException(e);
            je.initCause((Throwable)e);
            throw je;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteBytes((Message)this.message, (byte[])value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteBytes((Message)this.message, (byte[])value, (int)offset, (int)length);
    }

    public void writeObject(Object value) throws JMSException {
        this.checkWrite();
        if (!BytesMessageUtil.bytesWriteObject((Message)this.message, (Object)value)) {
            throw new MessageFormatException("Invalid object for properties");
        }
    }

    public void reset() throws JMSException {
        if (!this.readOnly) {
            this.readOnly = true;
            this.bodyLength = this.message.getBodySize();
        }
        BytesMessageUtil.bytesMessageReset((Message)this.message);
    }

    @Override
    public void doBeforeReceive() throws HornetQException {
        this.bodyLength = this.message.getBodySize();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        try {
            this.getBuffer().clear();
        }
        catch (RuntimeException e) {
            JMSException e2 = new JMSException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    public long getBodyLength() throws JMSException {
        this.checkRead();
        return this.bodyLength;
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.reset();
    }

    @Override
    public byte getType() {
        return 4;
    }

    private HornetQBuffer getBuffer() {
        return this.message.getBodyBuffer();
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        return c.isAssignableFrom(byte[].class);
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) {
        if (this.bodyLength == 0) {
            return null;
        }
        byte[] dst = new byte[this.bodyLength];
        this.message.getBodyBuffer().getBytes(17, dst);
        return (T)dst;
    }
}

