/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQInvalidFilterExpressionException;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.jms.client.HornetQJMSClientBundle;

public class HornetQJMSClientBundle_$bundle
implements Serializable,
HornetQJMSClientBundle {
    private static final long serialVersionUID = 1L;
    public static final HornetQJMSClientBundle_$bundle INSTANCE = new HornetQJMSClientBundle_$bundle();
    private static final String invalidFilter = "HQ129000: Invalid filter: {0}";
    private static final String invalidSubscriptionName = "HQ129001: Invalid Subscription Name. It is required to set the subscription name";
    private static final String destinationDoesNotExist = "HQ129002: Destination {0} does not exist";
    private static final String nameCannotBeNull = "HQ129003: name cannot be null";
    private static final String nameCannotBeEmpty = "HQ129004: name cannot be empty";
    private static final String callingMethodFromListenerRuntime = "HQ129005: It is illegal to call this method from within a Message Listener";
    private static final String callingMethodFromListener = "HQ129006: It is illegal to call this method from within a Message Listener";
    private static final String callingMethodFromCompletionListenerRuntime = "HQ129007: It is illegal to call this method from within a Completion Listener";
    private static final String callingMethodFromCompletionListener = "HQ129008: It is illegal to call this method from within a Completion Listener";
    private static final String nullArgumentNotAllowed = "HQ129009: Null {0} is not allowed";
    private static final String nullTopic = "HQ129010: Topic (Destination) cannot be null";
    private static final String onlyValidForByteOrStreamMessages = "HQ129011: LargeMessage streaming is only possible on ByteMessage or StreamMessage";
    private static final String invalidJavaIdentifier = "HQ129012: The property name ''{0}'' is not a valid java identifier.";
    private static final String messageNotWritable = "HQ129013: Message is read-only";
    private static final String messageNotReadable = "HQ129014: Message is write-only";
    private static final String illegalDeliveryMode = "HQ129015: Illegal deliveryMode value: {0}";

    protected HornetQJMSClientBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final HornetQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        HornetQInvalidFilterExpressionException result = new HornetQInvalidFilterExpressionException(MessageFormat.format(this.invalidFilter$str(), filter));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final HornetQIllegalStateException invalidSubscriptionName() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.invalidSubscriptionName$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSubscriptionName$str() {
        return invalidSubscriptionName;
    }

    @Override
    public final HornetQNonExistentQueueException destinationDoesNotExist(SimpleString destination) {
        HornetQNonExistentQueueException result = new HornetQNonExistentQueueException(MessageFormat.format(this.destinationDoesNotExist$str(), destination));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destinationDoesNotExist$str() {
        return destinationDoesNotExist;
    }

    @Override
    public final IllegalArgumentException nameCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.nameCannotBeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameCannotBeNull$str() {
        return nameCannotBeNull;
    }

    @Override
    public final IllegalArgumentException nameCannotBeEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(this.nameCannotBeEmpty$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameCannotBeEmpty$str() {
        return nameCannotBeEmpty;
    }

    @Override
    public final IllegalStateRuntimeException callingMethodFromListenerRuntime() {
        IllegalStateRuntimeException result = new IllegalStateRuntimeException(this.callingMethodFromListenerRuntime$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromListenerRuntime$str() {
        return callingMethodFromListenerRuntime;
    }

    @Override
    public final IllegalStateException callingMethodFromListener() {
        IllegalStateException result = new IllegalStateException(this.callingMethodFromListener$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromListener$str() {
        return callingMethodFromListener;
    }

    @Override
    public final IllegalStateRuntimeException callingMethodFromCompletionListenerRuntime() {
        IllegalStateRuntimeException result = new IllegalStateRuntimeException(this.callingMethodFromCompletionListenerRuntime$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromCompletionListenerRuntime$str() {
        return callingMethodFromCompletionListenerRuntime;
    }

    @Override
    public final IllegalStateException callingMethodFromCompletionListener() {
        IllegalStateException result = new IllegalStateException(this.callingMethodFromCompletionListener$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromCompletionListener$str() {
        return callingMethodFromCompletionListener;
    }

    @Override
    public final IllegalArgumentException nullArgumentNotAllowed(String type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.nullArgumentNotAllowed$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullArgumentNotAllowed$str() {
        return nullArgumentNotAllowed;
    }

    @Override
    public final InvalidDestinationException nullTopic() {
        InvalidDestinationException result = new InvalidDestinationException(this.nullTopic$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullTopic$str() {
        return nullTopic;
    }

    @Override
    public final IllegalStateException onlyValidForByteOrStreamMessages() {
        IllegalStateException result = new IllegalStateException(this.onlyValidForByteOrStreamMessages$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String onlyValidForByteOrStreamMessages$str() {
        return onlyValidForByteOrStreamMessages;
    }

    @Override
    public final JMSRuntimeException invalidJavaIdentifier(String propertyName) {
        JMSRuntimeException result = new JMSRuntimeException(MessageFormat.format(this.invalidJavaIdentifier$str(), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJavaIdentifier$str() {
        return invalidJavaIdentifier;
    }

    @Override
    public final MessageNotWriteableException messageNotWritable() {
        MessageNotWriteableException result = new MessageNotWriteableException(this.messageNotWritable$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageNotWritable$str() {
        return messageNotWritable;
    }

    @Override
    public final MessageNotReadableException messageNotReadable() {
        MessageNotReadableException result = new MessageNotReadableException(this.messageNotReadable$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageNotReadable$str() {
        return messageNotReadable;
    }

    @Override
    public final JMSException illegalDeliveryMode(int deliveryMode) {
        JMSException result = new JMSException(MessageFormat.format(this.illegalDeliveryMode$str(), deliveryMode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalDeliveryMode$str() {
        return illegalDeliveryMode;
    }
}

