/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.jms.client.HornetQBytesMessage;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQJMSClientBundle;
import org.hornetq.jms.client.HornetQMapMessage;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQObjectMessage;
import org.hornetq.jms.client.HornetQStreamMessage;
import org.hornetq.jms.client.HornetQTextMessage;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class HornetQMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private final HornetQConnection connection;
    private final SimpleString connID;
    private final ClientProducer clientProducer;
    private final ClientSession clientSession;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private int defaultDeliveryMode = 2;
    private long defaultDeliveryDelay = 0L;
    private final HornetQDestination defaultDestination;

    protected HornetQMessageProducer(HornetQConnection connection, ClientProducer producer, HornetQDestination defaultDestination, ClientSession clientSession) throws JMSException {
        this.connection = connection;
        this.connID = connection.getClientID() != null ? new SimpleString(connection.getClientID()) : connection.getUID();
        this.clientProducer = producer;
        this.defaultDestination = defaultDestination;
        this.clientSession = clientSession;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        if (deliveryMode != 1 && deliveryMode != 2) {
            throw HornetQJMSClientBundle.BUNDLE.illegalDeliveryMode(deliveryMode);
        }
        this.defaultDeliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        if (defaultPriority < 0 || defaultPriority > 9) {
            throw new JMSException("Illegal priority value: " + defaultPriority);
        }
        this.defaultPriority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.defaultDestination;
    }

    public void close() throws JMSException {
        this.connection.getThreadAwareContext().assertNotCompletionListenerThread();
        try {
            this.clientProducer.close();
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public void send(javax.jms.Message message) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, null);
    }

    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Destination destination, javax.jms.Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        this.checkDestination(destination);
        this.doSendx((HornetQDestination)destination, message, deliveryMode, priority, timeToLive, null);
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.defaultDeliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() throws JMSException {
        return this.defaultDeliveryDelay;
    }

    public void send(javax.jms.Message message, CompletionListener completionListener) throws JMSException {
        this.send(message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkCompletionListener(completionListener);
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(Destination destination, javax.jms.Message message, CompletionListener completionListener) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkClosed();
        this.checkCompletionListener(completionListener);
        this.checkDestination(destination);
        this.doSendx((HornetQDestination)destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(javax.jms.Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Topic topic, javax.jms.Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination((Destination)topic);
        this.doSendx((HornetQDestination)topic, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Queue queue, javax.jms.Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination((Destination)queue);
        this.doSendx((HornetQDestination)queue, message, deliveryMode, priority, timeToLive, null);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public String toString() {
        return "HornetQMessageProducer->" + this.clientProducer;
    }

    private void checkDefaultDestination() {
        if (this.defaultDestination == null) {
            throw new UnsupportedOperationException("Cannot specify destination if producer has a default destination");
        }
    }

    private void checkDestination(Destination destination) throws InvalidDestinationException {
        if (destination != null && !(destination instanceof HornetQDestination)) {
            throw new InvalidDestinationException("Not a HornetQ Destination:" + destination);
        }
        if (destination != null && this.defaultDestination != null) {
            throw new UnsupportedOperationException("Cannot specify destination if producer has a default destination");
        }
        if (destination == null) {
            throw HornetQJMSClientBundle.BUNDLE.nullTopic();
        }
    }

    private void checkCompletionListener(CompletionListener completionListener) {
        if (completionListener == null) {
            throw HornetQJMSClientBundle.BUNDLE.nullArgumentNotAllowed("CompletionListener");
        }
    }

    private void doSendx(HornetQDestination destination, javax.jms.Message jmsMessage, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        HornetQMessage hqJmsMessage;
        jmsMessage.setJMSDeliveryMode(deliveryMode);
        jmsMessage.setJMSPriority(priority);
        if (timeToLive == 0L) {
            jmsMessage.setJMSExpiration(0L);
        } else {
            jmsMessage.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        if (!this.disableMessageTimestamp) {
            jmsMessage.setJMSTimestamp(System.currentTimeMillis());
        } else {
            jmsMessage.setJMSTimestamp(0L);
        }
        SimpleString address = null;
        if (destination == null) {
            if (this.defaultDestination == null) {
                throw new UnsupportedOperationException("Destination must be specified on send with an anonymous producer");
            }
            destination = this.defaultDestination;
        } else {
            if (this.defaultDestination != null && !destination.equals(this.defaultDestination)) {
                throw new UnsupportedOperationException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
            }
            address = destination.getSimpleAddress();
            if (!this.connection.containsKnownDestination(address)) {
                try {
                    ClientSession.AddressQuery query = this.clientSession.addressQuery(address);
                    if (!query.isExists()) {
                        throw new InvalidDestinationException("Destination " + address + " does not exist");
                    }
                    this.connection.addKnownDestination(address);
                }
                catch (HornetQException e) {
                    throw JMSExceptionHelper.convertFromHornetQException(e);
                }
            }
        }
        boolean foreign = false;
        if (!(jmsMessage instanceof HornetQMessage)) {
            hqJmsMessage = jmsMessage instanceof BytesMessage ? new HornetQBytesMessage((BytesMessage)jmsMessage, this.clientSession) : (jmsMessage instanceof MapMessage ? new HornetQMapMessage((MapMessage)jmsMessage, this.clientSession) : (jmsMessage instanceof ObjectMessage ? new HornetQObjectMessage((ObjectMessage)jmsMessage, this.clientSession) : (jmsMessage instanceof StreamMessage ? new HornetQStreamMessage((StreamMessage)jmsMessage, this.clientSession) : (jmsMessage instanceof TextMessage ? new HornetQTextMessage((TextMessage)jmsMessage, this.clientSession) : new HornetQMessage(jmsMessage, this.clientSession)))));
            jmsMessage.setJMSDestination((Destination)destination);
            foreign = true;
        } else {
            hqJmsMessage = (HornetQMessage)jmsMessage;
        }
        if (!this.disableMessageID) {
            UUID uid = UUIDGenerator.getInstance().generateUUID();
            hqJmsMessage.getCoreMessage().setUserID(uid);
            hqJmsMessage.resetMessageID(null);
        }
        if (foreign) {
            jmsMessage.setJMSMessageID(hqJmsMessage.getJMSMessageID());
        }
        hqJmsMessage.setJMSDestination(destination);
        try {
            hqJmsMessage.doBeforeSend();
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.initCause((Throwable)e);
            throw je;
        }
        if (this.defaultDeliveryDelay > 0L) {
            hqJmsMessage.setJMSDeliveryTime(System.currentTimeMillis() + this.defaultDeliveryDelay);
        }
        ClientMessage coreMessage = hqJmsMessage.getCoreMessage();
        coreMessage.putStringProperty(HornetQConnection.CONNECTION_ID_PROPERTY_NAME, this.connID);
        try {
            if (completionListener != null) {
                this.clientProducer.send(address, (Message)coreMessage, (SendAcknowledgementHandler)new CompletionListenerWrapper(completionListener, jmsMessage, this));
            } else {
                this.clientProducer.send(address, (Message)coreMessage);
            }
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    private void checkClosed() throws JMSException {
        if (this.clientProducer.isClosed() || this.clientSession.isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
    }

    private static final class CompletionListenerWrapper
    implements SendAcknowledgementHandler {
        private final CompletionListener completionListener;
        private final javax.jms.Message jmsMessage;
        private final HornetQMessageProducer producer;

        public CompletionListenerWrapper(CompletionListener listener, javax.jms.Message jmsMessage, HornetQMessageProducer producer) {
            this.completionListener = listener;
            this.jmsMessage = jmsMessage;
            this.producer = producer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendAcknowledged(Message clientMessage) {
            if (this.jmsMessage instanceof StreamMessage) {
                try {
                    ((StreamMessage)this.jmsMessage).reset();
                }
                catch (JMSException e) {
                    // empty catch block
                }
            }
            if (this.jmsMessage instanceof BytesMessage) {
                try {
                    ((BytesMessage)this.jmsMessage).reset();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            try {
                this.producer.connection.getThreadAwareContext().setCurrentThread(true);
                this.completionListener.onCompletion(this.jmsMessage);
            }
            finally {
                this.producer.connection.getThreadAwareContext().clearCurrentThread(true);
            }
        }

        public String toString() {
            return CompletionListenerWrapper.class.getSimpleName() + "( completionListener=" + this.completionListener + ")";
        }
    }
}

