/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.reader.TextMessageUtil;

public class HornetQTextMessage
extends HornetQMessage
implements TextMessage {
    public static final byte TYPE = 3;
    private SimpleString text;

    public HornetQTextMessage(ClientSession session) {
        super((byte)3, session);
    }

    public HornetQTextMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQTextMessage(TextMessage foreign, ClientSession session) throws JMSException {
        super((javax.jms.Message)foreign, (byte)3, session);
        this.setText(foreign.getText());
    }

    @Override
    public byte getType() {
        return 3;
    }

    public void setText(String text) throws JMSException {
        this.checkWrite();
        this.text = text != null ? new SimpleString(text) : null;
        TextMessageUtil.writeBodyText((Message)this.message, (SimpleString)this.text);
    }

    public String getText() {
        if (this.text != null) {
            return this.text.toString();
        }
        return null;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    @Override
    public void doBeforeReceive() throws HornetQException {
        super.doBeforeReceive();
        this.text = TextMessageUtil.readBodyText((Message)this.message);
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) {
        return (T)this.getText();
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        if (this.text == null) {
            return true;
        }
        return c.isAssignableFrom(String.class);
    }
}

