/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.JournalFile;

public class JournalFileImpl
implements JournalFile {
    private final SequentialFile file;
    private final long fileID;
    private final int recordID;
    private long offset;
    private final AtomicInteger posCount = new AtomicInteger(0);
    private final AtomicInteger liveBytes = new AtomicInteger(0);
    private boolean canReclaim;
    private final AtomicInteger totalNegativeToOthers = new AtomicInteger(0);
    private final int version;
    private final Map<JournalFile, AtomicInteger> negCounts = new ConcurrentHashMap<JournalFile, AtomicInteger>();

    public JournalFileImpl(SequentialFile file, long fileID, int version) {
        this.file = file;
        this.fileID = fileID;
        this.version = version;
        this.recordID = (int)(fileID & Integer.MAX_VALUE);
    }

    @Override
    public void clearCounts() {
        this.negCounts.clear();
        this.posCount.set(0);
        this.liveBytes.set(0);
        this.totalNegativeToOthers.set(0);
    }

    @Override
    public int getPosCount() {
        return this.posCount.intValue();
    }

    @Override
    public boolean isCanReclaim() {
        return this.canReclaim;
    }

    @Override
    public void setCanReclaim(boolean canReclaim) {
        this.canReclaim = canReclaim;
    }

    @Override
    public void incNegCount(JournalFile file) {
        if (file != this) {
            this.totalNegativeToOthers.incrementAndGet();
        }
        this.getOrCreateNegCount(file).incrementAndGet();
    }

    @Override
    public int getNegCount(JournalFile file) {
        AtomicInteger count = this.negCounts.get(file);
        if (count == null) {
            return 0;
        }
        return count.intValue();
    }

    @Override
    public int getJournalVersion() {
        return this.version;
    }

    @Override
    public boolean resetNegCount(JournalFile file) {
        return this.negCounts.remove(file) != null;
    }

    @Override
    public void incPosCount() {
        this.posCount.incrementAndGet();
    }

    @Override
    public void decPosCount() {
        this.posCount.decrementAndGet();
    }

    public void extendOffset(int delta) {
        this.offset += (long)delta;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getFileID() {
        return this.fileID;
    }

    @Override
    public int getRecordID() {
        return this.recordID;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public SequentialFile getFile() {
        return this.file;
    }

    public String toString() {
        try {
            return "JournalFileImpl: (" + this.file.getFileName() + " id = " + this.fileID + ", recordID = " + this.recordID + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error:" + e.toString();
        }
    }

    public String debug() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<JournalFile, AtomicInteger> entry : this.negCounts.entrySet()) {
            builder.append(" file = " + entry.getKey() + " negcount value = " + entry.getValue() + "\n");
        }
        return builder.toString();
    }

    private synchronized AtomicInteger getOrCreateNegCount(JournalFile file) {
        AtomicInteger count = this.negCounts.get(file);
        if (count == null) {
            count = new AtomicInteger();
            this.negCounts.put(file, count);
        }
        return count;
    }

    @Override
    public void addSize(int bytes) {
        this.liveBytes.addAndGet(bytes);
    }

    @Override
    public void decSize(int bytes) {
        this.liveBytes.addAndGet(-bytes);
    }

    @Override
    public int getLiveSize() {
        return this.liveBytes.get();
    }

    @Override
    public int getTotalNegativeToOthers() {
        return this.totalNegativeToOthers.get();
    }
}

