/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.Message;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.utils.TypedProperties;

public final class LargeServerMessageImpl
extends ServerMessageImpl
implements LargeServerMessage {
    private static boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final JournalStorageManager storageManager;
    private long pendingRecordID = -1L;
    private boolean paged;
    private SequentialFile file;
    private SequentialFile pendingCopy;
    private long bodySize = -1L;
    private final AtomicInteger delayDeletionCount = new AtomicInteger(0);
    private volatile int memoryEstimate = -1;

    public LargeServerMessageImpl(JournalStorageManager storageManager) {
        this.storageManager = storageManager;
    }

    private LargeServerMessageImpl(LargeServerMessageImpl copy, TypedProperties properties, SequentialFile fileCopy, long newID) {
        super(copy, properties);
        this.storageManager = copy.storageManager;
        this.file = fileCopy;
        this.bodySize = copy.bodySize;
        this.setMessageID(newID);
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
        this.pendingRecordID = pendingRecordID;
    }

    @Override
    public long getPendingRecordID() {
        return this.pendingRecordID;
    }

    @Override
    public void setPaged() {
        this.paged = true;
    }

    @Override
    public synchronized void addBytes(byte[] bytes) throws Exception {
        this.validateFile();
        if (!this.file.isOpen()) {
            this.file.open();
        }
        this.storageManager.addBytesToLargeMessage(this.file, this.getMessageID(), bytes);
        this.bodySize += (long)bytes.length;
    }

    public void encodeBody(HornetQBuffer bufferOut, BodyEncoder context, int size) {
        try {
            ByteBuffer bufferRead = ByteBuffer.allocate(size);
            int bytesRead = context.encode(bufferRead);
            bufferRead.flip();
            if (bytesRead > 0) {
                bufferOut.writeBytes(bufferRead.array(), 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public synchronized int getEncodeSize() {
        return this.getHeadersAndPropertiesEncodeSize();
    }

    public void encode(HornetQBuffer buffer) {
        super.encodeHeadersAndProperties(buffer);
    }

    public void decode(HornetQBuffer buffer) {
        this.file = null;
        super.decodeHeadersAndProperties(buffer);
    }

    @Override
    public synchronized void incrementDelayDeletionCount() {
        this.delayDeletionCount.incrementAndGet();
        try {
            this.incrementRefCount();
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.errorIncrementDelayDeletionCount(e);
        }
    }

    @Override
    public synchronized void decrementDelayDeletionCount() throws Exception {
        int count = this.delayDeletionCount.decrementAndGet();
        this.decrementRefCount();
        if (count == 0) {
            this.checkDelete();
        }
    }

    public BodyEncoder getBodyEncoder() throws HornetQException {
        this.validateFile();
        return new DecodingContext();
    }

    private void checkDelete() throws Exception {
        if (this.getRefCount() <= 0) {
            if (isTrace) {
                HornetQServerLogger.LOGGER.trace("Deleting file " + this.file + " as the usage was complete");
            }
            try {
                this.deleteFile();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public synchronized int decrementRefCount() throws Exception {
        int currentRefCount = super.decrementRefCount();
        if (this.delayDeletionCount.get() <= 0) {
            this.checkDelete();
        }
        return currentRefCount;
    }

    @Override
    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public synchronized void deleteFile() throws Exception {
        this.validateFile();
        this.releaseResources();
        this.storageManager.deleteLargeMessageFile(this);
        if (this.pendingRecordID >= 0L) {
            this.storageManager.confirmPendingLargeMessage(this.pendingRecordID);
            this.pendingRecordID = -1L;
        }
    }

    @Override
    public boolean isFileExists() throws Exception {
        SequentialFile localfile = this.storageManager.createFileForLargeMessage(this.getMessageID(), this.durable);
        return localfile.exists();
    }

    @Override
    public synchronized int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = this.getHeadersAndPropertiesEncodeSize() + 4 + this.getEncodeSize() + 40 + 1;
        }
        return this.memoryEstimate;
    }

    @Override
    public synchronized void releaseResources() {
        if (this.file != null && this.file.isOpen()) {
            try {
                this.file.close();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.largeMessageErrorReleasingResources(e);
            }
        }
    }

    @Override
    public void setOriginalHeaders(ServerMessage other, boolean expiry) {
        super.setOriginalHeaders(other, expiry);
        LargeServerMessageImpl otherLM = (LargeServerMessageImpl)other;
        this.paged = otherLM.paged;
        if (this.paged) {
            this.removeProperty(Message.HDR_ORIG_MESSAGE_ID);
        }
    }

    @Override
    public synchronized ServerMessage copy() {
        SequentialFile newfile = this.storageManager.createFileForLargeMessage(this.messageID, this.durable);
        LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this, this.properties, newfile, this.messageID);
        return newMessage;
    }

    public void copyFrom(SequentialFile fileSource) throws Exception {
        this.bodySize = -1L;
        this.pendingCopy = fileSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCopy() throws Exception {
        if (this.pendingCopy != null) {
            SequentialFile copyTo = this.createFile();
            try {
                this.pendingRecordID = this.storageManager.storePendingLargeMessage(this.messageID);
                copyTo.open();
                this.pendingCopy.open();
                this.pendingCopy.copyTo(copyTo);
            }
            finally {
                copyTo.close();
                this.pendingCopy.close();
                this.pendingCopy = null;
            }
            this.closeFile();
            this.bodySize = -1L;
            this.file = null;
        }
    }

    @Override
    public synchronized ServerMessage copy(long newID) {
        try {
            SequentialFile newfile = this.storageManager.createFileForLargeMessage(newID, this.durable);
            LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this, this.properties, newfile, newID);
            newMessage.copyFrom(this.createFile());
            return newMessage;
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.lareMessageErrorCopying(e, this);
            return null;
        }
    }

    @Override
    public SequentialFile getFile() throws HornetQException {
        this.validateFile();
        return this.file;
    }

    @Override
    public String toString() {
        return "LargeServerMessage[messageID=" + this.messageID + ",priority=" + this.getPriority() + ",expiration=[" + (this.getExpiration() != 0L ? new Date(this.getExpiration()) : "null") + "]" + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]@" + System.identityHashCode(this);
    }

    protected void finalize() throws Throwable {
        this.releaseResources();
        super.finalize();
    }

    private synchronized void validateFile() throws HornetQException {
        try {
            if (this.file == null) {
                if (this.messageID <= 0L) {
                    throw new RuntimeException("MessageID not set on LargeMessage");
                }
                this.file = this.createFile();
                this.openFile();
                this.bodySize = this.file.size();
            }
        }
        catch (Exception e) {
            throw new HornetQInternalErrorException(e.getMessage(), e);
        }
    }

    protected SequentialFile createFile() {
        return this.storageManager.createFileForLargeMessage(this.getMessageID(), this.durable);
    }

    protected void openFile() throws Exception {
        if (this.file == null) {
            this.validateFile();
        } else if (!this.file.isOpen()) {
            this.file.open();
        }
    }

    protected void closeFile() throws Exception {
        if (this.file != null && this.file.isOpen()) {
            this.file.close();
        }
    }

    class DecodingContext
    implements BodyEncoder {
        private SequentialFile cFile;

        DecodingContext() {
        }

        public void open() throws HornetQException {
            try {
                if (this.cFile != null && this.cFile.isOpen()) {
                    this.cFile.close();
                }
                this.cFile = LargeServerMessageImpl.this.file.cloneFile();
                this.cFile.open();
            }
            catch (Exception e) {
                throw new HornetQException(HornetQExceptionType.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
            }
        }

        public void close() throws HornetQException {
            try {
                this.cFile.close();
            }
            catch (Exception e) {
                throw new HornetQInternalErrorException(e.getMessage(), e);
            }
        }

        public int encode(ByteBuffer bufferRead) throws HornetQException {
            try {
                return this.cFile.read(bufferRead);
            }
            catch (Exception e) {
                throw new HornetQInternalErrorException(e.getMessage(), e);
            }
        }

        public int encode(HornetQBuffer bufferOut, int size) throws HornetQException {
            ByteBuffer bufferRead = ByteBuffer.allocate(size);
            int bytesRead = this.encode(bufferRead);
            bufferRead.flip();
            if (bytesRead > 0) {
                bufferOut.writeBytes(bufferRead.array(), 0, bytesRead);
            }
            return bytesRead;
        }

        public long getLargeBodySize() {
            if (LargeServerMessageImpl.this.bodySize < 0L) {
                try {
                    LargeServerMessageImpl.this.bodySize = LargeServerMessageImpl.this.file.size();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
            return LargeServerMessageImpl.this.bodySize;
        }
    }
}

