/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompProtocolManager;
import org.hornetq.core.protocol.stomp.StompSubscription;
import org.hornetq.core.server.QueueQueryResult;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.Pair;
import org.hornetq.utils.UUIDGenerator;

public class StompSession
implements SessionCallback {
    private final StompProtocolManager manager;
    private final StompConnection connection;
    private ServerSession session;
    private final OperationContext sessionContext;
    private final Map<Long, StompSubscription> subscriptions = new ConcurrentHashMap<Long, StompSubscription>();
    private final Map<Long, Pair<Long, Integer>> messagesToAck = new ConcurrentHashMap<Long, Pair<Long, Integer>>();
    private volatile boolean noLocal = false;
    private final int consumerCredits;

    StompSession(StompConnection connection, StompProtocolManager manager, OperationContext sessionContext) {
        this.connection = connection;
        this.manager = manager;
        this.sessionContext = sessionContext;
        this.consumerCredits = ConfigurationHelper.getIntProperty((String)"stomp-consumer-credits", (int)10240, connection.getAcceptorUsed().getConfiguration());
    }

    void setServerSession(ServerSession session) {
        this.session = session;
    }

    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    @Override
    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    @Override
    public int sendMessage(ServerMessage serverMessage, long consumerID, int deliveryCount) {
        try {
            StompSubscription subscription = this.subscriptions.get(consumerID);
            StompFrame frame = this.connection.createStompMessage(serverMessage, subscription, deliveryCount);
            int length = frame.getEncodedSize();
            if (subscription.getAck().equals("auto")) {
                this.session.acknowledge(consumerID, serverMessage.getMessageID());
                this.session.commit();
            } else {
                this.messagesToAck.put(serverMessage.getMessageID(), (Pair<Long, Integer>)new Pair((Object)consumerID, (Object)length));
            }
            this.manager.send(this.connection, frame);
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int sendLargeMessageContinuation(long consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    @Override
    public int sendLargeMessage(ServerMessage msg, long consumerID, long bodySize, int deliveryCount) {
        return 0;
    }

    @Override
    public void closed() {
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
        this.connection.getTransportConnection().addReadyListener(listener);
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
        this.connection.getTransportConnection().removeReadyListener(listener);
    }

    public void acknowledge(String messageID, String subscriptionID) throws Exception {
        long id = Long.parseLong(messageID);
        Pair<Long, Integer> pair = this.messagesToAck.remove(id);
        if (pair == null) {
            throw new HornetQStompException("failed to ack because no message with id: " + id);
        }
        long consumerID = (Long)pair.getA();
        int credits = (Integer)pair.getB();
        StompSubscription sub = this.subscriptions.get(consumerID);
        if (subscriptionID != null && !sub.getID().equals(subscriptionID)) {
            throw new HornetQStompException("subscription id " + subscriptionID + " does not match " + sub.getID());
        }
        if (this.consumerCredits != -1) {
            this.session.receiveConsumerCredits(consumerID, credits);
        }
        if (sub.getAck().equals("client-individual")) {
            this.session.individualAcknowledge(consumerID, id);
        } else {
            this.session.acknowledge(consumerID, id);
        }
        this.session.commit();
    }

    public void addSubscription(long consumerID, String subscriptionID, String clientID, String durableSubscriptionName, String destination, String selector, String ack) throws Exception {
        SimpleString queue = SimpleString.toSimpleString((String)destination);
        if (destination.startsWith("jms.topic")) {
            if (durableSubscriptionName != null) {
                if (clientID == null) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription if the client-id of the connection is not set");
                }
                queue = SimpleString.toSimpleString((String)(clientID + "." + durableSubscriptionName));
                QueueQueryResult query = this.session.executeQueueQuery(queue);
                if (!query.isExists()) {
                    this.session.createQueue(SimpleString.toSimpleString((String)destination), queue, null, false, true);
                }
            } else {
                queue = UUIDGenerator.getInstance().generateSimpleStringUUID();
                this.session.createQueue(SimpleString.toSimpleString((String)destination), queue, null, true, false);
            }
        }
        this.session.createConsumer(consumerID, queue, SimpleString.toSimpleString((String)selector), false);
        StompSubscription subscription = new StompSubscription(subscriptionID, ack);
        this.subscriptions.put(consumerID, subscription);
        if (subscription.getAck().equals("auto")) {
            this.session.receiveConsumerCredits(consumerID, -1);
        } else {
            this.session.receiveConsumerCredits(consumerID, this.consumerCredits);
        }
        this.session.start();
    }

    public boolean unsubscribe(String id) throws Exception {
        Iterator<Map.Entry<Long, StompSubscription>> iterator = this.subscriptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, StompSubscription> entry = iterator.next();
            long consumerID = entry.getKey();
            StompSubscription sub = entry.getValue();
            if (id == null || !id.equals(sub.getID())) continue;
            iterator.remove();
            this.session.closeConsumer(consumerID);
            return true;
        }
        return false;
    }

    boolean containsSubscription(String subscriptionID) {
        for (Map.Entry<Long, StompSubscription> entry : this.subscriptions.entrySet()) {
            StompSubscription sub = entry.getValue();
            if (!sub.getID().equals(subscriptionID)) continue;
            return true;
        }
        return false;
    }

    public RemotingConnection getConnection() {
        return this.connection;
    }

    public OperationContext getContext() {
        return this.sessionContext;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void sendInternal(ServerMessageImpl message, boolean direct) throws Exception {
        if (this.connection.enableMessageID()) {
            message.putStringProperty("hqMessageId", "STOMP" + message.getMessageID());
        }
        this.session.send(message, direct);
    }
}

