/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.protocol.stomp.WebSocketServerHandler;
import org.hornetq.core.remoting.impl.netty.HornetQChannelHandler;
import org.hornetq.core.remoting.impl.netty.HornetQFrameDecoder;
import org.hornetq.core.remoting.impl.netty.HornetQFrameDecoder2;
import org.hornetq.core.remoting.impl.netty.HttpAcceptorHandler;
import org.hornetq.core.remoting.impl.netty.HttpKeepAliveRunnable;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnection;
import org.hornetq.core.remoting.impl.netty.TransportConstants;
import org.hornetq.core.remoting.impl.ssl.SSLSupport;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferDecoder;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.VersionLoader;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.local.DefaultLocalServerChannelFactory;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.VirtualExecutorService;

public class NettyAcceptor
implements Acceptor {
    private final ClusterConnection clusterConnection;
    private ChannelFactory channelFactory;
    private volatile ChannelGroup serverChannelGroup;
    private volatile ChannelGroup channelGroup;
    private ServerBootstrap bootstrap;
    private final BufferHandler handler;
    private final BufferDecoder decoder;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpServerScanPeriod;
    private final long httpResponseTime;
    private final boolean useNio;
    private final boolean useInvm;
    private final ProtocolType protocol;
    private final String host;
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final int nioRemotingThreads;
    private final HttpKeepAliveRunnable httpKeepAliveRunnable;
    private HttpAcceptorHandler httpHandler = null;
    private final ConcurrentMap<Object, NettyConnection> connections = new ConcurrentHashMap<Object, NettyConnection>();
    private final Map<String, Object> configuration;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private NotificationService notificationService;
    private VirtualExecutorService bossExecutor;
    private boolean paused;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private final long batchDelay;
    private final boolean directDeliver;

    public NettyAcceptor(Map<String, Object> configuration, BufferHandler handler, BufferDecoder decoder, ConnectionLifeCycleListener listener, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this(null, configuration, handler, decoder, listener, threadPool, scheduledThreadPool);
    }

    public NettyAcceptor(ClusterConnection clusterConnection, Map<String, Object> configuration, BufferHandler handler, BufferDecoder decoder, ConnectionLifeCycleListener listener, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
        this.handler = handler;
        this.decoder = decoder;
        this.listener = listener;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty((String)"ssl-enabled", (boolean)false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty((String)"http-enabled", (boolean)false, configuration);
        if (this.httpEnabled) {
            this.httpServerScanPeriod = ConfigurationHelper.getLongProperty((String)"http-server-scan-period", (long)5000L, configuration);
            this.httpResponseTime = ConfigurationHelper.getLongProperty((String)"http-response-time", (long)10000L, configuration);
            this.httpKeepAliveRunnable = new HttpKeepAliveRunnable();
            ScheduledFuture<?> future = scheduledThreadPool.scheduleAtFixedRate(this.httpKeepAliveRunnable, this.httpServerScanPeriod, this.httpServerScanPeriod, TimeUnit.MILLISECONDS);
            this.httpKeepAliveRunnable.setFuture(future);
        } else {
            this.httpServerScanPeriod = 0L;
            this.httpResponseTime = 0L;
            this.httpKeepAliveRunnable = null;
        }
        this.useNio = ConfigurationHelper.getBooleanProperty((String)"use-nio", (boolean)false, configuration);
        this.nioRemotingThreads = ConfigurationHelper.getIntProperty((String)"nio-remoting-threads", (int)-1, configuration);
        this.useInvm = ConfigurationHelper.getBooleanProperty((String)"use-invm", (boolean)false, configuration);
        String protocolStr = ConfigurationHelper.getStringProperty((String)"protocol", (String)TransportConstants.DEFAULT_PROTOCOL, configuration);
        this.protocol = ProtocolType.valueOf((String)protocolStr.toUpperCase());
        this.host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty((String)"port", (int)5445, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty((String)"key-store-path", (String)"hornetq.keystore", configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty((String)"key-store-password", (String)"secureexample", configuration, (String)"hornetq.usemaskedpassword", (String)"hornetq.usemaskedpassword");
            this.trustStorePath = ConfigurationHelper.getStringProperty((String)"trust-store-path", (String)"hornetq.truststore", configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty((String)"trust-store-password", (String)"secureexample", configuration, (String)"hornetq.usemaskedpassword", (String)"hornetq.usemaskedpassword");
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
            this.trustStorePath = null;
            this.trustStorePassword = null;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty((String)"tcp-no-delay", (boolean)true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty((String)"tcp-send-buffer-size", (int)32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty((String)"tcp-receive-buffer-size", (int)32768, configuration);
        this.threadPool = threadPool;
        this.scheduledThreadPool = scheduledThreadPool;
        this.batchDelay = ConfigurationHelper.getLongProperty((String)"batch-delay", (long)0L, configuration);
        this.directDeliver = ConfigurationHelper.getBooleanProperty((String)"direct-deliver", (boolean)true, configuration);
    }

    public synchronized void start() throws Exception {
        SSLContext context;
        if (this.channelFactory != null) {
            return;
        }
        this.bossExecutor = new VirtualExecutorService(this.threadPool);
        VirtualExecutorService workerExecutor = new VirtualExecutorService(this.threadPool);
        if (this.useInvm) {
            this.channelFactory = new DefaultLocalServerChannelFactory();
        } else if (this.useNio) {
            int threadsToUse = this.nioRemotingThreads == -1 ? Runtime.getRuntime().availableProcessors() * 3 : this.nioRemotingThreads;
            this.channelFactory = new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)workerExecutor, threadsToUse);
        } else {
            this.channelFactory = new OioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)workerExecutor);
        }
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        if (this.sslEnabled) {
            try {
                context = SSLSupport.createServerContext((String)this.keyStorePath, (String)this.keyStorePassword, (String)this.trustStorePath, (String)this.trustStorePassword);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to create NettyAcceptor for " + this.host + ":" + this.port);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline;
                LinkedHashMap<String, Object> handlers = new LinkedHashMap<String, Object>();
                if (NettyAcceptor.this.sslEnabled) {
                    SSLEngine engine = context.createSSLEngine();
                    engine.setUseClientMode(false);
                    SslHandler handler = new SslHandler(engine);
                    handlers.put("ssl", handler);
                }
                if (NettyAcceptor.this.httpEnabled) {
                    handlers.put("http-decoder", new HttpRequestDecoder());
                    handlers.put("http-aggregator", new HttpChunkAggregator(Integer.MAX_VALUE));
                    handlers.put("http-encoder", new HttpResponseEncoder());
                    NettyAcceptor.this.httpHandler = new HttpAcceptorHandler(NettyAcceptor.this.httpKeepAliveRunnable, NettyAcceptor.this.httpResponseTime);
                    handlers.put("http-handler", (Object)NettyAcceptor.this.httpHandler);
                }
                if (NettyAcceptor.this.protocol == ProtocolType.CORE) {
                    handlers.put("hornetq-decoder", new HornetQFrameDecoder2());
                } else if (NettyAcceptor.this.protocol == ProtocolType.STOMP_WS) {
                    handlers.put("http-decoder", new HttpRequestDecoder());
                    handlers.put("http-aggregator", new HttpChunkAggregator(65536));
                    handlers.put("http-encoder", new HttpResponseEncoder());
                    handlers.put("hornetq-decoder", new HornetQFrameDecoder(NettyAcceptor.this.decoder));
                    handlers.put("websocket-handler", (Object)new WebSocketServerHandler());
                } else if (NettyAcceptor.this.protocol != ProtocolType.STOMP) {
                    handlers.put("hornetq-decoder", new HornetQFrameDecoder(NettyAcceptor.this.decoder));
                }
                handlers.put("handler", (Object)new HornetQServerChannelHandler(NettyAcceptor.this.channelGroup, NettyAcceptor.this.handler, new Listener()));
                if (NettyAcceptor.this.protocol == ProtocolType.STOMP_WS) {
                    pipeline = new DefaultChannelPipeline();
                    for (Map.Entry handler : handlers.entrySet()) {
                        pipeline.addLast((String)handler.getKey(), (ChannelHandler)handler.getValue());
                    }
                } else {
                    pipeline = Channels.pipeline((ChannelHandler[])handlers.values().toArray(new ChannelHandler[handlers.size()]));
                }
                return pipeline;
            }
        };
        this.bootstrap.setPipelineFactory(factory);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.setOption("child.receiveBufferSize", (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.setOption("child.sendBufferSize", (Object)this.tcpSendBufferSize);
        }
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.bootstrap.setOption("child.reuseAddress", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.channelGroup = new DefaultChannelGroup("hornetq-accepted-channels");
        this.serverChannelGroup = new DefaultChannelGroup("hornetq-acceptor-channels");
        this.startServerChannels();
        this.paused = false;
        if (!"3.4.5.Final-2da5b0e".equals(VersionLoader.getVersion().getNettyVersion())) {
            HornetQServerLogger.LOGGER.unexpectedNettyVersion(VersionLoader.getVersion().getNettyVersion(), "3.4.5.Final-2da5b0e");
        }
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
        if (this.batchDelay > 0L) {
            this.flusher = new BatchFlusher();
            this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
        }
        HornetQServerLogger.LOGGER.startedNettyAcceptor("3.4.5.Final-2da5b0e", this.host, this.port, this.protocol);
    }

    private void startServerChannels() {
        String[] hosts;
        for (String h : hosts = TransportConfiguration.splitHosts((String)this.host)) {
            Object address = this.useInvm ? new LocalAddress(h) : new InetSocketAddress(h, this.port);
            Channel serverChannel = this.bootstrap.bind((SocketAddress)address);
            this.serverChannelGroup.add((Object)serverChannel);
        }
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public synchronized void stop() {
        if (this.channelFactory == null) {
            return;
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        if (this.httpKeepAliveRunnable != null) {
            this.httpKeepAliveRunnable.close();
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        ChannelGroupFuture future = this.channelGroup.close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            HornetQServerLogger.LOGGER.nettyChannelGroupError();
            for (Channel channel : future.getGroup()) {
                if (!channel.isBound()) continue;
                HornetQServerLogger.LOGGER.nettyChannelStillOpen(channel, channel.getRemoteAddress());
            }
        }
        this.channelFactory.releaseExternalResources();
        this.channelFactory = null;
        for (NettyConnection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
        }
        this.paused = false;
    }

    public boolean isStarted() {
        return this.channelFactory != null;
    }

    @Override
    public synchronized void pause() {
        if (this.paused) {
            return;
        }
        if (this.channelFactory == null) {
            return;
        }
        ChannelGroupFuture future = this.serverChannelGroup.unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            HornetQServerLogger.LOGGER.nettyChannelGroupBindError();
            for (Channel channel : future.getGroup()) {
                if (!channel.isBound()) continue;
                HornetQServerLogger.LOGGER.nettyChannelStillBound(channel, channel.getRemoteAddress());
            }
        }
        this.bossExecutor.shutdown();
        try {
            this.bossExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.paused = true;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public void setDefaultHornetQPrincipal(HornetQPrincipal defaultHornetQPrincipal) {
        throw new IllegalStateException("unsecure connections not allowed");
    }

    @Override
    public boolean isUnsecurable() {
        return false;
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (NettyConnection connection : NettyAcceptor.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(HornetQComponent component, Connection connection, ProtocolType protocol) {
            if (NettyAcceptor.this.connections.putIfAbsent(connection.getID(), (NettyConnection)connection) != null) {
                throw HornetQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            NettyAcceptor.this.listener.connectionCreated(component, connection, NettyAcceptor.this.protocol);
        }

        public void connectionDestroyed(Object connectionID) {
            if (NettyAcceptor.this.connections.remove(connectionID) != null) {
                NettyAcceptor.this.listener.connectionDestroyed(connectionID);
            }
        }

        public void connectionException(final Object connectionID, final HornetQException me) {
            new Thread(){

                @Override
                public void run() {
                    NettyAcceptor.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
            NettyConnection conn = (NettyConnection)NettyAcceptor.this.connections.get(connectionID);
            if (conn != null) {
                conn.fireReady(ready);
            }
        }
    }

    private final class HornetQServerChannelHandler
    extends HornetQChannelHandler {
        HornetQServerChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Listener connectionListener = new Listener();
            NettyConnection nc = new NettyConnection(NettyAcceptor.this.configuration, e.getChannel(), (ConnectionLifeCycleListener)connectionListener, !NettyAcceptor.this.httpEnabled && NettyAcceptor.this.batchDelay > 0L, NettyAcceptor.this.directDeliver);
            connectionListener.connectionCreated(NettyAcceptor.this, (Connection)nc, ProtocolType.CORE);
            SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
            if (sslHandler != null) {
                sslHandler.handshake().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            HornetQServerChannelHandler.this.active = true;
                        } else {
                            future.getChannel().close();
                        }
                    }
                });
            } else {
                this.active = true;
            }
        }
    }
}

