/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.server.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.hornetq.core.protocol.stomp.StompProtocolManagerFactory;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.remoting.impl.netty.TransportConstants;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.AcceptorFactory;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.HornetQThreadFactory;

public class RemotingServiceImpl
implements RemotingService,
ConnectionLifeCycleListener {
    private static final boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    public static final long CONNECTION_TTL_CHECK_INTERVAL = 2000L;
    private volatile boolean started = false;
    private final Set<TransportConfiguration> acceptorsConfig;
    private final List<Interceptor> incomingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private final List<Interceptor> outgoingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private final Set<Acceptor> acceptors = new HashSet<Acceptor>();
    private final Map<Object, ConnectionEntry> connections = new ConcurrentHashMap<Object, ConnectionEntry>();
    private final HornetQServer server;
    private final ManagementService managementService;
    private ExecutorService threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private FailureCheckAndFlushThread failureCheckAndFlushThread;
    private final ClusterManager clusterManager;
    private final Map<ProtocolType, ProtocolManager> protocolMap = new ConcurrentHashMap<ProtocolType, ProtocolManager>();
    private HornetQPrincipal defaultInvmSecurityPrincipal;

    public RemotingServiceImpl(ClusterManager clusterManager, Configuration config, HornetQServer server, ManagementService managementService, ScheduledExecutorService scheduledThreadPool) {
        this.acceptorsConfig = config.getAcceptorConfigurations();
        this.server = server;
        this.clusterManager = clusterManager;
        for (String interceptorClass : config.getIncomingInterceptorClassNames()) {
            try {
                this.incomingInterceptors.add((Interceptor)RemotingServiceImpl.safeInitNewInstance(interceptorClass));
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorCreatingRemotingInterceptor(e, interceptorClass);
            }
        }
        for (String interceptorClass : config.getOutgoingInterceptorClassNames()) {
            try {
                this.outgoingInterceptors.add((Interceptor)RemotingServiceImpl.safeInitNewInstance(interceptorClass));
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorCreatingRemotingInterceptor(e, interceptorClass);
            }
        }
        this.managementService = managementService;
        this.scheduledThreadPool = scheduledThreadPool;
        this.protocolMap.put(ProtocolType.CORE, new CoreProtocolManagerFactory().createProtocolManager(server, this.incomingInterceptors, this.outgoingInterceptors));
        this.protocolMap.put(ProtocolType.STOMP, new StompProtocolManagerFactory().createProtocolManager(server, this.incomingInterceptors, this.outgoingInterceptors));
        this.protocolMap.put(ProtocolType.STOMP_WS, new StompProtocolManagerFactory().createProtocolManager(server, this.incomingInterceptors, this.outgoingInterceptors));
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        HornetQThreadFactory tFactory = new HornetQThreadFactory("HornetQ-remoting-threads-" + this.server.toString() + "-" + System.identityHashCode(this), false, tccl);
        this.threadPool = Executors.newCachedThreadPool((ThreadFactory)tFactory);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (TransportConfiguration info : this.acceptorsConfig) {
            try {
                Set invalid;
                Class<?> clazz = loader.loadClass(info.getFactoryClassName());
                AcceptorFactory factory = (AcceptorFactory)clazz.newInstance();
                if (info.getParams() != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), info.getParams().keySet())).isEmpty()) {
                    HornetQServerLogger.LOGGER.invalidAcceptorKeys(ConfigurationHelper.stringSetToCommaListString((Set)invalid));
                    continue;
                }
                String protocolString = ConfigurationHelper.getStringProperty((String)"protocol", (String)TransportConstants.DEFAULT_PROTOCOL, (Map)info.getParams());
                ProtocolType protocol = ProtocolType.valueOf((String)protocolString.toUpperCase());
                ProtocolManager manager = this.protocolMap.get(protocol);
                ClusterConnection clusterConnection = this.lookupClusterConnection(info);
                Acceptor acceptor = factory.createAcceptor(clusterConnection, info.getParams(), new DelegatingBufferHandler(), manager, this, this.threadPool, this.scheduledThreadPool);
                if (this.defaultInvmSecurityPrincipal != null && acceptor.isUnsecurable()) {
                    acceptor.setDefaultHornetQPrincipal(this.defaultInvmSecurityPrincipal);
                }
                this.acceptors.add(acceptor);
                if (this.managementService == null) continue;
                acceptor.setNotificationService(this.managementService);
                this.managementService.registerAcceptor(acceptor, info);
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorCreatingAcceptor(e, info.getFactoryClassName());
            }
        }
        for (Acceptor a : this.acceptors) {
            a.start();
        }
        this.failureCheckAndFlushThread = new FailureCheckAndFlushThread(2000L);
        this.failureCheckAndFlushThread.start();
        this.started = true;
    }

    @Override
    public synchronized void allowInvmSecurityOverride(HornetQPrincipal principal) {
        this.defaultInvmSecurityPrincipal = principal;
        for (Acceptor acceptor : this.acceptors) {
            if (!acceptor.isUnsecurable()) continue;
            acceptor.setDefaultHornetQPrincipal(principal);
        }
    }

    @Override
    public synchronized void freeze(CoreRemotingConnection backupRemotingConnection) {
        for (Acceptor acceptor : this.acceptors) {
            try {
                acceptor.pause();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorStoppingAcceptor();
            }
        }
        HashMap<Object, ConnectionEntry> connectionEntries = new HashMap<Object, ConnectionEntry>(this.connections);
        for (Map.Entry<Object, ConnectionEntry> entry : connectionEntries.entrySet()) {
            RemotingConnection conn = entry.getValue().connection;
            if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                HornetQServerLogger.LOGGER.trace("Sending connection.disconnection packet to " + conn);
            }
            if (conn.equals(backupRemotingConnection) || conn.isClient()) continue;
            conn.disconnect(false);
            this.connections.remove(entry.getKey());
        }
    }

    @Override
    public void stop(boolean criticalError) throws Exception {
        boolean ok;
        if (!this.started) {
            return;
        }
        if (!this.started) {
            return;
        }
        this.failureCheckAndFlushThread.close(criticalError);
        for (Acceptor acceptor : this.acceptors) {
            if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                HornetQServerLogger.LOGGER.debug("Pausing acceptor " + acceptor);
            }
            acceptor.pause();
        }
        if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
            HornetQServerLogger.LOGGER.debug("Sending disconnect on live connections");
        }
        HashSet<ConnectionEntry> connectionEntries = new HashSet<ConnectionEntry>(this.connections.values());
        for (ConnectionEntry entry : connectionEntries) {
            RemotingConnection conn = entry.connection;
            if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                HornetQServerLogger.LOGGER.trace("Sending connection.disconnection packet to " + conn);
            }
            conn.disconnect(criticalError);
        }
        for (Acceptor acceptor : this.acceptors) {
            acceptor.stop();
        }
        this.acceptors.clear();
        this.connections.clear();
        if (this.managementService != null) {
            this.managementService.unregisterAcceptors();
        }
        this.threadPool.shutdown();
        if (!criticalError && !(ok = this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS))) {
            HornetQServerLogger.LOGGER.timeoutRemotingThreadPool();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public RemotingConnection removeConnection(Object remotingConnectionID) {
        ConnectionEntry entry = this.connections.remove(remotingConnectionID);
        if (entry != null) {
            return entry.connection;
        }
        HornetQServerLogger.LOGGER.errorRemovingConnection();
        return null;
    }

    @Override
    public synchronized Set<RemotingConnection> getConnections() {
        HashSet<RemotingConnection> conns = new HashSet<RemotingConnection>();
        for (ConnectionEntry entry : this.connections.values()) {
            conns.add(entry.connection);
        }
        return conns;
    }

    private ProtocolManager getProtocolManager(ProtocolType protocol) {
        return this.protocolMap.get(protocol);
    }

    public void connectionCreated(HornetQComponent component, Connection connection, ProtocolType protocol) {
        if (this.server == null) {
            throw new IllegalStateException("Unable to create connection, server hasn't finished starting up");
        }
        ProtocolManager pmgr = this.getProtocolManager(protocol);
        if (pmgr == null) {
            throw HornetQMessageBundle.BUNDLE.unknownProtocol(protocol);
        }
        ConnectionEntry entry = pmgr.createConnectionEntry((Acceptor)component, connection);
        if (isTrace) {
            HornetQServerLogger.LOGGER.trace("Connection created " + connection);
        }
        this.connections.put(connection.getID(), entry);
    }

    public void connectionDestroyed(Object connectionID) {
        ConnectionEntry conn;
        if (isTrace) {
            HornetQServerLogger.LOGGER.trace("Connection removed " + connectionID + " from server " + this.server, new Exception("trace"));
        }
        if ((conn = this.connections.get(connectionID)) != null) {
            List failureListeners = conn.connection.getFailureListeners();
            boolean empty = true;
            for (FailureListener listener : failureListeners) {
                if (!(listener instanceof ServerSessionImpl)) continue;
                empty = false;
                break;
            }
            if (empty) {
                this.connections.remove(connectionID);
                conn.connection.destroy();
            }
        }
    }

    public void connectionException(Object connectionID, HornetQException me) {
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.addIncomingInterceptor(interceptor);
    }

    @Override
    public boolean removeInterceptor(Interceptor interceptor) {
        return this.removeIncomingInterceptor(interceptor);
    }

    @Override
    public void addIncomingInterceptor(Interceptor interceptor) {
        this.incomingInterceptors.add(interceptor);
    }

    @Override
    public boolean removeIncomingInterceptor(Interceptor interceptor) {
        return this.incomingInterceptors.remove(interceptor);
    }

    @Override
    public void addOutgoingInterceptor(Interceptor interceptor) {
        this.outgoingInterceptors.add(interceptor);
    }

    @Override
    public boolean removeOutgoingInterceptor(Interceptor interceptor) {
        return this.outgoingInterceptors.remove(interceptor);
    }

    private ClusterConnection lookupClusterConnection(TransportConfiguration acceptorConfig) {
        String clusterConnectionName = (String)acceptorConfig.getParams().get("cluster-connection");
        ClusterConnection clusterConnection = null;
        if (clusterConnectionName != null) {
            clusterConnection = this.clusterManager.getClusterConnection(clusterConnectionName);
        }
        if (clusterConnection == null) {
            clusterConnection = this.clusterManager.getDefaultConnection(acceptorConfig);
        }
        return clusterConnection;
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    private final class FailureCheckAndFlushThread
    extends Thread {
        private final long pauseInterval;
        private volatile boolean closed;
        private final CountDownLatch latch;

        FailureCheckAndFlushThread(long pauseInterval) {
            super("hornetq-failure-check-thread");
            this.latch = new CountDownLatch(1);
            this.pauseInterval = pauseInterval;
        }

        public void close(boolean criticalError) {
            this.closed = true;
            this.latch.countDown();
            if (!criticalError) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            while (!this.closed) {
                try {
                    RemotingConnection conn;
                    long now = System.currentTimeMillis();
                    HashSet<Object> idsToRemove = new HashSet<Object>();
                    for (ConnectionEntry entry : RemotingServiceImpl.this.connections.values()) {
                        conn = entry.connection;
                        boolean flush = true;
                        if (entry.ttl != -1L) {
                            if (!conn.checkDataReceived()) {
                                if (now >= entry.lastCheck + entry.ttl) {
                                    idsToRemove.add(conn.getID());
                                    flush = false;
                                }
                            } else {
                                entry.lastCheck = now;
                            }
                        }
                        if (!flush) continue;
                        conn.flush();
                    }
                    for (Object id : idsToRemove) {
                        conn = RemotingServiceImpl.this.removeConnection(id);
                        if (conn == null) continue;
                        conn.fail((HornetQException)HornetQMessageBundle.BUNDLE.clientExited(conn.getRemoteAddress()));
                    }
                    if (!this.latch.await(this.pauseInterval, TimeUnit.MILLISECONDS)) continue;
                    return;
                }
                catch (Throwable e) {
                    HornetQServerLogger.LOGGER.errorOnFailureCheck(e);
                }
            }
        }
    }

    private final class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
            ConnectionEntry conn = (ConnectionEntry)RemotingServiceImpl.this.connections.get(connectionID);
            if (conn != null) {
                conn.connection.bufferReceived(connectionID, buffer);
            } else if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                HornetQServerLogger.LOGGER.trace("ConnectionID = " + connectionID + " was already closed, so ignoring packet");
            }
        }
    }
}

