/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorImpl;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.client.impl.TopologyMemberImpl;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.utils.Pair;

public final class QuorumManager
implements SessionFailureListener,
ClusterTopologyListener {
    private String targetServerID = "";
    private final ExecutorService executor;
    private final String serverIdentity;
    private CountDownLatch latch;
    private volatile BACKUP_ACTIVATION signal;
    private ClientSessionFactoryInternal sessionFactory;
    private final Topology topology;
    private CoreRemotingConnection connection;
    private static final int LATCH_TIMEOUT = 30;
    private static final int RECONNECT_ATTEMPTS = 5;
    private final Object decisionGuard = new Object();
    private final NodeManager nodeManager;

    public QuorumManager(ServerLocator serverLocator, ExecutorService executor, String identity, NodeManager nodeManager) {
        this.serverIdentity = identity;
        this.executor = executor;
        this.latch = new CountDownLatch(1);
        this.nodeManager = nodeManager;
        this.topology = serverLocator.getTopology();
    }

    public void nodeUP(TopologyMember topologyMember, boolean last) {
    }

    public void nodeDown(long eventUID, String nodeID) {
        if (this.targetServerID.equals(nodeID)) {
            this.decideOnAction();
        }
    }

    public void setLiveID(String liveID) {
        this.targetServerID = liveID;
        this.nodeManager.setNodeID(liveID);
        this.sessionFactory.addFailureListener((SessionFailureListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLiveDown() {
        Collection nodes = this.topology.getMembers();
        LinkedList<ServerLocatorImpl> locatorsList = new LinkedList<ServerLocatorImpl>();
        AtomicInteger pingCount = new AtomicInteger(0);
        int total = 0;
        for (TopologyMemberImpl tm : nodes) {
            if (!this.useIt(tm)) continue;
            ++total;
        }
        if (total < 1) {
            return true;
        }
        CountDownLatch latch = new CountDownLatch(total);
        try {
            for (TopologyMemberImpl tm : nodes) {
                Pair pair = tm.getConnector();
                TransportConfiguration transportConfiguration = (TransportConfiguration)pair.getA();
                if (!this.useIt(tm)) continue;
                ServerLocatorImpl locator = (ServerLocatorImpl)HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
                locatorsList.add(locator);
                this.executor.submit(new ServerConnect(latch, total, pingCount, locator, transportConfiguration));
            }
            try {
                latch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruption) {
                // empty catch block
            }
            boolean vote = QuorumManager.nodeIsDown(total, pingCount.get());
            HornetQServerLogger.LOGGER.trace("quorum vote is liveIsDown=" + vote + ", count=" + pingCount);
            boolean bl = vote;
            return bl;
        }
        finally {
            for (ServerLocator serverLocator : locatorsList) {
                try {
                    serverLocator.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private boolean useIt(TopologyMemberImpl tm) {
        return tm.getLive() != null && !this.targetServerID.equals(tm.getLive().getName());
    }

    public String toString() {
        return QuorumManager.class.getSimpleName() + "(server=" + this.serverIdentity + ")";
    }

    private static final boolean isSufficient(int total, int pingCount, long votesLeft) {
        boolean notEnoughVotesLeft = (long)total - 2L * ((long)pingCount + votesLeft) > 0L;
        return QuorumManager.nodeIsDown(total, pingCount) || notEnoughVotesLeft;
    }

    private static boolean nodeIsDown(int total, int pingCount) {
        return pingCount * 2 >= total - 1;
    }

    public void notifyRegistrationFailed() {
        this.signal = BACKUP_ACTIVATION.FAILURE_REPLICATING;
        this.latch.countDown();
    }

    public void notifyAlreadyReplicating() {
        this.signal = BACKUP_ACTIVATION.ALREADY_REPLICATING;
        this.latch.countDown();
    }

    public void beforeReconnect(HornetQException exception) {
    }

    public void connectionFailed(HornetQException exception, boolean failedOver) {
        this.decideOnAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decideOnAction() {
        Object object = this.decisionGuard;
        synchronized (object) {
            block7: {
                if (this.signal == BACKUP_ACTIVATION.FAIL_OVER) {
                    return;
                }
                if (!this.isLiveDown()) {
                    try {
                        this.sessionFactory.connect(5, false);
                        return;
                    }
                    catch (HornetQException e) {
                        if (e.getType() == HornetQExceptionType.NOT_CONNECTED) break block7;
                        HornetQServerLogger.LOGGER.errorReConnecting((Exception)((Object)e));
                    }
                }
            }
            this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        }
        this.latch.countDown();
    }

    public final BACKUP_ACTIVATION waitForStatusChange() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return BACKUP_ACTIVATION.STOP;
        }
        return this.signal;
    }

    public synchronized void causeExit(BACKUP_ACTIVATION signal) {
        this.removeListener();
        this.signal = signal;
        this.latch.countDown();
    }

    private void removeListener() {
        if (this.connection == null) {
            return;
        }
        this.connection.removeFailureListener((FailureListener)this);
    }

    public synchronized void failOver() {
        this.removeListener();
        this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        this.latch.countDown();
    }

    public void setSessionFactory(ClientSessionFactoryInternal sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void addAsFailureListenerOf(CoreRemotingConnection liveConnection) {
        this.connection = liveConnection;
        this.connection.addFailureListener((FailureListener)this);
    }

    public synchronized void reset() {
        this.latch = new CountDownLatch(1);
    }

    static enum BACKUP_ACTIVATION {
        FAIL_OVER,
        FAILURE_REPLICATING,
        ALREADY_REPLICATING,
        STOP;

    }

    private static class ServerConnect
    implements Runnable {
        private final ServerLocatorImpl locator;
        private final CountDownLatch latch;
        private final AtomicInteger count;
        private final TransportConfiguration tc;
        private final int total;

        public ServerConnect(CountDownLatch latch, int total, AtomicInteger count, ServerLocatorImpl serverLocator, TransportConfiguration serverTC) {
            this.total = total;
            this.locator = serverLocator;
            this.latch = latch;
            this.count = count;
            this.tc = serverTC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.locator.setReconnectAttempts(0);
            try {
                ClientSession session;
                ClientSessionFactory sessionFactory = this.locator.createSessionFactory(this.tc);
                if (sessionFactory != null && (session = sessionFactory.createSession()) != null) {
                    if (QuorumManager.isSufficient(this.total, this.count.incrementAndGet(), this.latch.getCount() - 1L)) {
                        while (this.latch.getCount() > 0L) {
                            this.latch.countDown();
                        }
                    }
                    session.close();
                    sessionFactory.close();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.latch.countDown();
                this.locator.close();
            }
        }
    }
}

