/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.utils.IDGenerator;

public class BatchingIDGenerator
implements IDGenerator {
    private final AtomicLong counter;
    private final long checkpointSize;
    private volatile long nextID;
    private final StorageManager storageManager;

    public BatchingIDGenerator(long start, long checkpointSize, StorageManager storageManager) {
        this.counter = new AtomicLong(start);
        this.nextID = start;
        this.checkpointSize = checkpointSize;
        this.storageManager = storageManager;
    }

    public void close() {
        this.storeID(this.counter.incrementAndGet(), this.counter.get());
    }

    public void loadState(long journalID, HornetQBuffer buffer) {
        IDCounterEncoding encoding = new IDCounterEncoding();
        encoding.decode(buffer);
        this.nextID = encoding.id;
        this.counter.set(this.nextID);
    }

    public long generateID() {
        long id = this.counter.getAndIncrement();
        if (id >= this.nextID) {
            this.saveCheckPoint(id);
        }
        return id;
    }

    public long getCurrentID() {
        return this.counter.get();
    }

    private synchronized void saveCheckPoint(long id) {
        if (id >= this.nextID) {
            this.nextID += this.checkpointSize;
            this.storeID(this.counter.incrementAndGet(), this.nextID);
        }
    }

    private void storeID(long journalID, long id) {
        try {
            this.storageManager.storeID(journalID, id);
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.batchingIdError(e);
        }
    }

    public static EncodingSupport createIDEncodingSupport(long id) {
        return new IDCounterEncoding(id);
    }

    protected static final class IDCounterEncoding
    implements EncodingSupport {
        private long id;

        public String toString() {
            return "IDCounterEncoding [id=" + this.id + "]";
        }

        private IDCounterEncoding(long id) {
            this.id = id;
        }

        IDCounterEncoding() {
        }

        public void decode(HornetQBuffer buffer) {
            this.id = buffer.readLong();
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.id);
        }

        public int getEncodeSize() {
            return 8;
        }
    }
}

