/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.protocol.stomp.FrameEventListener;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.StompDecoder;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompProtocolManager;
import org.hornetq.core.protocol.stomp.StompSession;
import org.hornetq.core.protocol.stomp.StompSubscription;
import org.hornetq.core.protocol.stomp.StompVersions;
import org.hornetq.core.protocol.stomp.VersionedStompFrameHandler;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.utils.ConfigurationHelper;

public class StompConnection
implements RemotingConnection {
    protected static final String CONNECTION_ID_PROP = "__HQ_CID";
    private final StompProtocolManager manager;
    private final Connection transportConnection;
    private String login;
    private String passcode;
    private String clientID;
    private boolean valid;
    private boolean destroyed = false;
    private final long creationTime;
    private final StompDecoder decoder;
    private final Acceptor acceptorUsed;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private final Object failLock = new Object();
    private volatile boolean dataReceived;
    private final boolean enableMessageID;
    private StompVersions version;
    private VersionedStompFrameHandler frameHandler;
    private boolean initialized;
    private FrameEventListener stompListener;
    private final Object sendLock = new Object();

    public StompDecoder getDecoder() {
        return this.decoder;
    }

    StompConnection(Acceptor acceptorUsed, Connection transportConnection, StompProtocolManager manager) {
        this.transportConnection = transportConnection;
        this.manager = manager;
        this.decoder = new StompDecoder(this);
        this.creationTime = System.currentTimeMillis();
        this.acceptorUsed = acceptorUsed;
        this.enableMessageID = ConfigurationHelper.getBooleanProperty((String)"stomp-enable-message-id", (boolean)false, acceptorUsed.getConfiguration());
    }

    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    public void setDataReceived() {
        this.dataReceived = true;
    }

    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer((int)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
        }
        this.destroyed = true;
        this.internalClose();
        object = this.sendLock;
        synchronized (object) {
            this.callClosingListeners();
        }
    }

    Acceptor getAcceptorUsed() {
        return this.acceptorUsed;
    }

    private void internalClose() {
        this.transportConnection.close();
        this.manager.cleanup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(HornetQException me) {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        HornetQServerLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.internalClose();
    }

    public void flush() {
    }

    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    public Object getID() {
        return this.transportConnection.getID();
    }

    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        this.manager.handleBuffer(this, buffer);
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    private void callFailureListeners(HornetQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public void negotiateVersion(StompFrame frame) throws HornetQStompException {
        String acceptVersion = frame.getHeader("accept-version");
        if (acceptVersion == null) {
            this.version = StompVersions.V1_0;
        } else {
            HashSet<String> requestVersions = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(acceptVersion, ",");
            while (tokenizer.hasMoreTokens()) {
                requestVersions.add(tokenizer.nextToken());
            }
            if (requestVersions.contains("1.1")) {
                this.version = StompVersions.V1_1;
            } else if (requestVersions.contains("1.0")) {
                this.version = StompVersions.V1_0;
            } else {
                HornetQStompException error = new HornetQStompException("Stomp versions not supported: " + acceptVersion);
                error.addHeader("version", acceptVersion);
                error.addHeader("content-type", "text/plain");
                error.setBody("Supported protocol version are " + this.manager.getSupportedVersionsAsString());
                error.setDisconnect(true);
                throw error;
            }
        }
        this.frameHandler = VersionedStompFrameHandler.getHandler(this, this.version);
        this.initialized = true;
    }

    public void setHost(String host) throws HornetQStompException {
        if (host == null) {
            HornetQStompException error = new HornetQStompException("Header host is null");
            error.setBody("Cannot accept null as host");
            throw error;
        }
        String localHost = this.manager.getVirtualHostName();
        if (!host.equals(localHost)) {
            HornetQStompException error = new HornetQStompException("Header host doesn't match server host");
            error.setBody("host " + host + " doesn't match server host name");
            throw error;
        }
    }

    public void handleFrame(StompFrame request) {
        StompFrame reply = null;
        if (this.stompListener != null) {
            this.stompListener.requestAccepted(request);
        }
        String cmd = request.getCommand();
        try {
            if (this.isDestroyed()) {
                throw new HornetQStompException("Connection was destroyed.");
            }
            if (!this.initialized) {
                if (!"CONNECT".equals(cmd) && !"STOMP".equals(cmd)) {
                    throw new HornetQStompException("Connection hasn't been established.");
                }
                this.negotiateVersion(request);
            }
            reply = this.frameHandler.handleFrame(request);
        }
        catch (HornetQStompException e) {
            reply = e.getFrame();
        }
        if (reply != null) {
            this.sendFrame(reply);
        }
        if ("DISCONNECT".equals(cmd)) {
            this.disconnect(false);
        }
    }

    public void sendFrame(StompFrame frame) {
        this.manager.sendReply(this, frame);
    }

    public boolean validateUser(String login, String passcode) {
        this.valid = this.manager.validateUser(login, passcode);
        if (this.valid) {
            this.login = login;
            this.passcode = passcode;
        }
        return this.valid;
    }

    public ServerMessageImpl createServerMessage() {
        return this.manager.createServerMessage();
    }

    public StompSession getSession(String txID) throws HornetQStompException {
        StompSession session = null;
        try {
            session = txID == null ? this.manager.getSession(this) : this.manager.getTransactedSession(this, txID);
        }
        catch (Exception e) {
            throw new HornetQStompException("Exception getting session", e);
        }
        return session;
    }

    public void validate() throws HornetQStompException {
        if (!this.valid) {
            throw new HornetQStompException("Connection is not valid.");
        }
    }

    public void sendServerMessage(ServerMessageImpl message, String txID) throws HornetQStompException {
        StompSession stompSession = this.getSession(txID);
        if (stompSession.isNoLocal()) {
            message.putStringProperty(CONNECTION_ID_PROP, this.getID().toString());
        }
        try {
            stompSession.sendInternal(message, true);
        }
        catch (Exception e) {
            throw new HornetQStompException("Error sending message " + message, e);
        }
    }

    public void disconnect(boolean criticalError) {
        this.destroy();
    }

    public void beginTransaction(String txID) throws HornetQStompException {
        try {
            this.manager.beginTransaction(this, txID);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HornetQStompException("Error beginning a transaction: " + txID, e);
        }
    }

    public void commitTransaction(String txID) throws HornetQStompException {
        try {
            this.manager.commitTransaction(this, txID);
        }
        catch (Exception e) {
            throw new HornetQStompException("Error committing " + txID, e);
        }
    }

    public void abortTransaction(String txID) throws HornetQStompException {
        try {
            this.manager.abortTransaction(this, txID);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HornetQStompException("Error aborting " + txID, e);
        }
    }

    public void subscribe(String destination, String selector, String ack, String id, String durableSubscriptionName, boolean noLocal) throws HornetQStompException {
        if (noLocal) {
            String noLocalFilter = "__HQ_CID <> '" + this.getID().toString() + "'";
            selector = selector == null ? noLocalFilter : selector + " AND " + noLocalFilter;
        }
        if (ack == null) {
            ack = "auto";
        }
        String subscriptionID = null;
        if (id != null) {
            subscriptionID = id;
        } else {
            if (destination == null) {
                throw new HornetQStompException("Client must set destination or id header to a SUBSCRIBE command");
            }
            subscriptionID = "subscription/" + destination;
        }
        try {
            this.manager.createSubscription(this, subscriptionID, durableSubscriptionName, destination, selector, ack, noLocal);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HornetQStompException("Error creating subscription " + subscriptionID, e);
        }
    }

    public void unsubscribe(String subscriptionID) throws HornetQStompException {
        try {
            this.manager.unsubscribe(this, subscriptionID);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HornetQStompException("Error unsubscripting " + subscriptionID, e);
        }
    }

    public void acknowledge(String messageID, String subscriptionID) throws HornetQStompException {
        try {
            this.manager.acknowledge(this, messageID, subscriptionID);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HornetQStompException("Error acknowledging message " + messageID, e);
        }
    }

    public String getVersion() {
        return String.valueOf((Object)this.version);
    }

    public String getHornetQServerName() {
        return "HornetQ/2.2.5 HornetQ Messaging Engine";
    }

    public StompFrame createStompMessage(ServerMessage serverMessage, StompSubscription subscription, int deliveryCount) throws Exception {
        return this.frameHandler.createMessageFrame(serverMessage, subscription, deliveryCount);
    }

    public void addStompEventListener(FrameEventListener listener) {
        this.stompListener = listener;
    }

    public void ping(StompFrame pingFrame) {
        this.manager.sendReply(this, pingFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalSend(StompFrame frame) throws Exception {
        HornetQBuffer buffer = frame.toHornetQBuffer();
        Object object = this.sendLock;
        synchronized (object) {
            this.getTransportConnection().write(buffer, false, false);
        }
        if (this.stompListener != null) {
            this.stompListener.replySent(frame);
        }
    }

    public VersionedStompFrameHandler getFrameHandler() {
        return this.frameHandler;
    }

    public boolean enableMessageID() {
        return this.enableMessageID;
    }
}

