/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp.v11;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.stomp.FrameEventListener;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.SimpleBytes;
import org.hornetq.core.protocol.stomp.Stomp;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompDecoder;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.VersionedStompFrameHandler;
import org.hornetq.core.protocol.stomp.v11.StompFrameV11;
import org.hornetq.core.server.HornetQServerLogger;

public class StompFrameHandlerV11
extends VersionedStompFrameHandler
implements FrameEventListener {
    private static final char ESC_CHAR = '\\';
    private HeartBeater heartBeater;

    public StompFrameHandlerV11(StompConnection connection) {
        this.connection = connection;
        connection.addStompEventListener(this);
    }

    @Override
    public StompFrame onConnect(StompFrame frame) {
        StompFrame response = null;
        Map<String, String> headers = frame.getHeadersMap();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientID = headers.get("client-id");
        String requestID = headers.get("request-id");
        try {
            if (this.connection.validateUser(login, passcode)) {
                String heartBeat;
                this.connection.setClientID(clientID);
                this.connection.setValid(true);
                response = new StompFrameV11("CONNECTED");
                response.addHeader("version", this.connection.getVersion());
                response.addHeader("session", this.connection.getID().toString());
                response.addHeader("server", this.connection.getHornetQServerName());
                if (requestID != null) {
                    response.addHeader("response-id", requestID);
                }
                if ((heartBeat = headers.get(Stomp.Headers.Connect.HEART_BEAT)) != null) {
                    this.handleHeartBeat(heartBeat);
                    if (this.heartBeater == null) {
                        response.addHeader("heart-beat", "0,0");
                    } else {
                        response.addHeader("heart-beat", this.heartBeater.getServerHeartBeatValue());
                    }
                }
            } else {
                response = new StompFrame("ERROR", true);
                response.addHeader("version", "1.0,1.1");
                response.setBody("Supported protocol versions are 1.0 and 1.1");
            }
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        catch (UnsupportedEncodingException e) {
            response = new HornetQStompException("Encoding error.", e).getFrame();
        }
        return response;
    }

    private void handleHeartBeat(String heartBeatHeader) throws HornetQStompException {
        String[] params = heartBeatHeader.split(",");
        if (params.length != 2) {
            throw new HornetQStompException("Incorrect heartbeat header " + heartBeatHeader);
        }
        long minPingInterval = Long.valueOf(params[0]);
        long minAcceptInterval = Long.valueOf(params[1]);
        if (minPingInterval != 0L || minAcceptInterval != 0L) {
            this.heartBeater = new HeartBeater(minPingInterval, minAcceptInterval);
        }
    }

    @Override
    public StompFrame onDisconnect(StompFrame frame) {
        if (this.heartBeater != null) {
            this.heartBeater.shutdown();
            try {
                this.heartBeater.join();
            }
            catch (InterruptedException e) {
                HornetQServerLogger.LOGGER.errorOnStompHeartBeat(e);
            }
        }
        return null;
    }

    @Override
    public StompFrame onUnsubscribe(StompFrame request) {
        StompFrame response = null;
        String id = request.getHeader("id");
        String subscriptionID = null;
        if (id == null) {
            response = new HornetQStompException("Must specify the subscription's id").getFrame();
            return response;
        }
        subscriptionID = id;
        try {
            this.connection.unsubscribe(subscriptionID);
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onAck(StompFrame request) {
        StompFrame response = null;
        String messageID = request.getHeader("message-id");
        String txID = request.getHeader("transaction");
        String subscriptionID = request.getHeader("subscription");
        if (txID != null) {
            HornetQServerLogger.LOGGER.stompTXAckNorSupported();
        }
        if (subscriptionID == null) {
            response = new HornetQStompException("subscription header is required").getFrame();
            return response;
        }
        try {
            this.connection.acknowledge(messageID, subscriptionID);
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onStomp(StompFrame request) {
        if (!this.connection.isValid()) {
            return this.onConnect(request);
        }
        return null;
    }

    @Override
    public StompFrame onNack(StompFrame request) {
        return this.onAck(request);
    }

    @Override
    public void replySent(StompFrame reply) {
        if (reply.getCommand().equals("CONNECTED")) {
            this.startHeartBeat();
        }
        if (reply.needsDisconnect()) {
            this.connection.disconnect(false);
        } else if (this.heartBeater != null) {
            this.heartBeater.pinged();
        }
    }

    private void startHeartBeat() {
        if (this.heartBeater != null) {
            this.heartBeater.start();
        }
    }

    public StompFrame createPingFrame() throws UnsupportedEncodingException {
        StompFrame frame = new StompFrame("STOMP");
        frame.setPing(true);
        return frame;
    }

    @Override
    public void requestAccepted(StompFrame request) {
        if (this.heartBeater != null) {
            this.heartBeater.pingAccepted();
        }
    }

    @Override
    public StompFrame createStompFrame(String command) {
        return new StompFrameV11(command);
    }

    @Override
    public StompFrame decode(StompDecoder decoder, HornetQBuffer buffer) throws HornetQStompException {
        byte[] content;
        block69: {
            block68: {
                block67: {
                    int readable = buffer.readableBytes();
                    if (decoder.data + readable >= decoder.workingBuffer.length) {
                        decoder.resizeWorking(decoder.data + readable);
                    }
                    buffer.readBytes(decoder.workingBuffer, decoder.data, readable);
                    decoder.data += readable;
                    if (decoder.command == null) {
                        int offset = 0;
                        while (decoder.workingBuffer[offset] == 10) {
                            if (this.heartBeater != null) {
                                this.heartBeater.pingAccepted();
                            }
                            if (++offset < decoder.data) continue;
                            decoder.data = 0;
                            return null;
                        }
                        if (decoder.data < 4) {
                            return null;
                        }
                        byte b = decoder.workingBuffer[offset];
                        switch (b) {
                            case 65: {
                                if (decoder.workingBuffer[offset + 1] == 66) {
                                    if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_ABORT_LENGTH + 1)) {
                                        return null;
                                    }
                                    decoder.command = "ABORT";
                                    break;
                                }
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_ACK_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "ACK";
                                break;
                            }
                            case 66: {
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_BEGIN_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "BEGIN";
                                break;
                            }
                            case 67: {
                                if (decoder.workingBuffer[offset + 2] == 77) {
                                    if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_COMMIT_LENGTH + 1)) {
                                        return null;
                                    }
                                    decoder.command = "COMMIT";
                                    break;
                                }
                                if (decoder.workingBuffer[offset + 7] == 69) {
                                    if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_CONNECTED_LENGTH + 1)) {
                                        return null;
                                    }
                                    decoder.command = "CONNECTED";
                                    break;
                                }
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_CONNECT_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "CONNECT";
                                break;
                            }
                            case 68: {
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_DISCONNECT_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "DISCONNECT";
                                break;
                            }
                            case 82: {
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_RECEIPT_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "RECEIPT";
                                break;
                            }
                            case 69: {
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_ERROR_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "ERROR";
                                break;
                            }
                            case 77: {
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_MESSAGE_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "MESSAGE";
                                break;
                            }
                            case 83: {
                                if (decoder.workingBuffer[offset + 1] == 69) {
                                    if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_SEND_LENGTH + 1)) {
                                        return null;
                                    }
                                    decoder.command = "SEND";
                                    break;
                                }
                                if (decoder.workingBuffer[offset + 1] == 85) {
                                    if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_SUBSCRIBE_LENGTH + 1)) {
                                        return null;
                                    }
                                    decoder.command = "SUBSCRIBE";
                                    break;
                                }
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_STOMP_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "STOMP";
                                break;
                            }
                            case 85: {
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_UNSUBSCRIBE_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "UNSUBSCRIBE";
                                break;
                            }
                            case 78: {
                                if (!decoder.tryIncrement(offset + StompDecoder.COMMAND_NACK_LENGTH + 1)) {
                                    return null;
                                }
                                decoder.command = "NACK";
                                break;
                            }
                            default: {
                                decoder.throwInvalid();
                            }
                        }
                        if (decoder.workingBuffer[decoder.pos - 1] != 10) {
                            decoder.throwInvalid();
                        }
                    }
                    if (decoder.readingHeaders) {
                        if (decoder.headerBytesCopyStart == -1) {
                            decoder.headerBytesCopyStart = decoder.pos;
                        }
                        boolean isEscaping = false;
                        SimpleBytes holder = new SimpleBytes(1024);
                        do {
                            byte b = decoder.workingBuffer[decoder.pos++];
                            switch (b) {
                                case 92: {
                                    if (isEscaping) {
                                        holder.append(b);
                                        isEscaping = false;
                                        break;
                                    }
                                    isEscaping = true;
                                    break;
                                }
                                case 58: {
                                    if (isEscaping) {
                                        holder.append(b);
                                        isEscaping = false;
                                    } else if (decoder.inHeaderName) {
                                        try {
                                            decoder.headerName = holder.getString();
                                        }
                                        catch (UnsupportedEncodingException e) {
                                            throw new HornetQStompException("Encoding exception", e);
                                        }
                                        holder.reset();
                                        decoder.inHeaderName = false;
                                        decoder.headerBytesCopyStart = decoder.pos;
                                        decoder.headerValueWhitespace = true;
                                    }
                                    decoder.whiteSpaceOnly = false;
                                    break;
                                }
                                case 110: {
                                    if (isEscaping) {
                                        holder.append((byte)10);
                                        isEscaping = false;
                                        break;
                                    }
                                    holder.append(b);
                                    break;
                                }
                                case 10: {
                                    String headerValue;
                                    if (decoder.whiteSpaceOnly) {
                                        decoder.readingHeaders = false;
                                        break block67;
                                    }
                                    try {
                                        headerValue = holder.getString();
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        throw new HornetQStompException("Encoding exception.", e);
                                    }
                                    holder.reset();
                                    decoder.headers.put(decoder.headerName, headerValue);
                                    if (decoder.headerName.equals("content-length")) {
                                        decoder.contentLength = Integer.parseInt(headerValue);
                                    }
                                    if (decoder.headerName.equals("content-type")) {
                                        decoder.contentType = headerValue;
                                    }
                                    decoder.whiteSpaceOnly = true;
                                    decoder.headerBytesCopyStart = decoder.pos;
                                    decoder.inHeaderName = true;
                                    decoder.headerValueWhitespace = false;
                                    break;
                                }
                                default: {
                                    decoder.whiteSpaceOnly = false;
                                    decoder.headerValueWhitespace = false;
                                    holder.append(b);
                                }
                            }
                        } while (decoder.pos != decoder.data);
                        return null;
                    }
                }
                content = null;
                if (decoder.contentLength == -1) break block68;
                if (decoder.pos + decoder.contentLength + 1 > decoder.data) break block69;
                content = new byte[decoder.contentLength];
                System.arraycopy(decoder.workingBuffer, decoder.pos, content, 0, decoder.contentLength);
                decoder.pos += decoder.contentLength;
                if (decoder.bodyStart == -1) {
                    decoder.bodyStart = decoder.pos;
                }
                while (decoder.pos < decoder.data && decoder.workingBuffer[decoder.pos++] != 0) {
                }
                break block69;
            }
            if (decoder.bodyStart == -1) {
                decoder.bodyStart = decoder.pos;
            }
            while (decoder.pos < decoder.data) {
                if (decoder.workingBuffer[decoder.pos++] != 0) continue;
                content = new byte[decoder.pos - decoder.bodyStart - 1];
                System.arraycopy(decoder.workingBuffer, decoder.bodyStart, content, 0, content.length);
                break;
            }
        }
        if (content != null) {
            if (decoder.data > decoder.pos) {
                if (decoder.workingBuffer[decoder.pos] == 10) {
                    ++decoder.pos;
                }
                if (decoder.data > decoder.pos) {
                    System.arraycopy(decoder.workingBuffer, decoder.pos, decoder.workingBuffer, 0, decoder.data - decoder.pos);
                }
            }
            decoder.data -= decoder.pos;
            StompFrameV11 ret = new StompFrameV11(decoder.command, decoder.headers, content);
            decoder.init();
            return ret;
        }
        return null;
    }

    private class HeartBeater
    extends Thread {
        private static final int MIN_SERVER_PING = 500;
        private static final int MIN_CLIENT_PING = 500;
        long serverPing = 0L;
        long serverAcceptPing = 0L;
        volatile boolean shutdown = false;
        AtomicLong lastPingTime = new AtomicLong(0L);
        AtomicLong lastAccepted = new AtomicLong(0L);
        StompFrame pingFrame;

        public HeartBeater(long clientPing, long clientAcceptPing) {
            if (clientPing != 0L) {
                long l = this.serverAcceptPing = clientPing > 500L ? clientPing : 500L;
            }
            if (clientAcceptPing != 0L) {
                this.serverPing = clientAcceptPing > 500L ? clientAcceptPing : 500L;
            }
        }

        public synchronized void shutdown() {
            this.shutdown = true;
            this.notify();
        }

        public String getServerHeartBeatValue() {
            return String.valueOf(this.serverPing) + "," + String.valueOf(this.serverAcceptPing);
        }

        public void pinged() {
            this.lastPingTime.set(System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.lastAccepted.set(System.currentTimeMillis());
            try {
                this.pingFrame = StompFrameHandlerV11.this.createPingFrame();
            }
            catch (UnsupportedEncodingException e1) {
                HornetQServerLogger.LOGGER.errorOnStompPingFrame(e1);
            }
            HeartBeater heartBeater = this;
            synchronized (heartBeater) {
                while (!this.shutdown) {
                    long dur1 = 0L;
                    long dur2 = 0L;
                    if (this.serverPing != 0L && (dur1 = System.currentTimeMillis() - this.lastPingTime.get()) >= this.serverPing) {
                        this.lastPingTime.set(System.currentTimeMillis());
                        StompFrameHandlerV11.this.connection.ping(this.pingFrame);
                        dur1 = 0L;
                    }
                    if (this.serverAcceptPing != 0L && (dur2 = System.currentTimeMillis() - this.lastAccepted.get()) > 2L * this.serverAcceptPing) {
                        StompFrameHandlerV11.this.connection.disconnect(false);
                        this.shutdown = true;
                        return;
                    }
                    long waitTime1 = 0L;
                    long waitTime2 = 0L;
                    if (this.serverPing > 0L) {
                        waitTime1 = this.serverPing - dur1;
                    }
                    if (this.serverAcceptPing > 0L) {
                        waitTime2 = this.serverAcceptPing * 2L - dur2;
                    }
                    long waitTime = 10L;
                    if (waitTime1 > 0L && waitTime2 > 0L) {
                        waitTime = Math.min(waitTime1, waitTime2);
                    } else if (waitTime1 > 0L) {
                        waitTime = waitTime1;
                    } else if (waitTime2 > 0L) {
                        waitTime = waitTime2;
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {}
                }
                return;
            }
        }

        public void pingAccepted() {
            this.lastAccepted.set(System.currentTimeMillis());
        }
    }
}

