/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp.v10;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.hornetq.core.protocol.stomp.FrameEventListener;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompDecoder;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.VersionedStompFrameHandler;
import org.hornetq.core.protocol.stomp.v10.StompFrameV10;
import org.hornetq.core.server.HornetQServerLogger;

public class StompFrameHandlerV10
extends VersionedStompFrameHandler
implements FrameEventListener {
    public StompFrameHandlerV10(StompConnection connection) {
        super(connection);
        this.decoder = new StompDecoder();
        this.decoder.init();
        connection.addStompEventListener(this);
    }

    @Override
    public StompFrame onConnect(StompFrame frame) {
        StompFrameV10 response = null;
        Map<String, String> headers = frame.getHeadersMap();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientID = headers.get("client-id");
        String requestID = headers.get("request-id");
        if (this.connection.validateUser(login, passcode)) {
            this.connection.setClientID(clientID);
            this.connection.setValid(true);
            response = new StompFrameV10("CONNECTED");
            if (frame.hasHeader("accept-version")) {
                response.addHeader("version", "1.0");
            }
            response.addHeader("session", this.connection.getID().toString());
            if (requestID != null) {
                response.addHeader("response-id", requestID);
            }
        } else {
            response = new StompFrameV10("ERROR");
            response.addHeader("message", "Failed to connect");
            try {
                response.setBody("The login account is not valid.");
            }
            catch (UnsupportedEncodingException e) {
                HornetQServerLogger.LOGGER.errorEncodingStompPacket(e);
            }
        }
        return response;
    }

    @Override
    public StompFrame onDisconnect(StompFrame frame) {
        return null;
    }

    @Override
    public StompFrame onUnsubscribe(StompFrame request) {
        StompFrame response = null;
        String destination = request.getHeader("destination");
        String id = request.getHeader("id");
        String durableSubscriberName = request.getHeader("durable-subscriber-name");
        String subscriptionID = null;
        if (id != null) {
            subscriptionID = id;
        } else {
            if (destination == null) {
                response = new HornetQStompException("Must specify the subscription's id or the destination you are unsubscribing from").getFrame();
                return response;
            }
            subscriptionID = "subscription/" + destination;
        }
        try {
            this.connection.unsubscribe(subscriptionID, durableSubscriberName);
        }
        catch (HornetQStompException e) {
            return e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onAck(StompFrame request) {
        StompFrame response = null;
        String messageID = request.getHeader("message-id");
        String txID = request.getHeader("transaction");
        if (txID != null) {
            HornetQServerLogger.LOGGER.stompTXAckNorSupported();
        }
        try {
            this.connection.acknowledge(messageID, null);
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onStomp(StompFrame request) {
        return this.onUnknown(request.getCommand());
    }

    @Override
    public StompFrame onNack(StompFrame request) {
        return this.onUnknown(request.getCommand());
    }

    @Override
    public StompFrame createStompFrame(String command) {
        return new StompFrameV10(command);
    }

    @Override
    public void replySent(StompFrame reply) {
        if (reply.needsDisconnect()) {
            this.connection.destroy();
        }
    }

    @Override
    public void requestAccepted(StompFrame request) {
    }
}

