/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.LiveNodeLocator;
import org.hornetq.spi.core.protocol.RemotingConnection;

final class ReplicationError
implements Interceptor {
    private final HornetQServer server;
    private LiveNodeLocator nodeLocator;

    public ReplicationError(HornetQServer server, LiveNodeLocator nodeLocator) {
        this.server = server;
        this.nodeLocator = nodeLocator;
    }

    public boolean intercept(Packet packet, RemotingConnection connection) throws HornetQException {
        if (packet.getType() != 116) {
            return true;
        }
        BackupReplicationStartFailedMessage message = (BackupReplicationStartFailedMessage)packet;
        switch (message.getRegistrationProblem()) {
            case ALREADY_REPLICATING: {
                this.tryNext();
                break;
            }
            case AUTHENTICATION: {
                this.failed();
                break;
            }
            case EXCEPTION: {
                this.failed();
                break;
            }
            default: {
                this.failed();
            }
        }
        return false;
    }

    private void failed() throws HornetQInternalErrorException {
        HornetQServerLogger.LOGGER.errorRegisteringBackup();
        this.nodeLocator.notifyRegistrationFailed(false);
    }

    private void tryNext() {
        this.nodeLocator.notifyRegistrationFailed(true);
    }
}

