/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompSession;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationListener;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUIDGenerator;

class StompProtocolManager
implements ProtocolManager,
NotificationListener {
    private final HornetQServer server;
    private final Executor executor;
    private final Map<String, StompSession> transactedSessions = new HashMap<String, StompSession>();
    private final Map<Object, StompSession> sessions = new HashMap<Object, StompSession>();
    private final Set<String> destinations = new ConcurrentHashSet();

    public StompProtocolManager(HornetQServer server, List<Interceptor> interceptors) {
        this.server = server;
        this.executor = server.getExecutorFactory().getExecutor();
        ManagementService service = server.getManagementService();
        if (service != null) {
            this.destinations.add(service.getManagementAddress().toString());
            service.addNotificationListener(this);
        }
    }

    @Override
    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        Long ttl;
        StompConnection conn = new StompConnection(acceptorUsed, connection, this);
        String ttlStr = (String)acceptorUsed.getConfiguration().get("connection-ttl");
        Long l = ttl = ttlStr == null ? null : Long.valueOf(ttlStr);
        if (ttl != null) {
            if (ttl > 0L) {
                return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), ttl.longValue());
            }
            throw new IllegalStateException("Stomp Connection TTL cannot be negative : " + ttl);
        }
        ttl = this.server.getConfiguration().getConnectionTTLOverride();
        if (ttl != -1L) {
            return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), ttl.longValue());
        }
        return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), 60000L);
    }

    @Override
    public void removeHandler(String name) {
    }

    @Override
    public int isReadyToHandle(HornetQBuffer buffer) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBuffer(RemotingConnection connection, HornetQBuffer buffer) {
        StompConnection conn = (StompConnection)connection;
        conn.setDataReceived();
        do {
            StompFrame request;
            try {
                request = conn.decode(buffer);
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorDecodingPacket(e);
                return;
            }
            if (request == null) break;
            try {
                conn.handleFrame(request);
            }
            finally {
                this.server.getStorageManager().clearContext();
            }
        } while (conn.hasBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(StompConnection connection, StompFrame frame) {
        if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
            HornetQServerLogger.LOGGER.trace("sent " + frame);
        }
        StompConnection stompConnection = connection;
        synchronized (stompConnection) {
            if (connection.isDestroyed()) {
                HornetQServerLogger.LOGGER.connectionClosed(connection);
                return false;
            }
            try {
                connection.physicalSend(frame);
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorSendingFrame(e, frame);
                return false;
            }
            return true;
        }
    }

    public StompSession getSession(StompConnection connection) throws Exception {
        StompSession stompSession = this.sessions.get(connection.getID());
        if (stompSession == null) {
            stompSession = new StompSession(connection, this, this.server.getStorageManager().newContext(this.server.getExecutorFactory().getExecutor()));
            String name = UUIDGenerator.getInstance().generateStringUUID();
            ServerSession session = this.server.createSession(name, connection.getLogin(), connection.getPasscode(), 102400, connection, true, false, false, false, null, stompSession);
            stompSession.setServerSession(session);
            this.sessions.put(connection.getID(), stompSession);
        }
        this.server.getStorageManager().setContext(stompSession.getContext());
        return stompSession;
    }

    public StompSession getTransactedSession(StompConnection connection, String txID) throws Exception {
        StompSession stompSession = this.transactedSessions.get(txID);
        if (stompSession == null) {
            stompSession = new StompSession(connection, this, this.server.getStorageManager().newContext(this.executor));
            String name = UUIDGenerator.getInstance().generateStringUUID();
            ServerSession session = this.server.createSession(name, connection.getLogin(), connection.getPasscode(), 102400, connection, false, false, false, false, null, stompSession);
            stompSession.setServerSession(session);
            this.transactedSessions.put(txID, stompSession);
        }
        this.server.getStorageManager().setContext(stompSession.getContext());
        return stompSession;
    }

    public void cleanup(final StompConnection connection) {
        connection.setValid(false);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StompSession session = (StompSession)StompProtocolManager.this.sessions.remove(connection.getID());
                if (session != null) {
                    try {
                        session.getSession().rollback(true);
                        session.getSession().close(false);
                    }
                    catch (Exception e) {
                        HornetQServerLogger.LOGGER.errorCleaningStompConn(e);
                    }
                }
                Iterator iterator = StompProtocolManager.this.transactedSessions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (((StompSession)entry.getValue()).getConnection() != connection) continue;
                    ServerSession serverSession = ((StompSession)entry.getValue()).getSession();
                    try {
                        serverSession.rollback(true);
                        serverSession.close(false);
                    }
                    catch (Exception e) {
                        HornetQServerLogger.LOGGER.errorCleaningStompConn(e);
                    }
                    iterator.remove();
                }
            }
        });
    }

    public void sendReply(final StompConnection connection, final StompFrame frame) {
        this.server.getStorageManager().afterCompleteOperations(new IOAsyncTask(){

            public void onError(int errorCode, String errorMessage) {
                HornetQServerLogger.LOGGER.errorProcessingIOCallback(errorCode, errorMessage);
                HornetQStompException e = new HornetQStompException("Error sending reply", HornetQExceptionType.createException((int)errorCode, (String)errorMessage));
                StompFrame error = e.getFrame();
                StompProtocolManager.this.send(connection, error);
            }

            public void done() {
                StompProtocolManager.this.send(connection, frame);
            }
        });
    }

    public String getSupportedVersionsAsString() {
        return "v1.0 v1.1 v1.2";
    }

    public String getVirtualHostName() {
        return "hornetq";
    }

    public boolean validateUser(String login, String passcode) {
        boolean validated = true;
        HornetQSecurityManager sm = this.server.getSecurityManager();
        if (sm != null && this.server.getConfiguration().isSecurityEnabled()) {
            validated = sm.validateUser(login, passcode);
        }
        return validated;
    }

    public ServerMessageImpl createServerMessage() {
        return new ServerMessageImpl(this.server.getStorageManager().generateUniqueID(), 512);
    }

    public void commitTransaction(StompConnection connection, String txID) throws Exception {
        StompSession session = this.getTransactedSession(connection, txID);
        if (session == null) {
            throw new HornetQStompException("No transaction started: " + txID);
        }
        this.transactedSessions.remove(txID);
        session.getSession().commit();
    }

    public void abortTransaction(StompConnection connection, String txID) throws Exception {
        StompSession session = this.getTransactedSession(connection, txID);
        if (session == null) {
            throw new HornetQStompException("No transaction started: " + txID);
        }
        this.transactedSessions.remove(txID);
        session.getSession().rollback(false);
    }

    public void createSubscription(StompConnection connection, String subscriptionID, String durableSubscriptionName, String destination, String selector, String ack, boolean noLocal) throws Exception {
        StompSession stompSession = this.getSession(connection);
        stompSession.setNoLocal(noLocal);
        if (stompSession.containsSubscription(subscriptionID)) {
            throw new HornetQStompException("There already is a subscription for: " + subscriptionID + ". Either use unique subscription IDs or do not create multiple subscriptions for the same destination");
        }
        long consumerID = this.server.getStorageManager().generateUniqueID();
        String clientID = connection.getClientID() != null ? connection.getClientID() : null;
        stompSession.addSubscription(consumerID, subscriptionID, clientID, durableSubscriptionName, destination, selector, ack);
    }

    public void unsubscribe(StompConnection connection, String subscriptionID, String durableSubscriberName) throws Exception {
        StompSession stompSession = this.getSession(connection);
        boolean unsubscribed = stompSession.unsubscribe(subscriptionID, durableSubscriberName);
        if (!unsubscribed) {
            throw new HornetQStompException("Cannot unsubscribe as no subscription exists for id: " + subscriptionID);
        }
    }

    public void acknowledge(StompConnection connection, String messageID, String subscriptionID) throws Exception {
        StompSession stompSession = this.getSession(connection);
        stompSession.acknowledge(messageID, subscriptionID);
    }

    public void beginTransaction(StompConnection connection, String txID) throws Exception {
        HornetQServerLogger.LOGGER.stompBeginTX(txID);
        if (this.transactedSessions.containsKey(txID)) {
            HornetQServerLogger.LOGGER.stompErrorTXExists(txID);
            throw new HornetQStompException(connection, "Transaction already started: " + txID);
        }
        this.getTransactedSession(connection, txID);
    }

    public boolean destinationExists(String destination) {
        return this.destinations.contains(destination);
    }

    public void onNotification(Notification notification) {
        NotificationType type = notification.getType();
        TypedProperties props = notification.getProperties();
        switch (type) {
            case BINDING_ADDED: {
                if (!props.containsProperty(ManagementHelper.HDR_BINDING_TYPE)) {
                    throw HornetQMessageBundle.BUNDLE.bindingTypeNotSpecified();
                }
                Integer bindingType = props.getIntProperty(ManagementHelper.HDR_BINDING_TYPE);
                if (bindingType == 2) {
                    return;
                }
                SimpleString address = props.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
                this.destinations.add(address.toString());
                break;
            }
            case BINDING_REMOVED: {
                SimpleString address = props.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
                this.destinations.remove(address.toString());
                break;
            }
        }
    }
}

