/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.core.remoting.impl.invm.InVMAcceptor;
import org.hornetq.core.server.HornetQMessageBundle;

public final class InVMRegistry {
    public static final InVMRegistry instance = new InVMRegistry();
    private final ConcurrentMap<Integer, InVMAcceptor> acceptors = new ConcurrentHashMap<Integer, InVMAcceptor>();

    public void registerAcceptor(int id, InVMAcceptor acceptor) {
        if (this.acceptors.putIfAbsent(id, acceptor) != null) {
            throw HornetQMessageBundle.BUNDLE.acceptorExists(id);
        }
    }

    public void unregisterAcceptor(int id) {
        if (this.acceptors.remove(id) == null) {
            throw HornetQMessageBundle.BUNDLE.acceptorNotExists(id);
        }
    }

    public InVMAcceptor getAcceptor(int id) {
        return (InVMAcceptor)this.acceptors.get(id);
    }

    public void clear() {
        this.acceptors.clear();
    }

    public int size() {
        return this.acceptors.size();
    }
}

