/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.impl.ConnectorsService;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ExecutorFactory;

public interface HornetQServer
extends HornetQComponent {
    public void setIdentity(String var1);

    public String getIdentity();

    public String describe();

    public Configuration getConfiguration();

    public RemotingService getRemotingService();

    public StorageManager getStorageManager();

    public PagingManager getPagingManager();

    public ManagementService getManagementService();

    public HornetQSecurityManager getSecurityManager();

    public Version getVersion();

    public NodeManager getNodeManager();

    public HornetQServerControlImpl getHornetQServerControl();

    public void registerActivateCallback(ActivateCallback var1);

    public void unregisterActivateCallback(ActivateCallback var1);

    public ServerSession createSession(String var1, String var2, String var3, int var4, RemotingConnection var5, boolean var6, boolean var7, boolean var8, boolean var9, String var10, SessionCallback var11) throws Exception;

    public void removeSession(String var1) throws Exception;

    public Set<ServerSession> getSessions();

    public HierarchicalRepository<Set<Role>> getSecurityRepository();

    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository();

    public int getConnectionCount();

    public PostOffice getPostOffice();

    public QueueFactory getQueueFactory();

    public ResourceManager getResourceManager();

    public List<ServerSession> getSessions(String var1);

    public ServerSession lookupSession(String var1, String var2);

    public ClusterManager getClusterManager();

    public SimpleString getNodeID();

    public boolean isActive();

    public boolean waitForActivation(long var1, TimeUnit var3) throws InterruptedException;

    public boolean waitForBackupSync(long var1, TimeUnit var3) throws InterruptedException;

    public void createSharedQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4) throws Exception;

    public Queue createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public Queue deployQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public Queue locateQueue(SimpleString var1) throws Exception;

    public void destroyQueue(SimpleString var1) throws Exception;

    public void destroyQueue(SimpleString var1, ServerSession var2) throws Exception;

    public void destroyQueue(SimpleString var1, ServerSession var2, boolean var3) throws Exception;

    public String destroyConnectionWithSessionMetadata(String var1, String var2) throws Exception;

    public ScheduledExecutorService getScheduledPool();

    public ExecutorFactory getExecutorFactory();

    public void setGroupingHandler(GroupingHandler var1);

    public GroupingHandler getGroupingHandler();

    public ReplicationEndpoint getReplicationEndpoint();

    public ReplicationManager getReplicationManager();

    public void deployDivert(DivertConfiguration var1) throws Exception;

    public void destroyDivert(SimpleString var1) throws Exception;

    public ConnectorsService getConnectorsService();

    public void deployBridge(BridgeConfiguration var1) throws Exception;

    public void destroyBridge(String var1) throws Exception;

    public ServerSession getSessionByID(String var1);

    public void threadDump(String var1);

    public void stop(boolean var1) throws Exception;

    public void startReplication(CoreRemotingConnection var1, ClusterConnection var2, Pair<TransportConfiguration, TransportConfiguration> var3, boolean var4) throws HornetQException;
}

