/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.HAPolicyConfiguration;
import org.hornetq.core.config.ha.ReplicaPolicyConfiguration;
import org.hornetq.core.config.ha.ReplicatedPolicyConfiguration;
import org.hornetq.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.hornetq.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.settings.impl.AddressSettings;

public class ConfigurationImpl
implements Configuration {
    public static final JournalType DEFAULT_JOURNAL_TYPE = JournalType.ASYNCIO;
    private static final long serialVersionUID = 4077088945050267843L;
    private String name = "ConfigurationImpl::" + System.identityHashCode(this);
    protected boolean fileDeploymentEnabled = HornetQDefaultConfiguration.isDefaultFileDeploymentEnabled();
    private boolean persistenceEnabled = HornetQDefaultConfiguration.isDefaultPersistenceEnabled();
    protected long fileDeploymentScanPeriod = HornetQDefaultConfiguration.getDefaultFileDeployerScanPeriod();
    private boolean persistDeliveryCountBeforeDelivery = HornetQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery();
    private int scheduledThreadPoolMaxSize = HornetQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize();
    private int threadPoolMaxSize = HornetQDefaultConfiguration.getDefaultThreadPoolMaxSize();
    private long securityInvalidationInterval = HornetQDefaultConfiguration.getDefaultSecurityInvalidationInterval();
    private boolean securityEnabled = HornetQDefaultConfiguration.isDefaultSecurityEnabled();
    protected boolean jmxManagementEnabled = HornetQDefaultConfiguration.isDefaultJmxManagementEnabled();
    protected String jmxDomain = HornetQDefaultConfiguration.getDefaultJmxDomain();
    protected long connectionTTLOverride = HornetQDefaultConfiguration.getDefaultConnectionTtlOverride();
    protected boolean asyncConnectionExecutionEnabled = HornetQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled();
    private long messageExpiryScanPeriod = HornetQDefaultConfiguration.getDefaultMessageExpiryScanPeriod();
    private int messageExpiryThreadPriority = HornetQDefaultConfiguration.getDefaultMessageExpiryThreadPriority();
    protected int idCacheSize = HornetQDefaultConfiguration.getDefaultIdCacheSize();
    private boolean persistIDCache = HornetQDefaultConfiguration.isDefaultPersistIdCache();
    private List<String> incomingInterceptorClassNames = new ArrayList<String>();
    private List<String> outgoingInterceptorClassNames = new ArrayList<String>();
    protected Map<String, TransportConfiguration> connectorConfigs = new HashMap<String, TransportConfiguration>();
    private Set<TransportConfiguration> acceptorConfigs = new HashSet<TransportConfiguration>();
    protected List<BridgeConfiguration> bridgeConfigurations = new ArrayList<BridgeConfiguration>();
    protected List<DivertConfiguration> divertConfigurations = new ArrayList<DivertConfiguration>();
    protected List<ClusterConnectionConfiguration> clusterConfigurations = new ArrayList<ClusterConnectionConfiguration>();
    private List<CoreQueueConfiguration> queueConfigurations = new ArrayList<CoreQueueConfiguration>();
    protected List<BroadcastGroupConfiguration> broadcastGroupConfigurations = new ArrayList<BroadcastGroupConfiguration>();
    protected Map<String, DiscoveryGroupConfiguration> discoveryGroupConfigurations = new LinkedHashMap<String, DiscoveryGroupConfiguration>();
    private String pagingDirectory = HornetQDefaultConfiguration.getDefaultPagingDir();
    private int maxConcurrentPageIO = HornetQDefaultConfiguration.getDefaultMaxConcurrentPageIo();
    protected String largeMessagesDirectory = HornetQDefaultConfiguration.getDefaultLargeMessagesDir();
    protected String bindingsDirectory = HornetQDefaultConfiguration.getDefaultBindingsDirectory();
    protected boolean createBindingsDir = HornetQDefaultConfiguration.isDefaultCreateBindingsDir();
    protected String journalDirectory = HornetQDefaultConfiguration.getDefaultJournalDir();
    protected boolean createJournalDir = HornetQDefaultConfiguration.isDefaultCreateJournalDir();
    public JournalType journalType = DEFAULT_JOURNAL_TYPE;
    protected boolean journalSyncTransactional = HornetQDefaultConfiguration.isDefaultJournalSyncTransactional();
    protected boolean journalSyncNonTransactional = HornetQDefaultConfiguration.isDefaultJournalSyncNonTransactional();
    protected int journalCompactMinFiles = HornetQDefaultConfiguration.getDefaultJournalCompactMinFiles();
    protected int journalCompactPercentage = HornetQDefaultConfiguration.getDefaultJournalCompactPercentage();
    protected int journalFileSize = HornetQDefaultConfiguration.getDefaultJournalFileSize();
    protected int journalMinFiles = HornetQDefaultConfiguration.getDefaultJournalMinFiles();
    protected int journalMaxIO_AIO = HornetQDefaultConfiguration.getDefaultJournalMaxIoAio();
    protected int journalBufferTimeout_AIO = HornetQDefaultConfiguration.getDefaultJournalBufferTimeoutAio();
    protected int journalBufferSize_AIO = HornetQDefaultConfiguration.getDefaultJournalBufferSizeAio();
    protected int journalMaxIO_NIO = HornetQDefaultConfiguration.getDefaultJournalMaxIoNio();
    protected int journalBufferTimeout_NIO = HornetQDefaultConfiguration.getDefaultJournalBufferTimeoutNio();
    protected int journalBufferSize_NIO = HornetQDefaultConfiguration.getDefaultJournalBufferSizeNio();
    protected boolean logJournalWriteRate = HornetQDefaultConfiguration.isDefaultJournalLogWriteRate();
    protected int journalPerfBlastPages = HornetQDefaultConfiguration.getDefaultJournalPerfBlastPages();
    protected boolean runSyncSpeedTest = HornetQDefaultConfiguration.isDefaultRunSyncSpeedTest();
    private boolean wildcardRoutingEnabled = HornetQDefaultConfiguration.isDefaultWildcardRoutingEnabled();
    private boolean messageCounterEnabled = HornetQDefaultConfiguration.isDefaultMessageCounterEnabled();
    private long messageCounterSamplePeriod = HornetQDefaultConfiguration.getDefaultMessageCounterSamplePeriod();
    private int messageCounterMaxDayHistory = HornetQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory();
    private long transactionTimeout = HornetQDefaultConfiguration.getDefaultTransactionTimeout();
    private long transactionTimeoutScanPeriod = HornetQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod();
    private SimpleString managementAddress = HornetQDefaultConfiguration.getDefaultManagementAddress();
    private SimpleString managementNotificationAddress = HornetQDefaultConfiguration.getDefaultManagementNotificationAddress();
    protected String clusterUser = HornetQDefaultConfiguration.getDefaultClusterUser();
    protected String clusterPassword = HornetQDefaultConfiguration.getDefaultClusterPassword();
    private long serverDumpInterval = HornetQDefaultConfiguration.getDefaultServerDumpInterval();
    protected boolean failoverOnServerShutdown = HornetQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private int memoryWarningThreshold = HornetQDefaultConfiguration.getDefaultMemoryWarningThreshold();
    private long memoryMeasureInterval = HornetQDefaultConfiguration.getDefaultMemoryMeasureInterval();
    protected GroupingHandlerConfiguration groupingHandlerConfiguration;
    private Map<String, AddressSettings> addressesSettings = new HashMap<String, AddressSettings>();
    private Map<String, Set<Role>> securitySettings = new HashMap<String, Set<Role>>();
    protected List<ConnectorServiceConfiguration> connectorServiceConfigurations = new ArrayList<ConnectorServiceConfiguration>();
    private boolean maskPassword = HornetQDefaultConfiguration.isDefaultMaskPassword();
    private transient String passwordCodec;
    private boolean resolveProtocols = HornetQDefaultConfiguration.isDefaultResolveProtocols();
    private long journalLockAcquisitionTimeout = HornetQDefaultConfiguration.getDefaultJournalLockAcquisitionTimeout();
    private HAPolicyConfiguration haPolicyConfiguration;

    @Override
    public boolean isClustered() {
        return !this.getClusterConfigurations().isEmpty();
    }

    @Override
    public boolean isFileDeploymentEnabled() {
        return this.fileDeploymentEnabled;
    }

    @Override
    public ConfigurationImpl setFileDeploymentEnabled(boolean enable) {
        this.fileDeploymentEnabled = enable;
        return this;
    }

    @Override
    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @Override
    public ConfigurationImpl setPersistenceEnabled(boolean enable) {
        this.persistenceEnabled = enable;
        return this;
    }

    @Override
    public long getFileDeployerScanPeriod() {
        return this.fileDeploymentScanPeriod;
    }

    @Override
    public ConfigurationImpl setFileDeployerScanPeriod(long period) {
        this.fileDeploymentScanPeriod = period;
        return this;
    }

    @Override
    public boolean isPersistDeliveryCountBeforeDelivery() {
        return this.persistDeliveryCountBeforeDelivery;
    }

    @Override
    public ConfigurationImpl setPersistDeliveryCountBeforeDelivery(boolean persistDeliveryCountBeforeDelivery) {
        this.persistDeliveryCountBeforeDelivery = persistDeliveryCountBeforeDelivery;
        return this;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public ConfigurationImpl setScheduledThreadPoolMaxSize(int maxSize) {
        this.scheduledThreadPoolMaxSize = maxSize;
        return this;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public ConfigurationImpl setThreadPoolMaxSize(int maxSize) {
        this.threadPoolMaxSize = maxSize;
        return this;
    }

    @Override
    public long getSecurityInvalidationInterval() {
        return this.securityInvalidationInterval;
    }

    @Override
    public ConfigurationImpl setSecurityInvalidationInterval(long interval) {
        this.securityInvalidationInterval = interval;
        return this;
    }

    @Override
    public long getConnectionTTLOverride() {
        return this.connectionTTLOverride;
    }

    @Override
    public ConfigurationImpl setConnectionTTLOverride(long ttl) {
        this.connectionTTLOverride = ttl;
        return this;
    }

    @Override
    public boolean isAsyncConnectionExecutionEnabled() {
        return this.asyncConnectionExecutionEnabled;
    }

    @Override
    public ConfigurationImpl setEnabledAsyncConnectionExecution(boolean enabled) {
        this.asyncConnectionExecutionEnabled = enabled;
        return this;
    }

    @Override
    @Deprecated
    public List<String> getInterceptorClassNames() {
        return this.getIncomingInterceptorClassNames();
    }

    @Override
    @Deprecated
    public ConfigurationImpl setInterceptorClassNames(List<String> interceptors) {
        this.setIncomingInterceptorClassNames((List)interceptors);
        return this;
    }

    @Override
    public List<String> getIncomingInterceptorClassNames() {
        return this.incomingInterceptorClassNames;
    }

    @Override
    public ConfigurationImpl setIncomingInterceptorClassNames(List<String> interceptors) {
        this.incomingInterceptorClassNames = interceptors;
        return this;
    }

    @Override
    public List<String> getOutgoingInterceptorClassNames() {
        return this.outgoingInterceptorClassNames;
    }

    @Override
    public ConfigurationImpl setOutgoingInterceptorClassNames(List<String> interceptors) {
        this.outgoingInterceptorClassNames = interceptors;
        return this;
    }

    @Override
    public Set<TransportConfiguration> getAcceptorConfigurations() {
        return this.acceptorConfigs;
    }

    @Override
    public ConfigurationImpl setAcceptorConfigurations(Set<TransportConfiguration> infos) {
        this.acceptorConfigs = infos;
        return this;
    }

    @Override
    public ConfigurationImpl addAcceptorConfiguration(TransportConfiguration infos) {
        this.acceptorConfigs.add(infos);
        return this;
    }

    @Override
    public ConfigurationImpl clearAcceptorConfigurations() {
        this.acceptorConfigs.clear();
        return this;
    }

    @Override
    public Map<String, TransportConfiguration> getConnectorConfigurations() {
        return this.connectorConfigs;
    }

    @Override
    public ConfigurationImpl setConnectorConfigurations(Map<String, TransportConfiguration> infos) {
        this.connectorConfigs = infos;
        return this;
    }

    @Override
    public ConfigurationImpl addConnectorConfiguration(String key, TransportConfiguration info) {
        this.connectorConfigs.put(key, info);
        return this;
    }

    @Override
    public GroupingHandlerConfiguration getGroupingHandlerConfiguration() {
        return this.groupingHandlerConfiguration;
    }

    @Override
    public ConfigurationImpl setGroupingHandlerConfiguration(GroupingHandlerConfiguration groupingHandlerConfiguration) {
        this.groupingHandlerConfiguration = groupingHandlerConfiguration;
        return this;
    }

    @Override
    public List<BridgeConfiguration> getBridgeConfigurations() {
        return this.bridgeConfigurations;
    }

    @Override
    public ConfigurationImpl setBridgeConfigurations(List<BridgeConfiguration> configs) {
        this.bridgeConfigurations = configs;
        return this;
    }

    public ConfigurationImpl addBridgeConfiguration(BridgeConfiguration config) {
        this.bridgeConfigurations.add(config);
        return this;
    }

    @Override
    public List<BroadcastGroupConfiguration> getBroadcastGroupConfigurations() {
        return this.broadcastGroupConfigurations;
    }

    @Override
    public ConfigurationImpl setBroadcastGroupConfigurations(List<BroadcastGroupConfiguration> configs) {
        this.broadcastGroupConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addBroadcastGroupConfiguration(BroadcastGroupConfiguration config) {
        this.broadcastGroupConfigurations.add(config);
        return this;
    }

    @Override
    public List<ClusterConnectionConfiguration> getClusterConfigurations() {
        return this.clusterConfigurations;
    }

    @Override
    public ConfigurationImpl setClusterConfigurations(List<ClusterConnectionConfiguration> configs) {
        this.clusterConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addClusterConfiguration(ClusterConnectionConfiguration config) {
        this.clusterConfigurations.add(config);
        return this;
    }

    @Override
    public ConfigurationImpl clearClusterConfigurations() {
        this.clusterConfigurations.clear();
        return this;
    }

    @Override
    public List<DivertConfiguration> getDivertConfigurations() {
        return this.divertConfigurations;
    }

    @Override
    public ConfigurationImpl setDivertConfigurations(List<DivertConfiguration> configs) {
        this.divertConfigurations = configs;
        return this;
    }

    public ConfigurationImpl addDivertConfiguration(DivertConfiguration config) {
        this.divertConfigurations.add(config);
        return this;
    }

    @Override
    public List<CoreQueueConfiguration> getQueueConfigurations() {
        return this.queueConfigurations;
    }

    @Override
    public ConfigurationImpl setQueueConfigurations(List<CoreQueueConfiguration> configs) {
        this.queueConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addQueueConfiguration(CoreQueueConfiguration config) {
        this.queueConfigurations.add(config);
        return this;
    }

    @Override
    public Map<String, DiscoveryGroupConfiguration> getDiscoveryGroupConfigurations() {
        return this.discoveryGroupConfigurations;
    }

    @Override
    public ConfigurationImpl setDiscoveryGroupConfigurations(Map<String, DiscoveryGroupConfiguration> discoveryGroupConfigurations) {
        this.discoveryGroupConfigurations = discoveryGroupConfigurations;
        return this;
    }

    @Override
    public ConfigurationImpl addDiscoveryGroupConfiguration(String key, DiscoveryGroupConfiguration discoveryGroupConfiguration) {
        this.discoveryGroupConfigurations.put(key, discoveryGroupConfiguration);
        return this;
    }

    @Override
    public int getIDCacheSize() {
        return this.idCacheSize;
    }

    @Override
    public ConfigurationImpl setIDCacheSize(int idCacheSize) {
        this.idCacheSize = idCacheSize;
        return this;
    }

    @Override
    public boolean isPersistIDCache() {
        return this.persistIDCache;
    }

    @Override
    public ConfigurationImpl setPersistIDCache(boolean persist) {
        this.persistIDCache = persist;
        return this;
    }

    @Override
    public String getBindingsDirectory() {
        return this.bindingsDirectory;
    }

    @Override
    public ConfigurationImpl setBindingsDirectory(String dir) {
        this.bindingsDirectory = dir;
        return this;
    }

    @Override
    public int getPageMaxConcurrentIO() {
        return this.maxConcurrentPageIO;
    }

    @Override
    public ConfigurationImpl setPageMaxConcurrentIO(int maxIO) {
        this.maxConcurrentPageIO = maxIO;
        return this;
    }

    @Override
    public String getJournalDirectory() {
        return this.journalDirectory;
    }

    @Override
    public ConfigurationImpl setJournalDirectory(String dir) {
        this.journalDirectory = dir;
        return this;
    }

    @Override
    public JournalType getJournalType() {
        return this.journalType;
    }

    @Override
    public ConfigurationImpl setPagingDirectory(String dir) {
        this.pagingDirectory = dir;
        return this;
    }

    @Override
    public String getPagingDirectory() {
        return this.pagingDirectory;
    }

    @Override
    public ConfigurationImpl setJournalType(JournalType type) {
        this.journalType = type;
        return this;
    }

    @Override
    public boolean isJournalSyncTransactional() {
        return this.journalSyncTransactional;
    }

    @Override
    public ConfigurationImpl setJournalSyncTransactional(boolean sync) {
        this.journalSyncTransactional = sync;
        return this;
    }

    @Override
    public boolean isJournalSyncNonTransactional() {
        return this.journalSyncNonTransactional;
    }

    @Override
    public ConfigurationImpl setJournalSyncNonTransactional(boolean sync) {
        this.journalSyncNonTransactional = sync;
        return this;
    }

    @Override
    public int getJournalFileSize() {
        return this.journalFileSize;
    }

    @Override
    public ConfigurationImpl setJournalFileSize(int size) {
        this.journalFileSize = size;
        return this;
    }

    @Override
    public int getJournalMinFiles() {
        return this.journalMinFiles;
    }

    @Override
    public ConfigurationImpl setJournalMinFiles(int files) {
        this.journalMinFiles = files;
        return this;
    }

    @Override
    public boolean isLogJournalWriteRate() {
        return this.logJournalWriteRate;
    }

    @Override
    public ConfigurationImpl setLogJournalWriteRate(boolean logJournalWriteRate) {
        this.logJournalWriteRate = logJournalWriteRate;
        return this;
    }

    @Override
    public int getJournalPerfBlastPages() {
        return this.journalPerfBlastPages;
    }

    @Override
    public ConfigurationImpl setJournalPerfBlastPages(int journalPerfBlastPages) {
        this.journalPerfBlastPages = journalPerfBlastPages;
        return this;
    }

    @Override
    public boolean isRunSyncSpeedTest() {
        return this.runSyncSpeedTest;
    }

    @Override
    public ConfigurationImpl setRunSyncSpeedTest(boolean run) {
        this.runSyncSpeedTest = run;
        return this;
    }

    @Override
    public boolean isCreateBindingsDir() {
        return this.createBindingsDir;
    }

    @Override
    public ConfigurationImpl setCreateBindingsDir(boolean create) {
        this.createBindingsDir = create;
        return this;
    }

    @Override
    public boolean isCreateJournalDir() {
        return this.createJournalDir;
    }

    @Override
    public ConfigurationImpl setCreateJournalDir(boolean create) {
        this.createJournalDir = create;
        return this;
    }

    @Override
    public boolean isWildcardRoutingEnabled() {
        return this.wildcardRoutingEnabled;
    }

    @Override
    public ConfigurationImpl setWildcardRoutingEnabled(boolean enabled) {
        this.wildcardRoutingEnabled = enabled;
        return this;
    }

    @Override
    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public ConfigurationImpl setTransactionTimeout(long timeout) {
        this.transactionTimeout = timeout;
        return this;
    }

    @Override
    public long getTransactionTimeoutScanPeriod() {
        return this.transactionTimeoutScanPeriod;
    }

    @Override
    public ConfigurationImpl setTransactionTimeoutScanPeriod(long period) {
        this.transactionTimeoutScanPeriod = period;
        return this;
    }

    @Override
    public long getMessageExpiryScanPeriod() {
        return this.messageExpiryScanPeriod;
    }

    @Override
    public ConfigurationImpl setMessageExpiryScanPeriod(long messageExpiryScanPeriod) {
        this.messageExpiryScanPeriod = messageExpiryScanPeriod;
        return this;
    }

    @Override
    public int getMessageExpiryThreadPriority() {
        return this.messageExpiryThreadPriority;
    }

    @Override
    public ConfigurationImpl setMessageExpiryThreadPriority(int messageExpiryThreadPriority) {
        this.messageExpiryThreadPriority = messageExpiryThreadPriority;
        return this;
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public ConfigurationImpl setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
        return this;
    }

    @Override
    public boolean isJMXManagementEnabled() {
        return this.jmxManagementEnabled;
    }

    @Override
    public ConfigurationImpl setJMXManagementEnabled(boolean enabled) {
        this.jmxManagementEnabled = enabled;
        return this;
    }

    @Override
    public String getJMXDomain() {
        return this.jmxDomain;
    }

    @Override
    public ConfigurationImpl setJMXDomain(String domain) {
        this.jmxDomain = domain;
        return this;
    }

    @Override
    public String getLargeMessagesDirectory() {
        return this.largeMessagesDirectory;
    }

    @Override
    public ConfigurationImpl setLargeMessagesDirectory(String directory) {
        this.largeMessagesDirectory = directory;
        return this;
    }

    @Override
    public boolean isMessageCounterEnabled() {
        return this.messageCounterEnabled;
    }

    @Override
    public ConfigurationImpl setMessageCounterEnabled(boolean enabled) {
        this.messageCounterEnabled = enabled;
        return this;
    }

    @Override
    public long getMessageCounterSamplePeriod() {
        return this.messageCounterSamplePeriod;
    }

    @Override
    public ConfigurationImpl setMessageCounterSamplePeriod(long period) {
        this.messageCounterSamplePeriod = period;
        return this;
    }

    @Override
    public int getMessageCounterMaxDayHistory() {
        return this.messageCounterMaxDayHistory;
    }

    @Override
    public ConfigurationImpl setMessageCounterMaxDayHistory(int maxDayHistory) {
        this.messageCounterMaxDayHistory = maxDayHistory;
        return this;
    }

    @Override
    public SimpleString getManagementAddress() {
        return this.managementAddress;
    }

    @Override
    public ConfigurationImpl setManagementAddress(SimpleString address) {
        this.managementAddress = address;
        return this;
    }

    @Override
    public SimpleString getManagementNotificationAddress() {
        return this.managementNotificationAddress;
    }

    @Override
    public ConfigurationImpl setManagementNotificationAddress(SimpleString address) {
        this.managementNotificationAddress = address;
        return this;
    }

    @Override
    public String getClusterUser() {
        return this.clusterUser;
    }

    @Override
    public ConfigurationImpl setClusterUser(String user) {
        this.clusterUser = user;
        return this;
    }

    @Override
    public String getClusterPassword() {
        return this.clusterPassword;
    }

    @Override
    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    @Override
    public ConfigurationImpl setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        return this;
    }

    @Override
    public ConfigurationImpl setClusterPassword(String theclusterPassword) {
        this.clusterPassword = theclusterPassword;
        return this;
    }

    @Override
    public int getJournalCompactMinFiles() {
        return this.journalCompactMinFiles;
    }

    @Override
    public int getJournalCompactPercentage() {
        return this.journalCompactPercentage;
    }

    @Override
    public ConfigurationImpl setJournalCompactMinFiles(int minFiles) {
        this.journalCompactMinFiles = minFiles;
        return this;
    }

    @Override
    public ConfigurationImpl setJournalCompactPercentage(int percentage) {
        this.journalCompactPercentage = percentage;
        return this;
    }

    @Override
    public long getServerDumpInterval() {
        return this.serverDumpInterval;
    }

    @Override
    public ConfigurationImpl setServerDumpInterval(long intervalInMilliseconds) {
        this.serverDumpInterval = intervalInMilliseconds;
        return this;
    }

    @Override
    public int getMemoryWarningThreshold() {
        return this.memoryWarningThreshold;
    }

    @Override
    public ConfigurationImpl setMemoryWarningThreshold(int memoryWarningThreshold) {
        this.memoryWarningThreshold = memoryWarningThreshold;
        return this;
    }

    @Override
    public long getMemoryMeasureInterval() {
        return this.memoryMeasureInterval;
    }

    @Override
    public ConfigurationImpl setMemoryMeasureInterval(long memoryMeasureInterval) {
        this.memoryMeasureInterval = memoryMeasureInterval;
        return this;
    }

    @Override
    public int getJournalMaxIO_AIO() {
        return this.journalMaxIO_AIO;
    }

    @Override
    public ConfigurationImpl setJournalMaxIO_AIO(int journalMaxIO) {
        this.journalMaxIO_AIO = journalMaxIO;
        return this;
    }

    @Override
    public int getJournalBufferTimeout_AIO() {
        return this.journalBufferTimeout_AIO;
    }

    @Override
    public ConfigurationImpl setJournalBufferTimeout_AIO(int journalBufferTimeout) {
        this.journalBufferTimeout_AIO = journalBufferTimeout;
        return this;
    }

    @Override
    public int getJournalBufferSize_AIO() {
        return this.journalBufferSize_AIO;
    }

    @Override
    public ConfigurationImpl setJournalBufferSize_AIO(int journalBufferSize) {
        this.journalBufferSize_AIO = journalBufferSize;
        return this;
    }

    @Override
    public int getJournalMaxIO_NIO() {
        return this.journalMaxIO_NIO;
    }

    @Override
    public ConfigurationImpl setJournalMaxIO_NIO(int journalMaxIO) {
        this.journalMaxIO_NIO = journalMaxIO;
        return this;
    }

    @Override
    public int getJournalBufferTimeout_NIO() {
        return this.journalBufferTimeout_NIO;
    }

    @Override
    public ConfigurationImpl setJournalBufferTimeout_NIO(int journalBufferTimeout) {
        this.journalBufferTimeout_NIO = journalBufferTimeout;
        return this;
    }

    @Override
    public int getJournalBufferSize_NIO() {
        return this.journalBufferSize_NIO;
    }

    @Override
    public ConfigurationImpl setJournalBufferSize_NIO(int journalBufferSize) {
        this.journalBufferSize_NIO = journalBufferSize;
        return this;
    }

    @Override
    public Map<String, AddressSettings> getAddressesSettings() {
        return this.addressesSettings;
    }

    @Override
    public ConfigurationImpl setAddressesSettings(Map<String, AddressSettings> addressesSettings) {
        this.addressesSettings = addressesSettings;
        return this;
    }

    @Override
    public ConfigurationImpl addAddressesSetting(String key, AddressSettings addressesSetting) {
        this.addressesSettings.put(key, addressesSetting);
        return this;
    }

    @Override
    public Map<String, Set<Role>> getSecurityRoles() {
        return this.securitySettings;
    }

    @Override
    public ConfigurationImpl setSecurityRoles(Map<String, Set<Role>> securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    @Override
    public List<ConnectorServiceConfiguration> getConnectorServiceConfigurations() {
        return this.connectorServiceConfigurations;
    }

    @Override
    public boolean isCheckForLiveServer() {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            return ((ReplicatedPolicyConfiguration)this.haPolicyConfiguration).isCheckForLiveServer();
        }
        return false;
    }

    @Override
    public ConfigurationImpl setCheckForLiveServer(boolean checkForLiveServer) {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ((ReplicatedPolicyConfiguration)this.haPolicyConfiguration).setCheckForLiveServer(checkForLiveServer);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HornetQ Configuration (");
        sb.append("clustered=").append(this.isClustered()).append(",");
        sb.append("journalDirectory=").append(this.journalDirectory).append(",");
        sb.append("bindingsDirectory=").append(this.bindingsDirectory).append(",");
        sb.append("largeMessagesDirectory=").append(this.largeMessagesDirectory).append(",");
        sb.append("pagingDirectory=").append(this.pagingDirectory);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ConfigurationImpl setConnectorServiceConfigurations(List<ConnectorServiceConfiguration> configs) {
        this.connectorServiceConfigurations = configs;
        return this;
    }

    @Override
    public ConfigurationImpl addConnectorServiceConfiguration(ConnectorServiceConfiguration config) {
        this.connectorServiceConfigurations.add(config);
        return this;
    }

    @Override
    public boolean isMaskPassword() {
        return this.maskPassword;
    }

    @Override
    public ConfigurationImpl setMaskPassword(boolean maskPassword) {
        this.maskPassword = maskPassword;
        return this;
    }

    @Override
    public ConfigurationImpl setPasswordCodec(String codec) {
        this.passwordCodec = codec;
        return this;
    }

    @Override
    public String getPasswordCodec() {
        return this.passwordCodec;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigurationImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setBackup(boolean backup) {
        return this;
    }

    @Override
    @Deprecated
    public boolean isSharedStore() {
        return this.haPolicyConfiguration instanceof SharedStoreMasterPolicyConfiguration || this.haPolicyConfiguration instanceof SharedStoreSlavePolicyConfiguration;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setSharedStore(boolean sharedStore) {
        return this;
    }

    @Override
    @Deprecated
    public long getFailbackDelay() {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getFailbackDelay();
        }
        if (this.haPolicyConfiguration instanceof SharedStoreMasterPolicyConfiguration) {
            SharedStoreMasterPolicyConfiguration hapc = (SharedStoreMasterPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getFailbackDelay();
        }
        if (this.haPolicyConfiguration instanceof SharedStoreSlavePolicyConfiguration) {
            SharedStoreSlavePolicyConfiguration hapc = (SharedStoreSlavePolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getFailbackDelay();
        }
        return -1L;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setFailbackDelay(long failbackDelay) {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setFailbackDelay(failbackDelay);
        } else if (this.haPolicyConfiguration instanceof SharedStoreMasterPolicyConfiguration) {
            SharedStoreMasterPolicyConfiguration hapc = (SharedStoreMasterPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setFailbackDelay(failbackDelay);
        } else if (this.haPolicyConfiguration instanceof SharedStoreSlavePolicyConfiguration) {
            SharedStoreSlavePolicyConfiguration hapc = (SharedStoreSlavePolicyConfiguration)this.haPolicyConfiguration;
            hapc.setFailbackDelay(failbackDelay);
        }
        return this;
    }

    @Override
    @Deprecated
    public String getBackupGroupName() {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getGroupName();
        }
        if (this.haPolicyConfiguration instanceof ReplicatedPolicyConfiguration) {
            ReplicatedPolicyConfiguration hapc = (ReplicatedPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getGroupName();
        }
        return null;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setBackupGroupName(String nodeGroupName) {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setGroupName(nodeGroupName);
        } else if (this.haPolicyConfiguration instanceof ReplicatedPolicyConfiguration) {
            ReplicatedPolicyConfiguration hapc = (ReplicatedPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setGroupName(nodeGroupName);
        }
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setReplicationClustername(String clusterName) {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setClusterName(clusterName);
        } else if (this.haPolicyConfiguration instanceof ReplicatedPolicyConfiguration) {
            ReplicatedPolicyConfiguration hapc = (ReplicatedPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setClusterName(clusterName);
        }
        return this;
    }

    @Override
    @Deprecated
    public String getReplicationClustername() {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getClusterName();
        }
        if (this.haPolicyConfiguration instanceof ReplicatedPolicyConfiguration) {
            ReplicatedPolicyConfiguration hapc = (ReplicatedPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getClusterName();
        }
        return null;
    }

    @Override
    @Deprecated
    public ConfigurationImpl setMaxSavedReplicatedJournalSize(int maxSavedReplicatedJournalsSize) {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setMaxSavedReplicatedJournalsSize(maxSavedReplicatedJournalsSize);
        }
        return this;
    }

    @Override
    @Deprecated
    public int getMaxSavedReplicatedJournalsSize() {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.getMaxSavedReplicatedJournalsSize();
        }
        return -1;
    }

    @Override
    @Deprecated
    public boolean isAllowFailBack() {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            return hapc.isAllowFailBack();
        }
        if (this.haPolicyConfiguration instanceof SharedStoreSlavePolicyConfiguration) {
            SharedStoreSlavePolicyConfiguration hapc = (SharedStoreSlavePolicyConfiguration)this.haPolicyConfiguration;
            return hapc.isAllowFailBack();
        }
        return false;
    }

    @Deprecated
    public void setAllowFailBack(boolean allowAutoFailBack) {
        if (this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration) {
            ReplicaPolicyConfiguration hapc = (ReplicaPolicyConfiguration)this.haPolicyConfiguration;
            hapc.setAllowFailBack(allowAutoFailBack);
        } else if (this.haPolicyConfiguration instanceof SharedStoreSlavePolicyConfiguration) {
            SharedStoreSlavePolicyConfiguration hapc = (SharedStoreSlavePolicyConfiguration)this.haPolicyConfiguration;
            hapc.setAllowFailBack(allowAutoFailBack);
        }
    }

    @Override
    @Deprecated
    public boolean isBackup() {
        return this.haPolicyConfiguration instanceof ReplicaPolicyConfiguration || this.haPolicyConfiguration instanceof SharedStoreSlavePolicyConfiguration;
    }

    @Override
    public ConfigurationImpl setResolveProtocols(boolean resolveProtocols) {
        this.resolveProtocols = resolveProtocols;
        return this;
    }

    @Override
    public boolean isResolveProtocols() {
        return this.resolveProtocols;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acceptorConfigs == null ? 0 : this.acceptorConfigs.hashCode());
        result = 31 * result + (this.addressesSettings == null ? 0 : this.addressesSettings.hashCode());
        result = 31 * result + (this.asyncConnectionExecutionEnabled ? 1231 : 1237);
        result = 31 * result + (this.bindingsDirectory == null ? 0 : this.bindingsDirectory.hashCode());
        result = 31 * result + (this.bridgeConfigurations == null ? 0 : this.bridgeConfigurations.hashCode());
        result = 31 * result + (this.broadcastGroupConfigurations == null ? 0 : this.broadcastGroupConfigurations.hashCode());
        result = 31 * result + (this.clusterConfigurations == null ? 0 : this.clusterConfigurations.hashCode());
        result = 31 * result + (this.clusterPassword == null ? 0 : this.clusterPassword.hashCode());
        result = 31 * result + (this.clusterUser == null ? 0 : this.clusterUser.hashCode());
        result = 31 * result + (int)(this.connectionTTLOverride ^ this.connectionTTLOverride >>> 32);
        result = 31 * result + (this.connectorConfigs == null ? 0 : this.connectorConfigs.hashCode());
        result = 31 * result + (this.connectorServiceConfigurations == null ? 0 : this.connectorServiceConfigurations.hashCode());
        result = 31 * result + (this.createBindingsDir ? 1231 : 1237);
        result = 31 * result + (this.createJournalDir ? 1231 : 1237);
        result = 31 * result + (this.discoveryGroupConfigurations == null ? 0 : this.discoveryGroupConfigurations.hashCode());
        result = 31 * result + (this.divertConfigurations == null ? 0 : this.divertConfigurations.hashCode());
        result = 31 * result + (this.failoverOnServerShutdown ? 1231 : 1237);
        result = 31 * result + (this.fileDeploymentEnabled ? 1231 : 1237);
        result = 31 * result + (int)(this.fileDeploymentScanPeriod ^ this.fileDeploymentScanPeriod >>> 32);
        result = 31 * result + (this.groupingHandlerConfiguration == null ? 0 : this.groupingHandlerConfiguration.hashCode());
        result = 31 * result + this.idCacheSize;
        result = 31 * result + (this.incomingInterceptorClassNames == null ? 0 : this.incomingInterceptorClassNames.hashCode());
        result = 31 * result + (this.jmxDomain == null ? 0 : this.jmxDomain.hashCode());
        result = 31 * result + (this.jmxManagementEnabled ? 1231 : 1237);
        result = 31 * result + this.journalBufferSize_AIO;
        result = 31 * result + this.journalBufferSize_NIO;
        result = 31 * result + this.journalBufferTimeout_AIO;
        result = 31 * result + this.journalBufferTimeout_NIO;
        result = 31 * result + this.journalCompactMinFiles;
        result = 31 * result + this.journalCompactPercentage;
        result = 31 * result + (this.journalDirectory == null ? 0 : this.journalDirectory.hashCode());
        result = 31 * result + this.journalFileSize;
        result = 31 * result + this.journalMaxIO_AIO;
        result = 31 * result + this.journalMaxIO_NIO;
        result = 31 * result + this.journalMinFiles;
        result = 31 * result + this.journalPerfBlastPages;
        result = 31 * result + (this.journalSyncNonTransactional ? 1231 : 1237);
        result = 31 * result + (this.journalSyncTransactional ? 1231 : 1237);
        result = 31 * result + (this.journalType == null ? 0 : this.journalType.hashCode());
        result = 31 * result + (this.largeMessagesDirectory == null ? 0 : this.largeMessagesDirectory.hashCode());
        result = 31 * result + (this.logJournalWriteRate ? 1231 : 1237);
        result = 31 * result + (this.managementAddress == null ? 0 : this.managementAddress.hashCode());
        result = 31 * result + (this.managementNotificationAddress == null ? 0 : this.managementNotificationAddress.hashCode());
        result = 31 * result + (this.maskPassword ? 1231 : 1237);
        result = 31 * result + this.maxConcurrentPageIO;
        result = 31 * result + (int)(this.memoryMeasureInterval ^ this.memoryMeasureInterval >>> 32);
        result = 31 * result + this.memoryWarningThreshold;
        result = 31 * result + (this.messageCounterEnabled ? 1231 : 1237);
        result = 31 * result + this.messageCounterMaxDayHistory;
        result = 31 * result + (int)(this.messageCounterSamplePeriod ^ this.messageCounterSamplePeriod >>> 32);
        result = 31 * result + (int)(this.messageExpiryScanPeriod ^ this.messageExpiryScanPeriod >>> 32);
        result = 31 * result + this.messageExpiryThreadPriority;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.outgoingInterceptorClassNames == null ? 0 : this.outgoingInterceptorClassNames.hashCode());
        result = 31 * result + (this.pagingDirectory == null ? 0 : this.pagingDirectory.hashCode());
        result = 31 * result + (this.persistDeliveryCountBeforeDelivery ? 1231 : 1237);
        result = 31 * result + (this.persistIDCache ? 1231 : 1237);
        result = 31 * result + (this.persistenceEnabled ? 1231 : 1237);
        result = 31 * result + (this.queueConfigurations == null ? 0 : this.queueConfigurations.hashCode());
        result = 31 * result + (this.runSyncSpeedTest ? 1231 : 1237);
        result = 31 * result + this.scheduledThreadPoolMaxSize;
        result = 31 * result + (this.securityEnabled ? 1231 : 1237);
        result = 31 * result + (int)(this.securityInvalidationInterval ^ this.securityInvalidationInterval >>> 32);
        result = 31 * result + (this.securitySettings == null ? 0 : this.securitySettings.hashCode());
        result = 31 * result + (int)(this.serverDumpInterval ^ this.serverDumpInterval >>> 32);
        result = 31 * result + this.threadPoolMaxSize;
        result = 31 * result + (int)(this.transactionTimeout ^ this.transactionTimeout >>> 32);
        result = 31 * result + (int)(this.transactionTimeoutScanPeriod ^ this.transactionTimeoutScanPeriod >>> 32);
        result = 31 * result + (this.wildcardRoutingEnabled ? 1231 : 1237);
        result = 31 * result + (this.resolveProtocols ? 1231 : 1237);
        result = 31 * result + (int)(this.journalLockAcquisitionTimeout ^ this.journalLockAcquisitionTimeout >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationImpl)) {
            return false;
        }
        ConfigurationImpl other = (ConfigurationImpl)obj;
        if (this.acceptorConfigs == null ? other.acceptorConfigs != null : !this.acceptorConfigs.equals(other.acceptorConfigs)) {
            return false;
        }
        if (this.addressesSettings == null ? other.addressesSettings != null : !this.addressesSettings.equals(other.addressesSettings)) {
            return false;
        }
        if (this.asyncConnectionExecutionEnabled != other.asyncConnectionExecutionEnabled) {
            return false;
        }
        if (this.bindingsDirectory == null ? other.bindingsDirectory != null : !this.bindingsDirectory.equals(other.bindingsDirectory)) {
            return false;
        }
        if (this.bridgeConfigurations == null ? other.bridgeConfigurations != null : !this.bridgeConfigurations.equals(other.bridgeConfigurations)) {
            return false;
        }
        if (this.broadcastGroupConfigurations == null ? other.broadcastGroupConfigurations != null : !this.broadcastGroupConfigurations.equals(other.broadcastGroupConfigurations)) {
            return false;
        }
        if (this.clusterConfigurations == null ? other.clusterConfigurations != null : !this.clusterConfigurations.equals(other.clusterConfigurations)) {
            return false;
        }
        if (this.clusterPassword == null ? other.clusterPassword != null : !this.clusterPassword.equals(other.clusterPassword)) {
            return false;
        }
        if (this.clusterUser == null ? other.clusterUser != null : !this.clusterUser.equals(other.clusterUser)) {
            return false;
        }
        if (this.connectionTTLOverride != other.connectionTTLOverride) {
            return false;
        }
        if (this.connectorConfigs == null ? other.connectorConfigs != null : !this.connectorConfigs.equals(other.connectorConfigs)) {
            return false;
        }
        if (this.connectorServiceConfigurations == null ? other.connectorServiceConfigurations != null : !this.connectorServiceConfigurations.equals(other.connectorServiceConfigurations)) {
            return false;
        }
        if (this.createBindingsDir != other.createBindingsDir) {
            return false;
        }
        if (this.createJournalDir != other.createJournalDir) {
            return false;
        }
        if (this.discoveryGroupConfigurations == null ? other.discoveryGroupConfigurations != null : !this.discoveryGroupConfigurations.equals(other.discoveryGroupConfigurations)) {
            return false;
        }
        if (this.divertConfigurations == null ? other.divertConfigurations != null : !this.divertConfigurations.equals(other.divertConfigurations)) {
            return false;
        }
        if (this.failoverOnServerShutdown != other.failoverOnServerShutdown) {
            return false;
        }
        if (this.fileDeploymentEnabled != other.fileDeploymentEnabled) {
            return false;
        }
        if (this.fileDeploymentScanPeriod != other.fileDeploymentScanPeriod) {
            return false;
        }
        if (this.groupingHandlerConfiguration == null ? other.groupingHandlerConfiguration != null : !this.groupingHandlerConfiguration.equals(other.groupingHandlerConfiguration)) {
            return false;
        }
        if (this.idCacheSize != other.idCacheSize) {
            return false;
        }
        if (this.incomingInterceptorClassNames == null ? other.incomingInterceptorClassNames != null : !this.incomingInterceptorClassNames.equals(other.incomingInterceptorClassNames)) {
            return false;
        }
        if (this.jmxDomain == null ? other.jmxDomain != null : !this.jmxDomain.equals(other.jmxDomain)) {
            return false;
        }
        if (this.jmxManagementEnabled != other.jmxManagementEnabled) {
            return false;
        }
        if (this.journalBufferSize_AIO != other.journalBufferSize_AIO) {
            return false;
        }
        if (this.journalBufferSize_NIO != other.journalBufferSize_NIO) {
            return false;
        }
        if (this.journalBufferTimeout_AIO != other.journalBufferTimeout_AIO) {
            return false;
        }
        if (this.journalBufferTimeout_NIO != other.journalBufferTimeout_NIO) {
            return false;
        }
        if (this.journalCompactMinFiles != other.journalCompactMinFiles) {
            return false;
        }
        if (this.journalCompactPercentage != other.journalCompactPercentage) {
            return false;
        }
        if (this.journalDirectory == null ? other.journalDirectory != null : !this.journalDirectory.equals(other.journalDirectory)) {
            return false;
        }
        if (this.journalFileSize != other.journalFileSize) {
            return false;
        }
        if (this.journalMaxIO_AIO != other.journalMaxIO_AIO) {
            return false;
        }
        if (this.journalMaxIO_NIO != other.journalMaxIO_NIO) {
            return false;
        }
        if (this.journalMinFiles != other.journalMinFiles) {
            return false;
        }
        if (this.journalPerfBlastPages != other.journalPerfBlastPages) {
            return false;
        }
        if (this.journalSyncNonTransactional != other.journalSyncNonTransactional) {
            return false;
        }
        if (this.journalSyncTransactional != other.journalSyncTransactional) {
            return false;
        }
        if (this.journalType != other.journalType) {
            return false;
        }
        if (this.largeMessagesDirectory == null ? other.largeMessagesDirectory != null : !this.largeMessagesDirectory.equals(other.largeMessagesDirectory)) {
            return false;
        }
        if (this.logJournalWriteRate != other.logJournalWriteRate) {
            return false;
        }
        if (this.managementAddress == null ? other.managementAddress != null : !this.managementAddress.equals((Object)other.managementAddress)) {
            return false;
        }
        if (this.managementNotificationAddress == null ? other.managementNotificationAddress != null : !this.managementNotificationAddress.equals((Object)other.managementNotificationAddress)) {
            return false;
        }
        if (this.maskPassword != other.maskPassword) {
            return false;
        }
        if (this.maxConcurrentPageIO != other.maxConcurrentPageIO) {
            return false;
        }
        if (this.memoryMeasureInterval != other.memoryMeasureInterval) {
            return false;
        }
        if (this.memoryWarningThreshold != other.memoryWarningThreshold) {
            return false;
        }
        if (this.messageCounterEnabled != other.messageCounterEnabled) {
            return false;
        }
        if (this.messageCounterMaxDayHistory != other.messageCounterMaxDayHistory) {
            return false;
        }
        if (this.messageCounterSamplePeriod != other.messageCounterSamplePeriod) {
            return false;
        }
        if (this.messageExpiryScanPeriod != other.messageExpiryScanPeriod) {
            return false;
        }
        if (this.messageExpiryThreadPriority != other.messageExpiryThreadPriority) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.outgoingInterceptorClassNames == null ? other.outgoingInterceptorClassNames != null : !this.outgoingInterceptorClassNames.equals(other.outgoingInterceptorClassNames)) {
            return false;
        }
        if (this.pagingDirectory == null ? other.pagingDirectory != null : !this.pagingDirectory.equals(other.pagingDirectory)) {
            return false;
        }
        if (this.persistDeliveryCountBeforeDelivery != other.persistDeliveryCountBeforeDelivery) {
            return false;
        }
        if (this.persistIDCache != other.persistIDCache) {
            return false;
        }
        if (this.persistenceEnabled != other.persistenceEnabled) {
            return false;
        }
        if (this.queueConfigurations == null ? other.queueConfigurations != null : !this.queueConfigurations.equals(other.queueConfigurations)) {
            return false;
        }
        if (this.runSyncSpeedTest != other.runSyncSpeedTest) {
            return false;
        }
        if (this.scheduledThreadPoolMaxSize != other.scheduledThreadPoolMaxSize) {
            return false;
        }
        if (this.securityEnabled != other.securityEnabled) {
            return false;
        }
        if (this.securityInvalidationInterval != other.securityInvalidationInterval) {
            return false;
        }
        if (this.securitySettings == null ? other.securitySettings != null : !this.securitySettings.equals(other.securitySettings)) {
            return false;
        }
        if (this.serverDumpInterval != other.serverDumpInterval) {
            return false;
        }
        if (this.threadPoolMaxSize != other.threadPoolMaxSize) {
            return false;
        }
        if (this.transactionTimeout != other.transactionTimeout) {
            return false;
        }
        if (this.transactionTimeoutScanPeriod != other.transactionTimeoutScanPeriod) {
            return false;
        }
        if (this.wildcardRoutingEnabled != other.wildcardRoutingEnabled) {
            return false;
        }
        if (this.resolveProtocols != other.resolveProtocols) {
            return false;
        }
        return this.journalLockAcquisitionTimeout == other.journalLockAcquisitionTimeout;
    }

    @Override
    public Configuration copy() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(this);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        return (Configuration)ois.readObject();
    }

    @Override
    public ConfigurationImpl setJournalLockAcquisitionTimeout(long journalLockAcquisitionTimeout) {
        this.journalLockAcquisitionTimeout = journalLockAcquisitionTimeout;
        return this;
    }

    @Override
    public long getJournalLockAcquisitionTimeout() {
        return this.journalLockAcquisitionTimeout;
    }

    @Override
    public HAPolicyConfiguration getHAPolicyConfiguration() {
        return this.haPolicyConfiguration;
    }

    @Override
    public ConfigurationImpl setHAPolicyConfiguration(HAPolicyConfiguration haPolicyConfiguration) {
        this.haPolicyConfiguration = haPolicyConfiguration;
        return this;
    }
}

