/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.ServerSessionPacketHandler;
import org.hornetq.core.protocol.core.impl.CoreProtocolManager;
import org.hornetq.core.protocol.core.impl.CoreSessionCallback;
import org.hornetq.core.protocol.core.impl.wireformat.CheckFailoverMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CheckFailoverReplyMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.protocol.RemotingConnection;

public class HornetQPacketHandler
implements ChannelHandler {
    private final HornetQServer server;
    private final Channel channel1;
    private final CoreRemotingConnection connection;
    private final CoreProtocolManager protocolManager;

    public HornetQPacketHandler(CoreProtocolManager protocolManager, HornetQServer server, Channel channel1, CoreRemotingConnection connection) {
        this.protocolManager = protocolManager;
        this.server = server;
        this.channel1 = channel1;
        this.connection = connection;
    }

    public void handlePacket(Packet packet) {
        byte type = packet.getType();
        switch (type) {
            case 30: {
                CreateSessionMessage request = (CreateSessionMessage)packet;
                this.handleCreateSession(request);
                break;
            }
            case -4: {
                CheckFailoverMessage request = (CheckFailoverMessage)packet;
                this.handleCheckForFailover(request);
                break;
            }
            case 32: {
                ReattachSessionMessage request = (ReattachSessionMessage)packet;
                this.handleReattachSession(request);
                break;
            }
            case 34: {
                CreateQueueMessage request = (CreateQueueMessage)packet;
                this.handleCreateQueue(request);
                break;
            }
            default: {
                HornetQServerLogger.LOGGER.invalidPacket(packet);
            }
        }
    }

    private void handleCheckForFailover(CheckFailoverMessage failoverMessage) {
        String nodeID = failoverMessage.getNodeID();
        boolean okToFailover = nodeID == null || !this.server.getHAPolicy().canScaleDown() || this.server.hasScaledDown(new SimpleString(nodeID));
        this.channel1.send((Packet)new CheckFailoverReplyMessage(okToFailover));
    }

    private void handleCreateSession(CreateSessionMessage request) {
        HornetQExceptionMessage response;
        boolean incompatibleVersion = false;
        try {
            Version version = this.server.getVersion();
            if (!version.isCompatible(request.getVersion())) {
                throw HornetQMessageBundle.BUNDLE.incompatibleClientServer();
            }
            if (!this.server.isStarted()) {
                throw HornetQMessageBundle.BUNDLE.serverNotStarted();
            }
            if (this.connection.getClientVersion() == 0) {
                this.connection.setClientVersion(request.getVersion());
            } else if (this.connection.getClientVersion() != request.getVersion()) {
                HornetQServerLogger.LOGGER.incompatibleVersionAfterConnect(request.getVersion(), this.connection.getClientVersion());
            }
            Channel channel = this.connection.getChannel(request.getSessionChannelID(), request.getWindowSize());
            HornetQPrincipal hornetQPrincipal = null;
            if (request.getUsername() == null) {
                hornetQPrincipal = this.connection.getDefaultHornetQPrincipal();
            }
            ServerSession session = this.server.createSession(request.getName(), hornetQPrincipal == null ? request.getUsername() : hornetQPrincipal.getUserName(), hornetQPrincipal == null ? request.getPassword() : hornetQPrincipal.getPassword(), request.getMinLargeMessageSize(), (RemotingConnection)this.connection, request.isAutoCommitSends(), request.isAutoCommitAcks(), request.isPreAcknowledge(), request.isXA(), request.getDefaultAddress(), new CoreSessionCallback(request.getName(), this.protocolManager, channel), null);
            ServerSessionPacketHandler handler = new ServerSessionPacketHandler(session, this.server.getStorageManager(), channel);
            channel.setHandler((ChannelHandler)handler);
            this.protocolManager.addSessionHandler(request.getName(), handler);
            response = new CreateSessionResponseMessage(this.server.getVersion().getIncrementingVersion());
        }
        catch (HornetQException e) {
            if (e.getType() == HornetQExceptionType.INCOMPATIBLE_CLIENT_SERVER_VERSIONS) {
                incompatibleVersion = true;
                HornetQServerLogger.LOGGER.debug("Sending HornetQException after Incompatible client", e);
            } else {
                HornetQServerLogger.LOGGER.failedToCreateSession((Exception)((Object)e));
            }
            response = new HornetQExceptionMessage(e);
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.failedToCreateSession(e);
            response = new HornetQExceptionMessage((HornetQException)new HornetQInternalErrorException());
        }
        if (incompatibleVersion) {
            this.channel1.sendAndFlush((Packet)response);
        } else {
            this.channel1.send((Packet)response);
        }
    }

    private void handleReattachSession(ReattachSessionMessage request) {
        ReattachSessionResponseMessage response = null;
        try {
            if (!this.server.isStarted()) {
                response = new ReattachSessionResponseMessage(-1, false);
            }
            HornetQServerLogger.LOGGER.debug("Reattaching request from " + this.connection.getRemoteAddress());
            ServerSessionPacketHandler sessionHandler = this.protocolManager.getSessionHandler(request.getName());
            if (sessionHandler == null) {
                response = new ReattachSessionResponseMessage(-1, false);
            } else if (sessionHandler.getChannel().getConfirmationWindowSize() == -1) {
                HornetQServerLogger.LOGGER.reattachRequestFailed(this.connection.getRemoteAddress());
                sessionHandler.closeListeners();
                sessionHandler.close();
                response = new ReattachSessionResponseMessage(-1, false);
            } else {
                int serverLastConfirmedCommandID = sessionHandler.transferConnection(this.connection, request.getLastConfirmedCommandID());
                response = new ReattachSessionResponseMessage(serverLastConfirmedCommandID, true);
            }
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.failedToReattachSession(e);
            response = new HornetQExceptionMessage((HornetQException)new HornetQInternalErrorException());
        }
        this.channel1.send((Packet)response);
    }

    private void handleCreateQueue(CreateQueueMessage request) {
        try {
            this.server.createQueue(request.getAddress(), request.getQueueName(), request.getFilterString(), request.isDurable(), request.isTemporary());
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.failedToHandleCreateQueue(e);
        }
    }
}

