/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class NodeAnnounceMessage
extends PacketImpl {
    protected String nodeID;
    protected String backupGroupName;
    protected boolean backup;
    protected long currentEventID;
    protected TransportConfiguration connector;
    protected TransportConfiguration backupConnector;
    private String scaleDownGroupName;

    public NodeAnnounceMessage(long currentEventID, String nodeID, String backupGroupName, String scaleDownGroupName, boolean backup, TransportConfiguration tc, TransportConfiguration backupConnector) {
        super((byte)111);
        this.currentEventID = currentEventID;
        this.nodeID = nodeID;
        this.backupGroupName = backupGroupName;
        this.backup = backup;
        this.connector = tc;
        this.backupConnector = backupConnector;
        this.scaleDownGroupName = scaleDownGroupName;
    }

    public NodeAnnounceMessage() {
        super((byte)111);
    }

    public NodeAnnounceMessage(byte nodeAnnounceMessage_V2) {
        super(nodeAnnounceMessage_V2);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getBackupGroupName() {
        return this.backupGroupName;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public TransportConfiguration getConnector() {
        return this.connector;
    }

    public TransportConfiguration getBackupConnector() {
        return this.backupConnector;
    }

    public String getScaleDownGroupName() {
        return this.scaleDownGroupName;
    }

    public long getCurrentEventID() {
        return this.currentEventID;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeString(this.nodeID);
        buffer.writeNullableString(this.backupGroupName);
        buffer.writeBoolean(this.backup);
        buffer.writeLong(this.currentEventID);
        if (this.connector != null) {
            buffer.writeBoolean(true);
            this.connector.encode(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        if (this.backupConnector != null) {
            buffer.writeBoolean(true);
            this.backupConnector.encode(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeNullableString(this.scaleDownGroupName);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.nodeID = buffer.readString();
        this.backupGroupName = buffer.readNullableString();
        this.backup = buffer.readBoolean();
        this.currentEventID = buffer.readLong();
        if (buffer.readBoolean()) {
            this.connector = new TransportConfiguration();
            this.connector.decode(buffer);
        }
        if (buffer.readBoolean()) {
            this.backupConnector = new TransportConfiguration();
            this.backupConnector.decode(buffer);
        }
        this.scaleDownGroupName = buffer.readNullableString();
    }

    public String toString() {
        return "NodeAnnounceMessage [backup=" + this.backup + ", connector=" + this.connector + ", nodeID=" + this.nodeID + ", toString()=" + super.toString() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.backup ? 1231 : 1237);
        result = 31 * result + (this.backupConnector == null ? 0 : this.backupConnector.hashCode());
        result = 31 * result + (this.connector == null ? 0 : this.connector.hashCode());
        result = 31 * result + (int)(this.currentEventID ^ this.currentEventID >>> 32);
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + (this.scaleDownGroupName == null ? 0 : this.scaleDownGroupName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NodeAnnounceMessage)) {
            return false;
        }
        NodeAnnounceMessage other = (NodeAnnounceMessage)((Object)obj);
        if (this.backup != other.backup) {
            return false;
        }
        if (this.backupConnector == null ? other.backupConnector != null : !this.backupConnector.equals((Object)other.backupConnector)) {
            return false;
        }
        if (this.connector == null ? other.connector != null : !this.connector.equals((Object)other.connector)) {
            return false;
        }
        if (this.currentEventID != other.currentEventID) {
            return false;
        }
        if (this.nodeID == null) {
            if (other.nodeID != null) {
                return false;
            }
        } else {
            if (!this.nodeID.equals(other.nodeID)) {
                return false;
            }
            if (!this.scaleDownGroupName.equals(other.scaleDownGroupName)) {
                return false;
            }
        }
        return true;
    }
}

