/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.server.cluster.qourum.QuorumVoteHandler;
import org.hornetq.core.server.cluster.qourum.Vote;

public class QuorumVoteMessage
extends PacketImpl {
    private SimpleString handler;
    private Vote vote;
    private HornetQBuffer voteBuffer;

    public QuorumVoteMessage() {
        super((byte)-2);
    }

    public QuorumVoteMessage(SimpleString handler, Vote vote) {
        super((byte)-2);
        this.handler = handler;
        this.vote = vote;
    }

    public void encodeRest(HornetQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeSimpleString(this.handler);
        this.vote.encode(buffer);
    }

    public void decodeRest(HornetQBuffer buffer) {
        super.decodeRest(buffer);
        this.handler = buffer.readSimpleString();
        this.voteBuffer = buffer.readSlice(buffer.readableBytes());
    }

    public SimpleString getHandler() {
        return this.handler;
    }

    public Vote getVote() {
        return this.vote;
    }

    public void decode(QuorumVoteHandler voteHandler) {
        this.vote = voteHandler.decode(this.voteBuffer);
    }
}

