/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.ha;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.client.impl.TopologyMemberImpl;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.cluster.ClusterControl;
import org.hornetq.core.server.cluster.ClusterController;
import org.hornetq.core.server.cluster.ha.ColocatedPolicy;
import org.hornetq.core.server.cluster.ha.HAManager;

public class ColocatedHAManager
implements HAManager {
    private final ColocatedPolicy haPolicy;
    private final HornetQServer server;
    private Map<String, HornetQServer> backupServers = new HashMap<String, HornetQServer>();
    private boolean started;

    public ColocatedHAManager(ColocatedPolicy haPolicy, HornetQServer hornetQServer) {
        this.haPolicy = haPolicy;
        this.server = hornetQServer;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.server.getActivation().haStarted();
        this.started = true;
    }

    public void stop() {
        for (HornetQServer hornetQServer : this.backupServers.values()) {
            try {
                hornetQServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.backupServers.clear();
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized boolean activateBackup(int backupSize, String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory, SimpleString nodeID) throws Exception {
        if (this.backupServers.size() >= this.haPolicy.getMaxBackups() || backupSize != this.backupServers.size()) {
            return false;
        }
        if (this.haPolicy.getBackupPolicy().isSharedStore()) {
            return this.activateSharedStoreBackup(journalDirectory, bindingsDirectory, largeMessagesDirectory, pagingDirectory);
        }
        return this.activateReplicatedBackup(nodeID);
    }

    @Override
    public Map<String, HornetQServer> getBackupServers() {
        return this.backupServers;
    }

    public boolean requestBackup(Pair<TransportConfiguration, TransportConfiguration> connectorPair, int backupSize, boolean replicated) throws Exception {
        ClusterController clusterController = this.server.getClusterManager().getClusterController();
        try (ClusterControl clusterControl = clusterController.connectToNode((TransportConfiguration)connectorPair.getA());){
            clusterControl.authorize();
            if (replicated) {
                boolean bl = clusterControl.requestReplicatedBackup(backupSize, this.server.getNodeID());
                return bl;
            }
            boolean bl = clusterControl.requestSharedStoreBackup(backupSize, this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getLargeMessagesDirectory(), this.server.getConfiguration().getPagingDirectory());
            return bl;
        }
    }

    private synchronized boolean activateSharedStoreBackup(String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory) throws Exception {
        Configuration configuration = this.server.getConfiguration().copy();
        HornetQServer backup = this.server.createBackupServer(configuration);
        try {
            int portOffset = this.haPolicy.getBackupPortOffset() * (this.backupServers.size() + 1);
            String name = "colocated_backup_" + this.backupServers.size() + 1;
            this.haPolicy.getBackupPolicy().setRestartBackup(false);
            backup.setHAPolicy(this.haPolicy.getBackupPolicy());
            ColocatedHAManager.updateSharedStoreConfiguration(configuration, name, portOffset, this.haPolicy.getExcludedConnectors(), journalDirectory, bindingsDirectory, largeMessagesDirectory, pagingDirectory, this.haPolicy.getBackupPolicy().getScaleDownPolicy() == null);
            this.backupServers.put(configuration.getName(), backup);
            backup.start();
        }
        catch (Exception e) {
            backup.stop();
            HornetQServerLogger.LOGGER.activateSharedStoreSlaveFailed(e);
            return false;
        }
        HornetQServerLogger.LOGGER.activatingSharedStoreSlave();
        return true;
    }

    private synchronized boolean activateReplicatedBackup(SimpleString nodeID) throws Exception {
        Configuration configuration = this.server.getConfiguration().copy();
        HornetQServer backup = this.server.createBackupServer(configuration);
        try {
            TopologyMemberImpl member = this.server.getClusterManager().getDefaultConnection(null).getTopology().getMember(nodeID.toString());
            int portOffset = this.haPolicy.getBackupPortOffset() * (this.backupServers.size() + 1);
            String name = "colocated_backup_" + this.backupServers.size() + 1;
            this.haPolicy.getBackupPolicy().setRestartBackup(false);
            backup.setHAPolicy(this.haPolicy.getBackupPolicy());
            ColocatedHAManager.updateReplicatedConfiguration(configuration, name, portOffset, this.haPolicy.getExcludedConnectors(), this.haPolicy.getBackupPolicy().getScaleDownPolicy() == null);
            backup.addActivationParam("REPLICATION_ENDPOINT", member);
            this.backupServers.put(configuration.getName(), backup);
            backup.start();
        }
        catch (Exception e) {
            backup.stop();
            HornetQServerLogger.LOGGER.activateReplicatedBackupFailed(e);
            return false;
        }
        HornetQServerLogger.LOGGER.activatingReplica(nodeID);
        return true;
    }

    private static void updateSharedStoreConfiguration(Configuration backupConfiguration, String name, int portOffset, List<String> remoteConnectors, String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory, boolean fullServer) {
        backupConfiguration.setName(name);
        backupConfiguration.setJournalDirectory(journalDirectory);
        backupConfiguration.setBindingsDirectory(bindingsDirectory);
        backupConfiguration.setLargeMessagesDirectory(largeMessagesDirectory);
        backupConfiguration.setPagingDirectory(pagingDirectory);
        ColocatedHAManager.updateAcceptorsAndConnectors(backupConfiguration, portOffset, remoteConnectors, fullServer);
    }

    private static void updateReplicatedConfiguration(Configuration backupConfiguration, String name, int portOffset, List<String> remoteConnectors, boolean fullServer) {
        backupConfiguration.setName(name);
        backupConfiguration.setJournalDirectory(backupConfiguration.getJournalDirectory() + name);
        backupConfiguration.setPagingDirectory(backupConfiguration.getPagingDirectory() + name);
        backupConfiguration.setLargeMessagesDirectory(backupConfiguration.getLargeMessagesDirectory() + name);
        backupConfiguration.setBindingsDirectory(backupConfiguration.getBindingsDirectory() + name);
        ColocatedHAManager.updateAcceptorsAndConnectors(backupConfiguration, portOffset, remoteConnectors, fullServer);
    }

    private static void updateAcceptorsAndConnectors(Configuration backupConfiguration, int portOffset, List<String> remoteConnectors, boolean fullServer) {
        if (fullServer) {
            Set<TransportConfiguration> acceptors = backupConfiguration.getAcceptorConfigurations();
            for (TransportConfiguration acceptor : acceptors) {
                ColocatedHAManager.updatebackupParams(backupConfiguration.getName(), portOffset, acceptor.getParams());
            }
            Map<String, TransportConfiguration> connectorConfigurations = backupConfiguration.getConnectorConfigurations();
            for (Map.Entry<String, TransportConfiguration> entry : connectorConfigurations.entrySet()) {
                if (remoteConnectors.contains(entry.getValue().getName())) continue;
                ColocatedHAManager.updatebackupParams(backupConfiguration.getName(), portOffset, entry.getValue().getParams());
            }
        } else {
            backupConfiguration.getAcceptorConfigurations().clear();
        }
    }

    private static void updatebackupParams(String name, int portOffset, Map<String, Object> params) {
        if (params != null) {
            Object serverId;
            Object port = params.get("port");
            if (port != null) {
                Integer integer = Integer.valueOf(port.toString());
                integer = integer + portOffset;
                params.put("port", integer.toString());
            }
            if ((serverId = params.get("server-id")) != null) {
                params.put("server-id", serverId.toString() + "(" + name + ")");
            }
        }
    }
}

