/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.ha;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.core.server.cluster.ha.BackupPolicy;
import org.hornetq.core.server.cluster.ha.HAPolicy;
import org.hornetq.core.server.impl.ColocatedActivation;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.LiveActivation;

public class ColocatedPolicy
implements HAPolicy<LiveActivation> {
    private boolean requestBackup = HornetQDefaultConfiguration.isDefaultHapolicyRequestBackup();
    private int backupRequestRetries = HornetQDefaultConfiguration.getDefaultHapolicyBackupRequestRetries();
    private long backupRequestRetryInterval = HornetQDefaultConfiguration.getDefaultHapolicyBackupRequestRetryInterval();
    private int maxBackups = HornetQDefaultConfiguration.getDefaultHapolicyMaxBackups();
    private int backupPortOffset = HornetQDefaultConfiguration.getDefaultHapolicyBackupPortOffset();
    private List<String> excludedConnectors = new ArrayList<String>();
    private BackupPolicy backupPolicy;
    private HAPolicy<LiveActivation> livePolicy;

    public ColocatedPolicy(boolean requestBackup, int backupRequestRetries, long backupRequestRetryInterval, int maxBackups, int backupPortOffset, List<String> excludedConnectors, HAPolicy livePolicy, BackupPolicy backupPolicy) {
        this.requestBackup = requestBackup;
        this.backupRequestRetries = backupRequestRetries;
        this.backupRequestRetryInterval = backupRequestRetryInterval;
        this.maxBackups = maxBackups;
        this.backupPortOffset = backupPortOffset;
        this.excludedConnectors = excludedConnectors;
        this.livePolicy = livePolicy;
        this.backupPolicy = backupPolicy;
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    @Override
    public boolean isSharedStore() {
        return this.backupPolicy.isSharedStore();
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public LiveActivation createActivation(HornetQServerImpl server, boolean wasLive, Map<String, Object> activationParams, HornetQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO) throws Exception {
        return new ColocatedActivation(server, this, this.livePolicy.createActivation(server, wasLive, activationParams, shutdownOnCriticalIO));
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    public boolean isRequestBackup() {
        return this.requestBackup;
    }

    public void setRequestBackup(boolean requestBackup) {
        this.requestBackup = requestBackup;
    }

    public int getBackupRequestRetries() {
        return this.backupRequestRetries;
    }

    public void setBackupRequestRetries(int backupRequestRetries) {
        this.backupRequestRetries = backupRequestRetries;
    }

    public long getBackupRequestRetryInterval() {
        return this.backupRequestRetryInterval;
    }

    public void setBackupRequestRetryInterval(long backupRequestRetryInterval) {
        this.backupRequestRetryInterval = backupRequestRetryInterval;
    }

    public int getMaxBackups() {
        return this.maxBackups;
    }

    public void setMaxBackups(int maxBackups) {
        this.maxBackups = maxBackups;
    }

    public int getBackupPortOffset() {
        return this.backupPortOffset;
    }

    public void setBackupPortOffset(int backupPortOffset) {
        this.backupPortOffset = backupPortOffset;
    }

    public List<String> getExcludedConnectors() {
        return this.excludedConnectors;
    }

    public void setExcludedConnectors(List<String> excludedConnectors) {
        this.excludedConnectors = excludedConnectors;
    }

    public HAPolicy<LiveActivation> getLivePolicy() {
        return this.livePolicy;
    }

    public void setLivePolicy(HAPolicy<LiveActivation> livePolicy) {
        this.livePolicy = livePolicy;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }
}

