/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.ha;

import java.util.Map;
import org.hornetq.core.server.cluster.ha.HAPolicy;
import org.hornetq.core.server.cluster.ha.ScaleDownPolicy;
import org.hornetq.core.server.impl.Activation;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.LiveOnlyActivation;

public class LiveOnlyPolicy
implements HAPolicy<Activation> {
    private ScaleDownPolicy scaleDownPolicy;

    public LiveOnlyPolicy() {
    }

    public LiveOnlyPolicy(ScaleDownPolicy scaleDownPolicy) {
        this.scaleDownPolicy = scaleDownPolicy;
    }

    @Override
    public Activation createActivation(HornetQServerImpl server, boolean wasLive, Map<String, Object> activationParams, HornetQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO) {
        return new LiveOnlyActivation(server, this);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }

    @Override
    public String getScaleDownGroupName() {
        return this.scaleDownPolicy == null ? null : this.scaleDownPolicy.getGroupName();
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    public ScaleDownPolicy getScaleDownPolicy() {
        return this.scaleDownPolicy;
    }

    public void setScaleDownPolicy(ScaleDownPolicy scaleDownPolicy) {
        this.scaleDownPolicy = scaleDownPolicy;
    }
}

