/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.List;
import java.util.Map;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.cluster.ClusterController;
import org.hornetq.core.server.cluster.HornetQServerSideProtocolManagerFactory;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.impl.PostOfficeJournalLoader;
import org.hornetq.core.server.impl.ScaleDownHandler;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.spi.core.remoting.ClientProtocolManagerFactory;

public class BackupRecoveryJournalLoader
extends PostOfficeJournalLoader {
    private HornetQServer parentServer;
    private ServerLocator locator;
    private final ClusterController clusterController;

    public BackupRecoveryJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, HornetQServer parentServer, ServerLocatorInternal locator, ClusterController clusterController) {
        super(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration);
        this.parentServer = parentServer;
        this.locator = locator;
        this.clusterController = clusterController;
    }

    @Override
    public void handleGroupingBindings(List<GroupingInfo> groupingInfos) {
        if (groupingInfos != null && groupingInfos.size() > 0) {
            HornetQServerLogger.LOGGER.groupBindingsOnRecovery();
        }
    }

    @Override
    public void handleDuplicateIds(Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap) throws Exception {
    }

    @Override
    public void postLoad(Journal messageJournal, ResourceManager resourceManager, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap) throws Exception {
        ScaleDownHandler scaleDownHandler = new ScaleDownHandler(this.pagingManager, this.postOffice, this.nodeManager, this.clusterController);
        this.locator.setProtocolManagerFactory((ClientProtocolManagerFactory)HornetQServerSideProtocolManagerFactory.getInstance());
        try (ClientSessionFactory sessionFactory = this.locator.createSessionFactory();){
            scaleDownHandler.scaleDown(sessionFactory, resourceManager, duplicateIDMap, this.parentServer.getConfiguration().getManagementAddress(), this.parentServer.getNodeID());
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.locator.close();
    }
}

