/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConfigurationUtils;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.AddressSettingsDeployer;
import org.hornetq.core.deployers.impl.BasicUserCredentialsDeployer;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.QueueDeployer;
import org.hornetq.core.deployers.impl.SecurityDeployer;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.journal.impl.SyncSpeedTest;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.PageCountPending;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.postoffice.impl.DivertBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.remoting.server.impl.RemotingServiceImpl;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.security.impl.SecurityStoreImpl;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MemoryManager;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.ServerSessionFactory;
import org.hornetq.core.server.cluster.BackupManager;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.ha.HAPolicy;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupHandlingAbstract;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.server.group.impl.LocalGroupingHandler;
import org.hornetq.core.server.group.impl.RemoteGroupingHandler;
import org.hornetq.core.server.impl.AIOFileLockNodeManager;
import org.hornetq.core.server.impl.Activation;
import org.hornetq.core.server.impl.ConnectorsService;
import org.hornetq.core.server.impl.DivertImpl;
import org.hornetq.core.server.impl.FileLockNodeManager;
import org.hornetq.core.server.impl.InVMNodeManager;
import org.hornetq.core.server.impl.JournalLoader;
import org.hornetq.core.server.impl.QueueFactoryImpl;
import org.hornetq.core.server.impl.ServerInfo;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.impl.ServiceRegistry;
import org.hornetq.core.server.impl.SharedNothingLiveActivation;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.impl.ManagementServiceImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.impl.ResourceManagerImpl;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.protocol.ProtocolManagerFactory;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.ReusableLatch;
import org.hornetq.utils.SecurityFormatter;
import org.hornetq.utils.VersionLoader;

public class HornetQServerImpl
implements HornetQServer {
    public static final String GENERIC_IGNORED_FILTER = "__HQX=-1";
    private HAPolicy haPolicy;
    private volatile SERVER_STATE state = SERVER_STATE.STOPPED;
    private final Version version;
    private final HornetQSecurityManager securityManager;
    private final Configuration configuration;
    private final MBeanServer mbeanServer;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    private volatile ScheduledExecutorService scheduledPool;
    private volatile ExecutorFactory executorFactory;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile HornetQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile BackupManager backupManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private final List<ProtocolManagerFactory> protocolManagerFactories = new ArrayList<ProtocolManagerFactory>();
    private volatile ManagementService managementService;
    private volatile ConnectorsService connectorsService;
    private MemoryManager memoryManager;
    private volatile DeploymentManager deploymentManager;
    private Deployer basicUserCredentialsDeployer;
    private Deployer addressSettingsDeployer;
    private Deployer queueDeployer;
    private Deployer securityDeployer;
    private final Map<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final ReusableLatch activationLatch = new ReusableLatch(0);
    private final Set<ActivateCallback> activateCallbacks = new ConcurrentHashSet();
    private volatile GroupingHandler groupingHandler;
    private NodeManager nodeManager;
    private String identity;
    private Thread backupActivationThread;
    private Activation activation;
    private Map<String, Object> activationParams = new HashMap<String, Object>();
    private final ShutdownOnCriticalErrorListener shutdownOnCriticalIO = new ShutdownOnCriticalErrorListener();
    private final HornetQServer parentServer;
    private final List<SimpleString> scaledDownNodeIDs = new ArrayList<SimpleString>();
    private boolean threadPoolSupplied = false;
    private boolean scheduledPoolSupplied = false;
    private ServiceRegistry serviceRegistry;

    public HornetQServerImpl() {
        this(null, null, null);
    }

    public HornetQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public HornetQServerImpl(Configuration configuration, HornetQServer parentServer) {
        this(configuration, null, null, parentServer);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public HornetQServerImpl(Configuration configuration, HornetQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer, HornetQSecurityManager securityManager) {
        this(configuration, mbeanServer, securityManager, null);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer, HornetQSecurityManager securityManager, HornetQServer parentServer) {
        this(configuration, mbeanServer, securityManager, parentServer, null);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer, HornetQSecurityManager securityManager, HornetQServer parentServer, ServiceRegistry serviceRegistry) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>();
        this.securityRepository.setDefault(new HashSet());
        this.parentServer = parentServer;
        this.serviceRegistry = serviceRegistry == null ? new ServiceRegistry() : serviceRegistry;
    }

    protected NodeManager createNodeManager(String directory, boolean replicatingBackup) {
        NodeManager manager = !this.configuration.isPersistenceEnabled() ? new InVMNodeManager(replicatingBackup) : (this.configuration.getJournalType() == JournalType.ASYNCIO && AsynchronousFileImpl.isLoaded() ? new AIOFileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout()) : new FileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout()));
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() throws Exception {
        if (this.state != SERVER_STATE.STOPPED) {
            HornetQServerLogger.LOGGER.debug("Server already started!");
            return;
        }
        this.state = SERVER_STATE.STARTING;
        if (this.haPolicy == null) {
            this.haPolicy = ConfigurationUtils.getHAPolicy(this.configuration.getHAPolicyConfiguration());
        }
        this.activationLatch.setCount(1);
        HornetQServerLogger.LOGGER.debug("Starting server " + this);
        OperationContextImpl.clearContext();
        try {
            boolean wasLive;
            this.checkJournalDirectory();
            this.nodeManager = this.createNodeManager(this.configuration.getJournalDirectory(), false);
            this.nodeManager.start();
            HornetQServerLogger.LOGGER.serverStarting(this.haPolicy.isBackup() ? "backup" : "live", this.configuration);
            if (this.configuration.isRunSyncSpeedTest()) {
                SyncSpeedTest test = new SyncSpeedTest();
                test.run();
            }
            boolean bl = wasLive = !this.haPolicy.isBackup();
            if (!this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.createActivation(this, false, this.activationParams, this.shutdownOnCriticalIO);
                this.activation.run();
            }
            if (this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.isSharedStore() ? this.haPolicy.createActivation(this, false, this.activationParams, this.shutdownOnCriticalIO) : this.haPolicy.createActivation(this, wasLive, this.activationParams, this.shutdownOnCriticalIO);
                this.backupActivationThread = new Thread((Runnable)this.activation, HornetQMessageBundle.BUNDLE.activationForServer(this));
                this.backupActivationThread.start();
            } else {
                this.state = SERVER_STATE.STARTED;
                HornetQServerLogger.LOGGER.serverStarted(this.getVersion().getFullVersion(), this.nodeManager.getNodeId(), this.identity != null ? this.identity : "");
            }
            this.connectorsService = new ConnectorsService(this.configuration, this.storageManager, this.scheduledPool, this.postOffice, this.serviceRegistry);
            this.connectorsService.start();
        }
        finally {
            OperationContextImpl.clearContext();
        }
    }

    protected final void finalize() throws Throwable {
        if (this.state != SERVER_STATE.STOPPED) {
            HornetQServerLogger.LOGGER.serverFinalisedWIthoutBeingSTopped();
            this.stop();
        }
        super.finalize();
    }

    public void setState(SERVER_STATE state) {
        this.state = state;
    }

    public SERVER_STATE getState() {
        return this.state;
    }

    public void interrupBackupThread(NodeManager nodeManagerInUse) throws InterruptedException {
        long timeout = 30000L;
        long start = System.currentTimeMillis();
        while (this.backupActivationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
            if (nodeManagerInUse != null) {
                nodeManagerInUse.interrupt();
            }
            this.backupActivationThread.interrupt();
            this.backupActivationThread.join(1000L);
        }
        if (System.currentTimeMillis() - start >= timeout) {
            this.threadDump("Timed out waiting for backup activation to exit");
        }
    }

    public void resetNodeManager() throws Exception {
        this.nodeManager.stop();
        this.nodeManager = this.createNodeManager(this.configuration.getJournalDirectory(), true);
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public HAPolicy getHAPolicy() {
        return this.haPolicy;
    }

    @Override
    public void setHAPolicy(HAPolicy haPolicy) {
        this.haPolicy = haPolicy;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setActivation(SharedNothingLiveActivation activation) {
        this.activation = activation;
    }

    public final void stopTheServer(final boolean criticalIOError) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    HornetQServerImpl.this.stop(false, criticalIOError, false);
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorStoppingServer(e);
                }
            }
        });
    }

    public final void stop() throws Exception {
        this.stop(false);
    }

    @Override
    public void addActivationParam(String key, Object val) {
        this.activationParams.put(key, val);
    }

    @Override
    public boolean isAddressBound(String address) throws Exception {
        return this.postOffice.isAddressBound(SimpleString.toSimpleString((String)address));
    }

    @Override
    public void threadDump(String reason) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        Map<Thread, StackTraceElement[]> stackTrace = Thread.getAllStackTraces();
        out.println(HornetQMessageBundle.BUNDLE.generatingThreadDump(reason));
        out.println("*******************************************************************************");
        for (Map.Entry<Thread, StackTraceElement[]> el : stackTrace.entrySet()) {
            out.println("===============================================================================");
            out.println(HornetQMessageBundle.BUNDLE.threadDump(el.getKey(), el.getKey().getName(), el.getKey().getId(), el.getKey().getThreadGroup()));
            out.println();
            for (StackTraceElement traceEl : el.getValue()) {
                out.println(traceEl);
            }
        }
        out.println("===============================================================================");
        out.println(HornetQMessageBundle.BUNDLE.endThreadDump());
        out.println("*******************************************************************************");
        HornetQServerLogger.LOGGER.warn(str.toString());
    }

    @Override
    public final void stop(boolean failoverOnServerShutdown) throws Exception {
        this.stop(failoverOnServerShutdown, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean restarting) throws Exception {
        HornetQServerImpl hornetQServerImpl = this;
        synchronized (hornetQServerImpl) {
            if (this.state == SERVER_STATE.STOPPED || this.state == SERVER_STATE.STOPPING) {
                return;
            }
            this.state = SERVER_STATE.STOPPING;
            this.activation.sendLiveIsStopping();
            HornetQServerImpl.stopComponent(this.connectorsService);
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                this.groupingHandler.stop();
            }
            HornetQServerImpl.stopComponent(this.clusterManager);
            this.freezeConnections();
        }
        this.activation.postConnectionFreeze();
        this.closeAllServerSessions(criticalIOError);
        if (this.storageManager != null) {
            this.storageManager.clearContext();
        }
        this.callDeActiveCallbacks();
        if (this.configuration.isFileDeploymentEnabled()) {
            HornetQServerImpl.stopComponent(this.basicUserCredentialsDeployer);
            HornetQServerImpl.stopComponent(this.addressSettingsDeployer);
            HornetQServerImpl.stopComponent(this.queueDeployer);
            HornetQServerImpl.stopComponent(this.securityDeployer);
            HornetQServerImpl.stopComponent(this.deploymentManager);
        }
        HornetQServerImpl.stopComponent(this.backupManager);
        this.activation.preStorageClose();
        HornetQServerImpl.stopComponent(this.pagingManager);
        if (this.storageManager != null) {
            this.storageManager.stop(criticalIOError);
        }
        if (this.remotingService != null) {
            this.remotingService.stop(criticalIOError);
        }
        if (this.managementService != null) {
            this.managementService.unregisterServer();
        }
        HornetQServerImpl.stopComponent(this.managementService);
        HornetQServerImpl.stopComponent(this.securityManager);
        HornetQServerImpl.stopComponent(this.resourceManager);
        HornetQServerImpl.stopComponent(this.postOffice);
        if (this.scheduledPool != null && !this.scheduledPoolSupplied) {
            this.scheduledPool.shutdownNow();
        }
        HornetQServerImpl.stopComponent(this.memoryManager);
        if (this.threadPool != null && !this.threadPoolSupplied) {
            this.threadPool.shutdown();
            try {
                if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    HornetQServerLogger.LOGGER.timedOutStoppingThreadpool(this.threadPool);
                    for (Runnable r : this.threadPool.shutdownNow()) {
                        HornetQServerLogger.LOGGER.debug("Cancelled the execution of " + r);
                    }
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!this.threadPoolSupplied) {
            this.threadPool = null;
        }
        if (!this.scheduledPoolSupplied) {
            this.scheduledPool = null;
        }
        if (this.securityStore != null) {
            this.securityStore.stop();
        }
        this.pagingManager = null;
        this.securityStore = null;
        this.resourceManager = null;
        this.postOffice = null;
        this.queueFactory = null;
        this.resourceManager = null;
        this.messagingServerControl = null;
        this.memoryManager = null;
        this.backupManager = null;
        this.sessions.clear();
        this.state = SERVER_STATE.STOPPED;
        this.activationLatch.setCount(1);
        SimpleString tempNodeID = this.getNodeID();
        if (this.activation != null) {
            this.activation.close(failoverOnServerShutdown, restarting);
        }
        if (this.backupActivationThread != null) {
            this.backupActivationThread.join(30000L);
            if (this.backupActivationThread.isAlive()) {
                HornetQServerLogger.LOGGER.backupActivationDidntFinish(this);
                this.backupActivationThread.interrupt();
            }
        }
        HornetQServerImpl.stopComponent(this.nodeManager);
        this.nodeManager = null;
        this.addressSettingsRepository.clearListeners();
        this.addressSettingsRepository.clearCache();
        this.scaledDownNodeIDs.clear();
        if (this.identity != null) {
            HornetQServerLogger.LOGGER.serverStopped("identity=" + this.identity + ",version=" + this.getVersion().getFullVersion(), tempNodeID);
        } else {
            HornetQServerLogger.LOGGER.serverStopped(this.getVersion().getFullVersion(), tempNodeID);
        }
    }

    public boolean checkLiveIsNotColocated(String nodeId) {
        if (this.parentServer == null) {
            return true;
        }
        return !this.parentServer.getNodeID().toString().equals(nodeId);
    }

    private void freezeConnections() {
        this.activation.freezeConnections(this.remotingService);
        for (ServerSession serverSession : this.sessions.values()) {
            try {
                serverSession.close(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void closeAllServerSessions(boolean criticalIOError) {
        if (this.state != SERVER_STATE.STOPPING) {
            return;
        }
        for (ServerSession session : this.sessions.values()) {
            try {
                session.close(true);
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
            }
        }
        if (!criticalIOError) {
            for (ServerSession session : this.sessions.values()) {
                try {
                    session.waitContextCompletion();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
                }
            }
        }
    }

    static void stopComponent(HornetQComponent component) throws Exception {
        if (component != null) {
            component.stop();
        }
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println(HornetQMessageBundle.BUNDLE.serverDescribe(this.identity, this.getClusterManager().describe()));
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String destroyConnectionWithSessionMetadata(String metaKey, String parameterValue) throws Exception {
        StringBuffer operationsExecuted = new StringBuffer();
        try {
            operationsExecuted.append("**************************************************************************************************\n");
            operationsExecuted.append(HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataHeader(metaKey, parameterValue) + "\n");
            Set<ServerSession> allSessions = this.getSessions();
            ServerSession sessionFound = null;
            for (ServerSession session : allSessions) {
                try {
                    String value = session.getMetaData(metaKey);
                    if (value == null || !value.equals(parameterValue)) continue;
                    sessionFound = session;
                    operationsExecuted.append(HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataClosingConnection(sessionFound.toString()) + "\n");
                    RemotingConnection conn = session.getRemotingConnection();
                    if (conn != null) {
                        conn.fail((HornetQException)HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataSendException(metaKey, parameterValue));
                    }
                    session.close(true);
                    this.sessions.remove(session.getName());
                }
                catch (Throwable e) {
                    HornetQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
            if (sessionFound == null) {
                operationsExecuted.append(HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataNoSessionFound(metaKey, parameterValue) + "\n");
            }
            operationsExecuted.append("**************************************************************************************************");
            String string = operationsExecuted.toString();
            return string;
        }
        finally {
            HornetQServerLogger.LOGGER.info(operationsExecuted.toString());
        }
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public HornetQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public boolean isStarted() {
        return this.state == SERVER_STATE.STARTED;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, ServerSessionFactory sessionFactory) throws Exception {
        if (this.securityStore != null) {
            this.securityStore.authenticate(username, password);
        }
        OperationContext context = this.storageManager.newContext(this.getExecutorFactory().getExecutor());
        ServerSessionImpl session = this.internalCreateSession(name, username, password, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, context, sessionFactory);
        this.sessions.put(name, session);
        return session;
    }

    protected ServerSessionImpl internalCreateSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, OperationContext context, ServerSessionFactory sessionFactory) throws Exception {
        if (sessionFactory == null) {
            return new ServerSessionImpl(name, username, password, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback, context);
        }
        return sessionFactory.createCoreSession(name, username, password, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback, context);
    }

    @Override
    public SecurityStore getSecurityStore() {
        return this.securityStore;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public ServerSession lookupSession(String key, String value) {
        Set<ServerSession> allSessions = this.getSessions();
        for (ServerSession session : allSessions) {
            String metaValue = session.getMetaData(key);
            if (metaValue == null || !metaValue.equals(value)) continue;
            return session;
        }
        return null;
    }

    @Override
    public synchronized List<ServerSession> getSessions(String connectionID) {
        Set<Map.Entry<String, ServerSession>> sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry<String, ServerSession> sessionEntry : sessionEntries) {
            ServerSession serverSession = sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public synchronized Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    @Override
    public boolean isActive() {
        return this.activationLatch.getCount() < 1;
    }

    @Override
    public boolean waitForActivation(long timeout, TimeUnit unit) throws InterruptedException {
        return this.activationLatch.await(timeout, unit);
    }

    @Override
    public HornetQServerControlImpl getHornetQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnections().size();
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeManager == null ? null : this.nodeManager.getNodeId();
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, durable, temporary, false, false);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString name, SimpleString filterString, boolean durable) throws Exception {
        Queue queue = this.createQueue(address, name, filterString, durable, !durable, true, !durable);
        if (!queue.getAddress().equals((Object)address)) {
            throw HornetQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentAddress(name);
        }
        if (filterString != null && (queue.getFilter() == null || !queue.getFilter().getFilterString().equals((Object)filterString)) || filterString == null && queue.getFilter() != null) {
            throw HornetQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentFilter(name);
        }
        if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
            HornetQServerLogger.LOGGER.debug("Transient Queue " + name + " created on address " + name + " with filter=" + filterString);
        }
    }

    @Override
    public Queue locateQueue(SimpleString queueName) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            return null;
        }
        Bindable queue = binding.getBindable();
        if (!(queue instanceof Queue)) {
            throw new IllegalStateException("locateQueue should only be used to locate queues");
        }
        return (Queue)binding.getBindable();
    }

    @Override
    public Queue deployQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        HornetQServerLogger.LOGGER.deployQueue(queueName);
        return this.createQueue(address, queueName, filterString, durable, temporary, true, false);
    }

    @Override
    public void destroyQueue(SimpleString queueName) throws Exception {
        this.destroyQueue(queueName, null, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, ServerSession session) throws Exception {
        this.destroyQueue(queueName, session, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, ServerSession session, boolean checkConsumerCount) throws Exception {
        this.destroyQueue(queueName, session, checkConsumerCount, false);
    }

    @Override
    public void destroyQueue(SimpleString queueName, ServerSession session, boolean checkConsumerCount, boolean removeConsumers) throws Exception {
        this.addressSettingsRepository.clearCache();
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw HornetQMessageBundle.BUNDLE.noSuchQueue(queueName);
        }
        Queue queue = (Queue)binding.getBindable();
        if (checkConsumerCount && queue.getConsumerCount() != 0) {
            throw HornetQMessageBundle.BUNDLE.cannotDeleteQueue(queue.getName(), queueName, binding.getClass().getName());
        }
        if (session != null) {
            if (queue.isDurable()) {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_DURABLE_QUEUE, session);
            } else {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_NON_DURABLE_QUEUE, session);
            }
        }
        queue.deleteQueue(removeConsumers);
    }

    @Override
    public void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        if (this.groupingHandler != null && this.managementService != null) {
            this.managementService.removeNotificationListener(this.groupingHandler);
        }
        this.groupingHandler = groupingHandler;
        if (this.managementService != null) {
            this.managementService.addNotificationListener(this.groupingHandler);
        }
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.activation.getReplicationManager();
    }

    @Override
    public ConnectorsService getConnectorsService() {
        return this.connectorsService;
    }

    @Override
    public void deployDivert(DivertConfiguration config) throws Exception {
        if (config.getName() == null) {
            HornetQServerLogger.LOGGER.divertWithNoName();
            return;
        }
        if (config.getAddress() == null) {
            HornetQServerLogger.LOGGER.divertWithNoAddress();
            return;
        }
        if (config.getForwardingAddress() == null) {
            HornetQServerLogger.LOGGER.divertWithNoForwardingAddress();
            return;
        }
        SimpleString sName = new SimpleString(config.getName());
        if (this.postOffice.getBinding(sName) != null) {
            HornetQServerLogger.LOGGER.divertBindingNotExists(sName);
            return;
        }
        SimpleString sAddress = new SimpleString(config.getAddress());
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        DivertImpl divert = new DivertImpl(new SimpleString(config.getForwardingAddress()), sName, new SimpleString(config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager);
        DivertBinding binding = new DivertBinding(this.storageManager.generateID(), sAddress, divert);
        this.postOffice.addBinding(binding);
        this.managementService.registerDivert(divert, config);
    }

    @Override
    public void destroyDivert(SimpleString name) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null) {
            throw HornetQMessageBundle.BUNDLE.noBindingForDivert(name);
        }
        if (!(binding instanceof DivertBinding)) {
            throw HornetQMessageBundle.BUNDLE.bindingNotDivert(name);
        }
        this.postOffice.removeBinding(name, null);
    }

    @Override
    public void deployBridge(BridgeConfiguration config) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.deployBridge(config);
        }
    }

    @Override
    public void destroyBridge(String name) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.destroyBridge(name);
        }
    }

    @Override
    public ServerSession getSessionByID(String sessionName) {
        return this.sessions.get(sessionName);
    }

    public String toString() {
        if (this.identity != null) {
            return "HornetQServerImpl::" + this.identity;
        }
        return "HornetQServerImpl::" + (this.nodeManager != null ? "serverUUID=" + this.nodeManager.getUUID() : "");
    }

    public void replaceQueueFactory(QueueFactory factory) {
        this.queueFactory = factory;
    }

    private PagingManager createPagingManager() {
        return new PagingManagerImpl(new PagingStoreFactoryNIO(this.storageManager, this.configuration.getPagingDirectory(), this.configuration.getJournalBufferTimeout_NIO(), this.scheduledPool, this.executorFactory, this.configuration.isJournalSyncNonTransactional(), this.shutdownOnCriticalIO), this.addressSettingsRepository);
    }

    private StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            return new JournalStorageManager(this.configuration, this.executorFactory, this.shutdownOnCriticalIO);
        }
        return new NullStorageManager();
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    private void callDeActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            try {
                callback.deActivate();
            }
            catch (Throwable e) {
                HornetQServerLogger.LOGGER.warn(e.getMessage(), e);
            }
        }
    }

    private void callActivationCompleteCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activationComplete();
        }
    }

    private void initializeExecutorServices() {
        HornetQThreadFactory tFactory;
        if (this.serviceRegistry.getExecutorService() == null) {
            tFactory = new HornetQThreadFactory("HornetQ-server-" + this.toString(), false, HornetQServerImpl.getThisClassLoader());
            this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? Executors.newCachedThreadPool((ThreadFactory)tFactory) : Executors.newFixedThreadPool(this.configuration.getThreadPoolMaxSize(), (ThreadFactory)tFactory);
        } else {
            this.threadPool = this.serviceRegistry.getExecutorService();
            this.threadPoolSupplied = true;
        }
        this.executorFactory = new OrderedExecutorFactory((Executor)this.threadPool);
        if (this.serviceRegistry.getScheduledExecutorService() == null) {
            tFactory = new HornetQThreadFactory("HornetQ-scheduled-threads", false, HornetQServerImpl.getThisClassLoader());
            this.scheduledPool = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), (ThreadFactory)tFactory);
        } else {
            this.scheduledPoolSupplied = true;
            this.scheduledPool = this.serviceRegistry.getScheduledExecutorService();
        }
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    synchronized boolean initialisePart1(boolean scalingDown) throws Exception {
        if (this.state == SERVER_STATE.STOPPED) {
            return false;
        }
        this.initializeExecutorServices();
        if (this.configuration.getJournalType() == JournalType.ASYNCIO && !AIOSequentialFileFactory.isSupported()) {
            HornetQServerLogger.LOGGER.switchingNIO();
            this.configuration.setJournalType(JournalType.NIO);
        }
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManager(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.deploymentManager = new FileDeploymentManager(this.configuration.getFileDeployerScanPeriod());
        }
        this.callPreActiveCallbacks();
        this.storageManager = this.createStorageManager();
        if (HornetQDefaultConfiguration.getDefaultClusterUser().equals(this.configuration.getClusterUser()) && HornetQDefaultConfiguration.getDefaultClusterPassword().equals(this.configuration.getClusterPassword())) {
            HornetQServerLogger.LOGGER.clusterSecurityRisk();
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService);
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl((int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getMessageExpiryThreadPriority(), this.configuration.isWildcardRoutingEnabled(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.clusterManager = new ClusterManager(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.nodeManager, this.haPolicy.isBackup());
        this.backupManager = new BackupManager(this, this.executorFactory, this.scheduledPool, this.nodeManager, this.configuration, this.clusterManager);
        this.clusterManager.deploy();
        this.remotingService = new RemotingServiceImpl(this.clusterManager, this.configuration, this, this.managementService, this.scheduledPool, this.protocolManagerFactories, this.executorFactory.getExecutor(), this.serviceRegistry);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.haPolicy.isBackup());
        if (!scalingDown) {
            if (this.configuration.isFileDeploymentEnabled()) {
                this.addressSettingsDeployer = new AddressSettingsDeployer(this.deploymentManager, this.addressSettingsRepository);
                this.addressSettingsDeployer.start();
            }
            this.deployAddressSettingsFromConfiguration();
        }
        this.storageManager.start();
        if (this.securityManager != null) {
            this.securityManager.start();
        }
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        if (this.configuration.isFileDeploymentEnabled()) {
            this.basicUserCredentialsDeployer = new BasicUserCredentialsDeployer(this.deploymentManager, this.securityManager);
            this.basicUserCredentialsDeployer.start();
            if (this.securityManager != null) {
                this.securityDeployer = new SecurityDeployer(this.deploymentManager, this.securityRepository);
                this.securityDeployer.start();
            }
        }
        this.deploySecurityFromConfiguration();
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
        return true;
    }

    synchronized void initialisePart2(boolean scalingDown) throws Exception {
        if (this.state == SERVER_STATE.STOPPED || this.state == SERVER_STATE.STOPPING) {
            return;
        }
        this.pagingManager.reloadStores();
        JournalLoadInformation[] journalInfo = this.loadJournals();
        final ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    HornetQServerLogger.LOGGER.dumpServerInfo(dumper.dump());
                }
            }, 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.queueDeployer = new QueueDeployer(this.deploymentManager, this);
            this.queueDeployer.start();
        } else {
            this.deployQueuesFromConfiguration();
        }
        this.callActivateCallbacks();
        if (!scalingDown) {
            this.deployDiverts();
            if (this.groupingHandler != null) {
                this.groupingHandler.start();
            }
            if (this.groupingHandler != null && this.groupingHandler instanceof LocalGroupingHandler) {
                this.clusterManager.start();
                this.groupingHandler.awaitBindings();
                this.remotingService.start();
            } else {
                this.remotingService.start();
                this.clusterManager.start();
            }
            if (this.nodeManager.getNodeId() == null) {
                throw HornetQMessageBundle.BUNDLE.nodeIdNull();
            }
            this.activationLatch.countDown();
            this.postOffice.startExpiryScanner();
        } else {
            this.activationLatch.countDown();
        }
        this.callActivationCompleteCallbacks();
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        for (CoreQueueConfiguration config : this.configuration.getQueueConfigurations()) {
            this.deployQueue(SimpleString.toSimpleString((String)config.getAddress()), SimpleString.toSimpleString((String)config.getName()), SimpleString.toSimpleString((String)config.getFilterString()), config.isDurable(), false);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressesSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private JournalLoadInformation[] loadJournals() throws Exception {
        JournalLoader journalLoader = this.activation.createJournalLoader(this.postOffice, this.pagingManager, this.storageManager, this.queueFactory, this.nodeManager, this.managementService, this.groupingHandler, this.configuration, this.parentServer);
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos);
        this.recoverStoredConfigs();
        HashMap<Long, QueueBindingInfo> queueBindingInfosMap = new HashMap<Long, QueueBindingInfo>();
        journalLoader.initQueues(queueBindingInfosMap, queueBindingInfos);
        journalLoader.handleGroupingBindings(groupingInfos);
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        HashSet<Pair<Long, Long>> pendingLargeMessages = new HashSet<Pair<Long, Long>>();
        LinkedList<PageCountPending> pendingNonTXPageCounter = new LinkedList<PageCountPending>();
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queueBindingInfosMap, duplicateIDMap, pendingLargeMessages, pendingNonTXPageCounter, journalLoader);
        journalLoader.handleDuplicateIds(duplicateIDMap);
        for (Pair<Long, Long> msgToDelete : pendingLargeMessages) {
            HornetQServerLogger.LOGGER.deletingPendingMessage(msgToDelete);
            LargeServerMessage msg = this.storageManager.createLargeMessage();
            msg.setMessageID((Long)msgToDelete.getB());
            msg.setPendingRecordID((Long)msgToDelete.getA());
            msg.setDurable(true);
            msg.deleteFile();
        }
        if (pendingNonTXPageCounter.size() != 0) {
            try {
                journalLoader.recoverPendingPageCounters(pendingNonTXPageCounter);
            }
            catch (Throwable e) {
                HornetQServerLogger.LOGGER.errorRecoveringPageCounter(e);
            }
        }
        journalLoader.cleanUp();
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        List<PersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (PersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
        List<PersistedRoles> roles = this.storageManager.recoverPersistedRoles();
        for (PersistedRoles roleItem : roles) {
            Set setRoles = SecurityFormatter.createSecurity((String)roleItem.getSendRoles(), (String)roleItem.getConsumeRoles(), (String)roleItem.getCreateDurableQueueRoles(), (String)roleItem.getDeleteDurableQueueRoles(), (String)roleItem.getCreateNonDurableQueueRoles(), (String)roleItem.getDeleteNonDurableQueueRoles(), (String)roleItem.getManageRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    private Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue) throws Exception {
        QueueBinding binding = (QueueBinding)this.postOffice.getBinding(queueName);
        if (binding != null) {
            if (ignoreIfExists) {
                return binding.getQueue();
            }
            throw HornetQMessageBundle.BUNDLE.queueAlreadyExists(queueName);
        }
        Filter filter = FilterImpl.createFilter(filterString);
        long txID = this.storageManager.generateID();
        long queueID = this.storageManager.generateID();
        PageSubscription pageSubscription = filterString != null && filterString.toString().equals(GENERIC_IGNORED_FILTER) ? null : this.pagingManager.getPageStore(address).getCursorProvider().createSubscription(queueID, filter, durable);
        Queue queue = this.queueFactory.createQueue(queueID, address, queueName, filter, pageSubscription, durable, temporary);
        if (transientQueue) {
            queue.setConsumersRefCount(this);
        }
        binding = new LocalQueueBinding(address, queue, this.nodeManager.getNodeId());
        if (durable) {
            this.storageManager.addQueueBinding(txID, binding);
        }
        try {
            this.postOffice.addBinding(binding);
            if (durable) {
                this.storageManager.commitBindings(txID);
            }
        }
        catch (Exception e) {
            try {
                if (durable) {
                    this.storageManager.rollbackBindings(txID);
                }
                if (queue != null) {
                    queue.close();
                }
                if (pageSubscription != null) {
                    pageSubscription.destroy();
                }
            }
            catch (Throwable ignored) {
                HornetQServerLogger.LOGGER.debug(ignored.getMessage(), ignored);
            }
            throw e;
        }
        this.managementService.registerAddress(address);
        this.managementService.registerQueue(queue, address, this.storageManager);
        return queue;
    }

    private void deployDiverts() throws Exception {
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            this.deployDivert(config);
        }
    }

    private void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupHandlingAbstract groupingHandler1 = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.executorFactory, this.scheduledPool, this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout(), config.getGroupTimeout(), config.getReaperPeriod()) : new RemoteGroupingHandler(this.executorFactory, this.managementService, config.getName(), config.getAddress(), config.getTimeout(), config.getGroupTimeout());
            this.groupingHandler = groupingHandler1;
            this.managementService.addNotificationListener(groupingHandler1);
        }
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            transformer = (Transformer)this.instantiateInstance(transformerClassName);
        }
        return transformer;
    }

    private Object instantiateInstance(String className) {
        return HornetQServerImpl.safeInitNewInstance(className);
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    void checkJournalDirectory() {
        File journalDir = new File(this.configuration.getJournalDirectory());
        if (!journalDir.exists()) {
            if (this.configuration.isCreateJournalDir()) {
                journalDir.mkdirs();
            } else {
                throw HornetQMessageBundle.BUNDLE.cannotCreateDir(journalDir.getAbsolutePath());
            }
        }
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    @Override
    public void addProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.add(factory);
    }

    @Override
    public void removeProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.remove(factory);
    }

    @Override
    public HornetQServer createBackupServer(Configuration configuration) {
        return new HornetQServerImpl(configuration, null, this.securityManager, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScaledDownNode(SimpleString scaledDownNodeId) {
        List<SimpleString> list = this.scaledDownNodeIDs;
        synchronized (list) {
            this.scaledDownNodeIDs.add(scaledDownNodeId);
            if (this.scaledDownNodeIDs.size() > 10) {
                this.scaledDownNodeIDs.remove(10);
            }
        }
    }

    @Override
    public boolean hasScaledDown(SimpleString scaledDownNodeId) {
        return this.scaledDownNodeIDs.contains(scaledDownNodeId);
    }

    int countNumberOfCopiedJournals() {
        File journalDir = new File(this.configuration.getJournalDirectory());
        final String fileName = journalDir.getName();
        int numberOfbackupsSaved = 0;
        if (journalDir.exists()) {
            File parentFile = new File(journalDir.getParent());
            String[] backupJournals = parentFile.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(fileName) && !name.matches(fileName);
                }
            });
            numberOfbackupsSaved = backupJournals != null ? backupJournals.length : 0;
        }
        return numberOfbackupsSaved;
    }

    void moveServerData() {
        String[] dataDirs = new String[]{this.configuration.getBindingsDirectory(), this.configuration.getJournalDirectory(), this.configuration.getPagingDirectory(), this.configuration.getLargeMessagesDirectory()};
        boolean allEmpty = true;
        int lowestSuffixForMovedData = 1;
        boolean redo = true;
        while (redo) {
            redo = false;
            for (String dir : dataDirs) {
                File fDir = new File(dir);
                if (fDir.exists()) {
                    if (!fDir.isDirectory()) {
                        throw HornetQMessageBundle.BUNDLE.journalDirIsFile(fDir);
                    }
                    if (fDir.list().length > 0) {
                        allEmpty = false;
                    }
                }
                String sanitizedPath = fDir.getPath();
                while (new File(sanitizedPath + lowestSuffixForMovedData).exists()) {
                    ++lowestSuffixForMovedData;
                    redo = true;
                }
            }
        }
        if (allEmpty) {
            return;
        }
        for (String dir0 : dataDirs) {
            File dir = new File(dir0);
            File newPath = new File(dir.getPath() + lowestSuffixForMovedData);
            if (dir.exists()) {
                if (!dir.renameTo(newPath)) {
                    throw HornetQMessageBundle.BUNDLE.couldNotMoveJournal(dir);
                }
                HornetQServerLogger.LOGGER.backupMovingDataAway(dir0, newPath.getPath());
            }
            File dirToRecreate = new File(dir0);
            int count = 0;
            while (!dirToRecreate.exists() && !dirToRecreate.mkdir()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (++count != 5) continue;
                throw HornetQMessageBundle.BUNDLE.cannotCreateDir(dir.getPath());
            }
        }
    }

    public final class ShutdownOnCriticalErrorListener
    implements IOCriticalErrorListener {
        boolean failedAlready = false;

        public synchronized void onIOException(Exception cause, String message, SequentialFile file) {
            if (!this.failedAlready) {
                this.failedAlready = true;
                HornetQServerLogger.LOGGER.ioCriticalIOError(message, file.toString(), cause);
                HornetQServerImpl.this.stopTheServer(true);
            }
        }
    }

    static enum SERVER_STATE {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

