/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.MessageReferenceImpl;
import org.hornetq.utils.MemorySize;
import org.hornetq.utils.TypedProperties;

public class ServerMessageImpl
extends MessageImpl
implements ServerMessage {
    private final AtomicInteger durableRefCount = new AtomicInteger();
    private final AtomicInteger refCount = new AtomicInteger();
    private PagingStore pagingStore;
    private static final int memoryOffset = MemorySize.is64bitArch() ? 352 : 232;
    private boolean persisted = false;
    private volatile int memoryEstimate = -1;

    public ServerMessageImpl() {
    }

    public ServerMessageImpl(long messageID, int initialMessageBufferSize) {
        super(initialMessageBufferSize);
        this.messageID = messageID;
    }

    protected ServerMessageImpl(ServerMessageImpl other) {
        super((MessageImpl)other);
    }

    protected ServerMessageImpl(ServerMessageImpl other, TypedProperties properties) {
        super((MessageImpl)other, properties);
    }

    public boolean isServerMessage() {
        return true;
    }

    @Override
    public ServerMessageImpl setMessageID(long id) {
        this.messageID = id;
        return this;
    }

    @Override
    public MessageReference createReference(Queue queue) {
        MessageReferenceImpl ref = new MessageReferenceImpl(this, queue);
        return ref;
    }

    @Override
    public boolean hasInternalProperties() {
        return this.properties.hasInternalProperties();
    }

    @Override
    public int incrementRefCount() throws Exception {
        int count = this.refCount.incrementAndGet();
        if (this.pagingStore != null) {
            if (count == 1) {
                this.pagingStore.addSize(this.getMemoryEstimate() + MessageReferenceImpl.getMemoryEstimate());
            } else {
                this.pagingStore.addSize(MessageReferenceImpl.getMemoryEstimate());
            }
        }
        return count;
    }

    @Override
    public int decrementRefCount() throws Exception {
        int count = this.refCount.decrementAndGet();
        if (this.pagingStore != null) {
            if (count == 0) {
                this.pagingStore.addSize(-this.getMemoryEstimate() - MessageReferenceImpl.getMemoryEstimate());
                if (this.buffer != null) {
                    this.buffer.byteBuf().release();
                }
            } else {
                this.pagingStore.addSize(-MessageReferenceImpl.getMemoryEstimate());
            }
        }
        return count;
    }

    @Override
    public int incrementDurableRefCount() {
        return this.durableRefCount.incrementAndGet();
    }

    @Override
    public int decrementDurableRefCount() {
        return this.durableRefCount.decrementAndGet();
    }

    @Override
    public int getRefCount() {
        return this.refCount.get();
    }

    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = memoryOffset + this.buffer.capacity() + this.properties.getMemoryOffset();
        }
        return this.memoryEstimate;
    }

    @Override
    public ServerMessage copy(long newID) {
        ServerMessageImpl m = new ServerMessageImpl(this);
        m.setMessageID(newID);
        return m;
    }

    @Override
    public void finishCopy() throws Exception {
    }

    @Override
    public ServerMessage copy() {
        return new ServerMessageImpl(this);
    }

    public ServerMessage makeCopyForExpiryOrDLA(long newID, MessageReference originalReference, boolean expiry) throws Exception {
        return this.makeCopyForExpiryOrDLA(newID, originalReference, expiry, true);
    }

    @Override
    public ServerMessage makeCopyForExpiryOrDLA(long newID, MessageReference originalReference, boolean expiry, boolean copyOriginalHeaders) throws Exception {
        ServerMessage copy = this.copy(newID);
        copy.finishCopy();
        if (copyOriginalHeaders) {
            copy.setOriginalHeaders(this, originalReference, expiry);
        }
        return copy;
    }

    @Override
    public void setOriginalHeaders(ServerMessage other, MessageReference originalReference, boolean expiry) {
        SimpleString originalQueue = other.getSimpleStringProperty(Message.HDR_ORIGINAL_QUEUE);
        if (originalQueue != null) {
            this.putStringProperty(Message.HDR_ORIGINAL_QUEUE, originalQueue);
        } else if (originalReference != null) {
            this.putStringProperty(Message.HDR_ORIGINAL_QUEUE, originalReference.getQueue().getName());
        }
        if (other.containsProperty(Message.HDR_ORIG_MESSAGE_ID)) {
            this.putStringProperty(Message.HDR_ORIGINAL_ADDRESS, other.getSimpleStringProperty(Message.HDR_ORIGINAL_ADDRESS));
            this.putLongProperty(Message.HDR_ORIG_MESSAGE_ID, other.getLongProperty(Message.HDR_ORIG_MESSAGE_ID));
        } else {
            this.putStringProperty(Message.HDR_ORIGINAL_ADDRESS, other.getAddress());
            this.putLongProperty(Message.HDR_ORIG_MESSAGE_ID, other.getMessageID());
        }
        this.setExpiration(0L);
        if (expiry) {
            long actualExpiryTime = System.currentTimeMillis();
            this.putLongProperty(Message.HDR_ACTUAL_EXPIRY_TIME, actualExpiryTime);
        }
        this.bufferValid = false;
    }

    @Override
    public void setPagingStore(PagingStore pagingStore) {
        this.pagingStore = pagingStore;
        this.address = pagingStore.getAddress();
    }

    @Override
    public synchronized void forceAddress(SimpleString address) {
        this.address = address;
        this.bufferValid = false;
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pagingStore;
    }

    @Override
    public boolean storeIsPaging() {
        if (this.pagingStore != null) {
            return this.pagingStore.isPaging();
        }
        return false;
    }

    public String toString() {
        return "ServerMessage[messageID=" + this.messageID + ",durable=" + this.isDurable() + ",userID=" + this.getUserID() + ",priority=" + this.getPriority() + ", bodySize=" + this.getBodyBufferCopy().capacity() + ",expiration=" + (this.getExpiration() != 0L ? new Date(this.getExpiration()) : Integer.valueOf(0)) + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]@" + System.identityHashCode(this);
    }

    public InputStream getBodyInputStream() {
        return null;
    }

    @Override
    public void encodeMessageIDToBuffer() {
        this.buffer.setLong(this.buffer.getInt(13) + 4, this.messageID);
    }

    @Override
    public byte[] getDuplicateIDBytes() {
        Object duplicateID = this.getDuplicateProperty();
        if (duplicateID == null) {
            return null;
        }
        if (duplicateID instanceof SimpleString) {
            return ((SimpleString)duplicateID).getData();
        }
        return (byte[])duplicateID;
    }

    @Override
    public Object getDuplicateProperty() {
        return this.getObjectProperty(Message.HDR_DUPLICATE_DETECTION_ID);
    }
}

