/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.hornetq.core.server.ConnectorServiceFactory;

public class ServiceRegistry {
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private Map<String, Interceptor> incomingInterceptors = new ConcurrentHashMap<String, Interceptor>();
    private Map<String, Interceptor> outgoingInterceptors = new ConcurrentHashMap<String, Interceptor>();
    private Map<String, Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> connectorServices = new ConcurrentHashMap<String, Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>>();

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void addConnectorService(ConnectorServiceFactory connectorServiceFactory, ConnectorServiceConfiguration configuration) {
        this.connectorServices.put(configuration.getConnectorName(), (Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>)new Pair((Object)connectorServiceFactory, (Object)configuration));
    }

    public void removeConnectorService(ConnectorServiceConfiguration configuration) {
        this.connectorServices.remove(configuration.getConnectorName());
    }

    public Collection<Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> getConnectorServices() {
        return this.connectorServices.values();
    }

    public void addIncomingInterceptor(String name, Interceptor interceptor) {
        this.incomingInterceptors.put(name, interceptor);
    }

    public void removeIncomingInterceptor(String name) {
        this.incomingInterceptors.remove(name);
    }

    public Collection<Interceptor> getIncomingInterceptors() {
        return Collections.unmodifiableCollection(this.incomingInterceptors.values());
    }

    public Interceptor getIncomingInterceptor(String name) {
        return this.incomingInterceptors.get(name);
    }

    public void addOutgoingInterceptor(String name, Interceptor interceptor) {
        this.outgoingInterceptors.put(name, interceptor);
    }

    public Interceptor getOutgoingInterceptor(String name) {
        return this.outgoingInterceptors.get(name);
    }

    public void removeOutgoingInterceptor(String name) {
        this.outgoingInterceptors.remove(name);
    }

    public Collection<Interceptor> getOutgoingInterceptors() {
        return Collections.unmodifiableCollection(this.outgoingInterceptors.values());
    }
}

