/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.transports.netty;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.logging.Logger;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class HornetQFrameDecoder
extends FrameDecoder {
    private static final Logger log = Logger.getLogger(HornetQFrameDecoder.class);
    private final BufferHandler handler;

    public HornetQFrameDecoder(BufferHandler handler) {
        this.handler = handler;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in) throws Exception {
        int start = in.readerIndex();
        int length = this.handler.isReadyToHandle((HornetQBuffer)new ChannelBufferWrapper(in));
        in.readerIndex(start);
        if (length == -1) {
            return null;
        }
        ChannelBuffer buffer = in.readBytes(length + 4);
        ChannelBuffer newBuffer = ChannelBuffers.dynamicBuffer((int)buffer.writerIndex());
        newBuffer.writeBytes(buffer);
        newBuffer.readInt();
        return newBuffer;
    }
}

