/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.transports.netty;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.impl.ssl.SSLSupport;
import org.hornetq.integration.transports.netty.ChannelPipelineSupport;
import org.hornetq.integration.transports.netty.HornetQChannelHandler;
import org.hornetq.integration.transports.netty.NettyConnection;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.Connector;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.Future;
import org.hornetq.utils.VersionLoader;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.VirtualExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnector
implements Connector {
    private static final Logger log = Logger.getLogger(NettyConnector.class);
    private ClientSocketChannelFactory channelFactory;
    private ClientBootstrap bootstrap;
    private ChannelGroup channelGroup;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpMaxClientIdleTime;
    private final long httpClientIdleScanPeriod;
    private final boolean httpRequiresSessionId;
    private final boolean useNio;
    private final boolean useServlet;
    private final String host;
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private final String servletPath;
    private final VirtualExecutorService virtualExecutor;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        if (listener == null) {
            throw new IllegalArgumentException("Invalid argument null listener");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Invalid argument null handler");
        }
        this.listener = listener;
        this.handler = handler;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty((String)"ssl-enabled", (boolean)false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty((String)"http-enabled", (boolean)false, configuration);
        this.servletPath = ConfigurationHelper.getStringProperty((String)"servlet-path", (String)"/messaging/HornetQServlet", configuration);
        if (this.httpEnabled) {
            this.httpMaxClientIdleTime = ConfigurationHelper.getLongProperty((String)"http-client-idle-time", (long)500L, configuration);
            this.httpClientIdleScanPeriod = ConfigurationHelper.getLongProperty((String)"http-client-idle-scan-period", (long)500L, configuration);
            this.httpRequiresSessionId = ConfigurationHelper.getBooleanProperty((String)"http-requires-session-id", (boolean)false, configuration);
        } else {
            this.httpMaxClientIdleTime = 0L;
            this.httpClientIdleScanPeriod = -1L;
            this.httpRequiresSessionId = false;
        }
        this.useNio = ConfigurationHelper.getBooleanProperty((String)"use-nio", (boolean)false, configuration);
        this.useServlet = ConfigurationHelper.getBooleanProperty((String)"use-servlet", (boolean)false, configuration);
        this.host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty((String)"port", (int)5445, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty((String)"key-store-path", (String)"hornetq.keystore", configuration);
            this.keyStorePassword = ConfigurationHelper.getStringProperty((String)"key-store-password", (String)"secureexample", configuration);
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty((String)"tcp-no-delay", (boolean)true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty((String)"tcp-send-buffer-size", (int)32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty((String)"tcp-receive-buffer-size", (int)32768, configuration);
        this.closeExecutor = closeExecutor;
        this.virtualExecutor = new VirtualExecutorService(threadPool);
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public synchronized void start() {
        SSLContext context;
        if (this.channelFactory != null) {
            return;
        }
        this.channelFactory = this.useNio ? new NioClientSocketChannelFactory((Executor)this.virtualExecutor, (Executor)this.virtualExecutor) : new OioClientSocketChannelFactory((Executor)this.virtualExecutor);
        if (this.useServlet) {
            ClientSocketChannelFactory proxyChannelFactory = this.channelFactory;
            this.channelFactory = new HttpTunnelingClientSocketChannelFactory(proxyChannelFactory);
        }
        this.bootstrap = new ClientBootstrap((ChannelFactory)this.channelFactory);
        this.bootstrap.setOption("tcpNoDelay", (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.setOption("receiveBufferSize", (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.setOption("sendBufferSize", (Object)this.tcpSendBufferSize);
        }
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.channelGroup = new DefaultChannelGroup("hornetq-connector");
        if (this.sslEnabled) {
            try {
                context = SSLSupport.getInstance((boolean)true, (String)this.keyStorePath, (String)this.keyStorePassword, null, null);
            }
            catch (Exception e) {
                this.close();
                IllegalStateException ise = new IllegalStateException("Unable to create NettyConnector for " + this.host);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        if (context != null && this.useServlet) {
            this.bootstrap.setOption("sslContext", (Object)context);
        }
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NettyConnector.this.sslEnabled && !NettyConnector.this.useServlet) {
                    ChannelPipelineSupport.addSSLFilter(pipeline, context, true);
                }
                if (NettyConnector.this.httpEnabled) {
                    pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpRequestEncoder());
                    pipeline.addLast("httpResponseDecoder", (ChannelHandler)new HttpResponseDecoder());
                    pipeline.addLast("httphandler", (ChannelHandler)new HttpHandler());
                }
                ChannelPipelineSupport.addCodecFilter(pipeline, NettyConnector.this.handler);
                pipeline.addLast("handler", (ChannelHandler)new HornetQClientChannelHandler(NettyConnector.this.channelGroup, NettyConnector.this.handler, new Listener()));
                return pipeline;
            }
        });
        if (!"3.1.5.GA-r1772".equals(VersionLoader.getVersion().getNettyVersion())) {
            log.warn((Object)("Unexpected Netty Version was expecting " + VersionLoader.getVersion().getNettyVersion() + " using " + "3.1.5.GA-r1772"));
        }
        log.debug((Object)"Started Netty Connector version 3.1.5.GA-r1772");
    }

    public synchronized void close() {
        if (this.channelFactory == null) {
            return;
        }
        this.bootstrap = null;
        this.channelGroup.close().awaitUninterruptibly();
        this.channelFactory.releaseExternalResources();
        this.channelFactory = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
    }

    public boolean isStarted() {
        return this.channelFactory != null;
    }

    public Connection createConnection() {
        if (this.channelFactory == null) {
            return null;
        }
        if (this.useServlet) {
            try {
                URI uri = new URI("http", null, this.host, this.port, this.servletPath, null, null);
                this.bootstrap.setOption("serverName", (Object)uri.getHost());
                this.bootstrap.setOption("serverPath", (Object)uri.getRawPath());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)address);
        future.awaitUninterruptibly();
        if (future.isSuccess()) {
            Channel ch = future.getChannel();
            SslHandler sslHandler = (SslHandler)ch.getPipeline().get(SslHandler.class);
            if (sslHandler != null) {
                try {
                    ChannelFuture handshakeFuture = sslHandler.handshake(ch);
                    handshakeFuture.awaitUninterruptibly();
                    if (!handshakeFuture.isSuccess()) {
                        ch.close().awaitUninterruptibly();
                        return null;
                    }
                    ((HornetQChannelHandler)ch.getPipeline().get(HornetQChannelHandler.class)).active = true;
                }
                catch (SSLException e) {
                    ch.close();
                    return null;
                }
            } else {
                ((HornetQChannelHandler)ch.getPipeline().get(HornetQChannelHandler.class)).active = true;
            }
            NettyConnection conn = new NettyConnection(ch, new Listener());
            return conn;
        }
        Throwable t = future.getCause();
        if (t != null && !(t instanceof ConnectException)) {
            log.error((Object)"Failed to create netty connection", future.getCause());
        }
        return null;
    }

    static /* synthetic */ String access$600(NettyConnector x0) {
        return x0.host;
    }

    static /* synthetic */ int access$700(NettyConnector x0) {
        return x0.port;
    }

    static /* synthetic */ String access$800(NettyConnector x0) {
        return x0.servletPath;
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(Connection connection) {
            if (NettyConnector.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw new IllegalArgumentException("Connection already exists with id " + connection.getID());
            }
        }

        public void connectionDestroyed(final Object connectionID) {
            if (NettyConnector.this.connections.remove(connectionID) != null) {
                NettyConnector.this.closeExecutor.execute(new Runnable(){

                    public void run() {
                        NettyConnector.this.listener.connectionDestroyed(connectionID);
                    }
                });
            }
        }

        public void connectionException(final Object connectionID, final HornetQException me) {
            NettyConnector.this.closeExecutor.execute(new Runnable(){

                public void run() {
                    NettyConnector.this.listener.connectionException(connectionID, me);
                }
            });
        }
    }

    @ChannelPipelineCoverage(value="one")
    class HttpHandler
    extends SimpleChannelHandler {
        private Channel channel;
        private long lastSendTime = 0L;
        private boolean waitingGet = false;
        private HttpIdleTimer task;
        private final String url = "http://" + NettyConnector.access$600(NettyConnector.this) + ":" + NettyConnector.access$700(NettyConnector.this) + NettyConnector.access$800(NettyConnector.this);
        private final Future handShakeFuture = new Future();
        private boolean active = false;
        private boolean handshaking = false;
        private final CookieDecoder cookieDecoder = new CookieDecoder();
        private String cookie;
        private final CookieEncoder cookieEncoder = new CookieEncoder(false);

        HttpHandler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelConnected(ctx, e);
            this.channel = e.getChannel();
            if (NettyConnector.this.httpClientIdleScanPeriod > 0L) {
                this.task = new HttpIdleTimer();
                ScheduledFuture<?> future = NettyConnector.this.scheduledThreadPool.scheduleAtFixedRate(this.task, NettyConnector.this.httpClientIdleScanPeriod, NettyConnector.this.httpClientIdleScanPeriod, TimeUnit.MILLISECONDS);
                this.task.setFuture(future);
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (this.task != null) {
                this.task.close();
            }
            super.channelClosed(ctx, e);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            HttpResponse response = (HttpResponse)e.getMessage();
            if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                Set cookieMap = this.cookieDecoder.decode(response.getHeader("Set-Cookie"));
                for (Cookie cookie : cookieMap) {
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    this.cookieEncoder.addCookie(cookie);
                    this.cookie = this.cookieEncoder.encode();
                }
                this.active = true;
                this.handShakeFuture.run();
            }
            UpstreamMessageEvent event = new UpstreamMessageEvent(e.getChannel(), (Object)response.getContent(), e.getRemoteAddress());
            this.waitingGet = false;
            ctx.sendUpstream((ChannelEvent)event);
        }

        public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (e.getMessage() instanceof ChannelBuffer) {
                if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                    if (this.handshaking) {
                        this.handshaking = true;
                    } else if (!this.handShakeFuture.await(5000L)) {
                        throw new RuntimeException("Handshake failed after timeout");
                    }
                }
                DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.url);
                if (this.cookie != null) {
                    httpRequest.addHeader("Cookie", this.cookie);
                }
                ChannelBuffer buf = (ChannelBuffer)e.getMessage();
                httpRequest.setContent(buf);
                httpRequest.addHeader("Content-Length", String.valueOf(buf.writerIndex()));
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)httpRequest, (SocketAddress)e.getRemoteAddress());
                this.lastSendTime = System.currentTimeMillis();
            } else {
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)e.getMessage(), (SocketAddress)e.getRemoteAddress());
                this.lastSendTime = System.currentTimeMillis();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class HttpIdleTimer
        implements Runnable {
            private boolean closed = false;
            private java.util.concurrent.Future<?> future;

            private HttpIdleTimer() {
            }

            @Override
            public synchronized void run() {
                if (this.closed) {
                    return;
                }
                if (!HttpHandler.this.waitingGet && System.currentTimeMillis() > HttpHandler.this.lastSendTime + NettyConnector.this.httpMaxClientIdleTime) {
                    DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, HttpHandler.this.url);
                    HttpHandler.this.waitingGet = true;
                    HttpHandler.this.channel.write((Object)httpRequest);
                }
            }

            public synchronized void setFuture(java.util.concurrent.Future<?> future) {
                this.future = future;
            }

            public void close() {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.closed = true;
            }
        }
    }

    @ChannelPipelineCoverage(value="one")
    private final class HornetQClientChannelHandler
    extends HornetQChannelHandler {
        HornetQClientChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }
    }
}

