/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.asynchttpclient;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.handler.StreamedAsyncHandler;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.http4s.AttributeMap;
import org.http4s.Header$;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Service$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.client.Client;
import org.http4s.client.DisposableResponse;
import org.http4s.client.asynchttpclient.AsyncHttpClient$;
import org.http4s.client.asynchttpclient.QueueSubscriber;
import org.http4s.client.impl.DefaultExecutor$;
import org.http4s.util.package$;
import org.http4s.util.threads$;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Iterable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scalaz.;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.stream.Process;
import scalaz.stream.io$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class AsyncHttpClient$ {
    public static AsyncHttpClient$ MODULE$;
    private final Logger log;
    private final DefaultAsyncHttpClientConfig defaultConfig;

    static {
        new AsyncHttpClient$();
    }

    public DefaultAsyncHttpClientConfig defaultConfig() {
        return this.defaultConfig;
    }

    public Client apply(AsyncHttpClientConfig config, int bufferSize, Option<ExecutorService> customExecutor) {
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient(config);
        ExecutorService executorService = (ExecutorService)customExecutor.getOrElse((Function0 & Serializable & scala.Serializable)() -> DefaultExecutor$.MODULE$.newClientDefaultExecutorService("async-http-client-response"));
        Task close = customExecutor.isDefined() ? Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> client.close()) : Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            client.close();
            executorService.shutdown();
        });
        return new Client(Service$.MODULE$.lift((Function1 & Serializable & scala.Serializable)req -> Task$.MODULE$.async((Function1 & Serializable & scala.Serializable)cb -> {
            client.executeRequest(this.toAsyncRequest(req), this.asyncHandler((Function1<.bslash.div<Throwable, DisposableResponse>, BoxedUnit>)cb, bufferSize, executorService));
            return BoxedUnit.UNIT;
        })), close);
    }

    public AsyncHttpClientConfig apply$default$1() {
        return this.defaultConfig();
    }

    public int apply$default$2() {
        return 8;
    }

    public Option<ExecutorService> apply$default$3() {
        return None$.MODULE$;
    }

    private AsyncHandler<BoxedUnit> asyncHandler(Function1<.bslash.div<Throwable, DisposableResponse>, BoxedUnit> callback, int bufferSize, ExecutorService executorService) {
        return new StreamedAsyncHandler<BoxedUnit>(callback, bufferSize, executorService){
            private AsyncHandler.State org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state;
            private DisposableResponse disposableResponse;
            private final Function1 callback$1;
            public final int bufferSize$2;
            private final ExecutorService executorService$2;

            public AsyncHandler.State org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state() {
                return this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state;
            }

            public void org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state_$eq(AsyncHandler.State x$1) {
                this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state = x$1;
            }

            private DisposableResponse disposableResponse() {
                return this.disposableResponse;
            }

            private void disposableResponse_$eq(DisposableResponse x$1) {
                this.disposableResponse = x$1;
            }

            public AsyncHandler.State onStream(Publisher<HttpResponseBodyPart> publisher) {
                QueueSubscriber<HttpResponseBodyPart> subscriber = new QueueSubscriber<HttpResponseBodyPart>(this){
                    private final /* synthetic */ anon.2 $outer;

                    public boolean whenNext(HttpResponseBodyPart element) {
                        boolean bl;
                        AsyncHandler.State state = this.$outer.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state();
                        if (AsyncHandler.State.CONTINUE.equals(state)) {
                            bl = super.whenNext(element);
                        } else if (AsyncHandler.State.ABORT.equals(state)) {
                            super.whenNext(element);
                            this.closeQueue();
                            bl = false;
                        } else {
                            if (AsyncHandler.State.UPGRADE.equals(state)) {
                                super.whenNext(element);
                                this.$outer.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state_$eq(AsyncHandler.State.ABORT);
                                throw new IllegalStateException("UPGRADE not implemented");
                            }
                            throw new MatchError((Object)state);
                        }
                        return bl;
                    }

                    public void request(int n) {
                        AsyncHandler.State state = this.$outer.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state();
                        if (AsyncHandler.State.CONTINUE.equals(state)) {
                            super.request(n);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.bufferSize$2);
                    }
                };
                Process body = subscriber.process().map((Function1 & Serializable & scala.Serializable)part -> ByteVector$.MODULE$.apply(part.getBodyPartBytes()));
                Response qual$1 = this.disposableResponse().response();
                Process x$5 = body;
                Status x$6 = qual$1.copy$default$1();
                HttpVersion x$7 = qual$1.copy$default$2();
                Headers x$8 = qual$1.copy$default$3();
                AttributeMap x$9 = qual$1.copy$default$5();
                Response response = qual$1.copy(x$6, x$7, x$8, x$5, x$9);
                this.execute((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.callback$1.apply((Object)new .bslash.div.minus((Object)new DisposableResponse(response, Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state_$eq(AsyncHandler.State.ABORT);
                    subscriber.killQueue();
                })))));
                publisher.subscribe((Subscriber)subscriber);
                return this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state();
            }

            public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart httpResponseBodyPart) {
                throw package$.MODULE$.bug("Expected it to call onStream instead.");
            }

            public AsyncHandler.State onStatusReceived(HttpResponseStatus status) {
                DisposableResponse qual$2 = this.disposableResponse();
                Response qual$3 = this.disposableResponse().response();
                Status x$10 = AsyncHttpClient$.MODULE$.org$http4s$client$asynchttpclient$AsyncHttpClient$$getStatus(status);
                HttpVersion x$11 = qual$3.copy$default$2();
                Headers x$12 = qual$3.copy$default$3();
                Process x$13 = qual$3.copy$default$4();
                AttributeMap x$14 = qual$3.copy$default$5();
                Response x$15 = qual$3.copy(x$10, x$11, x$12, x$13, x$14);
                Task x$16 = qual$2.copy$default$2();
                this.disposableResponse_$eq(qual$2.copy(x$15, x$16));
                return this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state();
            }

            public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) {
                DisposableResponse qual$4 = this.disposableResponse();
                Response qual$5 = this.disposableResponse().response();
                Headers x$17 = AsyncHttpClient$.MODULE$.org$http4s$client$asynchttpclient$AsyncHttpClient$$getHeaders(headers);
                Status x$18 = qual$5.copy$default$1();
                HttpVersion x$19 = qual$5.copy$default$2();
                Process x$20 = qual$5.copy$default$4();
                AttributeMap x$21 = qual$5.copy$default$5();
                Response x$22 = qual$5.copy(x$18, x$19, x$17, x$20, x$21);
                Task x$23 = qual$4.copy$default$2();
                this.disposableResponse_$eq(qual$4.copy(x$22, x$23));
                return this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state();
            }

            public void onThrowable(Throwable throwable) {
                this.execute((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.callback$1.apply((Object)new .minus.bslash.div((Object)throwable)));
            }

            public void onCompleted() {
            }

            private void execute(Function0<BoxedUnit> f) {
                this.executorService$2.execute(new Runnable(null, f){
                    private final Function0 f$1;

                    public void run() {
                        this.f$1.apply$mcV$sp();
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }
            {
                this.callback$1 = callback$1;
                this.bufferSize$2 = bufferSize$2;
                this.executorService$2 = executorService$2;
                this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state = AsyncHandler.State.CONTINUE;
                this.disposableResponse = new DisposableResponse(new Response(Response$.MODULE$.apply$default$1(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$http4s$client$asynchttpclient$AsyncHttpClient$$anon$$state_$eq(AsyncHandler.State.ABORT)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onStream$1(org.asynchttpclient.HttpResponseBodyPart ), $anonfun$onStream$2(org.http4s.client.asynchttpclient.AsyncHttpClient$$anon$2 org.http4s.client.asynchttpclient.QueueSubscriber org.http4s.Response ), $anonfun$onThrowable$1(org.http4s.client.asynchttpclient.AsyncHttpClient$$anon$2 java.lang.Throwable ), $anonfun$onStream$3(org.http4s.client.asynchttpclient.AsyncHttpClient$$anon$2 org.http4s.client.asynchttpclient.QueueSubscriber ), $anonfun$disposableResponse$1(org.http4s.client.asynchttpclient.AsyncHttpClient$$anon$2 )}, serializedLambda);
            }
        };
    }

    private org.asynchttpclient.Request toAsyncRequest(Request request) {
        return new RequestBuilder(request.method().toString()).setUrl(request.uri().toString()).setHeaders((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)request.headers().groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name().toString()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)x$2.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Iterable$.MODULE$.canBuildFrom())).asJavaCollection())).asJava()).setBody(this.getBodyGenerator((Process<Task, ByteVector>)request.body())).build();
    }

    private BodyGenerator getBodyGenerator(Process<Task, ByteVector> body) {
        return new InputStreamBodyGenerator(io$.MODULE$.toInputStream(body));
    }

    public Status org$http4s$client$asynchttpclient$AsyncHttpClient$$getStatus(HttpResponseStatus status) {
        return (Status)Status$.MODULE$.fromInt(status.getStatusCode()).valueOr((Function1 & Serializable & scala.Serializable)x$4 -> {
            throw x$4;
        });
    }

    public Headers org$http4s$client$asynchttpclient$AsyncHttpClient$$getHeaders(HttpResponseHeaders headers) {
        return Headers$.MODULE$.apply(((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(headers.getHeaders().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)header -> Header$.MODULE$.apply((String)header.getKey(), (String)header.getValue())).toList());
    }

    public static final /* synthetic */ String $anonfun$defaultConfig$1(long i) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http4s-async-http-client-worker-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)i)}));
    }

    private AsyncHttpClient$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger((String)"org.http4s.client.asynchttpclient.AsyncHttpClient");
        this.defaultConfig = new DefaultAsyncHttpClientConfig.Builder().setMaxConnectionsPerHost(200).setMaxConnections(400).setRequestTimeout(30000).setThreadFactory(threads$.MODULE$.threadFactory((Function1 & Serializable & scala.Serializable)i -> AsyncHttpClient$.$anonfun$defaultConfig$1(BoxesRunTime.unboxToLong((Object)i)), threads$.MODULE$.threadFactory$default$2(), threads$.MODULE$.threadFactory$default$3(), threads$.MODULE$.threadFactory$default$4(), threads$.MODULE$.threadFactory$default$5())).build();
    }
}

