/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.blaze;

import java.io.Serializable;
import java.net.ProtocolException;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Execution$;
import org.http4s.internal.package$;
import org.http4s.websocket.WebSocketFrame;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\u000b\u0016\tyAQA\r\u0001\u0005\u0002MBQA\u000e\u0001\u0005\u0002]Baa\u0011\u0001!\u0002\u0013!\u0005\"\u0002;\u0001\t\u0003)\b\"B?\u0001\t\u0013q\bbBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\t\u0019\u0002\u0001C!\u0003;9QAT\u000b\t\n=3Q\u0001F\u000b\t\nACQA\r\u0006\u0005\u0002E3AA\u0015\u0006\u0007'\")!\u0007\u0004C\u0001)\"1q\u000b\u0004Q\u0001\naCa\u0001\u0019\u0007!B\u0013\t\u0007\"\u00023\r\t\u0003)\u0007\"B5\r\t\u0003Q\u0007\"\u00029\r\t\u0003\t\b\"\u0002:\r\t\u0003\u0019(!E,T\rJ\fW.Z!hOJ,w-\u0019;pe*\u0011acF\u0001\u0006E2\f'0\u001a\u0006\u00031e\taa]3sm\u0016\u0014(B\u0001\u000e\u001c\u0003\u0019AG\u000f\u001e95g*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0014+Y1j\u0011a\n\u0006\u0003Q%\n\u0001\u0002]5qK2Lg.\u001a\u0006\u0003-eI!aK\u0014\u0003\u00115KGm\u0015;bO\u0016\u0004\"!\f\u0019\u000e\u00039R!aL\r\u0002\u0013],'m]8dW\u0016$\u0018BA\u0019/\u000599VMY*pG.,GO\u0012:b[\u0016\fa\u0001P5oSRtD#\u0001\u001b\u0011\u0005U\u0002Q\"A\u000b\u0002\t9\fW.Z\u000b\u0002qA\u0011\u0011\b\u0011\b\u0003uy\u0002\"aO\u0011\u000e\u0003qR!!P\u000f\u0002\rq\u0012xn\u001c;?\u0013\ty\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u0013aa\u0015;sS:<'BA \"\u0003-\t7mY;nk2\fGo\u001c:\u0011\u0005\u0015caB\u0001$\n\u001d\t9UJ\u0004\u0002I\u0019:\u0011\u0011j\u0013\b\u0003w)K\u0011\u0001H\u0005\u00035mI!\u0001G\r\n\u0005Y9\u0012!E,T\rJ\fW.Z!hOJ,w-\u0019;peB\u0011QGC\n\u0003\u0015}!\u0012a\u0014\u0002\f\u0003\u000e\u001cW/\\;mCR|'o\u0005\u0002\r?Q\tQ\u000b\u0005\u0002W\u00195\t!\"A\u0003rk\u0016,X\rE\u0002Z=2j\u0011A\u0017\u0006\u00037r\u000bq!\\;uC\ndWM\u0003\u0002^C\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005}S&!B)vKV,\u0017\u0001B:ju\u0016\u0004\"\u0001\t2\n\u0005\r\f#aA%oi\u00069\u0011n]#naRLX#\u00014\u0011\u0005\u0001:\u0017B\u00015\"\u0005\u001d\u0011un\u001c7fC:\fa!\u00199qK:$GCA6o!\t\u0001C.\u0003\u0002nC\t!QK\\5u\u0011\u0015y\u0017\u00031\u0001-\u0003\u00151'/Y7f\u0003\u0011!\u0018m[3\u0015\u00031\nQa\u00197fCJ$\u0012a[\u0001\fe\u0016\fGMU3rk\u0016\u001cH\u000f\u0006\u0002wyB\u0019qO\u001f\u0017\u000e\u0003aT!!_\u0011\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002|q\n1a)\u001e;ve\u0016DQ\u0001\u0019\u0003A\u0002\u0005\f\u0001B]3bI2{w\u000e\u001d\u000b\u0005W~\f\t\u0001C\u0003p\u000b\u0001\u0007A\u0006C\u0004\u0002\u0004\u0015\u0001\r!!\u0002\u0002\u0003A\u0004Ba^A\u0004Y%\u0019\u0011\u0011\u0002=\u0003\u000fA\u0013x.\\5tK\u0006Q\u0001.\u00198eY\u0016DU-\u00193\u0015\u000b-\fy!!\u0005\t\u000b=4\u0001\u0019\u0001\u0017\t\u000f\u0005\ra\u00011\u0001\u0002\u0006\u0005aqO]5uKJ+\u0017/^3tiR!\u0011qCA\r!\r9(p\u001b\u0005\u0007\u000379\u0001\u0019\u0001\u0017\u0002\t\u0011\fG/\u0019\u000b\u0005\u0003/\ty\u0002C\u0004\u0002\u001c!\u0001\r!!\t\u0011\u000b\u0005\r\u0012Q\u0005\u0017\u000e\u0003qK1!a\n]\u0005\r\u0019V-\u001d")
public class WSFrameAggregator
implements MidStage<WebSocketFrame, WebSocketFrame> {
    private final Accumulator accumulator;
    private Tail<WebSocketFrame> _nextStage;
    private Head<WebSocketFrame> _prevStage;
    private final Logger logger;

    public final MidStage<WebSocketFrame, WebSocketFrame> replaceInline(MidStage<WebSocketFrame, WebSocketFrame> stage) {
        return MidStage.replaceInline$((MidStage)this, stage);
    }

    public final void removeStage(Predef$.eq.colon.eq<MidStage<WebSocketFrame, WebSocketFrame>, MidStage<WebSocketFrame, WebSocketFrame>> ev) {
        MidStage.removeStage$((MidStage)this, ev);
    }

    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$((Stage)this, (Command.InboundCommand)cmd);
    }

    public final Tail<WebSocketFrame> replaceNext(LeafBuilder<WebSocketFrame> stage, boolean startup) {
        return Head.replaceNext$((Head)this, stage, (boolean)startup);
    }

    public final void sendInboundCommand(Command.InboundCommand cmd) {
        Head.sendInboundCommand$((Head)this, (Command.InboundCommand)cmd);
    }

    public void inboundCommand(Command.InboundCommand cmd) {
        Head.inboundCommand$((Head)this, (Command.InboundCommand)cmd);
    }

    public final void spliceAfter(MidStage<WebSocketFrame, WebSocketFrame> stage) {
        Head.spliceAfter$((Head)this, stage);
    }

    public final Option<Stage> findInboundStage(String name) {
        return Head.findInboundStage$((Head)this, (String)name);
    }

    public final <C extends Stage> Option<C> findInboundStage(Class<C> clazz) {
        return Head.findInboundStage$((Head)this, clazz);
    }

    public final void closePipeline(Option<Throwable> cause) {
        Tail.closePipeline$((Tail)this, cause);
    }

    public Future<WebSocketFrame> channelRead(int size, Duration timeout) {
        return Tail.channelRead$((Tail)this, (int)size, (Duration)timeout);
    }

    public int channelRead$default$1() {
        return Tail.channelRead$default$1$((Tail)this);
    }

    public Duration channelRead$default$2() {
        return Tail.channelRead$default$2$((Tail)this);
    }

    public Future channelWrite(Object data) {
        return Tail.channelWrite$((Tail)this, (Object)data);
    }

    public final Future channelWrite(Object data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, (Object)data, (Duration)timeout);
    }

    public Future<BoxedUnit> channelWrite(Seq<WebSocketFrame> data) {
        return Tail.channelWrite$((Tail)this, data);
    }

    public final Future<BoxedUnit> channelWrite(Seq<WebSocketFrame> data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, data, (Duration)timeout);
    }

    public final void spliceBefore(MidStage<WebSocketFrame, WebSocketFrame> stage) {
        Tail.spliceBefore$((Tail)this, stage);
    }

    public final Option<Stage> findOutboundStage(String name) {
        return Tail.findOutboundStage$((Tail)this, (String)name);
    }

    public final <C extends Stage> Option<C> findOutboundStage(Class<C> clazz) {
        return Tail.findOutboundStage$((Tail)this, clazz);
    }

    public final Tail<WebSocketFrame> replaceTail(LeafBuilder<WebSocketFrame> leafBuilder, boolean startup) {
        return Tail.replaceTail$((Tail)this, leafBuilder, (boolean)startup);
    }

    public void stageStartup() {
        Stage.stageStartup$((Stage)this);
    }

    public void stageShutdown() {
        Stage.stageShutdown$((Stage)this);
    }

    public Tail<WebSocketFrame> _nextStage() {
        return this._nextStage;
    }

    public void _nextStage_$eq(Tail<WebSocketFrame> x$1) {
        this._nextStage = x$1;
    }

    public Head<WebSocketFrame> _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head<WebSocketFrame> x$1) {
        this._prevStage = x$1;
    }

    public final Logger logger() {
        return this.logger;
    }

    public final void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String name() {
        return "WebSocket Frame Aggregator";
    }

    public Future<WebSocketFrame> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.channelRead(size, this.channelRead$default$2()).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WebSocketFrame f = (WebSocketFrame)success.value();
                this.readLoop(f, (Promise<WebSocketFrame>)p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                boxedUnit = p.failure(t);
            } else {
                throw new MatchError((Object)try_);
            }
            return boxedUnit;
        }, Execution$.MODULE$.directec());
        return p.future();
    }

    private void readLoop(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            this.handleHead(frame, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
            this.handleHead(frame, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (webSocketFrame instanceof WebSocketFrame.Continuation) {
            BoxedUnit boxedUnit;
            WebSocketFrame.Continuation continuation = (WebSocketFrame.Continuation)webSocketFrame;
            if (this.accumulator.isEmpty()) {
                ProtocolException e = new ProtocolException("Invalid state: Received a Continuation frame without accumulated state.");
                this.logger().error("Invalid state", (Throwable)e);
                p.failure((Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.accumulator.append(frame);
                if (continuation.last()) {
                    p.success((Object)this.accumulator.take());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        WSFrameAggregator.$anonfun$readLoop$1(this, p, x0$1);
                        return BoxedUnit.UNIT;
                    }, Execution$.MODULE$.trampoline());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            p.success((Object)webSocketFrame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void handleHead(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        if (!this.accumulator.isEmpty()) {
            ProtocolException e = new ProtocolException("Invalid state: Received a head frame with accumulated state");
            this.accumulator.clear();
            p.failure((Throwable)e);
        } else if (frame.last()) {
            p.success((Object)frame);
        } else {
            this.accumulator.append(frame);
            this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WSFrameAggregator.$anonfun$handleHead$1(this, p, x0$1);
                return BoxedUnit.UNIT;
            }, Execution$.MODULE$.directec());
        }
    }

    public Future<BoxedUnit> writeRequest(WebSocketFrame data) {
        return this.channelWrite(data);
    }

    public Future<BoxedUnit> writeRequest(Seq<WebSocketFrame> data) {
        return this.channelWrite(data);
    }

    public static final /* synthetic */ void $anonfun$readLoop$1(WSFrameAggregator $this, Promise p$2, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            WebSocketFrame f = (WebSocketFrame)success.value();
            $this.readLoop(f, (Promise<WebSocketFrame>)p$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            p$2.failure(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$handleHead$1(WSFrameAggregator $this, Promise p$3, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            WebSocketFrame f = (WebSocketFrame)success.value();
            $this.readLoop(f, (Promise<WebSocketFrame>)p$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            p$3.failure(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public WSFrameAggregator() {
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        Head.$init$((Head)this);
        MidStage.$init$((MidStage)this);
        this.accumulator = new Accumulator();
    }

    public static final class Accumulator {
        private final Queue<WebSocketFrame> queue = new Queue();
        private int size = 0;

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void append(WebSocketFrame frame) {
            if (this.queue.isEmpty()) {
                WebSocketFrame webSocketFrame = frame;
                boolean bl = webSocketFrame instanceof WebSocketFrame.Text ? true : webSocketFrame instanceof WebSocketFrame.Binary;
                if (bl) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw package$.MODULE$.bug(new StringBuilder(32).append("Shouldn't get here. Wrong type: ").append(webSocketFrame.getClass().getName()).toString());
                }
            }
            this.size += frame.length();
            this.queue.$plus$eq((Object)frame);
        }

        public WebSocketFrame take() {
            boolean bl;
            WebSocketFrame webSocketFrame = (WebSocketFrame)this.queue.head();
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                bl = true;
            } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
                bl = false;
            } else {
                AssertionError e = package$.MODULE$.bug(new StringBuilder(32).append("Shouldn't get here. Wrong type: ").append(webSocketFrame.getClass().getName()).toString());
                throw e;
            }
            boolean isText = bl;
            ObjectRef out = ObjectRef.create((Object)ByteVector$.MODULE$.empty());
            this.go$1(out);
            this.size = 0;
            return isText ? WebSocketFrame.Text$.MODULE$.apply((ByteVector)out.elem) : new WebSocketFrame.Binary((ByteVector)out.elem, WebSocketFrame.Binary$.MODULE$.apply$default$2());
        }

        public void clear() {
            this.size = 0;
            this.queue.clear();
        }

        private final void go$1(ObjectRef out$1) {
            while (!this.queue.isEmpty()) {
                ByteVector frame = ((WebSocketFrame)this.queue.dequeue()).data();
                out$1.elem = ((ByteVector)out$1.elem).$plus$plus(frame);
            }
        }
    }
}

