/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import java.io.Serializable;
import java.net.ProtocolException;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Execution$;
import org.http4s.internal.package$;
import org.http4s.websocket.WebSocketFrame;
import org.slf4j.Logger;
import scala.;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\u000b\u0016\tyAQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005\u0002YBaA\u0011\u0001!\u0002\u0013\u0019\u0005\"B:\u0001\t\u0003!\b\"\u0002?\u0001\t\u0013i\bbBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t\t\u0002\u0001C!\u000379Q!T\u000b\t\n93Q\u0001F\u000b\t\n=CQ!\r\u0006\u0005\u0002A3A!\u0015\u0006\u0007%\")\u0011\u0007\u0004C\u0001'\"1a\u000b\u0004Q\u0001\n]Caa\u0018\u0007!B\u0013\u0001\u0007\"B2\r\t\u0003!\u0007\"\u00025\r\t\u0003I\u0007\"B8\r\t\u0003\u0001\b\"B9\r\t\u0003\u0011(!E,T\rJ\fW.Z!hOJ,w-\u0019;pe*\u0011acF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005aI\u0012!\u00022mCj,'B\u0001\u000e\u001c\u0003\u0019AG\u000f\u001e95g*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0014*W-j\u0011a\n\u0006\u0003Q]\t\u0001\u0002]5qK2Lg.Z\u0005\u0003U\u001d\u0012\u0001\"T5e'R\fw-\u001a\t\u0003Y=j\u0011!\f\u0006\u0003]e\t\u0011b^3cg>\u001c7.\u001a;\n\u0005Aj#AD,fEN{7m[3u\rJ\fW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0002\"\u0001\u000e\u0001\u000e\u0003U\tAA\\1nKV\tq\u0007\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003u\u0005j\u0011a\u000f\u0006\u0003yu\ta\u0001\u0010:p_Rt\u0014B\u0001 \"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\n\u0013aC1dGVlW\u000f\\1u_J\u0004\"\u0001\u0012\u0007\u000f\u0005\u0015KaB\u0001$M\u001d\t95J\u0004\u0002I\u0015:\u0011!(S\u0005\u00029%\u0011!dG\u0005\u00031eI!AF\f\u0002#]\u001bfI]1nK\u0006;wM]3hCR|'\u000f\u0005\u00025\u0015M\u0011!b\b\u000b\u0002\u001d\nY\u0011iY2v[Vd\u0017\r^8s'\taq\u0004F\u0001U!\t)F\"D\u0001\u000b\u0003\u0015\tX/Z;f!\rAVlK\u0007\u00023*\u0011!lW\u0001\b[V$\u0018M\u00197f\u0015\ta\u0016%\u0001\u0006d_2dWm\u0019;j_:L!AX-\u0003\u000bE+X-^3\u0002\tML'0\u001a\t\u0003A\u0005L!AY\u0011\u0003\u0007%sG/A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003\u0015\u0004\"\u0001\t4\n\u0005\u001d\f#a\u0002\"p_2,\u0017M\\\u0001\u0007CB\u0004XM\u001c3\u0015\u0005)l\u0007C\u0001\u0011l\u0013\ta\u0017E\u0001\u0003V]&$\b\"\u00028\u0012\u0001\u0004Y\u0013!\u00024sC6,\u0017\u0001\u0002;bW\u0016$\u0012aK\u0001\u0006G2,\u0017M\u001d\u000b\u0002U\u0006Y!/Z1e%\u0016\fX/Z:u)\t)8\u0010E\u0002ws.j\u0011a\u001e\u0006\u0003q\u0006\n!bY8oGV\u0014(/\u001a8u\u0013\tQxO\u0001\u0004GkR,(/\u001a\u0005\u0006?\u0012\u0001\r\u0001Y\u0001\te\u0016\fG\rT8paR\u0019!N`@\t\u000b9,\u0001\u0019A\u0016\t\u000f\u0005\u0005Q\u00011\u0001\u0002\u0004\u0005\t\u0001\u000f\u0005\u0003w\u0003\u000bY\u0013bAA\u0004o\n9\u0001K]8nSN,\u0017A\u00035b]\u0012dW\rS3bIR)!.!\u0004\u0002\u0010!)aN\u0002a\u0001W!9\u0011\u0011\u0001\u0004A\u0002\u0005\r\u0011\u0001D<sSR,'+Z9vKN$H\u0003BA\u000b\u0003/\u00012A^=k\u0011\u0019\tIb\u0002a\u0001W\u0005!A-\u0019;b)\u0011\t)\"!\b\t\u000f\u0005e\u0001\u00021\u0001\u0002 A)\u0011\u0011EA\u0012W5\t1,C\u0002\u0002&m\u00131aU3r\u0001")
public class WSFrameAggregator
implements MidStage<WebSocketFrame, WebSocketFrame> {
    private final Accumulator accumulator;
    private Tail<WebSocketFrame> _nextStage;
    private Head<WebSocketFrame> _prevStage;
    private Logger logger;

    public final MidStage<WebSocketFrame, WebSocketFrame> replaceInline(MidStage<WebSocketFrame, WebSocketFrame> stage) {
        return MidStage.replaceInline$((MidStage)this, stage);
    }

    public final void removeStage(.eq.colon.eq<MidStage<WebSocketFrame, WebSocketFrame>, MidStage<WebSocketFrame, WebSocketFrame>> ev) {
        MidStage.removeStage$((MidStage)this, ev);
    }

    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$((Stage)this, (Command.InboundCommand)cmd);
    }

    public final Tail<WebSocketFrame> replaceNext(LeafBuilder<WebSocketFrame> stage, boolean startup) {
        return Head.replaceNext$((Head)this, stage, (boolean)startup);
    }

    public final void sendInboundCommand(Command.InboundCommand cmd) {
        Head.sendInboundCommand$((Head)this, (Command.InboundCommand)cmd);
    }

    public void inboundCommand(Command.InboundCommand cmd) {
        Head.inboundCommand$((Head)this, (Command.InboundCommand)cmd);
    }

    public final void spliceAfter(MidStage<WebSocketFrame, WebSocketFrame> stage) {
        Head.spliceAfter$((Head)this, stage);
    }

    public final Option<Stage> findInboundStage(String name) {
        return Head.findInboundStage$((Head)this, (String)name);
    }

    public final <C extends Stage> Option<C> findInboundStage(Class<C> clazz) {
        return Head.findInboundStage$((Head)this, clazz);
    }

    public final void closePipeline(Option<Throwable> cause) {
        Tail.closePipeline$((Tail)this, cause);
    }

    public Future<WebSocketFrame> channelRead(int size, Duration timeout) {
        return Tail.channelRead$((Tail)this, (int)size, (Duration)timeout);
    }

    public int channelRead$default$1() {
        return Tail.channelRead$default$1$((Tail)this);
    }

    public Duration channelRead$default$2() {
        return Tail.channelRead$default$2$((Tail)this);
    }

    public Future channelWrite(Object data) {
        return Tail.channelWrite$((Tail)this, (Object)data);
    }

    public final Future channelWrite(Object data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, (Object)data, (Duration)timeout);
    }

    public Future<BoxedUnit> channelWrite(Seq<WebSocketFrame> data) {
        return Tail.channelWrite$((Tail)this, data);
    }

    public final Future<BoxedUnit> channelWrite(Seq<WebSocketFrame> data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, data, (Duration)timeout);
    }

    public final void spliceBefore(MidStage<WebSocketFrame, WebSocketFrame> stage) {
        Tail.spliceBefore$((Tail)this, stage);
    }

    public final Option<Stage> findOutboundStage(String name) {
        return Tail.findOutboundStage$((Tail)this, (String)name);
    }

    public final <C extends Stage> Option<C> findOutboundStage(Class<C> clazz) {
        return Tail.findOutboundStage$((Tail)this, clazz);
    }

    public final Tail<WebSocketFrame> replaceTail(LeafBuilder<WebSocketFrame> leafBuilder, boolean startup) {
        return Tail.replaceTail$((Tail)this, leafBuilder, (boolean)startup);
    }

    public void stageStartup() {
        Stage.stageStartup$((Stage)this);
    }

    public void stageShutdown() {
        Stage.stageShutdown$((Stage)this);
    }

    public Tail<WebSocketFrame> _nextStage() {
        return this._nextStage;
    }

    public void _nextStage_$eq(Tail<WebSocketFrame> x$1) {
        this._nextStage = x$1;
    }

    public Head<WebSocketFrame> _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head<WebSocketFrame> x$1) {
        this._prevStage = x$1;
    }

    public final Logger logger() {
        return this.logger;
    }

    public final void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String name() {
        return "WebSocket Frame Aggregator";
    }

    public Future<WebSocketFrame> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.channelRead(size, this.channelRead$default$2()).onComplete((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WebSocketFrame f = (WebSocketFrame)success.value();
                this.readLoop(f, (Promise<WebSocketFrame>)p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                boxedUnit = p.failure(t);
            } else {
                throw new MatchError((Object)try_);
            }
            return boxedUnit;
        }, Execution$.MODULE$.directec());
        return p.future();
    }

    private void readLoop(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            this.handleHead(frame, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
            this.handleHead(frame, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (webSocketFrame instanceof WebSocketFrame.Continuation) {
            BoxedUnit boxedUnit;
            WebSocketFrame.Continuation continuation = (WebSocketFrame.Continuation)webSocketFrame;
            if (this.accumulator.isEmpty()) {
                ProtocolException e = new ProtocolException("Invalid state: Received a Continuation frame without accumulated state.");
                this.logger().error("Invalid state", (Throwable)e);
                p.failure((Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.accumulator.append(frame);
                if (continuation.last()) {
                    p.success((Object)this.accumulator.take());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1 & Serializable)x0$1 -> {
                        WSFrameAggregator.$anonfun$readLoop$1(this, p, x0$1);
                        return BoxedUnit.UNIT;
                    }, Execution$.MODULE$.trampoline());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            p.success((Object)webSocketFrame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void handleHead(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        if (!this.accumulator.isEmpty()) {
            ProtocolException e = new ProtocolException("Invalid state: Received a head frame with accumulated state");
            this.accumulator.clear();
            p.failure((Throwable)e);
        } else if (frame.last()) {
            p.success((Object)frame);
        } else {
            this.accumulator.append(frame);
            this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1 & Serializable)x0$1 -> {
                WSFrameAggregator.$anonfun$handleHead$1(this, p, x0$1);
                return BoxedUnit.UNIT;
            }, Execution$.MODULE$.directec());
        }
    }

    public Future<BoxedUnit> writeRequest(WebSocketFrame data) {
        return this.channelWrite(data);
    }

    public Future<BoxedUnit> writeRequest(Seq<WebSocketFrame> data) {
        return this.channelWrite(data);
    }

    public static final /* synthetic */ void $anonfun$readLoop$1(WSFrameAggregator $this, Promise p$2, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            WebSocketFrame f = (WebSocketFrame)success.value();
            $this.readLoop(f, (Promise<WebSocketFrame>)p$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            p$2.failure(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$handleHead$1(WSFrameAggregator $this, Promise p$3, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            WebSocketFrame f = (WebSocketFrame)success.value();
            $this.readLoop(f, (Promise<WebSocketFrame>)p$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            p$3.failure(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public WSFrameAggregator() {
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        Head.$init$((Head)this);
        MidStage.$init$((MidStage)this);
        this.accumulator = new Accumulator();
        Statics.releaseFence();
    }

    private static final class Accumulator {
        private final Queue<WebSocketFrame> queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        private int size = 0;

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void append(WebSocketFrame frame) {
            if (this.queue.isEmpty()) {
                WebSocketFrame webSocketFrame = frame;
                boolean bl = webSocketFrame instanceof WebSocketFrame.Text ? true : webSocketFrame instanceof WebSocketFrame.Binary;
                if (bl) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw package$.MODULE$.bug(new StringBuilder(32).append("Shouldn't get here. Wrong type: ").append(webSocketFrame.getClass().getName()).toString());
                }
            }
            this.size += frame.length();
            this.queue.$plus$eq((Object)frame);
        }

        public WebSocketFrame take() {
            boolean bl;
            WebSocketFrame webSocketFrame = (WebSocketFrame)this.queue.head();
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                bl = true;
            } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
                bl = false;
            } else {
                AssertionError e = package$.MODULE$.bug(new StringBuilder(32).append("Shouldn't get here. Wrong type: ").append(webSocketFrame.getClass().getName()).toString());
                throw e;
            }
            boolean isText = bl;
            ObjectRef out = ObjectRef.create((Object)ByteVector$.MODULE$.empty());
            this.go$1(out);
            this.size = 0;
            return isText ? WebSocketFrame.Text$.MODULE$.apply((ByteVector)out.elem) : new WebSocketFrame.Binary((ByteVector)out.elem, WebSocketFrame.Binary$.MODULE$.apply$default$2());
        }

        public void clear() {
            this.size = 0;
            this.queue.clear();
        }

        private final void go$1(ObjectRef out$1) {
            while (!this.queue.isEmpty()) {
                ByteVector frame = ((WebSocketFrame)this.queue.dequeue()).data();
                out$1.elem = ((ByteVector)out$1.elem).$plus$plus(frame);
            }
        }
    }
}

