/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.hyperledger.fabric.gateway.Identity;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.Wallet;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.gateway.spi.CommitHandlerFactory;
import org.hyperledger.fabric.gateway.spi.QueryHandlerFactory;
import org.hyperledger.fabric.sdk.HFClient;

public interface Gateway
extends AutoCloseable {
    public Network getNetwork(String var1);

    public Identity getIdentity();

    public static Builder createBuilder() {
        return new GatewayImpl.Builder();
    }

    public HFClient getClient();

    @Override
    public void close();

    public static interface Builder {
        public Builder networkConfig(Path var1) throws IOException;

        public Builder networkConfig(InputStream var1) throws IOException;

        public Builder identity(Wallet var1, String var2) throws IOException;

        public Builder identity(Identity var1);

        public Builder commitHandler(CommitHandlerFactory var1);

        public Builder queryHandler(QueryHandlerFactory var1);

        public Builder commitTimeout(long var1, TimeUnit var3);

        public Builder discovery(boolean var1);

        public Builder forceClose(boolean var1);

        public Gateway connect();
    }
}

