/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.identity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonWriter;
import org.hyperledger.fabric.gateway.Identity;
import org.hyperledger.fabric.gateway.Wallet;
import org.hyperledger.fabric.gateway.impl.identity.IdentityProvider;
import org.hyperledger.fabric.gateway.impl.identity.X509IdentityProvider;
import org.hyperledger.fabric.gateway.spi.WalletStore;

public final class WalletImpl
implements Wallet {
    private final WalletStore store;
    private final Map<String, IdentityProvider<?>> providers = Stream.of(X509IdentityProvider.INSTANCE).collect(Collectors.toMap(X509IdentityProvider::getTypeId, provider -> provider));

    public WalletImpl(WalletStore store) {
        this.store = store;
    }

    @Override
    public void put(String label, Identity identity) throws IOException {
        try (InputStream byteInStream = this.serializeIdentity(identity);){
            this.store.put(label, byteInStream);
        }
    }

    private InputStream serializeIdentity(Identity identity) {
        IdentityProvider<?> provider = this.getProvider(identity);
        JsonObject identityJson = provider.toJson(identity);
        return this.serializeJson(identityJson);
    }

    private IdentityProvider<?> getProvider(Identity identity) {
        Class<?> identityType = identity.getClass();
        return this.providers.values().stream().filter(provider -> provider.getType().isAssignableFrom(identityType)).findFirst().orElseThrow(() -> new IllegalArgumentException("No provider for identity type: " + identityType.getName()));
    }

    private InputStream serializeJson(JsonObject identityJson) {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try (JsonWriter jsonWriter = Json.createWriter((OutputStream)byteOutStream);){
            jsonWriter.writeObject(identityJson);
        }
        return new ByteArrayInputStream(byteOutStream.toByteArray());
    }

    /*
     * Loose catch block
     */
    @Override
    public Identity get(String label) throws IOException {
        InputStream identityData = this.store.get(label);
        Throwable throwable = null;
        if (identityData == null) {
            Identity identity = null;
            return identity;
        }
        Identity identity = this.deserializeIdentity(identityData);
        return identity;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            if (identityData != null) {
                if (throwable != null) {
                    try {
                        identityData.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    identityData.close();
                }
            }
        }
    }

    private Identity deserializeIdentity(InputStream identityData) throws IOException {
        JsonObject identityJson = Json.createReader((InputStream)identityData).readObject();
        String type = identityJson.getString("type");
        IdentityProvider<?> provider = this.getProvider(type);
        try {
            return provider.fromJson(identityJson);
        }
        catch (InvalidKeyException | CertificateException e) {
            throw new IOException(e);
        }
    }

    private IdentityProvider<?> getProvider(String typeId) {
        IdentityProvider<?> result = this.providers.get(typeId);
        if (result == null) {
            throw new IllegalArgumentException("No provider for identity type ID: " + typeId);
        }
        return result;
    }

    @Override
    public Set<String> list() throws IOException {
        return this.store.list();
    }

    @Override
    public void remove(String label) throws IOException {
        this.store.remove(label);
    }
}

