/*
 * Decompiled with CFR 0.152.
 */
package org.impalaframework.osgi.test;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.impalaframework.osgi.test.BundleFileFilter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableFileFilter
extends BundleFileFilter {
    private Map<String, List<String>> includes;
    private Map<String, List<String>> excludes;

    public ConfigurableFileFilter(Map<String, List<String>> includes, Map<String, List<String>> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public ConfigurableFileFilter(String includes, String excludes) {
        this.includes = ConfigurableFileFilter.buildMap(includes);
        this.excludes = ConfigurableFileFilter.buildMap(excludes);
    }

    private static Map<String, List<String>> buildMap(String includes) {
        HashMap<String, List<String>> includesMap = new HashMap<String, List<String>>();
        if (includes != null) {
            String[] semiColonSplit;
            for (String item : semiColonSplit = includes.split(";")) {
                int colonIndex = (item = item.trim()).indexOf(58);
                Assert.isTrue((colonIndex >= 0 ? 1 : 0) != 0, (String)("Invalid format for argument " + includes + ". Format should be something like 'folder1:file1,file2; folder2:file3,file4'"));
                String folder = item.substring(0, colonIndex).trim();
                String afterColon = item.substring(colonIndex + 1);
                String[] fileSplit = afterColon.split(",");
                ArrayList<String> fileList = new ArrayList<String>();
                includesMap.put(folder, fileList);
                for (String file : fileSplit) {
                    fileList.add(file.trim());
                }
            }
        }
        return includesMap;
    }

    @Override
    public boolean accept(File file) {
        boolean accept = super.accept(file);
        if (!accept) {
            return false;
        }
        String parentFolder = file.getParentFile().getName();
        String name = file.getName();
        List<String> list = this.includes.get(parentFolder);
        if (list != null && list.size() == 1 && "*".equalsIgnoreCase(list.get(0))) {
            return true;
        }
        boolean included = this.isIncluded(parentFolder, name);
        if (!included) {
            return false;
        }
        boolean excluded = this.isExcluded(parentFolder, name);
        if (excluded) {
            return false;
        }
        return accept;
    }

    private boolean isIncluded(String parentFolder, String name) {
        return this.isPresentInMap(this.includes, parentFolder, name);
    }

    private boolean isExcluded(String parentFolder, String name) {
        return this.isPresentInMap(this.excludes, parentFolder, name);
    }

    private boolean isPresentInMap(Map<String, List<String>> map, String parentFolder, String name) {
        List<String> list = map.get(parentFolder);
        if (list == null) {
            return false;
        }
        boolean present = false;
        for (String item : list) {
            if (!name.contains(item)) continue;
            present = true;
            break;
        }
        return present;
    }
}

