/*
 * Decompiled with CFR 0.152.
 */
package org.impalaframework.osgi.test;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.impalaframework.util.PathUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFetcher {
    private String repositoryRootDirectory;
    private String[] repositoryFolders;

    public FileFetcher(String repositoryRootDirectory, String[] repositoryFolders) {
        Assert.notNull((Object)repositoryRootDirectory);
        Assert.notNull((Object)repositoryFolders);
        this.repositoryRootDirectory = repositoryRootDirectory;
        this.repositoryFolders = repositoryFolders;
    }

    public List<Resource> getResources(FileFilter filter) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String folder : this.repositoryFolders) {
            File[] files;
            String directory = PathUtils.getPath((String)this.repositoryRootDirectory, (String)folder);
            File fileFolder = new File(directory);
            for (File file : files = fileFolder.listFiles(filter)) {
                resources.add((Resource)new FileSystemResource(file));
            }
        }
        return resources;
    }
}

