/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.DescriptorParser;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.parser.mappers.ProtofileMapper;
import protostream.com.squareup.protoparser.ProtoFile;
import protostream.com.squareup.protoparser.ProtoParser;

public final class SquareProtoParser
implements DescriptorParser {
    private static final ProtofileMapper PROTOFILE_MAPPER = new ProtofileMapper();
    private final Configuration configuration;

    public SquareProtoParser(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Map<String, FileDescriptor> parse(FileDescriptorSource fileDescriptorSource) throws DescriptorParserException {
        Map<String, char[]> input = fileDescriptorSource.getFileDescriptors();
        LinkedHashMap<String, FileDescriptor> fileDescriptorMap = new LinkedHashMap<String, FileDescriptor>(input.size());
        for (Map.Entry<String, char[]> entry : input.entrySet()) {
            String fileName = entry.getKey();
            try {
                ProtoFile protoFile = ProtoParser.parse(fileName, new CharArrayReader(entry.getValue()));
                FileDescriptor fileDescriptor = PROTOFILE_MAPPER.map(protoFile);
                fileDescriptor.setConfiguration(this.configuration);
                fileDescriptorMap.put(fileName, fileDescriptor);
            }
            catch (DescriptorParserException e) {
                this.reportParsingError(fileDescriptorSource, fileDescriptorMap, fileName, e);
            }
            catch (IOException | RuntimeException e) {
                this.reportParsingError(fileDescriptorSource, fileDescriptorMap, fileName, new DescriptorParserException(e));
            }
        }
        return fileDescriptorMap;
    }

    private void reportParsingError(FileDescriptorSource fileDescriptorSource, Map<String, FileDescriptor> fileDescriptorMap, String fileName, DescriptorParserException dpe) {
        if (fileDescriptorSource.getProgressCallback() == null) {
            throw dpe;
        }
        FileDescriptor stub = new FileDescriptor.Builder().withName(fileName).withParsingException(dpe).build();
        stub.setConfiguration(this.configuration);
        fileDescriptorMap.put(fileName, stub);
        fileDescriptorSource.getProgressCallback().handleError(fileName, dpe);
    }
}

