/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumContainer;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.MessageContainer;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.OptionContainer;
import org.infinispan.protostream.descriptors.ResolutionContext;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.namespace.FileNamespace;
import org.infinispan.protostream.descriptors.namespace.Namespace;
import org.infinispan.protostream.impl.Log;

public final class FileDescriptor {
    private static final Log log = Log.LogFactory.getLog(FileDescriptor.class);
    private final Syntax syntax;
    private Configuration configuration;
    private final String name;
    private final String packageName;
    private final List<String> dependencies;
    private final List<String> publicDependencies;
    private final List<Option> options;
    private final List<Descriptor> messageTypes;
    private final List<EnumDescriptor> enumTypes;
    private final Map<String, FileDescriptor> dependants = new HashMap<String, FileDescriptor>();
    private FileNamespace fileNamespace;
    private Status status;
    private final DescriptorParserException parsingException;

    private FileDescriptor(Builder builder) {
        this.syntax = builder.syntax == null ? Syntax.PROTO2 : builder.syntax;
        this.name = builder.name;
        this.packageName = builder.packageName;
        this.dependencies = List.copyOf(builder.dependencies);
        this.publicDependencies = List.copyOf(builder.publicDependencies);
        this.options = List.copyOf(builder.options);
        this.enumTypes = List.copyOf(builder.enumTypes);
        this.messageTypes = List.copyOf(builder.messageTypes);
        this.parsingException = builder.parsingException;
        this.status = this.parsingException != null ? Status.PARSING_ERROR : Status.UNRESOLVED;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, FileDescriptor> getDependants() {
        return this.dependants;
    }

    public boolean isResolved() {
        return this.status.isResolved();
    }

    public void markUnresolved() {
        this.status = Status.UNRESOLVED;
    }

    void markError() {
        if (this.status != Status.PARSING_ERROR) {
            this.status = Status.ERROR;
        }
    }

    public void clearErrors() {
        if (this.status != Status.RESOLVED && this.status != Status.PARSING_ERROR) {
            this.markUnresolved();
            this.fileNamespace = null;
            for (FileDescriptor fd : this.dependants.values()) {
                fd.clearErrors();
            }
            this.dependants.clear();
        }
    }

    public Namespace getExportedNamespace() {
        if (this.status != Status.RESOLVED) {
            throw new IllegalStateException("File '" + this.name + "' is not resolved yet");
        }
        return this.fileNamespace.getExportedNamespace();
    }

    public void resolveDependencies(ResolutionContext resolutionContext) throws DescriptorParserException {
        this.resolveDependencies(resolutionContext, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependencies(ResolutionContext resolutionContext, Set<String> processedFiles) throws DescriptorParserException {
        if (this.status == Status.PARSING_ERROR) {
            resolutionContext.handleError(this, this.parsingException);
            return;
        }
        if (this.status != Status.UNRESOLVED) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Resolving dependencies of %s", this.name);
        }
        try {
            List<FileDescriptor> pubDeps = this.resolveImports(this.publicDependencies, resolutionContext, processedFiles);
            List<FileDescriptor> deps = this.resolveImports(this.dependencies, resolutionContext, processedFiles);
            if (this.status.isError()) {
                return;
            }
            this.fileNamespace = new FileNamespace(this, pubDeps, deps);
            for (FileDescriptor fd : pubDeps) {
                fd.dependants.put(this.name, this);
            }
            for (FileDescriptor fd : deps) {
                fd.dependants.put(this.name, this);
            }
            for (Descriptor desc : this.messageTypes) {
                this.collectDescriptors(desc, resolutionContext);
            }
            for (EnumDescriptor enumDesc : this.enumTypes) {
                this.collectEnumDescriptors(enumDesc, resolutionContext);
            }
            for (Descriptor descriptor : this.messageTypes) {
                this.resolveFieldTypes(descriptor);
            }
            this.status = Status.RESOLVED;
            resolutionContext.flush();
            resolutionContext.handleSuccess(this);
        }
        catch (DescriptorParserException dpe) {
            resolutionContext.handleError(this, dpe);
        }
        catch (Exception e) {
            resolutionContext.handleError(this, new DescriptorParserException(e));
        }
        finally {
            if (this.status != Status.RESOLVED) {
                resolutionContext.clear();
            }
        }
    }

    private List<FileDescriptor> resolveImports(List<String> dependencies, ResolutionContext resolutionContext, Set<String> processedFiles) throws DescriptorParserException {
        ArrayList<FileDescriptor> fileDescriptors = new ArrayList<FileDescriptor>(dependencies.size());
        HashSet<String> uniqueDependencies = new HashSet<String>(dependencies.size());
        for (String dependency : dependencies) {
            if (!uniqueDependencies.add(dependency)) {
                resolutionContext.handleError(this, new DescriptorParserException("Duplicate import : " + dependency));
                continue;
            }
            FileDescriptor fd = resolutionContext.getFileDescriptorMap().get(dependency);
            if (fd == null) {
                resolutionContext.handleError(this, new DescriptorParserException("Import '" + dependency + "' not found"));
                continue;
            }
            if (fd.status == Status.UNRESOLVED) {
                if (!processedFiles.add(dependency)) {
                    resolutionContext.handleError(this, new DescriptorParserException("Cyclic import detected at " + this.name + ", import " + dependency));
                    continue;
                }
                fd.resolveDependencies(resolutionContext, processedFiles);
            }
            if (fd.status.isError()) {
                resolutionContext.handleError(this, new DescriptorParserException("File " + this.name + " imports a file (" + fd.getName() + ") that has errors"));
                continue;
            }
            fileDescriptors.add(fd);
        }
        return fileDescriptors;
    }

    private void collectDescriptors(Descriptor descriptor, ResolutionContext resolutionContext) {
        descriptor.setFileDescriptor(this);
        this.fileNamespace.put(descriptor.getFullName(), descriptor);
        resolutionContext.addGenericDescriptor(descriptor);
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.collectDescriptors(nested, resolutionContext);
        }
        for (EnumDescriptor enumDescriptor : descriptor.getEnumTypes()) {
            this.collectEnumDescriptors(enumDescriptor, resolutionContext);
        }
    }

    private void collectEnumDescriptors(EnumDescriptor enumDescriptor, ResolutionContext resolutionContext) {
        enumDescriptor.setFileDescriptor(this);
        this.fileNamespace.put(enumDescriptor.getFullName(), enumDescriptor);
        resolutionContext.addGenericDescriptor(enumDescriptor);
    }

    private void resolveFieldTypes(Descriptor descriptor) {
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (fieldDescriptor.getType() != null && fieldDescriptor.getType() != Type.GROUP && fieldDescriptor.getType() != Type.MESSAGE && fieldDescriptor.getType() != Type.ENUM) continue;
            GenericDescriptor res = this.searchType(fieldDescriptor.getTypeName(), descriptor);
            if (res instanceof EnumDescriptor) {
                fieldDescriptor.setEnumType((EnumDescriptor)res);
                continue;
            }
            if (res instanceof Descriptor) {
                fieldDescriptor.setMessageType((Descriptor)res);
                continue;
            }
            throw new DescriptorParserException("Failed to resolve type of field \"" + fieldDescriptor.getFullName() + "\" in \"" + this.name + "\". Type not found : " + fieldDescriptor.getTypeName());
        }
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.resolveFieldTypes(nested);
        }
    }

    private String getScopedName(String name) {
        return this.packageName == null ? name : this.packageName.concat(".").concat(name);
    }

    private GenericDescriptor searchType(String name, Descriptor scope) {
        GenericDescriptor fullyQualified = this.fileNamespace.get(this.getScopedName(name));
        if (fullyQualified != null) {
            return fullyQualified;
        }
        GenericDescriptor relativeName = this.fileNamespace.get(name);
        if (relativeName != null) {
            return relativeName;
        }
        if (scope != null) {
            Descriptor containingType;
            String searchScope = scope.getFullName().concat(".").concat(name);
            GenericDescriptor o = this.fileNamespace.get(searchScope);
            if (o != null) {
                return o;
            }
            while ((containingType = scope.getContainingType()) != null) {
                GenericDescriptor res = this.searchType(name, containingType);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return this.packageName;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String name) {
        for (Option o : this.options) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public List<EnumDescriptor> getEnumTypes() {
        return this.enumTypes;
    }

    public List<Descriptor> getMessageTypes() {
        return this.messageTypes;
    }

    public Map<String, GenericDescriptor> getTypes() {
        if (this.status != Status.RESOLVED) {
            throw new IllegalStateException("File '" + this.name + "' is not resolved yet");
        }
        return this.fileNamespace.getLocalNamespace().getTypes();
    }

    public String toString() {
        return "FileDescriptor{name='" + this.name + "', packageName='" + this.packageName + "', status=" + this.status + "}";
    }

    public static String fullName(String parent, String name) {
        return parent == null ? name : parent + "." + name;
    }

    public static final class Builder
    implements MessageContainer<Builder>,
    OptionContainer<Builder>,
    EnumContainer<Builder> {
        private Syntax syntax = Syntax.PROTO2;
        private String name;
        private String packageName;
        private List<String> dependencies = new ArrayList<String>();
        private List<String> publicDependencies = new ArrayList<String>();
        private List<Option> options = new ArrayList<Option>();
        private List<EnumDescriptor> enumTypes = new ArrayList<EnumDescriptor>();
        private List<Descriptor> messageTypes = new ArrayList<Descriptor>();
        private DescriptorParserException parsingException;

        public Builder withSyntax(Syntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        @Override
        public String getFullName() {
            return this.packageName;
        }

        public Builder withDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Builder addDependency(String dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder withPublicDependencies(List<String> publicDependencies) {
            this.publicDependencies = publicDependencies;
            return this;
        }

        public Builder addPublicDependency(String dependency) {
            this.publicDependencies.add(dependency);
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder addOption(Option option) {
            this.options.add(option);
            return this;
        }

        public Builder withEnumTypes(List<EnumDescriptor> enumTypes) {
            this.enumTypes = enumTypes;
            return this;
        }

        @Override
        public Builder addEnum(EnumDescriptor.Builder enumDescriptor) {
            this.enumTypes.add(enumDescriptor.withFullName(FileDescriptor.fullName(this.packageName, enumDescriptor.getName())).build());
            return this;
        }

        public Builder withMessageTypes(List<Descriptor> messageTypes) {
            this.messageTypes = messageTypes;
            return this;
        }

        @Override
        public Builder addMessage(Descriptor.Builder message) {
            this.messageTypes.add(message.withFullName(FileDescriptor.fullName(this.packageName, message.getName())).build());
            return this;
        }

        public Builder withParsingException(DescriptorParserException parsingException) {
            this.parsingException = parsingException;
            return this;
        }

        public FileDescriptor build() {
            HashSet<String> optionNames = new HashSet<String>(this.options.size());
            for (Option option : this.options) {
                if (optionNames.add(option.getName())) continue;
                throw new DescriptorParserException(this.name + ": Option \"" + option.getName() + "\" was already set.");
            }
            return new FileDescriptor(this);
        }
    }

    public static enum Syntax {
        PROTO2,
        PROTO3;


        public static Syntax fromString(String syntax) {
            return Syntax.valueOf(syntax.toUpperCase());
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static enum Status {
        UNRESOLVED,
        RESOLVED,
        ERROR,
        PARSING_ERROR;


        boolean isResolved() {
            return this == RESOLVED;
        }

        boolean isError() {
            return this == ERROR || this == PARSING_ERROR;
        }
    }
}

